/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.workflow;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.MessageRequestInfo;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.message.api.SmsUsingQuantities;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u6d88\u606f\u4e2d\u5fc3\u670d\u52a1")
public class MessageCenterServiceHelper {
    private static Log logger = LogFactory.getLog(MessageCenterServiceHelper.class);

    private static IMessageCenterService getMessageService() {
        return (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
    }

    @KSMethod
    public static TaskInfo createBizTask(TaskEntityInfo taskEntityInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.createBizTask(taskEntityInfo);
    }

    @KSMethod
    public static BatchOperateResult completeBizTask(CompleteOperationParam completeOperationParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.completeBizTask(completeOperationParam);
    }

    public static BatchOperateResult deleteBizTask(DeleteOperationParam deleteOperationParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.deleteBizTask(deleteOperationParam);
    }

    @KSMethod
    public static BatchOperateResult transferBizTask(TransferOperationParam transferOperationParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.transferBizTask(transferOperationParam);
    }

    @KSMethod
    public static BatchOperateResult updateParticipant(UpdateParticipantParam updateParticipantParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.updateParticipant(updateParticipantParam);
    }

    @KSMethod
    public BatchOperateResult circulateBizTask(CirculateOperationParam circulateOperationParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.circulateBizTask(circulateOperationParam);
    }

    @KSMethod
    public static SmsUsingQuantities getSmsUsingQuantitySummary() {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getSmsUsingQuantitySummary();
    }

    @KSMethod
    public static Map<String, Object> createTask(TaskEntityInfo taskEntityInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.createTask(taskEntityInfo);
    }

    @KSMethod
    public static Map<String, Object> batchComplateTasks(List<Long> taskIds, Long userId, ILocaleString opinion, Map<String, Object> variables) {
        logger.info(String.format("batchComplateTasks-%s-%s-%s-%s", taskIds.toString(), userId, opinion.toString(), variables.toString()));
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.batchComplateTasks(taskIds, userId, opinion, variables);
    }

    @KSMethod
    public static Map<String, Object> updateTaskParticipant(Long taskId, List<Long> userIds) {
        logger.info(String.format("batchComplateTasks-%s-%s", taskId, userIds.toString()));
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.updateTaskParticipant(taskId, userIds);
    }

    @KSMethod
    public static Map<String, Object> batchDeleteTasks(List<Long> taskIds) {
        logger.info(String.format("ApiBatchDeleteTasks-%s", taskIds));
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.batchDeleteTasks(taskIds);
    }

    @KSMethod
    public static Map<String, Object> batchSendMessages(List<MessageInfo> messageInfos) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.batchSendMessages(messageInfos);
    }

    @Deprecated
    @KSMethod
    public static long sendMessage(MessageInfo messageInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.sendMessage(messageInfo);
    }

    @KSMethod
    public static List<Map<String, Object>> getMsgCenterCardOptions(String uid) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMsgCenterCardOptions(uid);
    }

    @KSMethod
    public static long getUnReadMessageCount(String uid) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getUnReadMessageCount(uid);
    }

    @KSMethod
    public static List<Map<String, Object>> getUnReadMessage(String uid, int topCount) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getUnReadMessage(uid, topCount);
    }

    @KSMethod
    public static List<String> getMessageTemplateByFilters(String type, String channel, String scene, String entityNumber) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageTemplateByFilters(type, channel, scene, entityNumber);
    }

    @KSMethod
    public static List<ILocaleString> getMessageTemplateLocaleByFilters(String type, String channel, String scenen, String entityNumber) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageTemplateLocaleByFilters(type, channel, scenen, entityNumber);
    }

    @KSMethod
    public static String getChannelsOfMsgType(String type) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getChannelsOfMsgType(type);
    }

    @KSMethod
    public static Map<String, Object> retractMessage(Long messageId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.retractMessage(messageId);
    }

    @KSMethod
    public static void updateBadgeCount(List<Long> userIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.updateBadgeCount(userIds);
    }

    @KSMethod
    public static Map<String, Object> deleteMessage(List<Object> msgIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.deleteMessage(msgIds);
    }

    @KSMethod
    public static List<Map<String, Object>> getMessageByFilter(String userId, String entityNumber, String tags, String msgType, boolean unread, int top) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageByFilter(userId, entityNumber, tags, msgType, unread, top);
    }

    @KSMethod
    public static void setMsgReadState(List<Object> msgIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.setMsgReadState(msgIds);
    }

    @KSMethod
    public static List<Map<String, Object>> getToHandleTasksMessage(Long userId, Integer topCount) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getToHandleTasksMessage(userId, topCount);
    }

    @KSMethod
    public static Long getTohandleTaskCountByType(String uid, String type) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getTaskCountByType(uid, type);
    }

    @KSMethod
    public static void resendMessageByIds(List<Long> channelMsgIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.resendMessageByIds(channelMsgIds);
    }

    @KSMethod
    public static void resendMessageByMsgInfos(List<MessageInfo> messageInfos) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.resendMessageByMsgInfos(messageInfos);
    }

    @KSMethod
    public static Map<String, Object> updateChannelData(Map<String, Object> channelParam) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.updateChannelData(channelParam);
    }

    @KSMethod
    public static void setMsgReadState(Long msgId, List<Long> userIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.setMsgReadState(msgId, userIds);
    }

    @KSMethod
    public static Map<String, Object> getMessageReadState(Long msgId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageReadState(msgId);
    }

    @KSMethod
    public static Map<String, Object> sendNoticeMessageByLoginUser(Long userId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.sendNoticeMessageByLoginUser(userId);
    }

    public static Map<String, Object> builMessageUrl(String formId, String mobFormId, Long pkId, Map<String, Object> param) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.builMessageUrl(formId, mobFormId, pkId, param);
    }

    public static void setMessagePopup(Long messageId, List<Long> userIds, boolean popupState) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.setMessagePopup(messageId, userIds, popupState);
    }

    public static void clearMsgPersonalTopIdsCache(Long userId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.clearMsgPersonalTopIdsCache(userId);
    }

    public static List<Map<String, Object>> getUnreadActivityMessageByAppNum(Long userId, String ... appNum) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getUnreadActivityMessageByAppNum(userId, appNum);
    }

    @KSMethod
    public static void updateToDoMsgContent(MessageServiceConfig config, ITaskMsg taskMsg) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.updateToDoMsgContent(config, taskMsg);
    }

    @KSMethod
    public static void updateToDoMsgContent(MessageServiceConfig config, MessageInfo messageInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.updateToDoMsgContent(config, messageInfo);
    }

    @KSMethod
    public static List<Map<String, Object>> getMessageData(MessageRequestInfo messageRequestInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageData(messageRequestInfo);
    }

    @KSMethod
    public static Map<String, Object> getMessageById(List<Long> messageIds) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageById(messageIds);
    }

    @KSMethod
    public static void updateWxqyPublicAuthorizeData(String config) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageService.updateWxqyPublicAuthorizeData(config);
    }

    @KSMethod
    public static List<Map<String, Object>> getNoCodeFlowMessageData(MessageRequestInfo messageRequestInfo) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        messageRequestInfo.setSource("NoCodeFlow");
        messageRequestInfo.setUnread(Boolean.FALSE);
        return messageService.getMessageData(messageRequestInfo);
    }

    @KSMethod
    public static Long getNoCodeFlowMessageCount(String userId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getNoCodeFlowMessageCount(userId, null);
    }

    @KSMethod
    public static Long getNoCodeFlowUnReadMessageCount(String userId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getNoCodeFlowMessageCount(userId, "unread");
    }

    public static Map<String, Object> getEnableChannel() {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getEnableChannel();
    }

    @KSMethod
    public static Map<String, Object> getMessageDatas(String messageType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageDatas(messageType, messageCenterParams);
    }

    @KSMethod
    public static Long getMessageDatasCount(String messageType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMessageDatasCount(messageType, messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getToHandleTasks(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getToHandleTasks(messageCenterParams);
    }

    @KSMethod
    public static Long getToHandleTaskCount(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getToHandleTaskCount(messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getTransferTasks(String taskType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getTransferTasks(taskType, messageCenterParams);
    }

    @KSMethod
    public static Long getTransferTaskCount(String taskType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getTransferTaskCount(taskType, messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getDelegateTasks(String taskType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getDelegateTasks(taskType, messageCenterParams);
    }

    @KSMethod
    public static Long getDelegateTaskCount(String taskType, MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getDelegateTaskCount(taskType, messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getHandledTasks(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getHandledTasks(messageCenterParams);
    }

    @KSMethod
    public static Long getHandledTaskCount(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getHandledTaskCount(messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getToApplyProcess(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getToApplyProcess(messageCenterParams);
    }

    @KSMethod
    public static Long getToApplyProcessCount(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getToApplyProcessCount(messageCenterParams);
    }

    @KSMethod
    public static Map<String, Object> getApplyedProcess(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getApplyedProcess(messageCenterParams);
    }

    @KSMethod
    public static Long getApplyedProcessCount(MessageCenterParams messageCenterParams) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getApplyedProcessCount(messageCenterParams);
    }

    @KSMethod
    public static List<Map<String, Object>> getTaskAndMessageCategory() {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getTaskAndMessageCategory();
    }

    @KSMethod
    public static List<Map<String, Object>> getUserFilterSchemes(String formId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getUserFilterSchemes(formId);
    }

    @KSMethod
    public static List<Map<String, String>> getTaskAndMessageFields(String formId) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getTaskAndMessageFields(formId);
    }

    @KSMethod
    public static List<Map<String, Object>> getMsgCenterCardOptions(String uid, List<String> itemKey) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMsgCenterCardOptions(uid, itemKey);
    }

    @KSMethod
    public static List<Map<String, Object>> getMsgCenterCardType(String uid) {
        IMessageCenterService messageService = MessageCenterServiceHelper.getMessageService();
        return messageService.getMsgCenterCardType(uid);
    }
}

