/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.repair;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.health.repair.IRepair;
import kd.bos.health.svn.HealthSVNUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class AbstractMetadaRepair
implements IRepair {
    private static final String SVNPATH = "svnpath";
    private static final String USERNAME = "username";
    private static final String PW = "password";
    private static final String ANNOTATION = "annotation";

    @Override
    public void repair(Map<String, Object> data) {
    }

    public AbstractMetadata[] prepareRepair(Map<String, Object> data) {
        String id = (String)data.get("id");
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        return new AbstractMetadata[]{formMeta, entityMeta};
    }

    public void commit(Map<String, Object> data, AbstractMetadata[] abstractMetadatas) {
        String id = (String)data.get("id");
        String svnPath = (String)data.get(SVNPATH);
        String userName = (String)data.get(USERNAME);
        String passWord = (String)data.get(PW);
        String svnMessage = (String)data.get(ANNOTATION);
        String appNumber = (String)data.get("appnumber");
        IFormView view = (IFormView)data.get("view");
        String formModel = "BillFormModel";
        MetadataWriter writer = new MetadataWriter(formModel);
        writer.save(abstractMetadatas);
        List list = MetadataDao.getFormDeployFile((String)id);
        JSONObject message = new JSONObject();
        message.put(USERNAME, (Object)userName);
        message.put(PW, (Object)Encrypters.encode((String)passWord));
        message.put(SVNPATH, (Object)svnPath);
        ArrayList<String> commitPath = new ArrayList<String>(10);
        for (DeployFile deployFile : list) {
            commitPath.add(HealthSVNUtils.metaDataLocalPath + File.separator + appNumber + File.separator + "metadata" + File.separator + deployFile.getFileName());
        }
        JSONObject result = HealthSVNUtils.commit(svnPath, message, id, commitPath, svnMessage, HealthSVNUtils.metaDataLocalPath + File.separator + appNumber);
        if (result.get((Object)"ERROR") != null && view != null) {
            view.showMessage((String)result.get((Object)"ERROR"));
        }
    }

    public void checkOutFolder(Map<String, Object> data) {
        String svnPath = (String)data.get(SVNPATH);
        String userName = (String)data.get(USERNAME);
        String passWord = (String)data.get(PW);
        String appNumber = (String)data.get("appnumber");
        JSONObject message = new JSONObject();
        message.put(USERNAME, (Object)userName);
        message.put(PW, (Object)Encrypters.encode((String)passWord));
        message.put(SVNPATH, (Object)svnPath);
        SVNClientManager manager = HealthSVNUtils.getClientManager(svnPath, message, new JSONObject());
        HealthSVNUtils.checkRootFolder(HealthSVNUtils.metaDataLocalPath + File.separator + appNumber, svnPath, manager, new JSONObject());
    }

    public void removeItem(AbstractMetadata[] abstractMetadatas, String fieldId) {
        FormMetadata formMetadata = (FormMetadata)abstractMetadatas[0];
        List formLists = formMetadata.getItems();
        formLists.remove(formMetadata.getItem(fieldId));
        EntityMetadata entityMetadata = (EntityMetadata)abstractMetadatas[1];
        List entityLists = entityMetadata.getItems();
        EntityItem item = null;
        for (EntityItem entityItem : entityLists) {
            if (!entityItem.getId().equals(fieldId)) continue;
            item = entityItem;
        }
        if (item != null) {
            entityLists.remove(item);
        }
    }

    public boolean removeMetadata(String number, String appNumber, IFormView view, Map<String, Object> data) {
        String fileName = "delete_" + number;
        String id = (String)data.get("id");
        String svnPath = (String)data.get(SVNPATH);
        String userName = (String)data.get(USERNAME);
        String passWord = (String)data.get(PW);
        String annotaion = (String)data.get(ANNOTATION);
        JSONObject svnMsg = new JSONObject();
        svnMsg.put(USERNAME, (Object)userName);
        svnMsg.put(PW, (Object)Encrypters.encode((String)passWord));
        svnMsg.put(SVNPATH, (Object)svnPath);
        ArrayList<String> fileList = new ArrayList<String>();
        String localPath = HealthSVNUtils.metaDataLocalPath + File.separator + appNumber + File.separator + "preinsdata";
        fileList.add(localPath + File.separator + fileName + ".sql");
        HealthSVNUtils.commit(fileList, svnMsg, HealthSVNUtils.getClientManager(svnPath, svnMsg, new JSONObject()), annotaion);
        return true;
    }

    public void deleteMetadata(String formId) {
        Map result = new HashMap<String, String>(16);
        try (TXHandle tx = TX.required((String)"mdl_BizPageListPlugin_deletePage");){
            try {
                QFilter[] filters = null;
                QFilter f1 = new QFilter("form", "=", (Object)formId);
                filters = new QFilter[]{f1};
                DynamicObject dyc = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"id", (QFilter[])filters);
                String pkId = dyc.getString("id");
                Object[] pkIds = new String[]{pkId};
                MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                BusinessDataServiceHelper.delete((IDataEntityType)met, (Object[])pkIds);
                result = MetadataDao.delFormMetadata((String)formId);
                if (result != null && result.get("success") != null && !((Boolean)result.get("success")).booleanValue()) {
                    throw new KDException(BosErrorCode.deleteFailed, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u6709\u4f9d\u8d56\uff0c\u5220\u9664\u5931\u8d25\uff01", (String)"AbstractMetadaRepair_0", (String)"bos-healthexamination", (Object[])new Object[0])});
                }
            }
            catch (Exception e) {
                tx.markRollback();
            }
            try {
                List<Map<String, Object>> formList = this.findParentAndType(formId);
                Map<String, Object> form = formList.get(0);
                String devType = (String)form.get("devType");
                String masterId = (String)form.get("masterId");
                if ("2".equals(devType) && QueryServiceHelper.exists((String)"bos_formmeta", (Object)masterId)) {
                    MetadataDao.rebuildRuntimeMetaById((String)masterId);
                }
            }
            catch (Exception e) {
                if (result == null) {
                    throw new KDException(BosErrorCode.deleteFailed, new Object[]{ResManager.loadKDString((String)"\u5220\u9664\u9875\u9762\u5143\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a", (String)"AbstractMetadaRepair_1", (String)"bos-healthexamination", (Object[])new Object[0])});
                }
                result.put("rebuildruntimemeta", ResManager.loadKDString((String)"\u6e05\u7406\u8fd0\u884c\u671f\u5143\u6570\u636e\u7f13\u5b58\u5b58\u5728\u5f02\u5e38\uff01", (String)"AbstractMetadaRepair_2", (String)"bos-healthexamination", (Object[])new Object[0]));
            }
        }
    }

    public void removeSVNmetadata(Map<String, Object> data) {
        String id = (String)data.get("id");
        String svnPath = (String)data.get(SVNPATH);
        String userName = (String)data.get(USERNAME);
        String passWord = (String)data.get(PW);
        String annotaion = (String)data.get(ANNOTATION);
        List deployFileList = MetadataDao.getFormDeployFile((String)id);
        ArrayList<String> urls = new ArrayList<String>(10);
        for (DeployFile deployFile : deployFileList) {
            String fileName = deployFile.getFileName();
            urls.add(svnPath + "/metadata/" + fileName);
        }
        HealthSVNUtils.deleteMeta(svnPath, userName, passWord, urls, annotaion);
    }

    private List<Map<String, Object>> findParentAndType(String formId) {
        String sql = "select FNUMBER,FMASTERID,FPARENTID,FTYPE from T_META_FORMDESIGN where FID = ?";
        List formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{formId}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("parentId", rs.getString("FPARENTID"));
                    map.put("masterId", rs.getString("FMASTERID"));
                    map.put("devType", rs.getString("FTYPE"));
                    map.put("formNumber", rs.getString("FNUMBER"));
                    list.add(map);
                }
                return list;
            }
        });
        return formList;
    }
}

