/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.run;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAllValidate {
    private static final Logger logger = LoggerFactory.getLogger(StartAllValidate.class);
    public static String access_token = "";
    private HttpClient client = HttpClientBuilder.create().build();
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static void main(String[] args) {
        String url = null;
        String userid = null;
        String tenantid = null;
        String accountid = null;
        String appNumber = null;
        url = StartAllValidate.getArg(args, 0);
        userid = StartAllValidate.getArg(args, 1);
        tenantid = StartAllValidate.getArg(args, 2);
        accountid = StartAllValidate.getArg(args, 3);
        appNumber = StartAllValidate.getArg(args, 4);
        StartAllValidate start = new StartAllValidate();
        String startCaseApiUrl = url + "healthvalidate/validate.do?appNumber=" + appNumber;
        HttpGet httpGet = new HttpGet(startCaseApiUrl);
        httpGet.addHeader((Header)new BasicHeader("access_token", access_token));
        httpGet.setHeader("Accept-Language", "zh-CN,zh;");
        httpGet.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8;");
        try {
            if (start.login(url, userid, tenantid, accountid)) {
                HttpResponse response = start.client.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                byte[] contentByts = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                String res = new String(contentByts, UTF_8);
                List resultList = (List)JSON.parseObject((String)res, ArrayList.class);
                StringBuffer buffer = new StringBuffer();
                for (Object string : resultList) {
                    buffer.append(string).append(",\r\n");
                }
                logger.info("the message is\r\n:" + buffer);
            } else {
                logger.info("\u767b\u5f55\u5931\u8d25");
            }
        }
        catch (ClientProtocolException e) {
            logger.error("\u5ba2\u6237\u7aef\u534f\u8bae\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
    }

    private static String getArg(String[] args, int index) {
        String argVal = args[index];
        if (argVal == null || argVal.trim().length() == 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u53c2\u6570\u503c\u4e3a\u7a7a", (String)"StartAllValidate_2", (String)"bos-healthexamination", (Object[])new Object[0]), index));
        }
        return argVal.trim();
    }

    public boolean login(String url, String openid, String tenantid, String accountId) throws ClientProtocolException, IOException {
        String addr = url + "api/upgradeLogin.do";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("api", "true");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantid", tenantid);
        params.put("accountId", accountId);
        String jsEntity = JSON.toJSONString(params);
        String data = "";
        HttpPost post = new HttpPost(addr);
        try {
            Header respHeader;
            HttpEntity resEntity;
            for (Map.Entry entry : header.entrySet()) {
                post.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
            StringEntity se = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                resEntity = response.getEntity();
                respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = StartAllValidate.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity, (Charset)UTF_8);
                }
            } else {
                logger.info("!!!!statusCode:" + statusCode);
                try {
                    resEntity = response.getEntity();
                    respHeader = resEntity.getContentEncoding();
                    if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                        GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                        InputStream in = gzipEntity.getContent();
                        data = StartAllValidate.getHTMLContent(in);
                    } else {
                        data = EntityUtils.toString((HttpEntity)resEntity, (Charset)UTF_8);
                    }
                }
                catch (Exception e) {
                    logger.info("exception message:" + e.getMessage());
                    logger.info("exception StackTrace:" + Arrays.toString(e.getStackTrace()));
                }
            }
            logger.info("data:" + data);
            if (null == data || "".equals(data)) {
                logger.error("errorinfo:\u767b\u5f55\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff1a\u2460\u53c2\u6570\u4e2durl\u662f\u5426\u6b63\u786e\uff01\u2461\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u662f\u5426\u914d\u7f6e\u6570\u636e\u4e2d\u5fc3\uff01\u2462\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u73af\u5883\u4fe1\u606f\u4e0eurl\u662f\u5426\u5339\u914d\uff01");
            }
            Map map = (Map)JSON.parseObject((String)data, HashMap.class);
            Map token = (Map)map.get("data");
            access_token = token.get("access_token").toString();
        }
        catch (IOException ex) {
            logger.error("\u767b\u5f55\u5f02\u5e38\uff1a" + data);
            throw ex;
        }
        catch (JSONException ex) {
            logger.error("\u767b\u5f55\u65f6json\u89e3\u6790\u5f02\u5e38\uff1a" + data);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6htmlcontent\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6htmlcontent\u5f02\u5e38", (Throwable)e);
            }
        }
        return sb.toString();
    }
}

