/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.svn;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import org.apache.commons.io.FilenameUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class HealthSVNUtils {
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String metaDataLocalPath = USER_HOME + File.separator + "healthvalidate";
    private static final String ERROR = "error";
    private static final Log LOG = LogFactory.getLog(HealthSVNUtils.class);

    public static JSONObject commit(SVNClientManager clientManager, File[] files, JSONObject commitSVNMsg, String svnMessage) {
        try {
            clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, true, true);
            SVNCommitInfo info = clientManager.getCommitClient().doCommit(files, true, svnMessage, null, null, false, false, SVNDepth.INFINITY);
            if (info.equals(SVNCommitInfo.NULL)) {
                commitSVNMsg.put("CONFLICT", (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e\u65e0\u53d8\u5316,\u4e0d\u9700\u8981\u63d0\u4ea4\uff01", (String)"HealthSVNUtils_0", (String)"bos-healthexamination", (Object[])new Object[0]));
                return commitSVNMsg;
            }
        }
        catch (SVNException e) {
            String errMessage = e.getMessage();
            commitSVNMsg.put("ERROR", (Object)String.format(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"HealthSVNUtils_10", (String)"bos-healthexamination", (Object[])new Object[0]), errMessage));
            return commitSVNMsg;
        }
        return commitSVNMsg;
    }

    public static void checkRootFolder(String filePath, String svnPath, SVNClientManager clientManager, JSONObject checkoutMsg) {
        File checkOutFile = new File(FilenameUtils.getName((String)filePath));
        try {
            Boolean flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
            if (!flag.booleanValue()) {
                HealthSVNUtils.checkedOut(checkOutFile, svnPath, clientManager, checkoutMsg);
                flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
                if (!flag.booleanValue()) {
                    checkoutMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u76ee\u5f55\u4e0d\u662fsvn\u7ba1\u7406\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5:%s", (String)"HealthSVNUtils_2", (String)"bos-healthexamination", (Object[])new Object[0]), checkOutFile));
                }
            }
            clientManager.getWCClient().doCleanup(checkOutFile);
            clientManager.getWCClient().doRevert(new File[]{checkOutFile}, SVNDepth.INFINITY, null);
            clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, SVNDepth.INFINITY, false, true);
        }
        catch (SVNException e) {
            try {
                clientManager.getWCClient().doCleanup(checkOutFile);
                clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, false);
                clientManager.getWCClient().doRevert(checkOutFile, false);
                clientManager.getWCClient().doResolve(checkOutFile, false);
            }
            catch (SVNException e1) {
                checkoutMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u672c\u5730\u6587\u4ef6svn\u8def\u5f84\uff1a%s\u51fa\u9519\uff01\u89e3\u51b3\u529e\u6cd5\uff1a1\u3001\u8bf7\u5230\u672c\u5730\u8be5\u8def\u5f84\u4e0b\uff0c\u6267\u884csvn\u7684revert\u3001update\u3001cleanup\u540e\u518d\u8bd5\uff1b2\u3001\u5220\u9664\u8be5\u6587\u4ef6\u5939\u540e\u518d\u8bd5\u3002", (String)"HealthSVNUtils_3", (String)"bos-healthexamination", (Object[])new Object[0]), checkOutFile));
            }
        }
    }

    private static void checkedOut(File checkOutFile, String svnPath, SVNClientManager clientManager, JSONObject checkoutMsg) {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            updateClient.doCheckout(url, checkOutFile, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNException e) {
            checkoutMsg.put(ERROR, (Object)e.getMessage());
        }
    }

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static SVNClientManager getClientManager(String svnPath, JSONObject svnMsg, JSONObject checkOutMsg) {
        BasicAuthenticationManager authManager;
        HealthSVNUtils.setupLibrary();
        try {
            String userName = svnMsg.get((Object)"username").toString();
            String password = svnMsg.get((Object)"password").toString();
            password = Encrypters.decode((String)password);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(userName, password, false, url, false)});
            repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
            SVNNodeKind nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)ResManager.loadKDString((String)"svn\u8def\u5f84\u51fa\u9519", (String)"HealthSVNUtils_4", (String)"bos-healthexamination", (Object[])new Object[0]));
                throw new SVNException(err);
            }
        }
        catch (SVNException e) {
            checkOutMsg.put(ERROR, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            checkOutMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u8fde\u63a5\u51fa\u9519,\u8bf7\u68c0\u67e5svn\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u8def\u5f84\u662f\u5426\u6b63\u786e\uff01", (String)"HealthSVNUtils_5", (String)"bos-healthexamination", (Object[])new Object[0]));
            return null;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        return clientManager;
    }

    public static String getSVNUrl(String formNumber) {
        String bizAppId = BizAppServiceHelp.getAppIdByFormNum((String)formNumber);
        String svnPath = BizAppServiceHelp.getSVNPathByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            return svnPath;
        }
        return svnPath;
    }

    public static JSONObject commit(String svnPath, JSONObject message, String formId, List<String> commitPath, String svnMessage, String localPath) {
        SVNClientManager manager;
        File filePath = new File(FilenameUtils.getName((String)localPath));
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if ((manager = HealthSVNUtils.getClientManager(svnPath, message, new JSONObject())) != null) {
            HealthSVNUtils.checkRootFolder(localPath, svnPath, manager, new JSONObject());
        }
        HealthSVNUtils.expFormMetadata(formId, localPath);
        return HealthSVNUtils.commit(commitPath, message, manager, svnMessage);
    }

    public static JSONObject expFormMetadata(String formId, String exportPath) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (list != null && list.size() > 0) {
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    HealthSVNUtils.saveDymLangFile(dymLangMeta, dymLangFileName, exportPath);
                }
                HealthSVNUtils.saveDymLangFile(dymMeta, dymFileName, exportPath);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    private static void saveDymLangFile(String dymLangMeta, String dymLangFileName, String exportPath) {
        boolean flag;
        File file;
        String fullPath = HealthSVNUtils.getMetaXmlPath(dymLangFileName, exportPath);
        String[] abovePath = fullPath.split(dymLangFileName);
        File fileAbovePath = new File(FilenameUtils.getName((String)abovePath[0]));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        if ((file = new File(FilenameUtils.getName((String)fullPath))).exists() && !(flag = file.delete())) {
            LOG.info(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25", (String)"HealthSVNUtils_6", (String)"bos-healthexamination", (Object[])new Object[0]));
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
            boolean flag2 = file.createNewFile();
            if (!flag2) {
                LOG.info(ResManager.loadKDString((String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (String)"HealthSVNUtils_7", (String)"bos-healthexamination", (Object[])new Object[0]));
            }
            writer.write(dymLangMeta);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getMetaXmlPath(String filename, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, filename);
        return fullPath;
    }

    public static JSONObject commit(List<String> fileList, JSONObject commitSVNMsg, SVNClientManager manager, String svnMessage) {
        ArrayList<File> files = new ArrayList<File>(10);
        for (String url : fileList) {
            File file = new File(FilenameUtils.getName((String)url));
            files.add(file);
        }
        File[] filetocommit = files.toArray(new File[0]);
        return HealthSVNUtils.commit(manager, filetocommit, commitSVNMsg, svnMessage);
    }

    public static void saveFile(String content, String fileName, String filePath) {
        String path = filePath + File.separator + fileName + ".sql";
        File file = new File(FilenameUtils.getName((String)path));
        if (!file.exists()) {
            try {
                boolean flag = file.createNewFile();
                if (!flag) {
                    LOG.info(ResManager.loadKDString((String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (String)"HealthSVNUtils_7", (String)"bos-healthexamination", (Object[])new Object[0]));
                }
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static JSONObject deleteMeta(String svnPath, String username, String password, List<String> formUrls, String annotaion) {
        JSONObject svnMsg = new JSONObject();
        svnMsg.put("username", (Object)username);
        svnMsg.put("password", (Object)Encrypters.encode((String)password));
        SVNURL[] deleteUrls = new SVNURL[formUrls.size()];
        for (int i = 0; i < formUrls.size(); ++i) {
            String deleteUrl = formUrls.get(i);
            try {
                deleteUrls[i] = SVNURL.parseURIEncoded((String)deleteUrl);
                continue;
            }
            catch (SVNException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return HealthSVNUtils.deleteSVN(HealthSVNUtils.getClientManager(svnPath, svnMsg, new JSONObject()), deleteUrls, annotaion);
    }

    public static JSONObject deleteSVN(SVNClientManager clientManager, SVNURL[] deleteUrls, String deleteMessage) {
        JSONObject result = new JSONObject();
        if (clientManager == null) {
            result.put("fail", (Object)ResManager.loadKDString((String)"svn\u4e0a\u672a\u5220\u9664\uff0c\u539f\u56e0\uff1a\u8c03\u7528kd.bos.health.svn.HealthSVNUtils.deleteSVN()\u65b9\u6cd5\u65f6\uff0cclientManager\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"HealthSVNUtils_8", (String)"bos-healthexamination", (Object[])new Object[0]));
            return result;
        }
        try {
            SVNCommitClient commitClient = clientManager.getCommitClient();
            commitClient.doDelete(deleteUrls, deleteMessage);
            result.put("result", (Object)"success");
        }
        catch (SVNException e) {
            result.put("fail", (Object)String.format(ResManager.loadKDString((String)"svn\u4e0a\u672a\u5220\u9664\uff0c\u539f\u56e0", (String)"HealthSVNUtils_9", (String)"bos-healthexamination", (Object[])new Object[0]), e.getMessage()));
        }
        return result;
    }

    public static String createRemoveSql(String number, String id) {
        return "DELETE FROM T_META_FORMDESIGN WHERE FID = '" + id + "';\nDELETE FROM T_META_FORMDESIGN_L WHERE FID = '" + id + "';\nDELETE FROM T_META_ENTITYDESIGN WHERE FID = '" + id + "';\nDELETE FROM T_META_ENTITYDESIGN_L WHERE FID = '" + id + "';\nDELETE FROM T_META_FORM WHERE FID = '" + id + "';\nDELETE FROM T_META_ENTITY WHERE FID = '" + id + "';\nDELETE FROM T_META_ENTITYINFO WHERE FMAINENTITYID = '" + id + "'; \nDELETE FROM T_META_MAINENTITYINFO WHERE FDENTITYID = '" + id + "';\nDELETE FROM t_meta_bizunitrelform WHERE FID = '" + id + "';";
    }
}

