/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.validate;

import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.health.validate.HealthExcutor;
import kd.bos.health.validate.HealthMetaDataResult;
import kd.bos.health.validate.HealthResult;
import kd.bos.health.validate.HealthUtils;
import kd.bos.health.validate.HealthValidateMetaData;
import kd.bos.health.validator.IHealthValidator;
import kd.bos.health.validator.MetadataValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HealthMetaDataExcutor
extends HealthExcutor {
    private static final Log log = LogFactory.getLog(HealthMetaDataExcutor.class);
    private List<String> numbers = new ArrayList<String>();

    public List<String> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(List<String> numbers) {
        this.numbers = numbers;
    }

    public void addNumbers(String number) {
        this.numbers.add(number);
    }

    @Override
    public List<HealthResult> execute() {
        if (!this.numbers.isEmpty()) {
            String queryString = HealthUtils.stringJoin(this.numbers, ",");
            String sql = "select B.fname,A.fnumber,A.fdata,A.fid,C.FDATA from t_meta_entitydesign A LEFT OUTER JOIN t_meta_entitydesign_l B on A.fid=B.fid LEFT OUTER JOIN t_meta_formdesign C on A.FID=C.FID where A.fnumber in (" + queryString + ") and B.flocaleid='zh_CN'";
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<List<HealthResult>>(){

                public List<HealthResult> handle(ResultSet rs) throws Exception {
                    ArrayList<HealthResult> results = new ArrayList<HealthResult>(10);
                    while (rs.next()) {
                        Document document2;
                        Throwable throwable;
                        String name = rs.getString(1);
                        String number = rs.getString(2);
                        String entityXmlData = rs.getString(3);
                        String id = rs.getString(4);
                        String formXmlData = rs.getString(5);
                        HealthValidateMetaData metaData = new HealthValidateMetaData();
                        metaData.setName(name);
                        metaData.setNumber(number);
                        metaData.setId(id);
                        SAXReader saxReader = new SAXReader();
                        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                        try {
                            throwable = null;
                            try (StringReader entityStrReader = new StringReader(entityXmlData);){
                                document2 = saxReader.read((Reader)entityStrReader);
                                Element entityRoot = document2.getRootElement();
                                metaData.setEntityXmlData(entityRoot);
                            }
                            catch (Throwable document2) {
                                throwable = document2;
                                throw document2;
                            }
                        }
                        catch (DocumentException e) {
                            log.error((Throwable)e);
                        }
                        try {
                            throwable = null;
                            try (StringReader formStrReader = new StringReader(formXmlData);){
                                document2 = saxReader.read((Reader)formStrReader);
                                Element formRoot = document2.getRootElement();
                                metaData.setFormXmlData(formRoot);
                            }
                            catch (Throwable document3) {
                                throwable = document3;
                                throw document3;
                            }
                        }
                        catch (DocumentException e) {
                            log.error((Throwable)e);
                        }
                        for (IHealthValidator validator : HealthMetaDataExcutor.this.getValidatorConfig().getValidatorList()) {
                            if (!(validator instanceof MetadataValidator)) continue;
                            List<HealthResult> result = validator.execute(metaData);
                            if (result != null) {
                                for (HealthResult healthResult : result) {
                                    ((HealthMetaDataResult)healthResult).setId(id);
                                }
                            }
                            if (result == null) continue;
                            results.addAll(result);
                        }
                    }
                    return results;
                }
            });
        }
        return new ArrayList<HealthResult>();
    }
}

