/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.health.validator.HealthExamnationRegister;
import kd.bos.health.validator.IHealthValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ValidatorConfig {
    private static final Log log = LogFactory.getLog(ValidatorConfig.class);
    private List<IHealthValidator> validatorList = new ArrayList<IHealthValidator>();

    public ValidatorConfig() {
        for (String validatorClass : HealthExamnationRegister.registerValidate) {
            try {
                IHealthValidator validator = (IHealthValidator)Class.forName(validatorClass).newInstance();
                this.validatorList.add(validator);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Throwable)e);
            }
        }
    }

    public List<IHealthValidator> getValidatorList() {
        return this.validatorList;
    }

    public void setValidatorList(List<IHealthValidator> validateList) {
        this.validatorList = validateList;
    }

    public void addValidator(IHealthValidator validator) {
        this.validatorList.add(validator);
    }
}

