/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.validator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.health.validate.HealthMetaDataResult;
import kd.bos.health.validate.HealthResult;
import kd.bos.health.validate.HealthValidateData;
import kd.bos.health.validate.HealthValidateMetaData;
import kd.bos.health.validator.AbstractHealthValidator;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import org.dom4j.Element;
import org.dom4j.Node;

public class MetadataValidator
extends AbstractHealthValidator {
    @Override
    public List<HealthResult> execute(HealthValidateData data) {
        if (data instanceof HealthValidateMetaData) {
            return this.execute((HealthValidateMetaData)data);
        }
        return super.execute(data);
    }

    public List<HealthResult> execute(HealthValidateMetaData data) {
        if (this.getSelectNodes() == null) {
            return new ArrayList<HealthResult>();
        }
        String number = data.getNumber();
        String name = data.getName();
        Element root = data.getEntityXmlData();
        List nodeList = root.selectNodes(this.getSelectNodes());
        ArrayList<HealthResult> results = new ArrayList<HealthResult>();
        for (Node node : nodeList) {
            Node nameNode = node.selectSingleNode(".//Key");
            Node idNode = node.selectSingleNode(".//Id");
            Node entityNode = node.selectSingleNode(".//BaseEntityId");
            String basedataName = nameNode.getText();
            HealthMetaDataResult metaResult = new HealthMetaDataResult("field");
            metaResult.setNumber(number);
            metaResult.setName(name);
            metaResult.setMetadataField(idNode.getText());
            metaResult.setRepairClass("kd.bos.health.repair.FieldRemoveRepair");
            if (entityNode != null) {
                String basedataEntityId = entityNode.getText();
                if (StringUtils.isBlank((CharSequence)basedataEntityId)) {
                    this.addToReturn(results, basedataName, metaResult);
                    continue;
                }
                if (!this.needCheckRef()) continue;
                this.checkRef(results, basedataName, metaResult, basedataEntityId);
                continue;
            }
            this.addToReturn(results, basedataName, metaResult);
        }
        return results;
    }

    protected boolean needCheckRef() {
        return false;
    }

    private void checkRef(List<HealthResult> results, String basedataName, HealthMetaDataResult metaResult, String basedataEntityId) {
        try {
            MetadataDao.readRuntimeMeta((String)basedataEntityId, (MetaCategory)MetaCategory.Form);
        }
        catch (Exception e) {
            this.addToReturn(results, basedataName, metaResult);
        }
    }

    private void addToReturn(List<HealthResult> results, String basedataName, HealthMetaDataResult metaResult) {
        metaResult.setReturnText(basedataName + ":" + this.blankMsg());
        results.add(metaResult);
    }

    protected String getSelectNodes() {
        return null;
    }

    protected String blankMsg() {
        return "";
    }
}

