/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.web.ConcurrentCache;

public class DispatchServiceHelper {
    private static final ConcurrentCache<String, Object> proxyMap = new ConcurrentCache(5000);

    public static <T> T getBOSService(final String appId, String serviceName, Class<T> bizCls) {
        String key;
        Object obj;
        if (serviceName == null) {
            serviceName = bizCls.getSimpleName();
        }
        if ((obj = proxyMap.get(key = (appId + "#" + serviceName + "#" + bizCls.getName()).toLowerCase())) == null) {
            final String sn = serviceName;
            obj = Proxy.newProxyInstance(bizCls.getClassLoader(), new Class[]{bizCls}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return DispatchServiceHelper.invokeBOSServiceByAppId(appId, sn, method.getName(), args);
                }
            });
            proxyMap.put(key, obj);
        }
        return (T)obj;
    }

    public static Object invokeBOSServiceByFormId(String formId, String serviceName, String methodName, Object ... paras) {
        String appId = (String)DispatchServiceHelper.invokeBOSService("FormService", "getAppId", formId);
        DispatchService service = DispatchServiceHelper.serviceLookup(appId);
        return service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
    }

    private static DispatchService serviceLookup(String appId) {
        DispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        return service;
    }

    public static Object invokeBOSServiceByAppId(String appId, String serviceName, String methodName, Object ... paras) {
        DispatchService service = DispatchServiceHelper.serviceLookup(appId);
        return service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
    }

    public static Object invokeBOSService(String serviceName, String methodName, Object ... paras) {
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        return service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
    }

    static {
        ServiceLookup.addSystemAppId((String[])new String[]{"bos", "bd", "sbd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"iscb"});
        ServiceLookup.addSystemAppId((String[])new String[]{"cvp"});
        ServiceLookup.addSystemAppId((String[])new String[]{"idi"});
        ServiceLookup.addSystemAppId((String[])new String[]{"adm", "bid", "ent", "im", "mal", "pbd", "pur", "quo", "scp", "sou", "srm", "ten", "bdm", "mm", "lbd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"mppm", "mpur", "mscp", "pm", "pmm", "rebm", "repe", "resc", "resm"});
        ServiceLookup.addSystemAppId((String[])new String[]{"pmbd", "pmpd", "pmps"});
        ServiceLookup.addSystemAppId((String[])new String[]{"aifs", "ai", "ap", "ar", "bcm", "cas", "er", "fa", "fibd", "gl", "iep", "pa", "ua", "rpt", "cm", "em"});
        ServiceLookup.addSystemAppId((String[])new String[]{"ssc", "task"});
        ServiceLookup.addSystemAppId((String[])new String[]{"am", "bei", "fbp", "fim"});
        ServiceLookup.addSystemAppId((String[])new String[]{"exp", "kdem", "tra"});
        ServiceLookup.addSystemAppId((String[])new String[]{"eb"});
        ServiceLookup.addSystemAppId((String[])new String[]{"haos", "hbom", "hbp", "hbss", "heo", "hers", "hjms", "hlcs"});
        ServiceLookup.addSystemAppId((String[])new String[]{"hsas", "hsbp", "hsbs", "hscs", "hspp", "hsss"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bbc", "dmp", "dpa", "dpm", "drm", "gcm", "gmc", "mdr", "mem", "ocic", "ococ", "ocp", "orvc", "pos", "posm", "rsp", "rspm", "rss", "saa", "dbd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"tc"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bcm_calcnode"});
        ServiceLookup.addSystemAppId((String[])new String[]{"ir"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bos-up"});
    }
}

