/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.servicehelper.util.VersionManageUtil;
import kd.bos.web.DispatchServiceHelper;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GITManagerAction {
    private static final String SCRIPT = "script";
    private static final String BIZ_SCRIPT_SERVICE = "BizScriptService";
    private static final String SUCCESS = "success";
    private static final String METADATA_MERGE = "merge";
    private static final String LOG = "log";
    static Log logger = LogFactory.getLog(GITManagerAction.class);
    private static String delErrMsg = "delete file fail";

    public void getConflictFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String baseXml;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String type = request.getParameter("type");
        if (!LOG.equals(type) && !this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        String gitRepository = request.getParameter("gitrepository");
        String filePath = request.getParameter("filepath");
        String localMeta = request.getParameter("personalgitrepository");
        String remoteMeta = localMeta + "temp";
        String projectUrl = request.getParameter("projecturl");
        String commitId = request.getParameter("uuid");
        String[] spl = filePath.split("/");
        boolean isNewGit = DevportalCommonUtil.isEnableNewGit();
        String fileName = spl[spl.length - 1];
        if (isNewGit) {
            String[] split = filePath.split("\\$\\$");
            fileName = split[0];
        }
        map.clear();
        if (!VersionManageUtil.checkFileType((String)fileName, map)) {
            this.setReturnData(response, map);
            return;
        }
        if (METADATA_MERGE.equals(type)) {
            baseXml = Encrypters.decode((String)localMeta);
            baseXml = VersionManageUtil.unCompress((String)baseXml);
            String mergeXml = Encrypters.decode((String)gitRepository);
            mergeXml = VersionManageUtil.unCompress((String)mergeXml);
            Map<String, Object> res = this.handleMetaMerge(baseXml, mergeXml, fileName);
            ArrayList<String> hide = new ArrayList<String>();
            hide.add("whitespace");
            hide.add("rightarrow");
            res.put("hide", hide);
            this.setReturnData(response, res);
            return;
        }
        if (isNewGit) {
            baseXml = Encrypters.decode((String)projectUrl);
            baseXml = VersionManageUtil.unCompress((String)baseXml);
            String mergeXml = Encrypters.decode((String)gitRepository);
            mergeXml = VersionManageUtil.unCompress((String)mergeXml);
            String[] split = filePath.split("\\$\\$");
            String[] split1 = split[0].split("/");
            String name = split1[split1.length - 1];
            String lastCommitId = "";
            String currentCommitId = "";
            if (filePath.contains("$$$$")) {
                if (!filePath.endsWith("$$")) {
                    currentCommitId = split[2];
                }
            } else if (filePath.endsWith("$$")) {
                lastCommitId = split[1];
            } else {
                lastCommitId = split[1];
                currentCommitId = split[2];
            }
            Map<String, Object> res = this.handleGitDiff(baseXml, mergeXml, name, lastCommitId, currentCommitId);
            ArrayList<String> hide = new ArrayList<String>();
            hide.add("whitespace");
            hide.add("rightarrow");
            res.put("hide", hide);
            this.setReturnData(response, res);
            return;
        }
        String remoteFilePath = remoteMeta + File.separator + filePath;
        String localFilePath = localMeta + File.separator + filePath;
        String checkedRemoteFilePath = this.checkFilePath(remoteFilePath);
        String checkedLocalFilePath = this.checkFilePath(localFilePath);
        String localeContent = null;
        String remoteContent = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (SCRIPT.equals(type)) {
            remoteContent = this.getScriptFile(checkedRemoteFilePath);
            result.put("svncontent", remoteContent);
        } else {
            result.put("svncontent", this.getPageFile(checkedRemoteFilePath));
        }
        result.put("svnname", "Remote File " + fileName);
        if (SCRIPT.equals(type)) {
            localeContent = this.getScriptFile(checkedLocalFilePath);
            result.put("localecontent", localeContent);
        } else {
            result.put("localecontent", this.getPageFile(checkedLocalFilePath));
        }
        result.put("localename", "Local File " + fileName);
        this.setReturnData(response, result);
    }

    private Map<String, Object> handleMetaMerge(String lastXml, String xml, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("svncontent", lastXml);
        result.put("svnname", String.format(ResManager.loadKDString((String)"\u57fa\u51c6\u5143\u6570\u636e%s", (String)"GITManagerAction_0", (String)"bos-webactions", (Object[])new Object[0]), name));
        result.put("localecontent", xml);
        result.put("localename", String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5143\u6570\u636e%s", (String)"GITManagerAction_1", (String)"bos-webactions", (Object[])new Object[0]), name));
        return result;
    }

    private Map<String, Object> handleGitDiff(String lastXml, String xml, String name, String lastCommit, String currentCommit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("svncontent", lastXml);
        result.put("svnname", lastCommit + " " + name);
        result.put("localecontent", xml);
        result.put("localename", currentCommit + " " + name);
        return result;
    }

    private String getScriptFile(String localFilePath) {
        String scriptInfo = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getScriptFileByPath", localFilePath);
        return scriptInfo;
    }

    private String getPageFile(String filePath) {
        String pageInfo = (String)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "getPageFile", filePath);
        return pageInfo;
    }

    public void updateToLocale(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (!this.verifyInterface(map)) {
            this.setReturnData(response, map);
            return;
        }
        String id = request.getParameter("id");
        String bizAppId = request.getParameter("bizappid");
        String content = request.getParameter("content");
        String type = request.getParameter("type");
        String personalGitRepository = request.getParameter("personalgitrepository");
        boolean isNewGit = DevportalCommonUtil.isEnableNewGit();
        if (isNewGit) {
            this.updateFileToLocal(bizAppId, content, personalGitRepository, response);
            return;
        }
        String appNumber = (String)DispatchServiceHelper.invokeBOSService("BizAppService", "getAppNumberByAppId", bizAppId);
        String metaDataGitRepository = personalGitRepository + File.separator + "metadata" + File.separator + appNumber;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (SCRIPT.equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "gitUpdateScript", id, content);
            DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "gitSaveScriptFile", id, metaDataGitRepository);
            result.put(SUCCESS, flag);
        } else if ("page".equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updatePageContent", id, content);
            DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "gitSaveFormFile", id, metaDataGitRepository);
            result.put(SUCCESS, flag);
        } else if ("app".equalsIgnoreCase(type)) {
            boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "updateAppContent", id, content);
            result.put(SUCCESS, flag);
        }
        this.setReturnData(response, result);
    }

    private void setReturnData(HttpServletResponse response, Map<String, Object> result) throws IOException {
        String resultToString = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resultToString);
    }

    private void updateFileToLocal(String fileName, String content, String metaGitRepository, HttpServletResponse response) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean flag = (Boolean)DispatchServiceHelper.invokeBOSService(BIZ_SCRIPT_SERVICE, "saveFileToLocal", fileName, content, metaGitRepository);
        result.put(SUCCESS, flag);
        this.setReturnData(response, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pull(String gitUrl, String tempGirRepository, String userName, String passWord) {
        File file = new File(tempGirRepository);
        String projectURL = tempGirRepository + File.separator + ".git";
        File gitFile = new File(projectURL);
        if (!file.exists() || !gitFile.exists()) {
            GITManagerAction.cloneRepository(gitUrl, tempGirRepository, userName, passWord);
        }
        try (Git git = null;){
            git = Git.open((File)gitFile);
            PullCommand pull = git.pull();
            pull.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            pull.call();
        }
    }

    public static String cloneRepository(String gitUrl, String repository, String userName, String passWord) {
        try {
            GITManagerAction.deleteKd(new File(repository));
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(gitUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(userName, passWord));
            cloneCommand.setDirectory(new File(repository)).setCloneAllBranches(true).call();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Auth fail") || e.getMessage().contains("not authorized")) {
                return "noPermission";
            }
            return e.getMessage();
        }
        return SUCCESS;
    }

    private static void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                logger.warn(delErrMsg);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    logger.warn(delErrMsg);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                GITManagerAction.deleteKd(fileList[i]);
            }
            if (!file.delete()) {
                logger.warn(delErrMsg);
            }
        }
    }

    private String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    private boolean verifyInterface(Map<String, Object> result) {
        VersionManageUtil.checkPermission(result, (boolean)true);
        return result.get(SUCCESS) == null;
    }
}

