/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.ksql.util.Base64;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.web.DispatchServiceHelper;

public class ManagerCenterDeployAction {
    private static final Log logger = LogFactory.getLog(ManagerCenterDeployAction.class);
    private static final String PARAMS = "params";
    private static final String BOS_UP = "bos-up";
    private static final String MQ_DEPLOY_SERVICE = "MQDeployService";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA256";

    public void deploy() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(BOS_UP, MQ_DEPLOY_SERVICE, "deployMC", params);
        logger.info("MCDeploy result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void rebuild() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(BOS_UP, MQ_DEPLOY_SERVICE, "rebuildDym", params);
        logger.info("MCRebuildDym result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void beforeDeploy() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        params.put("action", "before");
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(BOS_UP, MQ_DEPLOY_SERVICE, "DeployPackageMC", params);
        logger.info("DeployPackageMC result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void afterDeploy() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        params.put("action", "after");
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(BOS_UP, MQ_DEPLOY_SERVICE, "DeployPackageMC", params);
        logger.info("DeployPackageMC result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void AppDeploy() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        Map result = (Map)DispatchServiceHelper.invokeBOSServiceByAppId(BOS_UP, MQ_DEPLOY_SERVICE, "AppDeploy", params);
        logger.info("APPDeploy result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void MQDeploy() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        Map result = (Map)DispatchServiceHelper.invokeBOSService("DeployService", "deployMC", params);
        logger.info("MCDeploy result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    public void MQRebuild() throws IOException {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String type = request.getParameter("type");
        String paramStr = request.getParameter(PARAMS);
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.put(PARAMS, param);
        }
        params.put("type", type);
        Object result = DispatchServiceHelper.invokeBOSService("DeployService", "rebuildDym", params);
        logger.info("MCRebuildDym result:" + SerializationUtils.toJsonString((Object)result));
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    private boolean signVerify(HttpServletRequest request) throws IOException {
        boolean isVerify = Boolean.parseBoolean(System.getProperty("kd.upgrade.signverify.enable"));
        if (!isVerify) {
            return true;
        }
        String tenantId = request.getHeader("tenantId");
        String upgradeSign = request.getHeader("upgradesign");
        String timeStamp = request.getParameter("timeStamp");
        byte[] key = this.getKey(tenantId);
        if (key == null || StringUtils.isBlank((CharSequence)timeStamp)) {
            logger.info("SystemProperty:mc_value_secret is null or timeStamp is null");
            return false;
        }
        String signInfo = this.computeSign(timeStamp, key);
        return signInfo.equals(upgradeSign);
    }

    String computeSign(String data, byte[] key) {
        String result = null;
        try {
            SecretKeySpec signinKey = new SecretKeySpec(key, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signinKey);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            return Base64.encodeBytes((byte[])rawHmac);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return result;
        }
    }

    private byte[] getKey(String tenantId) {
        String mcVal = SystemPropertyUtils.getProptyByTenant((String)"mc_value_secret", (String)tenantId);
        if (StringUtils.isBlank((CharSequence)mcVal)) {
            return null;
        }
        if (Encrypters.isEncrypted((String)mcVal)) {
            mcVal = Encrypters.decode((String)mcVal);
        }
        return mcVal.getBytes(StandardCharsets.UTF_8);
    }
}

