/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.ksql.util.Base64;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.web.DispatchServiceHelper;

public class ManagerCenterMetadataAction {
    private static final String FORM_ID = "formId";
    private static final String METADATA_SERVICE = "MetadataService";
    private static final String MESSAGE = "formId is null";
    private static final Log logger = LogFactory.getLog(ManagerCenterMetadataAction.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA256";

    private String getAppId(HttpServletRequest request) {
        String appId = request.getParameter("appId");
        appId = appId == null ? "bos" : appId;
        return appId;
    }

    public void getFormFunctions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.signVerify(request)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"Illegal request.");
            return;
        }
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId(appId, METADATA_SERVICE, "loadFormFunctions", formId)));
    }

    private boolean signVerify(HttpServletRequest request) throws IOException {
        boolean isVerify = Boolean.parseBoolean(System.getProperty("kd.upgrade.signverify.enable"));
        if (!isVerify) {
            return true;
        }
        String tenantId = request.getHeader("tenantId");
        String upgradeSign = request.getHeader("upgradesign");
        String timeStamp = request.getParameter("timeStamp");
        byte[] key = this.getKey(tenantId);
        if (key == null || StringUtils.isBlank((CharSequence)timeStamp)) {
            logger.info("SystemProperty:mc_value_secret is null or timeStamp is null");
            return false;
        }
        String signInfo = this.computeSign(timeStamp, key);
        return signInfo != null && signInfo.equals(upgradeSign);
    }

    private String computeSign(String data, byte[] key) {
        String result = null;
        try {
            SecretKeySpec signinKey = new SecretKeySpec(key, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signinKey);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            return Base64.encodeBytes((byte[])rawHmac);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return result;
        }
    }

    private byte[] getKey(String tenantId) {
        String mcVal = SystemPropertyUtils.getProptyByTenant((String)"mc_value_secret", (String)tenantId);
        if (StringUtils.isBlank((CharSequence)mcVal)) {
            return null;
        }
        if (Encrypters.isEncrypted((String)mcVal)) {
            mcVal = Encrypters.decode((String)mcVal);
        }
        return mcVal.getBytes(StandardCharsets.UTF_8);
    }
}

