/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.report.ColHeaderFilterParse;
import kd.bos.mservice.report.JoinRefColumn;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class CacheDataFilter {
    private static final Log log = LogFactory.getLog(CacheDataFilter.class);
    private static final String SPAN_TYPE = "ReportService";
    private String[] dataSetFields = null;
    private static final String BOS_MSERVICE_REPORT = "bos-mservice-report";

    CacheDataFilter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet filterAndSort(String cacheDataSetId, MainEntityType rptEntityType, List<ReportColumn> columns, List<FilterItemInfo> filterItemInfoList, String[] orderCols) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.filterAndSort");){
            if (span.isRealtime()) {
                span.addLocaleTag("cacheDataSetId", (Object)cacheDataSetId);
                span.addLocaleTag("filterItemInfoList", filterItemInfoList);
                span.addLocaleTag("orderCols", (Object)orderCols);
            }
            if (!(filterItemInfoList != null && !filterItemInfoList.isEmpty() || orderCols != null && orderCols.length != 0)) {
                DataSet dataSet = null;
                return dataSet;
            }
            if (StringUtils.isBlank((CharSequence)cacheDataSetId)) {
                DataSet dataSet = null;
                return dataSet;
            }
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheDataSetId);
            DataSet dataSet = cachedDataSet.toDataSet(Algo.create((String)(this.getClass().getName() + "#filterAndSort")), false);
            if (span.isRealtime()) {
                span.addLocaleTag("dataSet.fields", (Object)dataSet.getRowMeta().getFieldNames());
                span.addLocaleTag("columns", columns);
            }
            ColHeaderFilterParse filterParse = new ColHeaderFilterParse(rptEntityType, columns, dataSet.getRowMeta());
            LinkedHashMap<String, JoinRefColumn> joinColumnMap = new LinkedHashMap<String, JoinRefColumn>(4);
            HashMap<String, String> colKeyMap = new HashMap<String, String>(4);
            String filter = filterParse.buildScript(filterItemInfoList, colKeyMap, joinColumnMap);
            String[] orderbys = filterParse.buildOrderBy(orderCols, colKeyMap, joinColumnMap);
            DataSet dataSet2 = this.filterAndSort(dataSet, filter, orderbys, colKeyMap, joinColumnMap);
            return dataSet2;
        }
        catch (AlgoException e) {
            String message = e.getMessage();
            log.error("\u62a5\u8868\u4e8c\u6b21\u67e5\u8be2/\u8fc7\u6ee4\u62a5\u9519", (Throwable)e);
            if (!message.startsWith("Cache dataset not found or timed out: ")) throw new KDBizException(message);
            message = ResManager.loadKDString((String)"\u754c\u9762\u8bbf\u95ee\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6216\u5237\u65b0\u3002", (String)"CacheDataFilter_0", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    public DataSet filterAndSort(DataSet dataSet, MainEntityType rptEntityType, List<ReportColumn> columns, List<FilterItemInfo> filterItemInfoList, String[] orderCols) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.filterAndSort");){
            if (span.isRealtime()) {
                span.addLocaleTag("filterItemInfoList", filterItemInfoList);
                span.addLocaleTag("orderCols", (Object)orderCols);
                span.addLocaleTag("dataSet.fields", (Object)dataSet.getRowMeta().getFieldNames());
                span.addLocaleTag("columns", columns);
            }
            if (!(filterItemInfoList != null && !filterItemInfoList.isEmpty() || orderCols != null && orderCols.length != 0)) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            ColHeaderFilterParse filterParse = new ColHeaderFilterParse(rptEntityType, columns, dataSet.getRowMeta());
            LinkedHashMap<String, JoinRefColumn> joinColumnMap = new LinkedHashMap<String, JoinRefColumn>(4);
            HashMap<String, String> colKeyMap = new HashMap<String, String>(4);
            String filter = filterParse.buildScript(filterItemInfoList, colKeyMap, joinColumnMap);
            String[] orderbys = filterParse.buildOrderBy(orderCols, colKeyMap, joinColumnMap);
            DataSet dataSet3 = this.filterAndSort(dataSet, filter, orderbys, colKeyMap, joinColumnMap);
            return dataSet3;
        }
    }

    public DataSet filterAndSort(DataSet dataSet, String filter, String[] orderbys, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.doFilterAndSort");){
            if (span.isRealtime()) {
                span.addLocaleTag("filter", (Object)filter);
                span.addLocaleTag("orderbys", (Object)orderbys);
                span.addLocaleTag("colKeyMap", colKeyMap);
                span.addLocaleTag("joinColumnMap", joinColumnMap);
            }
            if (StringUtils.isBlank((CharSequence)filter) && (orderbys == null || orderbys.length == 0)) {
                DataSet dataSet2 = dataSet;
                return dataSet2;
            }
            if (dataSet == null) {
                DataSet dataSet3 = null;
                return dataSet3;
            }
            DataSet dataSet4 = this.doFilterAndSort(dataSet, filter, orderbys, colKeyMap, joinColumnMap);
            return dataSet4;
        }
    }

    protected DataSet doFilterAndSort(DataSet dataSet, String filter, String[] orderbys, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        DataSet outSet = dataSet;
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.beforeSelect");){
            outSet = this.beforeSelect(outSet, colKeyMap);
            if (span.isRealtime()) {
                span.addLocaleTag("dataSetFields", (Object)this.dataSetFields);
            }
        }
        span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.join");
        var8_8 = null;
        try {
            outSet = this.join(outSet, joinColumnMap);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var8_8 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.doFilter");
        var8_8 = null;
        try {
            outSet = this.doFilter(outSet, filter);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var8_8 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.doOrder");
        var8_8 = null;
        try {
            outSet = this.doOrder(outSet, orderbys);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var8_8 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        span = EntityTracer.create((String)SPAN_TYPE, (String)"CacheDataFilter.afterSelect");
        var8_8 = null;
        try {
            outSet = this.afterSelect(outSet, colKeyMap, joinColumnMap);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (var8_8 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        return outSet;
    }

    protected DataSet beforeSelect(DataSet dataSet, Map<String, String> colKeyMap) {
        this.dataSetFields = dataSet.getRowMeta().getFieldNames();
        if (colKeyMap == null || colKeyMap.isEmpty()) {
            return dataSet;
        }
        String[] selects = this.buildSelect(dataSet.getRowMeta(), colKeyMap);
        return dataSet.select(selects);
    }

    protected String[] buildSelect(RowMeta rowMeta, Map<String, String> colKeyMap) {
        HashMap<String, ArrayList<String>> fieldKeyMap = new HashMap<String, ArrayList<String>>(colKeyMap.size());
        for (Map.Entry<String, String> entry : colKeyMap.entrySet()) {
            String colKey = entry.getKey();
            String fieldKey = entry.getValue();
            ArrayList<String> list = (ArrayList<String>)fieldKeyMap.get(fieldKey);
            if (list == null) {
                list = new ArrayList<String>(1);
                fieldKeyMap.put(fieldKey, list);
            }
            list.add(colKey);
        }
        this.dataSetFields = new String[rowMeta.getFieldCount()];
        ArrayList<String> selects = new ArrayList<String>(rowMeta.getFieldCount());
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            String select = rowMeta.getFieldName(i);
            this.dataSetFields[i] = rowMeta.getFieldName(i);
            if (!colKeyMap.containsKey(select)) {
                selects.add(select);
            } else {
                String alias = select + DB.genLongId((String)"");
                selects.add(select + " as " + alias);
                this.dataSetFields[i] = alias + " as " + select;
            }
            List list = (List)fieldKeyMap.get(select);
            if (list == null) continue;
            for (String colKey : list) {
                selects.add(select + " as " + colKey);
            }
        }
        return selects.toArray(new String[0]);
    }

    protected DataSet afterSelect(DataSet dataSet, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        if (colKeyMap.isEmpty() && joinColumnMap.isEmpty()) {
            return dataSet;
        }
        return dataSet.select(this.dataSetFields);
    }

    protected DataSet join(DataSet dataSet, Map<String, JoinRefColumn> joinColumnMap) {
        if (joinColumnMap == null || joinColumnMap.size() == 0) {
            return dataSet;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<String> fieldKeys = new ArrayList<String>(Arrays.asList(rowMeta.getFieldNames()));
        DataSet outSet = dataSet;
        String algoKey = this.getClass().getName() + "#join";
        ORM orm = ORM.create();
        for (Map.Entry<String, JoinRefColumn> joinItem : joinColumnMap.entrySet()) {
            JoinRefColumn joinColumn = joinItem.getValue();
            DataSet copy = outSet.copy();
            DataSet idSet = copy.select(joinColumn.getJoinField()).distinct();
            ArrayList<Object> ids = new ArrayList<Object>(10);
            while (idSet.hasNext()) {
                Row row = idSet.next();
                ids.add(row.get(0));
            }
            QFilter idsFilter = new QFilter("id", "in", ids);
            String idAlias = joinColumn.getJoinField() + ".id";
            String idKey = "id as " + idAlias;
            DataSet joinDataSet = orm.queryDataSet(algoKey, joinColumn.getJoinEntityNumber(), idKey + ", " + joinColumn.getSelectStr(), new QFilter[]{idsFilter});
            JoinDataSet join = outSet.leftJoin(joinDataSet).on(joinColumn.getJoinField(), idAlias);
            String[] selFields = joinColumn.getFieldAlias();
            join.select(fieldKeys.toArray(new String[0]), selFields);
            for (String selField : selFields) {
                fieldKeys.add(selField);
            }
            outSet = join.finish();
        }
        return outSet;
    }

    protected DataSet doFilter(DataSet dataSet, String filter) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            return dataSet.filter((FilterFunction)new FormulaFilter(filter));
        }
        return dataSet;
    }

    protected DataSet doOrder(DataSet dataSet, String[] orderbys) {
        if (orderbys != null && orderbys.length > 0) {
            return dataSet.orderBy(orderbys);
        }
        return dataSet;
    }

    static class FormulaFilter
    extends FilterFunction
    implements Serializable {
        private String filter;
        private transient BOSExpression expression;
        private transient Map<String, Integer> fieldIndexs = null;

        public FormulaFilter(String filter) {
            this.filter = filter;
        }

        public boolean test(Row row) {
            if (this.getExpression().getExpr() == null) {
                return true;
            }
            Map<String, Object> ctx = this.getVarVals(row);
            return (Boolean)FormulaEngine.execExcelFormula((Expr)this.getExpression().getExpr(), ctx);
        }

        private Map<String, Object> getVarVals(Row row) {
            Map<String, Integer> indexs = this.getFieldIndexs();
            HashMap<String, Object> varValues = new HashMap<String, Object>(indexs.size());
            for (Map.Entry<String, Integer> var : indexs.entrySet()) {
                varValues.put(var.getKey(), row.get(var.getValue().intValue()));
            }
            return varValues;
        }

        private BOSExpression getExpression() {
            if (this.expression == null) {
                this.expression = new BOSExpression(this.filter);
            }
            return this.expression;
        }

        private Map<String, Integer> getFieldIndexs() {
            BOSExpression expr = this.getExpression();
            if (this.fieldIndexs == null) {
                if (expr.getVars() == null || expr.getVars().isEmpty()) {
                    this.fieldIndexs = new HashMap<String, Integer>(0);
                } else {
                    this.fieldIndexs = new HashMap<String, Integer>(expr.getVars().size());
                    RowMeta rowMeta = this.getSourceRowMeta();
                    for (String var : expr.getVars()) {
                        this.fieldIndexs.put(var, rowMeta.getFieldIndex(var));
                    }
                }
            }
            return this.fieldIndexs;
        }
    }
}

