/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.mservice.report.JoinRefColumn;
import kd.bos.mvc.report.ReportPropUtil;

class ColHeaderFilterParse {
    private static final String SPAN_TYPE = "ReportService";
    private List<ReportColumn> columnList;
    private Map<String, ReportColumn> columnMap;
    private MainEntityType rptEntityType = null;
    private MainEntityType localMainType = null;
    private Set<String> dataSourceFields = null;

    public ColHeaderFilterParse(MainEntityType rptEntityType, List<ReportColumn> columnList, RowMeta rowMeta) {
        this.rptEntityType = rptEntityType;
        this.columnList = columnList;
        this.columnMap = new HashMap<String, ReportColumn>(columnList.size());
        for (ReportColumn col : columnList) {
            this.columnMap.put(col.getFieldKey(), col);
        }
        if (rowMeta != null) {
            String[] fields = rowMeta.getFieldNames();
            this.dataSourceFields = new HashSet<String>(fields.length);
            for (String field : fields) {
                this.dataSourceFields.add(field.toLowerCase(Locale.ENGLISH));
            }
        }
    }

    public String[] buildOrderBy(String[] colKeys, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        if (colKeys == null) {
            return null;
        }
        if (colKeys.length == 0) {
            return new String[0];
        }
        ArrayList<String> orderbys = new ArrayList<String>(colKeys.length);
        MainEntityType mainType = this.getMainType();
        for (int i = 0; i < colKeys.length; ++i) {
            String colKey;
            ReportColumn col;
            String[] arr = StringUtils.split((String)colKeys[i]);
            if (arr.length == 0 || arr.length > 2 || (col = this.columnMap.get(colKey = arr[0])) == null || !this.existInDataSource(col)) continue;
            String orderby = colKey;
            ArrayList<String> displayProps = new ArrayList<String>(0);
            IDataEntityProperty prop = this.getProp(mainType, col, displayProps);
            if (prop == null) continue;
            this.addColKeyToFieldName(col, colKeyMap);
            List<JoinRefColumn> list = this.buildJoinColumn(prop, displayProps.toArray(new String[0]));
            if (!list.isEmpty()) {
                JoinRefColumn.SelectField selectField = list.get(list.size() - 1).getSelectFields().entrySet().iterator().next().getValue();
                orderby = selectField.getAlias();
                for (JoinRefColumn item : list) {
                    JoinRefColumn joinRefColumn = joinColumnMap.get(item.getJoinField());
                    if (joinRefColumn != null) {
                        joinRefColumn.getSelectFields().putAll(item.getSelectFields());
                        continue;
                    }
                    joinColumnMap.put(item.getJoinField(), item);
                }
            }
            if (arr.length > 1) {
                orderbys.add(orderby + " " + arr[1]);
                continue;
            }
            orderbys.add(orderby);
        }
        return orderbys.toArray(new String[0]);
    }

    public String buildScript(List<FilterItemInfo> filterItemInfos, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        if (filterItemInfos == null || filterItemInfos.isEmpty()) {
            return null;
        }
        FilterCondition filterCondition = this.buildFilterCondition(filterItemInfos, colKeyMap, joinColumnMap);
        FilterBuilder filterBuilder = new FilterBuilder(this.getMainType(), filterCondition);
        String[] scripts = filterBuilder.buildFilterScript();
        return scripts == null || scripts.length == 0 ? null : scripts[0];
    }

    private MainEntityType getMainType() {
        if (this.localMainType == null) {
            RptEntityBuilder rptEntityBuilder = new RptEntityBuilder(this.rptEntityType, this.columnList);
            this.localMainType = rptEntityBuilder.build();
        }
        return this.localMainType;
    }

    private FilterCondition buildFilterCondition(List<FilterItemInfo> filterItemInfos, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        FilterCondition filterCondition = new FilterCondition();
        for (FilterItemInfo item : filterItemInfos) {
            ArrayList<FilterValue> values = new ArrayList<FilterValue>(1);
            FilterValue valueItem = null;
            if (item.getValue() instanceof List) {
                List list = (List)item.getValue();
                for (Object obj : list) {
                    valueItem = new FilterValue();
                    valueItem.setValue(obj);
                    values.add(valueItem);
                }
            } else {
                valueItem = new FilterValue();
                valueItem.setValue(item.getValue());
                values.add(valueItem);
            }
            this.addSimpleFilterRow(filterCondition, item, values, colKeyMap, joinColumnMap);
        }
        return filterCondition;
    }

    private void addSimpleFilterRow(FilterCondition filterCondition, FilterItemInfo item, List<FilterValue> value, Map<String, String> colKeyMap, Map<String, JoinRefColumn> joinColumnMap) {
        String colKey = item.getPropName();
        ReportColumn col = this.columnMap.get(colKey);
        if (col == null) {
            return;
        }
        if (!this.existInDataSource(col)) {
            return;
        }
        this.addColKeyToFieldName(col, colKeyMap);
        ArrayList<String> displayProps = new ArrayList<String>(0);
        IDataEntityProperty prop = this.getProp(this.getMainType(), col, displayProps);
        if (prop == null) {
            return;
        }
        List<JoinRefColumn> list = this.buildJoinColumn(prop, displayProps.toArray(new String[0]));
        for (JoinRefColumn listItem : list) {
            JoinRefColumn joinRefColumn = joinColumnMap.get(listItem.getJoinField());
            if (joinRefColumn != null) {
                joinRefColumn.getSelectFields().putAll(listItem.getSelectFields());
                continue;
            }
            joinColumnMap.put(listItem.getJoinField(), listItem);
        }
        if (!list.isEmpty()) {
            JoinRefColumn joinRefColumn = list.get(0);
            String[] disFullPropNames = joinRefColumn.getFieldAlias();
            if (disFullPropNames.length == 1) {
                String fullFieldKey = joinRefColumn.getFieldAlias()[0];
                SimpleFilterRow simpleFilterRow = new SimpleFilterRow("", item.getCompareType(), fullFieldKey, "", LogicOperate.AND.name(), value);
                filterCondition.addFilterRow(simpleFilterRow);
            } else {
                for (int i = 0; i < disFullPropNames.length; ++i) {
                    String leftBracket = i == 0 ? "(" : "";
                    String rightBracket = i == displayProps.size() - 1 ? ")" : "";
                    LogicOperate logic = i == displayProps.size() - 1 ? LogicOperate.AND : LogicOperate.OR;
                    String fullFieldKey = disFullPropNames[i];
                    SimpleFilterRow simpleFilterRow = new SimpleFilterRow(leftBracket, item.getCompareType(), fullFieldKey, rightBracket, logic.toString(), value);
                    filterCondition.addFilterRow(simpleFilterRow);
                }
            }
        } else {
            SimpleFilterRow simpleFilterRow = new SimpleFilterRow("", item.getCompareType(), colKey, "", LogicOperate.AND.name(), value);
            filterCondition.addFilterRow(simpleFilterRow);
        }
    }

    private List<JoinRefColumn> buildJoinColumn(IDataEntityProperty prop, String[] displayProps) {
        if (displayProps == null || displayProps.length == 0) {
            return new ArrayList<JoinRefColumn>(0);
        }
        ArrayList<JoinRefColumn> joinColumnList = new ArrayList<JoinRefColumn>(displayProps.length);
        IDataEntityType refType = null;
        if (prop instanceof IBasedataField) {
            refType = ((IBasedataField)prop).getComplexType();
        } else if (prop instanceof IRefBillField) {
            refType = ((IRefBillField)prop).getComplexType();
        }
        if (refType != null) {
            JoinRefColumn joinColumn = new JoinRefColumn(refType.getName(), prop.getName(), displayProps);
            joinColumnList.add(joinColumn);
        }
        return joinColumnList;
    }

    private boolean existInDataSource(ReportColumn col) {
        String dataSourceField = col.getFieldKey();
        if (StringUtils.isNotBlank((CharSequence)col.getDateIndex()) && !StringUtils.equalsIgnoreCase((CharSequence)col.getFieldKey(), (CharSequence)col.getDateIndex())) {
            dataSourceField = col.getDateIndex();
        }
        if (dataSourceField != null) {
            dataSourceField = dataSourceField.toLowerCase(Locale.ENGLISH);
        }
        boolean exists = true;
        if (this.dataSourceFields != null && !this.dataSourceFields.contains(dataSourceField)) {
            ReportColumn refCol;
            exists = false;
            if (StringUtils.isNotBlank((CharSequence)col.getRefBasedataProp()) && (refCol = this.columnMap.get(col.getRefBasedataProp())) != null) {
                String refBasedata = StringUtils.isBlank((CharSequence)refCol.getDateIndex()) ? refCol.getFieldKey() : refCol.getDateIndex();
                exists = this.dataSourceFields.contains(refBasedata);
            }
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ColHeaderFilterParse.existInDataSource", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("col.fieldKey", (Object)col.getFieldKey());
                span.addLocaleTag("col.dataIndex", (Object)col.getDateIndex());
                span.addLocaleTag("dataIndex", (Object)dataSourceField);
                span.addLocaleTag("rowSet.fields", this.dataSourceFields);
                span.addLocaleTag("exists", (Object)exists);
            }
        }
        return exists;
    }

    private void addColKeyToFieldName(ReportColumn col, Map<String, String> colKeyMap) {
        ReportColumn bdCol;
        if (StringUtils.isNotBlank((CharSequence)col.getDateIndex()) && !StringUtils.equalsIgnoreCase((CharSequence)col.getFieldKey(), (CharSequence)col.getDateIndex())) {
            colKeyMap.put(col.getFieldKey(), col.getDateIndex());
        } else if (StringUtils.isNotBlank((CharSequence)col.getRefBasedataProp()) && (bdCol = this.columnMap.get(col.getRefBasedataProp())) != null) {
            this.addColKeyToFieldName(bdCol, colKeyMap);
        }
    }

    private IDataEntityProperty getProp(MainEntityType mainType, ReportColumn col, List<String> dispProps) {
        DynamicProperty prop = mainType.getProperty(col.getFieldKey());
        if (prop != null) {
            String[] displayPropArr = EntityTypeUtil.getBasedataDisplayProps((IDataEntityProperty)prop);
            if (displayPropArr != null) {
                for (String dispProp : displayPropArr) {
                    if (!StringUtils.isNotBlank((CharSequence)dispProp)) continue;
                    dispProps.add(dispProp);
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)col.getRefBasedataProp()) && (prop = mainType.getProperty(col.getRefBasedataProp())) != null) {
            dispProps.add(col.getDisplayProp());
        }
        return prop;
    }

    public static class RptEntityBuilder {
        private MainEntityType rptEntityType = null;
        private List<ReportColumn> columnList;

        public RptEntityBuilder(MainEntityType rptEntityType, List<ReportColumn> columnList) {
            this.rptEntityType = rptEntityType;
            this.columnList = columnList;
        }

        public MainEntityType build() {
            MainEntityType mainType = null;
            if (this.rptEntityType == null) {
                mainType = new MainEntityType();
                mainType.setName("rpt_colheaderfilterparse");
            } else {
                mainType = this.rptEntityType;
            }
            MainEntityType copyMainType = (MainEntityType)ReportPropUtil.createReportType((DynamicObjectType)mainType, this.columnList);
            for (ReportColumn column : this.columnList) {
                if (!StringUtils.isNotBlank((CharSequence)column.getDateIndex())) continue;
                String colKey = column.getFieldKey();
                String propName = column.getDateIndex() + "_" + column.getFieldKey();
                DynamicProperty colProp = copyMainType.getProperty(propName);
                if (!(colProp instanceof DynamicProperty)) continue;
                DynamicProperty prop = copyMainType.getProperty(colKey);
                if (prop != null) {
                    copyMainType.getProperties().remove((Object)prop);
                }
                colProp.setName(colKey);
                copyMainType.getProperties().remove((Object)colProp);
                copyMainType.getProperties().add((Object)colProp);
            }
            return copyMainType;
        }
    }
}

