/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;

class JoinRefColumn {
    private String joinEntityNumber;
    private String joinField;
    private static final String SPLIT_CHAR = ".";
    private Map<String, SelectField> selectFields;

    public JoinRefColumn(String joinEntityNumber, String joinField, String[] selectKeys) {
        this.joinEntityNumber = joinEntityNumber;
        this.joinField = joinField;
        this.selectFields = new HashMap<String, SelectField>(1);
        for (String selectKey : selectKeys) {
            String alias = this.buildAlias(joinField, selectKey);
            this.selectFields.put(selectKey, new SelectField(selectKey, alias));
        }
    }

    public String getJoinEntityNumber() {
        return this.joinEntityNumber;
    }

    public String getJoinField() {
        return this.joinField;
    }

    public void addSelectField(String selectKey) {
        String alias = this.buildAlias(this.joinField, selectKey);
        this.selectFields.put(selectKey, new SelectField(selectKey, alias));
    }

    public Map<String, SelectField> getSelectFields() {
        return this.selectFields;
    }

    public String getSelectStr() {
        if (this.selectFields.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, SelectField> item : this.selectFields.entrySet()) {
            stringBuilder.append(item.getValue().toString()).append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public String[] getFieldAlias() {
        ArrayList<String> alias = new ArrayList<String>(this.selectFields.size());
        for (Map.Entry<String, SelectField> entry : this.selectFields.entrySet()) {
            alias.add(entry.getValue().getAlias());
        }
        return alias.toArray(new String[0]);
    }

    private String buildAlias(String joinField, String selField) {
        return String.format("%s%s%s", joinField, SPLIT_CHAR, selField);
    }

    public String toString() {
        return String.format("select [%s] from dataSet left join [%s] on dataSet.[%s] = [%s].id", this.getSelectStr(), this.joinEntityNumber, this.joinField, this.joinEntityNumber);
    }

    static class SelectField {
        private String fieldKey;
        private String alias;

        public SelectField(String fieldKey, String alias) {
            this.fieldKey = fieldKey;
            this.alias = alias;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            if (StringUtils.isBlank((CharSequence)this.alias)) {
                return this.fieldKey;
            }
            return this.fieldKey + " as " + this.alias;
        }
    }
}

