/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dbversion;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dbversion.VersionCaptionInfo;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class IndustryVersionService {
    private static Log log = LogFactory.getLog(IndustryVersionService.class);
    private static final String INDUSTRY_VERSION_TYPE = "INDUSTRY_VERSION_TYPE_REGION";
    private static final String COSMIC_BOS = "cosmic_bos";
    private static final String CCS_PREFIX = "constellation_";
    private static final String GALAXY_PREFIX = "galaxy_";
    private static final String COSMIC_BOS_CCS_PREFIX = "cosmic_bos_constellation_";
    private static final String COSMIC_BOS_GALAXY_PREFIX = "cosmic_bos_galaxy_";
    private static final String COSMIC_BOS_VERSION_CAPTION_LIST = "cosmic_bos_version_caption_list";
    private static final String VERSION_CAPTION_PREFIX = "version_caption_";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("INDUSTRY_VERSION_TYPE_REGION", new DistributeCacheHAPolicy());

    public static List<IndustryVersionInfo> getVersion(String productNumber) {
        String verStr = IndustryVersionService.getFromLocalCache(productNumber);
        List<Object> versionList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)verStr) && (versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class)) != null && !versionList.isEmpty()) {
            return versionList;
        }
        verStr = IndustryVersionService.getFromCache(productNumber);
        if (StringUtils.isNotBlank((CharSequence)verStr)) {
            versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class);
            if (versionList != null && !versionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(productNumber, verStr);
            }
            return versionList;
        }
        versionList = IndustryVersionService.getVersionFromDB(productNumber);
        if (versionList != null && !versionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(versionList);
            IndustryVersionService.putToLocalCache(productNumber, str);
            IndustryVersionService.putToCache(productNumber, str);
        }
        return versionList;
    }

    public static IndustryVersionInfo getVersion(String productNumber, String isv) {
        String verStr = IndustryVersionService.getFromLocalCache(productNumber, isv);
        if (StringUtils.isNotBlank((CharSequence)verStr)) {
            return (IndustryVersionInfo)SerializationUtils.fromJsonString((String)verStr, IndustryVersionInfo.class);
        }
        verStr = IndustryVersionService.getFromCache(productNumber, isv);
        if (StringUtils.isNotBlank((CharSequence)verStr)) {
            IndustryVersionService.putToLocalCache(productNumber, isv, verStr);
            return (IndustryVersionInfo)SerializationUtils.fromJsonString((String)verStr, IndustryVersionInfo.class);
        }
        IndustryVersionInfo verInfo = IndustryVersionService.getVersionFromDB(productNumber, isv);
        if (verInfo != null) {
            String str = SerializationUtils.toJsonString((Object)verInfo);
            IndustryVersionService.putToLocalCache(productNumber, isv, str);
            IndustryVersionService.putToCache(productNumber, isv, str);
        }
        return verInfo;
    }

    public static List<IndustryVersionInfo> getVersionInfos() {
        String verStr = IndustryVersionService.getFromLocalCache(COSMIC_BOS_CCS_PREFIX);
        List<Object> versionList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)verStr) && (versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class)) != null && !versionList.isEmpty()) {
            return versionList;
        }
        verStr = IndustryVersionService.getFromCache(COSMIC_BOS_CCS_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)verStr)) {
            versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class);
            if (versionList != null && !versionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(COSMIC_BOS_CCS_PREFIX, verStr);
            }
            return versionList;
        }
        versionList = IndustryVersionService.getVersionInfosFromDB(CCS_PREFIX);
        if (versionList != null && !versionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(versionList);
            IndustryVersionService.putToLocalCache(COSMIC_BOS_CCS_PREFIX, str);
            IndustryVersionService.putToCache(COSMIC_BOS_CCS_PREFIX, str);
        }
        return versionList;
    }

    public static List<IndustryVersionInfo> getGalaxyVersionInfos() {
        String verStr = IndustryVersionService.getFromLocalCache(COSMIC_BOS_GALAXY_PREFIX);
        List<Object> versionList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)verStr) && (versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class)) != null && !versionList.isEmpty()) {
            return versionList;
        }
        verStr = IndustryVersionService.getFromCache(COSMIC_BOS_GALAXY_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)verStr)) {
            versionList = SerializationUtils.fromJsonStringToList((String)verStr, IndustryVersionInfo.class);
            if (versionList != null && !versionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(COSMIC_BOS_GALAXY_PREFIX, verStr);
            }
            return versionList;
        }
        versionList = IndustryVersionService.getVersionInfosFromDB(GALAXY_PREFIX);
        if (versionList != null && !versionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(versionList);
            IndustryVersionService.putToLocalCache(COSMIC_BOS_GALAXY_PREFIX, str);
            IndustryVersionService.putToCache(COSMIC_BOS_GALAXY_PREFIX, str);
        }
        return versionList;
    }

    public static List<IndustryVersionInfo> getCaptionInfos() {
        String cacheKey = "version_caption_.cosmic_bos_version_caption_list";
        String captionStr = IndustryVersionService.getFromLocalCache(cacheKey);
        List<Object> captionList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)captionStr) && (captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class)) != null && !captionList.isEmpty()) {
            return captionList;
        }
        captionStr = IndustryVersionService.getFromCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr)) {
            captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class);
            if (captionList != null && !captionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(cacheKey, captionStr);
            }
            return captionList;
        }
        captionList = IndustryVersionService.getCationInfosFromDB();
        if (captionList != null && !captionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(captionList);
            IndustryVersionService.putToLocalCache(cacheKey, str);
            IndustryVersionService.putToCache(cacheKey, str);
        }
        return captionList;
    }

    public static List<IndustryVersionInfo> getCaption(String productName) {
        String cacheKey = "version_caption_." + productName;
        List<Object> captionList = new ArrayList(10);
        String captionStr = IndustryVersionService.getFromLocalCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr) && (captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class)) != null && !captionList.isEmpty()) {
            return captionList;
        }
        captionStr = IndustryVersionService.getFromCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr)) {
            captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class);
            if (captionList != null && !captionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(cacheKey, captionStr);
            }
            return captionList;
        }
        captionList = IndustryVersionService.getCaptionFromDB(productName);
        if (captionList != null && !captionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(captionList);
            IndustryVersionService.putToLocalCache(cacheKey, str);
            IndustryVersionService.putToCache(cacheKey, str);
        }
        return captionList;
    }

    public static List<IndustryVersionInfo> getCaption(String isv, String productName) {
        String cacheKey = "version_caption_." + isv + "." + productName;
        List<Object> captionList = new ArrayList(10);
        String captionStr = IndustryVersionService.getFromLocalCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr) && (captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class)) != null && !captionList.isEmpty()) {
            log.info("versionCaption local cache : " + captionStr);
            return captionList;
        }
        captionStr = IndustryVersionService.getFromCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr)) {
            captionList = SerializationUtils.fromJsonStringToList((String)captionStr, IndustryVersionInfo.class);
            if (captionList != null && !captionList.isEmpty()) {
                IndustryVersionService.putToLocalCache(cacheKey, captionStr);
            }
            log.info("versionCaption redis cache : " + captionStr);
            return captionList;
        }
        captionList = IndustryVersionService.getCaptionFromDB(isv, productName);
        if (captionList != null && !captionList.isEmpty()) {
            String str = SerializationUtils.toJsonString(captionList);
            IndustryVersionService.putToLocalCache(cacheKey, str);
            IndustryVersionService.putToCache(cacheKey, str);
            log.info("versionCaption db : " + str);
        }
        return captionList;
    }

    public static IndustryVersionInfo getCaption(String productNumber, String isv, String productName) {
        String cacheKey = "version_caption_." + productNumber + "." + productName + "." + isv;
        IndustryVersionInfo captionInfo = null;
        String captionStr = IndustryVersionService.getFromLocalCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr) && (captionInfo = (IndustryVersionInfo)SerializationUtils.fromJsonString((String)captionStr, IndustryVersionInfo.class)) != null) {
            log.info("versionCaption local cache : " + captionStr);
            return captionInfo;
        }
        captionStr = IndustryVersionService.getFromCache(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)captionStr)) {
            captionInfo = (IndustryVersionInfo)SerializationUtils.fromJsonString((String)captionStr, IndustryVersionInfo.class);
            if (captionInfo != null) {
                IndustryVersionService.putToLocalCache(cacheKey, captionStr);
            }
            log.info("versionCaption redis cache : " + captionStr);
            return captionInfo;
        }
        captionInfo = IndustryVersionService.getCaptionFromDB(productNumber, isv, productName);
        if (captionInfo != null) {
            String str = SerializationUtils.toJsonString((Object)captionInfo);
            IndustryVersionService.putToLocalCache(cacheKey, str);
            IndustryVersionService.putToCache(cacheKey, str);
            log.info("versionCaption db : " + str);
        }
        return captionInfo;
    }

    public static void clearCache(String productNumber, String isv, String productName) {
        String cacheKey = "version_caption_." + productName;
        IndustryVersionService.getLocalCache().remove(new String[]{IndustryVersionService.genVersionCacheKey(cacheKey)});
        cache.remove(IndustryVersionService.getRootCacheKey(), IndustryVersionService.genVersionCacheKey(cacheKey));
        cacheKey = "version_caption_." + productNumber + "." + productName + "." + isv;
        IndustryVersionService.getLocalCache().remove(new String[]{IndustryVersionService.genVersionCacheKey(cacheKey)});
        cache.remove(IndustryVersionService.getRootCacheKey(), IndustryVersionService.genVersionCacheKey(cacheKey));
        cacheKey = "version_caption_." + isv + "." + productName;
        IndustryVersionService.getLocalCache().remove(new String[]{IndustryVersionService.genVersionCacheKey(cacheKey)});
        cache.remove(IndustryVersionService.getRootCacheKey(), IndustryVersionService.genVersionCacheKey(cacheKey));
        cacheKey = "version_caption_.cosmic_bos_version_caption_list";
        IndustryVersionService.getLocalCache().remove(new String[]{IndustryVersionService.genVersionCacheKey(cacheKey)});
        cache.remove(IndustryVersionService.getRootCacheKey(), IndustryVersionService.genVersionCacheKey(cacheKey));
        cache.remove(IndustryVersionService.getRootCacheKey());
    }

    private static List<IndustryVersionInfo> getVersionInfosFromDB(String productPrefix) {
        String sql = String.format("select fid, fproductnumber, fversion, fisv, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like '%s';", productPrefix + "%");
        ArrayList<IndustryVersionInfo> versions = new ArrayList<IndustryVersionInfo>();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                ArrayList<IndustryVersionInfo> vers = new ArrayList<IndustryVersionInfo>(rs.getRow());
                while (rs.next()) {
                    long id = rs.getLong("fid");
                    String productNumber = rs.getString("fproductnumber");
                    String version = rs.getString("fversion");
                    String upgradeTime = rs.getString("fupgradetime");
                    String isv = rs.getString("fisv");
                    IndustryVersionInfo info = new IndustryVersionInfo(productNumber, isv, version);
                    info.setId(id);
                    info.setUpgradeTime(upgradeTime);
                    vers.add(info);
                }
                return vers;
            });
            for (IndustryVersionInfo version : allVersion) {
                if (!COSMIC_BOS.equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            allVersion.stream().max(IndustryVersionService.versionComparator()).ifPresent(versions::add);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
        }
        return versions;
    }

    public static void clearCache(String productNumber, String isv) {
        String key = IndustryVersionService.genVersionCacheKey(productNumber);
        if (StringUtils.isBlank((CharSequence)productNumber)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)isv)) {
            IndustryVersionService.getLocalCache().remove(new String[]{key});
            cache.remove(IndustryVersionService.getRootCacheKey(), key);
            key = IndustryVersionService.genVersionCacheKey(productNumber, isv);
        }
        IndustryVersionService.getLocalCache().remove(new String[]{key});
        IndustryVersionService.getLocalCache().remove(new String[]{IndustryVersionService.genVersionCacheKey(COSMIC_BOS_CCS_PREFIX)});
        cache.remove(IndustryVersionService.getRootCacheKey(), IndustryVersionService.genVersionCacheKey(COSMIC_BOS_CCS_PREFIX));
        cache.remove(IndustryVersionService.getRootCacheKey(), key);
        cache.remove(IndustryVersionService.getRootCacheKey());
    }

    private static IndustryVersionInfo getVersionFromDB(String productNumber, String isv) {
        String sql = "select fid, fproductnumber, fversion, fisv, fupgradetime from t_bas_industry_version where fproductnumber = ? and fisv = ?;";
        Object[] params = new Object[]{productNumber, isv};
        try {
            return (IndustryVersionInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<IndustryVersionInfo>(){

                public IndustryVersionInfo handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        long id = rs.getLong("fid");
                        String productNumber = rs.getString("fproductnumber");
                        String version = rs.getString("fversion");
                        String upgradeTime = rs.getString("fupgradetime");
                        String isv = rs.getString("fisv");
                        IndustryVersionInfo info = new IndustryVersionInfo(productNumber, isv, version);
                        info.setId(id);
                        info.setUpgradeTime(upgradeTime);
                        return info;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ea7\u54c1\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return null;
        }
    }

    private static String getFromLocalCache(String productNumber, String isv) {
        String key = IndustryVersionService.genVersionCacheKey(productNumber, isv);
        return (String)IndustryVersionService.getLocalCache().get(key);
    }

    private static String getFromCache(String productNumber, String isv) {
        String type = IndustryVersionService.getRootCacheKey();
        String key = IndustryVersionService.genVersionCacheKey(productNumber, isv);
        return (String)ThreadCache.get((Object)(type + "." + key), () -> (String)cache.get(type, key));
    }

    private static List<IndustryVersionInfo> getVersionFromDB(String productNumber) {
        String sql = "select fid, fproductnumber, fversion, fisv, fupgradetime from t_bas_industry_version where fproductnumber = ?;";
        Object[] params = new Object[]{productNumber};
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<IndustryVersionInfo>>(){

                public List<IndustryVersionInfo> handle(ResultSet rs) throws Exception {
                    ArrayList<IndustryVersionInfo> vers = new ArrayList<IndustryVersionInfo>(10);
                    while (rs.next()) {
                        long id = rs.getLong("fid");
                        String productNumber = rs.getString("fproductnumber");
                        String version = rs.getString("fversion");
                        String upgradeTime = rs.getString("fupgradetime");
                        String isv = rs.getString("fisv");
                        IndustryVersionInfo info = new IndustryVersionInfo(productNumber, isv, version);
                        info.setId(id);
                        info.setUpgradeTime(upgradeTime);
                        vers.add(info);
                    }
                    return vers;
                }
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ea7\u54c1\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return null;
        }
    }

    private static List<IndustryVersionInfo> getCationInfosFromDB() {
        try {
            String sql = "select a.fid, a.fisv,a.fproductnumber, a.fproductname fname,a.fversion, a.fupgradetime, a.fproducttype, b.fproductname, b.fcaption from t_bas_industry_version a join t_bas_versioncaption b on a.fid = b.fid;";
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                HashMap<Long, IndustryVersionInfo> infos = new HashMap<Long, IndustryVersionInfo>(16);
                ArrayList versionList = new ArrayList(10);
                while (rs.next()) {
                    IndustryVersionService.buildVersionInfo(infos, rs);
                }
                versionList.addAll(infos.values());
                return versionList;
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u663e\u793a\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return new ArrayList<IndustryVersionInfo>();
        }
    }

    private static List<IndustryVersionInfo> getCaptionFromDB(String productName) {
        String sql = "select a.fid, a.fisv,a.fproductnumber, a.fproductname fname,a.fversion, a.fupgradetime, a.fproducttype, b.fproductname, b.fcaption from t_bas_industry_version a join t_bas_versioncaption b on a.fid = b.fid where b.fproductname = ? and b.fcaption not in ('', ' ', 'null') order by a.fupgradetime desc;";
        Object[] params = new Object[]{productName};
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                HashMap<Long, IndustryVersionInfo> infos = new HashMap<Long, IndustryVersionInfo>(16);
                ArrayList versionList = new ArrayList(10);
                while (rs.next()) {
                    IndustryVersionService.buildVersionInfo(infos, rs);
                }
                versionList.addAll(infos.values());
                return versionList;
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ea7\u54c1\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return new ArrayList<IndustryVersionInfo>(1);
        }
    }

    private static List<IndustryVersionInfo> getCaptionFromDB(String isv, String productName) {
        String sql = "select a.fid, a.fisv,a.fproductnumber, a.fproductname fname,a.fversion, a.fupgradetime, a.fproducttype, b.fproductname, b.fcaption from t_bas_industry_version a join t_bas_versioncaption b on a.fid = b.fid where  a.fisv = ? and b.fproductname like ? and b.fcaption not in ('', ' ', 'null') order by a.fupgradetime desc;";
        productName = String.format("%s%s", productName, "%");
        Object[] params = new SqlParameter[]{new SqlParameter("Fisv", 12, (Object)isv), new SqlParameter("FProductName", 12, (Object)productName)};
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                HashMap<Long, IndustryVersionInfo> infos = new HashMap<Long, IndustryVersionInfo>(16);
                ArrayList versionList = new ArrayList(10);
                while (rs.next()) {
                    IndustryVersionService.buildVersionInfo(infos, rs);
                }
                versionList.addAll(infos.values());
                return versionList;
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ea7\u54c1\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return new ArrayList<IndustryVersionInfo>(1);
        }
    }

    private static IndustryVersionInfo getCaptionFromDB(String productNumber, String isv, String productName) {
        String sql = "select a.fid, a.fisv,a.fproductnumber, a.fproductname fname,a.fversion, a.fupgradetime, a.fproducttype, b.fproductname, b.fcaption from t_bas_industry_version a join t_bas_versioncaption b on a.fid = b.fid where a.fproductnumber = ? and a.fisv = ? and b.fproductname = ?;";
        Object[] params = new Object[]{productNumber, isv, productName};
        try {
            return (IndustryVersionInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                if (rs.next()) {
                    return IndustryVersionService.buildVersionInfo(null, rs);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ea7\u54c1\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
            return null;
        }
    }

    private static IndustryVersionInfo buildVersionInfo(Map<Long, IndustryVersionInfo> infos, ResultSet rs) throws SQLException {
        IndustryVersionInfo info;
        if (rs == null) {
            return null;
        }
        Long id = rs.getLong("fid");
        IndustryVersionInfo industryVersionInfo = info = infos == null ? null : infos.get(id);
        if (info == null) {
            String productNumber = rs.getString("fproductnumber");
            String version = rs.getString("fversion");
            String upgradeTime = rs.getString("fupgradetime");
            String isv = rs.getString("fisv");
            String name = rs.getString("fname");
            info = new IndustryVersionInfo(productNumber, isv, version);
            info.setId(id);
            info.setUpgradeTime(upgradeTime);
            info.setProductName(name);
        }
        String pName = rs.getString("fproductname");
        String caption = rs.getString("fcaption");
        info.getVerCaption().add(new VersionCaptionInfo(id, caption, pName));
        if (infos != null) {
            infos.put(id, info);
        }
        return info;
    }

    private static String getFromLocalCache(String productNumber) {
        String key = IndustryVersionService.genVersionCacheKey(productNumber);
        return (String)IndustryVersionService.getLocalCache().get(key);
    }

    private static String getFromCache(String productNumber) {
        String type = IndustryVersionService.getRootCacheKey();
        String key = IndustryVersionService.genVersionCacheKey(productNumber);
        return (String)ThreadCache.get((Object)(type + "." + key), () -> (String)cache.get(type, key));
    }

    protected static void putToLocalCache(String productNumber, String ver) {
        String key = IndustryVersionService.genVersionCacheKey(productNumber);
        IndustryVersionService.getLocalCache().put(key, (Object)ver);
    }

    protected static void putToLocalCache(String productNumber, String isv, String ver) {
        String key = IndustryVersionService.genVersionCacheKey(productNumber, isv);
        IndustryVersionService.getLocalCache().put(key, (Object)ver);
    }

    protected static void putToCache(String productNumber, String ver) {
        String rootCacheKey = IndustryVersionService.getRootCacheKey();
        String key = IndustryVersionService.genVersionCacheKey(productNumber);
        cache.put(rootCacheKey, key, (Object)ver);
    }

    protected static void putToCache(String productNumber, String isv, String ver) {
        String rootCacheKey = IndustryVersionService.getRootCacheKey();
        String key = IndustryVersionService.genVersionCacheKey(productNumber, isv);
        cache.put(rootCacheKey, key, (Object)ver);
    }

    private static String getRootCacheKey() {
        return String.format("%s_%s_%s", CacheKeyUtil.getAcctId(), INDUSTRY_VERSION_TYPE, "CACHE_KEY");
    }

    private static String genVersionCacheKey(String key) {
        return (key + ".cache_key").toLowerCase();
    }

    private static String genVersionCacheKey(String key, String isv) {
        return (key + "." + isv + ".cache_key").toLowerCase();
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxItemSize(50);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), INDUSTRY_VERSION_TYPE, info);
    }

    private static Comparator<IndustryVersionInfo> versionComparator() {
        return (o1, o2) -> {
            String ver1 = o1.getVersion();
            String ver2 = o2.getVersion();
            return IndustryVersionService.comparePartVer(ver1, ver2, 3);
        };
    }

    protected static int comparePartVer(String fullVer, String dbVer, int part) {
        if (kd.bos.util.StringUtils.isBlank((String)dbVer) && kd.bos.util.StringUtils.isBlank((String)fullVer)) {
            return 0;
        }
        if (kd.bos.util.StringUtils.isBlank((String)dbVer)) {
            return 1;
        }
        if (kd.bos.util.StringUtils.isBlank((String)fullVer)) {
            return -1;
        }
        String[] verStrs = fullVer.split("\\.");
        Integer[] intVers = new Integer[verStrs.length];
        for (int i = 0; i < verStrs.length; ++i) {
            intVers[i] = Integer.parseInt(verStrs[i]);
        }
        String[] dbVerStrs = dbVer.split("\\.");
        int length = dbVerStrs.length;
        if (verStrs.length > dbVerStrs.length) {
            length = verStrs.length;
        }
        Integer[] intDbVers = new Integer[length];
        for (int i = 0; i < verStrs.length; ++i) {
            intDbVers[i] = i >= dbVerStrs.length ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(dbVerStrs[i]));
        }
        int result = 0;
        for (int i = 0; i < length && (part == 0 || part != i); ++i) {
            if (intVers[i] > intDbVers[i]) {
                result = 1;
                break;
            }
            if (intVers[i] >= intDbVers[i]) continue;
            result = -1;
            break;
        }
        return result;
    }
}

