/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.domaindefine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.domaindefine.DMImpExpUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.upgrade.ExtJarApi;
import kd.bos.utils.DBDateUtil;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class DMImportAPI {
    private static final String NUMBER = "number";
    private static final String STATUS = "status";
    private static final String[] SUPPORT_ENTITY = new String[]{"bos_devp_properpty", "bos_devp_elementcategory", "bos_devp_element", "bos_devp_operation", "bos_devp_opservice", "bos_devp_rule", "bos_devp_validation"};
    private static Log log = LogFactory.getLog(DMImportAPI.class);
    private DMImpExpUtil impExpUtil = new DMImpExpUtil();

    public void importZip(String zipFileName, String desc, InputStream inStream, Consumer<List<DynamicObject>> onSave) throws IOException, DocumentException {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_devp_dmimport");
        DynamicObject importData = (DynamicObject)type.createInstance();
        importData.set("billstatus", (Object)"B");
        importData.set("billno", (Object)ID.genLongIds((int)1)[0]);
        importData.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        importData.set("createdate", (Object)DBDateUtil.getDate());
        importData.set("filename", (Object)zipFileName);
        importData.set("desc", (Object)desc);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        ArrayList<Map<String, Object>> jarList = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection entrys = importData.getDynamicObjectCollection("entryentity");
        this.readZipFiles(inStream, entrys, saveList, jarList);
        this.executeTran(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"DMImportAPI_0", (String)"bos-business-dao", (Object[])new Object[0]), (Consumer<TXHandle>)((Consumer)arg_0 -> DMImportAPI.lambda$importZip$1(saveList, onSave, jarList, importData, (DynamicObjectType)type, arg_0)));
    }

    private void readZipFiles(InputStream inStream, DynamicObjectCollection logEntrys, List<DynamicObject> saveList, List<Map<String, Object>> jarData) throws IOException, DocumentException {
        try (ZipArchiveInputStream zipIn = new ZipArchiveInputStream(inStream);){
            ZipArchiveEntry zipEntry;
            while ((zipEntry = zipIn.getNextZipEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                if (fileName.endsWith("xml")) {
                    String xml = this.getZipContent(zipIn);
                    DynamicObject data = this.createDomainModelData(fileName, xml);
                    if (data == null) {
                        return;
                    }
                    this.addXmlLog(logEntrys, fileName, data);
                    saveList.add(data);
                    continue;
                }
                if (!fileName.endsWith("jar")) continue;
                this.addJarLog(logEntrys, fileName);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("filename", fileName);
                map.put("jar", this.getZipData(zipIn));
                jarData.add(map);
            }
        }
    }

    private void addJarLog(DynamicObjectCollection logEntrys, String fileName) {
        DynamicObject entryRow = logEntrys.addNew();
        entryRow.set("type", (Object)ResManager.loadKDString((String)"JAR\u5305", (String)"DMImportAPI_3", (String)"bos-business-dao", (Object[])new Object[0]));
        String number = "domainjar" + ISVService.getISVInfo().getId();
        entryRow.set(NUMBER, (Object)number);
        entryRow.set("name", (Object)fileName);
        entryRow.set("entryfilename", (Object)fileName);
        entryRow.set(STATUS, (Object)(this.existsJar(number) ? ResManager.loadKDString((String)"\u8986\u76d6", (String)"DMImportAPI_4", (String)"bos-business-dao", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e", (String)"DMImportAPI_5", (String)"bos-business-dao", (Object[])new Object[0])));
    }

    private void addXmlLog(DynamicObjectCollection logEntrys, String fileName, DynamicObject data) {
        DynamicObject entryRow = logEntrys.addNew();
        entryRow.set(NUMBER, data.get(NUMBER));
        entryRow.set("type", (Object)data.getDynamicObjectType().getDisplayName().getLocaleValue());
        OrmLocaleValue localeValue = (OrmLocaleValue)data.get("name");
        entryRow.set("name", (Object)localeValue.getLocaleValue());
        entryRow.set("entryfilename", (Object)fileName);
        entryRow.set(STATUS, (Object)(data.getDataEntityState().getPkSnapshotSet() != null ? ResManager.loadKDString((String)"\u8986\u76d6", (String)"DMImportAPI_4", (String)"bos-business-dao", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e", (String)"DMImportAPI_5", (String)"bos-business-dao", (Object[])new Object[0])));
    }

    private boolean existsJar(String number) {
        String existSql = "SELECT fnumber,fhash FROM T_META_EXT_JAR WHERE fnumber = ? ";
        Map numberHash = (Map)DB.query((DBRoute)DBRoute.meta, (String)existSql, (Object[])new Object[]{number}, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
            return map;
        });
        return numberHash.size() > 0;
    }

    private void executeTran(String msg, Consumer<TXHandle> supplier) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                supplier.accept((Object)tx);
                tx.commit();
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error(msg, (Throwable)ex);
                throw ex;
            }
        }
    }

    private DynamicObject read(IDataEntityType entityType, QFilter[] filters) {
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataReader.LoadFromCache", entityType.getName(), "id", filters, (String)null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ArrayList idList = new ArrayList();
            ds.forEach(row -> idList.add(row.get(0)));
            if (!idList.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)BusinessDataReader.read(idList.get(0), (IDataEntityType)entityType, (Boolean)true);
                return dynamicObject;
            }
        }
        return null;
    }

    private DynamicObject createDomainModelData(String fileName, String xml) throws DocumentException {
        String entityId = this.getXmlType(xml);
        if (!this.checkEntityType(entityId)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        try {
            DynamicObject data;
            DynamicObject importData = this.impExpUtil.fromExportXml((DynamicObjectType)entityType, xml);
            this.checkNumber(importData);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter(NUMBER, "=", importData.get(NUMBER)));
            if (importData.containsProperty("isv")) {
                filters.add(new QFilter("isv", "=", importData.get("isv")));
            }
            if ((data = this.read((IDataEntityType)entityType, filters.toArray(new QFilter[0]))) != null) {
                importData.set("id", data.get("id"));
                importData.getDataEntityState().setPkSnapshotSet(data.getDataEntityState().getPkSnapshotSet());
            }
            return importData;
        }
        catch (KDBizException ex) {
            throw new KDBizException(fileName + " " + ex.getMessage());
        }
    }

    private void checkNumber(DynamicObject data) {
        if (data.getDynamicObjectType() instanceof BasedataEntityType) {
            BasedataEntityType type = (BasedataEntityType)data.getDynamicObjectType();
            String numberProp = NUMBER;
            if (StringUtils.isNotBlank((CharSequence)type.getNumberProperty())) {
                numberProp = type.getNumberProperty();
            }
            if (data.containsProperty(numberProp)) {
                String number = data.getString(numberProp);
                boolean checkIsv = true;
                if (type.getName().equals("bos_devp_element") && data.getString("issys").equals("true")) {
                    checkIsv = false;
                }
                String isvid = "";
                if (!data.containsProperty("isv")) {
                    checkIsv = false;
                } else {
                    isvid = data.getString("isv");
                }
                this.doCheckNumber(number, isvid, checkIsv);
            }
        }
    }

    private void doCheckNumber(String number, String isvId, boolean checkISv) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9]+[a-zA-Z0-9_]*$");
        if (!pattern.matcher(number).matches()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u4ee5\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DMImportAPI_6", (String)"bos-business-dao", (Object[])new Object[0])});
        }
        if (checkISv && !"kingdee".equals(isvId) && !"".equals(isvId)) {
            String upIsv = Character.toString(isvId.trim().charAt(0)).toUpperCase() + isvId.substring(1);
            if (!number.startsWith(isvId) && !number.startsWith(upIsv)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4f7f\u7528\u5f00\u53d1\u5546\u6807\u8bc6\u524d\u7f00\uff1a<\u5f00\u53d1\u5546\u6807\u8bc6>\u7f16\u7801\u3002", (String)"DMImportAPI_7", (String)"bos-business-dao", (Object[])new Object[0])});
            }
        }
    }

    private boolean checkEntityType(String entityType) {
        for (String entity : SUPPORT_ENTITY) {
            if (!entity.equalsIgnoreCase(entityType)) continue;
            return true;
        }
        return false;
    }

    private String getZipContent(ZipArchiveInputStream zipIn) throws IOException {
        byte[] buf = this.getZipData(zipIn);
        int start = 0;
        if (buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
            start = 3;
        }
        return new String(buf, start, buf.length - start, StandardCharsets.UTF_8);
    }

    private byte[] getZipData(ZipArchiveInputStream zipIn) throws IOException {
        int readLength = 0;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((readLength = zipIn.read(buf, 0, 1024)) != -1) {
            bos.write(buf, 0, readLength);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private String getXmlType(String xml) throws DocumentException {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xml);
        Document doc = reader.read((Reader)strReader);
        return doc.getRootElement().getName();
    }

    private SAXReader getSaxReader() {
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException var2) {
            log.error((Throwable)var2);
        }
        return saxReader;
    }

    private static /* synthetic */ void lambda$importZip$1(List saveList, Consumer onSave, List jarList, DynamicObject importData, DynamicObjectType type, TXHandle o) {
        if (!saveList.isEmpty()) {
            saveList.forEach(row -> BusinessDataWriter.save((IDataEntityType)row.getDynamicObjectType(), (Object[])new DynamicObject[]{row}));
            if (onSave != null) {
                onSave.accept((Object)saveList);
            }
        }
        for (Map jarData : jarList) {
            byte[] data;
            String number = "domainjar" + ISVService.getISVInfo().getId() + jarData.get("filename");
            if (number.length() > 100) {
                number = number.substring(number.length() - 100);
            }
            if ((data = (byte[])jarData.get("jar")) == null || data.length <= 0) continue;
            ExtJarApi.save(number, ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DMImportAPI_1", (String)"bos-business-dao", (Object[])new Object[0]), data, "mdl", ISVService.getISVInfo().getId());
        }
        if (!jarList.isEmpty()) {
            try {
                ExtJarApi.reset(RequestContext.get().getAccountId());
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u91cd\u7f6e\u70ed\u90e8\u7f72\u5931\u8d25\u3002", (String)"DMImportAPI_2", (String)"bos-business-dao", (Object[])new Object[0])});
            }
        }
        int i = 1;
        for (DynamicObject entryRow : importData.getDynamicObjectCollection("entryentity")) {
            entryRow.set("seq", (Object)i++);
        }
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new DynamicObject[]{importData});
    }
}

