/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pushservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSend;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.pushservice.WebSocketIdReader;

public class PushMessagePublisher {
    private static final Log log = LogFactory.getLog(PushMessagePublisher.class);
    private static MsgSend sender = MsgSendFactory.getSender();
    private static final String BOS_BUSINESS_DAO = "bos-business-dao";

    public static void sendPushMessage(PushMessage wsMsg) {
        Objects.requireNonNull(wsMsg, ResManager.loadKDString((String)"PushMessage \u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_0", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getRange(), ResManager.loadKDString((String)"PushMessage \u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_1", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getType(), ResManager.loadKDString((String)"PushMessage \u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_2", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getBody(), ResManager.loadKDString((String)"PushMessage \u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_3", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        List<String> socketIds = PushMessagePublisher.getWebSessionIds(wsMsg);
        if (socketIds != null && !socketIds.isEmpty()) {
            PushMessagePublisher.sendPushMessage(socketIds, wsMsg);
        }
    }

    public static void sendPushMessage(PushMessage wsMsg, List<String> webSocketIdList) {
        Objects.requireNonNull(wsMsg, ResManager.loadKDString((String)"PushMessage \u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_0", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getRange(), ResManager.loadKDString((String)"PushMessage \u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_1", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getType(), ResManager.loadKDString((String)"PushMessage \u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_2", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        Objects.requireNonNull(wsMsg.getBody(), ResManager.loadKDString((String)"PushMessage \u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_3", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
        List<String> socketIds = PushMessagePublisher.getWebSessionIds(wsMsg);
        if (socketIds != null && !socketIds.isEmpty()) {
            PushMessagePublisher.sendPushMessage(socketIds, wsMsg);
        }
        webSocketIdList.addAll(socketIds);
    }

    public static void sendPushMessage(List<String> socketIds, PushMessage wsMsg) {
        for (String socketId : socketIds) {
            if (wsMsg.getBody() instanceof String) {
                sender.send(socketId, String.valueOf(wsMsg.getBody()));
                continue;
            }
            sender.send(socketId, SerializationUtils.toJsonString((Object)wsMsg.getBody()));
        }
    }

    private static List<String> getWebSessionIds(PushMessage wsMsg) {
        List<String> socketIds = new ArrayList<String>();
        RequestContext rc = RequestContext.get();
        switch (wsMsg.getRange()) {
            case RootPage: {
                Objects.requireNonNull(wsMsg.getTo(), ResManager.loadKDString((String)"PushMessage \u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_4", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
                if (wsMsg.getTo().indexOf("root") == -1) {
                    throw new IllegalArgumentException(ResManager.loadKDString((String)"PushMessage\u7684\u76ee\u6807\u53ea\u80fd\u4e3a\u6839\u9875\u9762\uff0c\u8bf7\u4f7f\u7528FormShowParameter.getRootPageId", (String)"PushMessagePublisher_5", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
                }
                List webSocketIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)rc.getGlobalSessionId());
                if (!webSocketIds.contains(wsMsg.getTo())) break;
                socketIds.add(wsMsg.getTo());
                break;
            }
            case Session: {
                Objects.requireNonNull(wsMsg.getTo(), ResManager.loadKDString((String)"PushMessage \u76ee\u6807session\u4e0d\u80fd\u4e3a\u7a7a", (String)"PushMessagePublisher_6", (String)BOS_BUSINESS_DAO, (Object[])new Object[0]));
                String sessionId = wsMsg.getTo();
                socketIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)sessionId);
                if (socketIds != null && !socketIds.isEmpty()) break;
                log.warn("\u6ca1\u6709\u6253\u5f00\u4efb\u4f55\u6d4f\u89c8\u5668\uff0c\u6240\u4ee5\u4e5f\u6ca1\u6709\u4efb\u4f55websocket\u53ef\u63a8\u9001");
                break;
            }
            case Account: {
                socketIds = WebSocketIdReader.getWebSocketIdsInAccount((String)rc.getAccountId());
                break;
            }
            case Tenant: {
                break;
            }
        }
        return socketIds;
    }
}

