/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sqlscript;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sqlscript.Column;
import kd.bos.sqlscript.KSQLDataType;
import kd.bos.sqlscript.PreInsLongTextData;

public class BatchPreInsDataScriptBuilder {
    private static final Log log = LogFactory.getLog(BatchPreInsDataScriptBuilder.class);
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final String WHERE = " WHERE ";
    private static final int BATCH_SIZE = 2000;
    private int batchSize;

    public BatchPreInsDataScriptBuilder() {
    }

    public BatchPreInsDataScriptBuilder(int batchSize) {
        this.batchSize = batchSize;
        if (this.batchSize == 0) {
            this.batchSize = 2000;
        }
    }

    public final Map<String, Object> genInsertSQLScript(DBRoute dbRoute, String strTableName, String strFields, String strWhere, String strOders, String strDesc) {
        String[] fields;
        if (dbRoute == null || StringUtils.isBlank((CharSequence)dbRoute.getRouteKey())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"DBRoute \u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PreInsDataScriptBuilder_1", (String)"bos-business-dao", (Object[])new Object[0])});
        }
        LinkedHashMap<String, String> filedMap = new LinkedHashMap<String, String>(16);
        List pkColNames = DB.getPrimaryKeys((DBRoute)dbRoute, (String)strTableName);
        if (pkColNames.isEmpty()) {
            log.info("Table " + strTableName + ": primary key not defined.");
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u8868\u672a\u5b9a\u4e49\u4e3b\u952e\uff0c\u4e0d\u80fd\u751f\u6210\u811a\u672c\uff01", (String)"PreInsDataScriptBuilder_2", (String)"bos-business-dao", (Object[])new Object[0])});
        }
        HashSet<String> mapPKCols = new HashSet<String>(16);
        for (String[] pk : pkColNames) {
            String upperPK = pk.toUpperCase();
            mapPKCols.add(upperPK);
            filedMap.put(upperPK, upperPK);
        }
        for (String field : fields = strFields.replaceAll(" +", "").split(",")) {
            String[] aliasFields = new String[2];
            int indAlias = StringUtils.lastIndexOfIgnoreCase((CharSequence)field, (CharSequence)" as ");
            if (indAlias > 0) {
                aliasFields[0] = field.substring(0, indAlias);
                aliasFields[1] = field.substring(indAlias + 3, field.length());
            } else {
                int indSpace = field.lastIndexOf(32);
                if (indSpace > 0) {
                    aliasFields[0] = field.substring(0, indSpace);
                    aliasFields[1] = field.substring(indSpace, field.length());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)aliasFields[1])) {
                filedMap.put(aliasFields[1], field);
                continue;
            }
            filedMap.put(field, field);
        }
        StringBuffer sqlFields = new StringBuffer();
        for (String field : filedMap.values()) {
            sqlFields.append(field).append(',');
        }
        if (sqlFields.length() == 0) {
            return null;
        }
        String consFields = sqlFields.substring(0, sqlFields.length() - 1);
        return this.genInsertScript(dbRoute, strTableName, mapPKCols, consFields, strWhere, strOders, strDesc);
    }

    private static String getDeleteSql(String strTableName, Map<String, Object[]> dictPK) {
        StringBuilder deleteSb = new StringBuilder("DELETE FROM ");
        deleteSb.append(strTableName);
        deleteSb.append(WHERE);
        int i = 0;
        for (Map.Entry<String, Object[]> entry : dictPK.entrySet()) {
            if (i > 0) {
                deleteSb.append(" and ");
            }
            deleteSb.append(entry.getKey()).append(" = ? ");
            ++i;
        }
        deleteSb.append(';');
        return deleteSb.toString();
    }

    private static String getDataSql(String strTableName, String strFieldList, String strWhere, String strOder) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(strFieldList).append(" FROM ");
        sb.append(strTableName).append(' ');
        sb.append(StringUtils.isNotBlank((CharSequence)strWhere) ? WHERE + strWhere : "").append(' ');
        sb.append(StringUtils.isNotBlank((CharSequence)strOder) ? "ORDER BY " + strOder : "");
        return sb.toString();
    }

    private Map<String, Object> genInsertScript(final DBRoute dbRoute, final String strTableName, final HashSet mapPKCols, String colFields, String strWhere, String strOders, String strDesc) {
        String[] cols = colFields.split(",");
        HashSet<String> setCols = new HashSet<String>();
        for (String colStr : cols) {
            setCols.add(colStr.toUpperCase());
        }
        String consFields = String.join((CharSequence)", ", setCols.toArray(new String[setCols.size()]));
        String strSQL = BatchPreInsDataScriptBuilder.getDataSql(strTableName, consFields, strWhere, strOders);
        return (Map)DB.query((DBRoute)dbRoute, (String)strSQL, (Object[])new SqlParameter[0], (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws KDException {
                try {
                    StringBuilder sb = new StringBuilder("[").append(System.getProperty("line.separator"));
                    ArrayList<Column> columns = new ArrayList<Column>();
                    String insertSql = this.getInsertFieldSQL(strTableName, rs, columns, mapPKCols);
                    StringBuilder headCol = new StringBuilder();
                    ArrayList<Integer> primaryKey = new ArrayList<Integer>(10);
                    int pkIdx = 0;
                    block6: for (Column col : columns) {
                        if (mapPKCols.contains(col.getName().toUpperCase())) {
                            primaryKey.add(pkIdx);
                        }
                        ++pkIdx;
                        int type = col.getType();
                        String name = col.getName();
                        switch (type) {
                            case 12: {
                                headCol.append(name).append(":date,");
                                continue block6;
                            }
                            case 14: {
                                headCol.append(name).append(":decimal,");
                                continue block6;
                            }
                        }
                        headCol.append(name).append(",");
                    }
                    String headColStr = headCol.toString();
                    headColStr = headColStr.substring(0, headCol.length() - 1);
                    ArrayList params = new ArrayList(10);
                    boolean i = false;
                    while (rs.next()) {
                        ArrayList<Object> rowParameter2 = new ArrayList<Object>(columns.size());
                        for (Column col : columns) {
                            String xmlValue = "";
                            RefObject tempRef_xmlValue = new RefObject((Object)xmlValue);
                            rowParameter2.add(BatchPreInsDataScriptBuilder.this.GetStr(dbRoute, strTableName, col, rs, (RefObject<String>)tempRef_xmlValue));
                            xmlValue = (String)tempRef_xmlValue.argvalue;
                            if (!StringUtils.isNotBlank((CharSequence)xmlValue)) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u9884\u7f6e\u811a\u672c\u4e0d\u652f\u6301\u5927\u6587\u672c\u5b57\u6bb5\u3002", (String)"BatchPreInsDataScriptBuilder_0", (String)"bos-business-dao", (Object[])new Object[0]));
                        }
                        params.add(rowParameter2);
                    }
                    int index = 0;
                    for (int n = 0; n < params.size(); n += BatchPreInsDataScriptBuilder.this.batchSize) {
                        int startIndex = n;
                        int endIndex = n + BatchPreInsDataScriptBuilder.this.batchSize;
                        if (endIndex > params.size()) {
                            endIndex = params.size();
                        }
                        List subParamList = params.subList(startIndex, endIndex);
                        if (index == 0) {
                            sb.append("\t").append("{").append(System.getProperty("line.separator"));
                        } else {
                            sb.append(",").append(System.getProperty("line.separator")).append("\t").append("{").append(System.getProperty("line.separator"));
                        }
                        BatchPreInsDataScriptBuilder.this.appendValue(sb, "table", strTableName, true, true);
                        BatchPreInsDataScriptBuilder.this.appendValue(sb, "columns", headColStr, true, true);
                        BatchPreInsDataScriptBuilder.this.appendValue(sb, "pk", JSON.toJSONString(primaryKey), false, true);
                        StringBuilder paramsSb = new StringBuilder("[").append(System.getProperty("line.separator"));
                        subParamList.forEach(rowParameter -> paramsSb.append("\t\t\t").append(JSON.toJSONString((Object)rowParameter)).append(",").append(System.getProperty("line.separator")));
                        String paramStr = paramsSb.toString();
                        paramStr = paramStr.substring(0, paramStr.lastIndexOf(","));
                        paramStr = paramStr + System.getProperty("line.separator") + "\t\t]";
                        BatchPreInsDataScriptBuilder.this.appendValue(sb, "params", paramStr, false, false);
                        sb.append(System.getProperty("line.separator")).append("\t").append("}");
                        ++index;
                    }
                    sb.append(System.getProperty("line.separator")).append("]");
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("sql", sb.toString());
                    return resultMap;
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
            }

            private String getInsertFieldSQL(String strTableName2, ResultSet rs, List<Column> columns, HashSet mapPKCols2) throws SQLException {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                int fieldCount = resultSetMetaData.getColumnCount();
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ").append(strTableName2).append("(");
                StringBuilder fieldSb = new StringBuilder(" ");
                StringBuilder valuesSb = new StringBuilder(" ");
                PreInsLongTextData longTextData1 = new PreInsLongTextData();
                for (int i = 1; i <= fieldCount; ++i) {
                    String fieldName = resultSetMetaData.getColumnName(i);
                    int colType = resultSetMetaData.getColumnType(i);
                    Column col = new Column();
                    col.setName(fieldName);
                    String colTypeName = resultSetMetaData.getColumnTypeName(i);
                    if (colType == 2 && "NUMBER".equals(colTypeName) && resultSetMetaData.getScale(i) == 0) {
                        int precision = resultSetMetaData.getPrecision(i);
                        if (precision > 10 && precision <= 19) {
                            col.setType(11);
                        } else if (precision <= 10) {
                            col.setType(9);
                        }
                    } else if (colType == 12 && "text".equals(resultSetMetaData.getColumnTypeName(i))) {
                        col.setType(8);
                    } else {
                        col.setType(KSQLDataType.javaSqlType2KSQLDataType(colType));
                    }
                    col.setIndex(i);
                    columns.add(col);
                    fieldSb.append(fieldName).append(',');
                    valuesSb.append("?,");
                }
                String fieldStr = fieldSb.toString();
                fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
                String valuesStr = valuesSb.toString();
                valuesStr = valuesStr.substring(0, valuesStr.length() - 1);
                sb.append(fieldStr).append(")").append("VALUES(").append(valuesStr).append(") ");
                String strInsertSQL = sb.toString();
                return strInsertSQL;
            }
        });
    }

    private void appendValue(StringBuilder sb, String key, Object value, boolean withQuotes, boolean withSeperator) {
        sb.append("\t\t").append("\"").append(key).append("\"").append(":");
        if (value == null) {
            sb.append("null");
        } else if (withQuotes) {
            sb.append("\"").append(value).append("\"");
        } else {
            sb.append(value);
        }
        if (withSeperator) {
            sb.append(",").append(System.getProperty("line.separator"));
        }
    }

    private Object GetStr(DBRoute dbRoute, String tableName, Column col, ResultSet rs, RefObject<String> xmlValue) throws SQLException {
        boolean isNull;
        boolean bl = isNull = rs.getObject(col.getIndex()) == null;
        if (isNull) {
            return null;
        }
        Object colValue = null;
        int colType = col.getType();
        DBType dbtype = DB.getDBType((DBRoute)dbRoute);
        if (colType == 14) {
            colValue = this.ZERO.equals(rs.getBigDecimal(col.getIndex())) ? "0.00" : rs.getString(col.getIndex());
        } else if (colType == 15) {
            SQLXML objValue = rs.getSQLXML(col.getIndex());
            String value = objValue == null ? "'<xml></xml>'" : objValue.toString();
            xmlValue.argvalue = value;
        } else if (colType == 8 || colType == 7) {
            Object clob = null;
            clob = dbtype == DBType.DM ? rs.getString(col.getIndex()) : rs.getObject(col.getIndex());
            if (clob == null || clob.toString().length() < 1000) {
                String value = clob == null ? "" : clob.toString();
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                colValue = value;
            } else {
                xmlValue.argvalue = clob.toString();
            }
        } else if (colType == 12) {
            Timestamp objValue = rs.getTimestamp(col.getIndex());
            if (objValue != null) {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
                colValue = sFormat.format(objValue);
            }
        } else if (colType == 6) {
            Blob blob = rs.getBlob(col.getIndex());
            byte[] bdata = blob.getBytes(1L, (int)blob.length());
            String s = new String(bdata, StandardCharsets.UTF_8);
            xmlValue.argvalue = "<![CDATA[" + s + "]]>";
        } else {
            colValue = rs.getObject(col.getIndex());
        }
        return colValue;
    }

    private String GetStr1(DBRoute dbRoute, String tableName, Column col, ResultSet rs, RefObject<String> xmlValue) throws SQLException {
        boolean withMark;
        boolean isNull;
        boolean bl = isNull = rs.getObject(col.getIndex()) == null;
        if (isNull) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        int colType = col.getType();
        DBType dbtype = DB.getDBType((DBRoute)dbRoute);
        if (DBType.SQLServer == dbtype) {
            if (colType == 3 || colType == 8 || colType == 2) {
                sb.append('N');
            }
        } else if (colType == 12) {
            sb.append("{ts'");
        }
        boolean bl2 = withMark = colType == 3 || colType == 8 || colType == 2 || colType == 1 || colType == 0 || colType == 7;
        if (withMark) {
            sb.append("'");
        }
        if (colType == 14 && this.ZERO.equals(rs.getBigDecimal(col.getIndex()))) {
            sb.append("0.00");
        } else if (colType == 15) {
            SQLXML objValue = rs.getSQLXML(col.getIndex());
            String value = objValue == null ? "'<xml></xml>'" : objValue.toString();
            xmlValue.argvalue = value;
        } else if (colType == 8 || colType == 7) {
            Object clob = null;
            clob = dbtype == DBType.DM ? rs.getString(col.getIndex()) : rs.getObject(col.getIndex());
            if (clob == null || clob.toString().length() < 1000) {
                String value = clob == null ? "" : clob.toString();
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                sb.append(value);
            } else {
                xmlValue.argvalue = clob.toString();
                sb.append(' ');
            }
        } else if (colType == 12) {
            String value;
            Date objValue = rs.getDate(col.getIndex());
            if (objValue != null) {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
                value = sFormat.format(objValue);
            } else {
                value = "";
            }
            value = value.replace("'", "''");
            if (value.length() == 0) {
                value = " ";
            }
            sb.append(value);
        } else if (colType == 6) {
            Blob blob = rs.getBlob(col.getIndex());
            byte[] bdata = blob.getBytes(1L, (int)blob.length());
            String s = new String(bdata, StandardCharsets.UTF_8);
            xmlValue.argvalue = "<![CDATA[" + s + "]]>";
            sb.append("NULL");
        } else {
            Object objValue = rs.getObject(col.getIndex());
            String value = objValue == null ? "" : objValue.toString();
            if ((value = value.replace("'", "''")).length() == 0) {
                value = " ";
            }
            sb.append(value);
        }
        if (withMark) {
            sb.append("'");
        } else if (colType == 12) {
            sb.append("'}");
        }
        return sb.toString();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

