/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sqlscript;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.DBVersion;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sqlscript.Column;
import kd.bos.sqlscript.KSQLDataType;
import kd.bos.sqlscript.PKCol;
import kd.bos.sqlscript.PreInsLongTextData;
import kd.bos.sqlscript.PreInsLongTextDataCollection;

public class PreInsDataScriptBuilder {
    private static final Log log = LogFactory.getLog(PreInsDataScriptBuilder.class);
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final String WHERE = " WHERE ";

    public final Map<String, Object> genInsertSQLScript(DBRoute dbRoute, String strTableName, String strFields, String strWhere, String strOders, String strDesc) {
        String[] fields;
        if (dbRoute == null || StringUtils.isBlank((CharSequence)dbRoute.getRouteKey())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"DBRoute \u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PreInsDataScriptBuilder_1", (String)"bos-business-dao", (Object[])new Object[0])});
        }
        LinkedHashMap<String, String> filedMap = new LinkedHashMap<String, String>(16);
        List pkColNames = DB.getPrimaryKeys((DBRoute)dbRoute, (String)strTableName);
        if (pkColNames.isEmpty()) {
            log.info("Table " + strTableName + ": primary key not defined.");
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u8868\u672a\u5b9a\u4e49\u4e3b\u952e\uff0c\u4e0d\u80fd\u751f\u6210\u811a\u672c\uff01", (String)"PreInsDataScriptBuilder_2", (String)"bos-business-dao", (Object[])new Object[0])});
        }
        HashSet<String> mapPKCols = new HashSet<String>(16);
        for (String[] pk : pkColNames) {
            String upperPK = pk.toUpperCase();
            mapPKCols.add(upperPK);
            filedMap.put(upperPK, upperPK);
        }
        for (String field : fields = strFields.replaceAll(" +", "").split(",")) {
            String[] aliasFields = new String[2];
            int indAlias = StringUtils.lastIndexOfIgnoreCase((CharSequence)field, (CharSequence)" as ");
            if (indAlias > 0) {
                aliasFields[0] = field.substring(0, indAlias);
                aliasFields[1] = field.substring(indAlias + 3, field.length());
            } else {
                int indSpace = field.lastIndexOf(32);
                if (indSpace > 0) {
                    aliasFields[0] = field.substring(0, indSpace);
                    aliasFields[1] = field.substring(indSpace, field.length());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)aliasFields[1])) {
                filedMap.put(aliasFields[1], field);
                continue;
            }
            filedMap.put(field, field);
        }
        StringBuffer sqlFields = new StringBuffer();
        for (String field : filedMap.values()) {
            sqlFields.append(field).append(',');
        }
        if (sqlFields.length() == 0) {
            return null;
        }
        String consFields = sqlFields.substring(0, sqlFields.length() - 1);
        return this.genInsertScript(dbRoute, strTableName, mapPKCols, consFields, strWhere, strOders, strDesc);
    }

    private static String getDataSql(String strTableName, String strFieldList, String strWhere, String strOder) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(strFieldList).append(" FROM ");
        sb.append(strTableName).append(' ');
        sb.append(StringUtils.isNotBlank((CharSequence)strWhere) ? WHERE + strWhere : "").append(' ');
        sb.append(StringUtils.isNotBlank((CharSequence)strOder) ? "ORDER BY " + strOder : "");
        return sb.toString();
    }

    private static void genHeadScript(String desc, StringBuilder sbScript) {
        sbScript.append("/****** Object:Data   ").append(desc).append("    Script Date: ");
        sbScript.append(new java.util.Date()).append(" ******/");
        sbScript.append("\r\n");
    }

    private static void genDeleteScript(String strTableName, String strWhere, StringBuilder sb) {
        sb.append("DELETE ").append(strTableName);
        sb.append(StringUtils.isNotBlank((CharSequence)strWhere) ? WHERE + strWhere : "");
        sb.append(';').append(System.getProperty("line.separator"));
    }

    private Map<String, Object> genInsertScript(final DBRoute dbRoute, final String strTableName, final HashSet mapPKCols, String colFields, String strWhere, String strOders, String strDesc) {
        String[] cols = colFields.split(",");
        HashSet<String> setCols = new HashSet<String>();
        for (String colStr : cols) {
            setCols.add(colStr.toUpperCase());
        }
        String consFields = String.join((CharSequence)", ", setCols.toArray(new String[setCols.size()]));
        String strSQL = PreInsDataScriptBuilder.getDataSql(strTableName, consFields, strWhere, strOders);
        return (Map)DB.query((DBRoute)dbRoute, (String)strSQL, (Object[])new SqlParameter[0], (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws KDException {
                try {
                    ArrayList<Column> columns = new ArrayList<Column>();
                    HashMap<String, StringWriter> longTextDataFile = new HashMap<String, StringWriter>();
                    String strSQL = this.getInsertFieldSQL(strTableName, rs, columns);
                    StringBuilder sbScript = new StringBuilder();
                    while (rs.next()) {
                        StringBuilder valuesSQL = new StringBuilder();
                        valuesSQL.append("VALUES (");
                        HashMap<String, Object[]> dictPK = new HashMap<String, Object[]>();
                        HashMap<String, String[]> dictLongTextCol = new HashMap<String, String[]>();
                        for (Column col : columns) {
                            if (mapPKCols.contains(col.getName().toUpperCase())) {
                                Object objValue = rs.getObject(col.getIndex());
                                dictPK.put(col.getName(), new Object[]{col.getType(), objValue});
                            }
                            Object xmlValue = "";
                            RefObject refObject = new RefObject(xmlValue);
                            valuesSQL.append(PreInsDataScriptBuilder.this.GetStr(dbRoute, strTableName, col, rs, (RefObject<String>)refObject)).append(',');
                            xmlValue = (String)refObject.argvalue;
                            if (!StringUtils.isNotBlank((CharSequence)xmlValue)) continue;
                            String[] val = new String[]{xmlValue, col.getType() == 6 ? "blob" : "nclob"};
                            dictLongTextCol.put(col.getName(), val);
                        }
                        String strVal = valuesSQL.toString();
                        strVal = strVal.substring(0, strVal.length() - 1) + "); ";
                        sbScript.append("DELETE FROM ").append(strTableName);
                        sbScript.append(PreInsDataScriptBuilder.WHERE);
                        int i = 0;
                        for (Map.Entry entry : dictPK.entrySet()) {
                            if (i > 0) {
                                sbScript.append(" and ");
                            }
                            int type = (Integer)((Object[])entry.getValue())[0];
                            String pkVal = ((Object[])entry.getValue())[1].toString();
                            if (type == 0 || type == 1 || type == 2 || type == 3) {
                                sbScript.append((String)entry.getKey()).append(" = '").append(pkVal).append("'");
                            } else {
                                sbScript.append((String)entry.getKey()).append(" = ").append(pkVal);
                            }
                            ++i;
                        }
                        sbScript.append(';').append(System.getProperty("line.separator"));
                        sbScript.append(strSQL);
                        sbScript.append(strVal);
                        sbScript.append(System.lineSeparator());
                        PreInsLongTextDataCollection ltds = new PreInsLongTextDataCollection();
                        for (Map.Entry item : dictLongTextCol.entrySet()) {
                            if (!StringUtils.isNotBlank((CharSequence)((String[])item.getValue())[0])) continue;
                            PreInsLongTextData longTextData = new PreInsLongTextData();
                            longTextData.setDbKey(dbRoute.getRouteKey());
                            longTextData.setTable(strTableName);
                            longTextData.setColname((String)item.getKey());
                            longTextData.setTexttype(((String[])item.getValue())[1]);
                            ArrayList<PKCol> pkCols = new ArrayList<PKCol>(16);
                            longTextData.setPkCol(pkCols);
                            for (Map.Entry pk : dictPK.entrySet()) {
                                PKCol pkCol = new PKCol();
                                pkCol.setName((String)pk.getKey());
                                pkCol.setType((Integer)((Object[])dictPK.get(pk.getKey()))[0]);
                                pkCol.setValue(((Object[])dictPK.get(pk.getKey()))[1].toString());
                                pkCols.add(pkCol);
                            }
                            longTextData.setData(((String[])item.getValue())[0]);
                            ltds.add(longTextData);
                        }
                        if (ltds.size() <= 0) continue;
                        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{PreInsLongTextDataCollection.class});
                        Marshaller marshaller = jAXBContext.createMarshaller();
                        StringWriter sw = new StringWriter();
                        marshaller.marshal((Object)ltds, (Writer)sw);
                        String strxmlFileName = PreInsDataScriptBuilder.this.GetXmlFileName(strTableName, dictPK);
                        longTextDataFile.put(strxmlFileName, sw);
                    }
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("sql", sbScript.toString());
                    if (!longTextDataFile.isEmpty()) {
                        resultMap.put("xml", longTextDataFile);
                    }
                    return resultMap;
                }
                catch (SQLException | JAXBException e) {
                    throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
            }

            private String getInsertFieldSQL(String strTableName2, ResultSet rs, List<Column> columns) throws SQLException {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                int fieldCount = resultSetMetaData.getColumnCount();
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ").append(strTableName2).append("(");
                PreInsLongTextData longTextData1 = new PreInsLongTextData();
                for (int i = 1; i <= fieldCount; ++i) {
                    String fieldName = resultSetMetaData.getColumnName(i);
                    int colType = resultSetMetaData.getColumnType(i);
                    Column col = new Column();
                    col.setName(fieldName);
                    String colTypeName = resultSetMetaData.getColumnTypeName(i);
                    if (colType == 2 && "NUMBER".equals(colTypeName) && resultSetMetaData.getScale(i) == 0) {
                        int precision = resultSetMetaData.getPrecision(i);
                        if (precision > 10 && precision <= 19) {
                            col.setType(11);
                        } else if (precision <= 10) {
                            col.setType(9);
                        }
                    } else if (colType == 12 && "text".equals(resultSetMetaData.getColumnTypeName(i))) {
                        col.setType(8);
                    } else {
                        col.setType(KSQLDataType.javaSqlType2KSQLDataType(colType));
                    }
                    col.setIndex(i);
                    columns.add(col);
                    sb.append(fieldName).append(',');
                }
                String strInsertSQL = sb.toString();
                String strSQL = strInsertSQL.substring(0, strInsertSQL.length() - 1) + ") ";
                return strSQL;
            }
        });
    }

    private String GetXmlFileName(String strTableName, Map<String, Object[]> dictPK) {
        String strxmlFileName = "";
        String strPKValue = "";
        if (dictPK != null) {
            for (Map.Entry<String, Object[]> entry : dictPK.entrySet()) {
                strPKValue = entry.getValue()[1].toString() + "_";
            }
        }
        int year = Calendar.getInstance().get(1) % 100;
        int week = Calendar.getInstance().get(3);
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            isv = "kd";
        }
        String[] ver = DBVersion.getVer().split("\\.");
        strxmlFileName = String.format("%s_%s.%s.%s%s_%s.%s.xml", isv, ver[0], ver[1], year, week, strTableName, StringUtils.isBlank((CharSequence)strPKValue) ? UUID.randomUUID().toString() : strPKValue.substring(0, strPKValue.length() - 1));
        return strxmlFileName;
    }

    private String GetStr(DBRoute dbRoute, String tableName, Column col, ResultSet rs, RefObject<String> xmlValue) throws SQLException {
        boolean withMark;
        boolean isNull;
        boolean bl = isNull = rs.getObject(col.getIndex()) == null;
        if (isNull) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        int colType = col.getType();
        DBType dbtype = DB.getDBType((DBRoute)dbRoute);
        if (DBType.SQLServer == dbtype) {
            if (colType == 3 || colType == 8 || colType == 2) {
                sb.append('N');
            }
        } else if (colType == 12) {
            sb.append("{ts'");
        }
        boolean bl2 = withMark = colType == 3 || colType == 8 || colType == 2 || colType == 1 || colType == 0 || colType == 7;
        if (withMark) {
            sb.append("'");
        }
        if (colType == 14 && this.ZERO.equals(rs.getBigDecimal(col.getIndex()))) {
            sb.append("0.00");
        } else if (colType == 15) {
            SQLXML objValue = rs.getSQLXML(col.getIndex());
            String value = objValue == null ? "'<xml></xml>'" : objValue.toString();
            xmlValue.argvalue = value;
        } else if (colType == 8 || colType == 7) {
            Object clob = null;
            clob = dbtype == DBType.DM ? rs.getString(col.getIndex()) : rs.getObject(col.getIndex());
            if (clob == null || clob.toString().length() < 1000) {
                String value = clob == null ? "" : clob.toString();
                if ((value = value.replace("'", "''")).length() == 0) {
                    value = " ";
                }
                sb.append(value);
            } else {
                xmlValue.argvalue = clob.toString();
                sb.append(' ');
            }
        } else if (colType == 12) {
            String value;
            Date objValue = rs.getDate(col.getIndex());
            if (objValue != null) {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.getDefault());
                value = sFormat.format(objValue);
            } else {
                value = "";
            }
            value = value.replace("'", "''");
            if (value.length() == 0) {
                value = " ";
            }
            sb.append(value);
        } else if (colType == 6) {
            Blob blob = rs.getBlob(col.getIndex());
            byte[] bdata = blob.getBytes(1L, (int)blob.length());
            String s = new String(bdata, StandardCharsets.UTF_8);
            xmlValue.argvalue = "<![CDATA[" + s + "]]>";
            sb.append("NULL");
        } else {
            Object objValue = rs.getObject(col.getIndex());
            String value = objValue == null ? "" : objValue.toString();
            if ((value = value.replace("'", "''")).length() == 0) {
                value = " ";
            }
            sb.append(value);
        }
        if (withMark) {
            sb.append("'");
        } else if (colType == 12) {
            sb.append("'}");
        }
        return sb.toString();
    }
}

