/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.subsystem.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class SubSystemReader {
    private static final String LIBNAME = "libName";
    private String errorMsg = "Error:%s";
    private static final String FNUMBER = ":FNUMBER";
    private static final String ERROR = "error:%s;  sql:%s";

    public Map<String, Object> getSubSystem() {
        List pathList;
        String sql = "select s.FMAPSCCMETAFOLDER,s.FLIBNAME from T_BAS_SUBSYSTEM s ";
        try {
            pathList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws KDException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    try {
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("libAddress", rs.getString(1));
                            map.put(SubSystemReader.LIBNAME, rs.getString(2));
                            list.add(map);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(SubSystemReader.this.errorMsg, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (pathList != null && pathList.size() > 0) {
            return (Map)pathList.get(0);
        }
        return null;
    }

    public Map<String, Object> getSubSystem(String number) {
        List pathList;
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, -9, (Object)number.toLowerCase())};
        String sql = "select s.FMAPSCCMETAFOLDER,s.FLIBNAME from T_BAS_SUBSYSTEM s where s.FNUMBER = ? ";
        try {
            pathList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws KDException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    try {
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("libAddress", rs.getString(1));
                            map.put(SubSystemReader.LIBNAME, rs.getString(2));
                            list.add(map);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(SubSystemReader.this.errorMsg, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (pathList != null && pathList.size() > 0) {
            return (Map)pathList.get(0);
        }
        return null;
    }

    public Map<String, Object> getLibName(String number) {
        List pathList;
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, -9, (Object)number.toLowerCase())};
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t1.FLIBNAME FROM T_BAS_SUBSYSTEM t1 \n");
        sql.append("INNER JOIN T_META_FORMDESIGN t2 ON t1.FID = t2.FSUBSYSID \n");
        sql.append("WHERE t2.FNUMBER = ? \n");
        try {
            pathList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws KDException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    try {
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put(SubSystemReader.LIBNAME, rs.getString(1));
                            list.add(map);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(SubSystemReader.this.errorMsg, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (pathList != null && pathList.size() > 0) {
            return (Map)pathList.get(0);
        }
        return null;
    }

    public boolean checkNumber(String number) {
        String sql = String.format("select 1 from %s where FNUMBER = ? ", "T_BAS_SUBSYSTEM");
        Object[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number)};
        Integer val = (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws KDException {
                Integer iRet = 0;
                try {
                    if (rs.next()) {
                        iRet = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(SubSystemReader.this.errorMsg, e.getMessage())});
                }
                return iRet;
            }
        });
        if (StringUtils.isBlank((Object)val)) {
            val = 0;
        }
        return val > 0;
    }

    public boolean checkName(String name) {
        String sql = String.format("select 1 from %s where FNAME = ? ", "T_BAS_SUBSYSTEM_L");
        Object[] params = new SqlParameter[]{new SqlParameter(":FNAME", 12, (Object)name)};
        Integer val = (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws KDException {
                Integer iRet = 0;
                try {
                    if (rs.next()) {
                        iRet = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(SubSystemReader.this.errorMsg, e.getMessage())});
                }
                return iRet;
            }
        });
        if (StringUtils.isBlank((Object)val)) {
            val = 0;
        }
        return val > 0;
    }
}

