/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upgrade.ExtClassLoader;

public class ClassManager {
    private static final Log logger = LogFactory.getLog(ClassManager.class);
    private static LocalMemoryCache localMemoryCache = null;
    private static final List<Job> jobs = new ArrayList<Job>(2);

    public static Class<?> forName(String className) {
        ExtClassLoader loader = ClassManager.getExtClassLoader(ClassManager.getAccountId());
        return loader.loadClass(className);
    }

    public static Object getSingleton(String className) {
        ExtClassLoader loader = ClassManager.getExtClassLoader(ClassManager.getAccountId());
        return loader.getSingleton(className);
    }

    public static void reset(String accountId) throws Exception {
        ClassManager.disposeCurrent(accountId);
        ExtClassLoader loader = ClassManager.getExtClassLoader(accountId);
        loader.init();
    }

    private static String getAccountId() {
        RequestContext rc = RequestContext.get();
        String account = null;
        account = rc == null ? "requestcontextnull" : RequestContext.get().getAccountId();
        if (StringUtils.isBlank((CharSequence)account)) {
            account = "accountidnull";
        }
        return account;
    }

    private static synchronized void disposeCurrent(String accountId) {
        ExtClassLoader loader = (ExtClassLoader)ClassManager.getLocalCache().get(accountId);
        if (loader != null) {
            loader.dispose();
        }
        logger.info(" remove ExtClassLoader " + accountId);
        ClassManager.getLocalCache().remove(new String[]{accountId});
    }

    private static synchronized ExtClassLoader getExtClassLoader(String accountId) {
        ExtClassLoader loader = (ExtClassLoader)ClassManager.getLocalCache().get(accountId);
        if (loader == null) {
            logger.info("new ExtClassLoader: " + accountId);
            loader = new ExtClassLoader(accountId);
            ClassManager.getLocalCache().put(accountId, (Object)loader);
        }
        return loader;
    }

    private static synchronized LocalMemoryCache getLocalCache() {
        if (localMemoryCache == null) {
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(43200);
            info.setMaxMemSize(10000);
            localMemoryCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(Instance.getClusterName(), "extclassmanager", info);
        }
        return localMemoryCache;
    }

    static synchronized void addJob(Job job) {
        jobs.add(job);
    }

    private static synchronized Job[] getJobs() {
        return jobs.toArray(new Job[jobs.size()]);
    }

    static {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        1.sleep(3000L);
                        Job[] jobArray = ClassManager.getJobs();
                        int n = jobArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block2;
                            Job job = jobArray[n2];
                            job.run();
                            ++n2;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.setName("ExtClassLoaderMonitor");
        t.start();
    }

    static interface Job {
        public void run();
    }
}

