/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import kd.bos.dataentity.TypesContainer;
import kd.bos.instance.Instance;
import kd.bos.upgrade.JarFileManager;
import kd.bos.upgrade.SingletonContainer;
import kd.bos.upgrade.ZipFileCache;

public class ExtClassLoader
extends ClassLoader {
    private JarFileManager jarManager;
    private SingletonContainer<String, Class<?>> localClasses;
    private SingletonContainer<String, Object> localSingletons;
    private static final Class<?> NON_CLASS = NoClass.class;
    private static final SingletonContainer<Class<?>, Object> globalSingletons;

    public ExtClassLoader(String account) {
        this.jarManager = new JarFileManager(account);
        this.localClasses = new SingletonContainer(this.getClassFactory());
        this.localSingletons = new SingletonContainer<String, Object>(this.getLocalSingletonFactory());
    }

    final Object getSingleton(String className) {
        return this.localSingletons.get(className);
    }

    private boolean isExtClass(String name) {
        return this.jarManager.find(name) != null;
    }

    final void dispose() {
        this.jarManager.dispose();
    }

    final void init() throws Exception {
        this.jarManager.init();
    }

    private SingletonContainer.Factory<String, Class<?>> getClassFactory() {
        return new SingletonContainer.Factory<String, Class<?>>(){

            @Override
            public Class<?> create(String name) {
                try {
                    File file = ExtClassLoader.this.jarManager.find(name);
                    if (file == null) {
                        return NON_CLASS;
                    }
                    return ExtClassLoader.this.loadClass(name, file);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("%s: %s failed.", Instance.getAppName(), name), e);
                }
            }
        };
    }

    @Override
    public final Class<?> loadClass(String name) {
        Class<?> clz = this.localClasses.get(name);
        if (clz == NON_CLASS) {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("%s: %s not found.", Instance.getAppName(), name), e);
            }
        }
        return clz;
    }

    @Override
    public final URL getResource(String name) {
        String key = JarFileManager.getResouceKey(name);
        File file = this.jarManager.find(key);
        if (file == null) {
            return super.getResource(name);
        }
        return this.createURL(name, file);
    }

    private URL createURL(String name, File file) {
        try {
            return new URL(null, "sky://" + name, this.createURLStreamHandler(name, file));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private URLStreamHandler createURLStreamHandler(final String name, final File file) {
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return ExtClassLoader.this.createResourceConnection(name, file, u);
            }
        };
    }

    private Class<?> loadClass(String name, File file) throws IOException {
        String res = name.replace('.', '/') + ".class";
        byte[] bytes = ZipFileCache.read(file, res);
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private URLConnection createResourceConnection(final String name, final File file, URL u) {
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                byte[] bytes = ZipFileCache.read(file, name);
                return new ByteArrayInputStream(bytes);
            }
        };
    }

    private SingletonContainer.Factory<String, Object> getLocalSingletonFactory() {
        return new SingletonContainer.Factory<String, Object>(){

            @Override
            public Object create(String className) {
                try {
                    Class cls = (Class)ExtClassLoader.this.localClasses.get(className);
                    if (ExtClassLoader.this.isExtClass(className)) {
                        return TypesContainer.createInstance((Class)cls);
                    }
                    return globalSingletons.get(cls);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
    }

    static {
        ClassLoader.registerAsParallelCapable();
        globalSingletons = new SingletonContainer(new SingletonContainer.Factory<Class<?>, Object>(){

            @Override
            public Object create(Class<?> cls) {
                try {
                    return TypesContainer.createInstance(cls);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }

    static class NoClass {
        NoClass() {
        }
    }
}

