/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.IDService;
import kd.bos.upgrade.ClassManager;

public class ExtJarApi {
    private static final String SQL = "INSERT INTO T_META_EXT_JAR(fid,fnumber,fdescription,fenabled,fjar,fhash,flast_modified_time,flast_modifier,fapp,fisv)values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    public static void reset(String accountId) throws Exception {
        ExtJarApi.select();
        ClassManager.reset(accountId);
    }

    public static boolean select() {
        String sql = "SELECT 1 FROM T_META_EXT_JAR";
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, ResultSet::next);
    }

    public static boolean delete(long id) {
        String sql = "DELETE FROM T_META_EXT_JAR WHERE fid=?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{id});
    }

    public static boolean enable(long id) {
        String sql = "UPDATE T_META_EXT_JAR SET fenabled=? WHERE fid=?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{"1", id});
    }

    public static boolean disable(long id) {
        String sql = "UPDATE T_META_EXT_JAR SET fenabled=? WHERE fid=?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{"0", id});
    }

    public static boolean enableDeployJar() {
        String sql = "UPDATE T_META_EXT_JAR SET fenabled=?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{"1"});
    }

    public static boolean disableDeployJar() {
        String sql = "UPDATE T_META_EXT_JAR SET fenabled=?";
        return DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{"0"});
    }

    public static void clear() {
        String sql = "TRUNCATE TABLE T_META_EXT_JAR";
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static void insert(String number, String description, byte[] jar, String app, String isv) {
        long fid = IDService.get().genLongId();
        String fnumber = ExtJarApi.trim(number, 100);
        String fdescription = ExtJarApi.trim(description, 300);
        String fenabled = "1";
        long fhash = ExtJarApi.getCRC(jar);
        Timestamp flast_modified_time = new Timestamp(System.currentTimeMillis());
        long flast_modifier = ExtJarApi.getCurrentUserId();
        String fapp = ExtJarApi.trim(app, 50);
        String fisv = ExtJarApi.trim(isv, 50);
        String sql = SQL;
        Object[] params = new Object[]{fid, fnumber, fdescription, fenabled, jar, fhash, flast_modified_time, flast_modifier, fapp, fisv};
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    public static void save(String number, String description, byte[] jar, String app, String isv) {
        long fid = IDService.get().genLongId();
        String fnumber = ExtJarApi.trim(number, 100);
        String fdescription = ExtJarApi.trim(description, 300);
        String fenabled = "1";
        long fhash = ExtJarApi.getCRC(jar);
        Timestamp flast_modified_time = new Timestamp(System.currentTimeMillis());
        long flast_modifier = ExtJarApi.getCurrentUserId();
        String fapp = ExtJarApi.trim(app, 50);
        String fisv = ExtJarApi.trim(isv, 50);
        boolean hasNumber = false;
        String existSql = "SELECT fnumber,fhash FROM T_META_EXT_JAR WHERE fnumber=?";
        Object[] existParams = new Object[]{number};
        Map mapExist = null;
        mapExist = (Map)DB.query((DBRoute)DBRoute.meta, (String)existSql, (Object[])existParams, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = null;
                if (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("number", rs.getString(1));
                    map.put("hash", rs.getString(2));
                }
                return map;
            }
        });
        if (mapExist == null) {
            String sql = SQL;
            Object[] params = new Object[]{fid, fnumber, fdescription, fenabled, jar, fhash, flast_modified_time, flast_modifier, fapp, fisv};
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
        } else {
            long existHash = Long.parseLong((String)mapExist.get("hash"));
            if (fhash != existHash) {
                String uSql = "UPDATE T_META_EXT_JAR SET fjar=?,fhash=?,flast_modified_time=? WHERE fnumber=?";
                Object[] uParams = new Object[]{jar, fhash, flast_modified_time, fnumber};
                DB.execute((DBRoute)DBRoute.meta, (String)uSql, (Object[])uParams);
            }
        }
    }

    public static void save(List<Map<String, Object>> lstJarInfo) {
        ArrayList<String> lstNumber = new ArrayList<String>(16);
        StringBuilder numbers = new StringBuilder();
        for (int i = 0; i < lstJarInfo.size(); ++i) {
            numbers.append("?,");
            lstNumber.add((String)lstJarInfo.get(i).get("name"));
        }
        numbers = new StringBuilder(numbers.substring(0, numbers.length() - 1));
        String existSql = "SELECT fnumber,fhash FROM T_META_EXT_JAR WHERE fnumber in (" + numbers + ")";
        Map numberHash = (Map)DB.query((DBRoute)DBRoute.meta, (String)existSql, (Object[])lstNumber.toArray(), (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = null;
                while (rs.next()) {
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    map.put(rs.getString(1), rs.getString(2));
                }
                return map;
            }
        });
        ArrayList<Object[]> lstInsertParams = null;
        ArrayList<Object[]> lstUpdateParams = null;
        for (Map<String, Object> jarInfo : lstJarInfo) {
            Object temp;
            String number = (String)jarInfo.get("name");
            String fnumber = ExtJarApi.trim(number, 100);
            String description = (String)jarInfo.get("desc");
            byte[] jar = (byte[])jarInfo.get("jar");
            long fhash = ExtJarApi.getCRC(jar);
            String app = (String)jarInfo.get("app");
            String isv = (String)jarInfo.get("isv");
            Timestamp flast_modified_time = new Timestamp(System.currentTimeMillis());
            String hashOld = null;
            if (numberHash != null && (temp = numberHash.get(number)) != null) {
                hashOld = (String)temp;
            }
            if (StringUtils.isBlank(hashOld)) {
                long fid = IDService.get().genLongId();
                String fdescription = ExtJarApi.trim(description, 300);
                String fenabled = "1";
                long flast_modifier = ExtJarApi.getCurrentUserId();
                String fapp = ExtJarApi.trim(app, 50);
                String fisv = ExtJarApi.trim(isv, 50);
                Object[] params = new Object[]{fid, fnumber, fdescription, fenabled, jar, fhash, flast_modified_time, flast_modifier, fapp, fisv};
                if (lstInsertParams == null) {
                    lstInsertParams = new ArrayList<Object[]>();
                }
                lstInsertParams.add(params);
                continue;
            }
            long existHash = Long.parseLong(hashOld);
            if (fhash == existHash) continue;
            Object[] uParams = new Object[]{jar, fhash, flast_modified_time, fnumber};
            if (lstUpdateParams == null) {
                lstUpdateParams = new ArrayList<Object[]>();
            }
            lstUpdateParams.add(uParams);
        }
        try (TXHandle h = TX.requiresNew();){
            if (lstInsertParams != null && !lstInsertParams.isEmpty()) {
                String sql = SQL;
                DB.executeBatch((DBRoute)DBRoute.meta, (String)sql, (List)lstInsertParams);
            }
            if (lstUpdateParams != null && !lstUpdateParams.isEmpty()) {
                String uSql = "UPDATE T_META_EXT_JAR SET fjar=?,fhash=?,flast_modified_time=? WHERE fnumber=?";
                DB.executeBatch((DBRoute)DBRoute.meta, (String)uSql, (List)lstUpdateParams);
            }
        }
    }

    public static List<Map<String, Object>> list() {
        String sql = "SELECT  fid,fnumber,fdescription,fenabled,fhash,flast_modified_time,flast_modifier,fapp,fisv FROM T_META_EXT_JAR";
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                return ExtJarApi.toList(rs);
            }
        });
    }

    private static String trim(String s, int maxLength) {
        if (s == null || s.length() == 0) {
            return " ";
        }
        if (s.length() < maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 2) + "..";
    }

    private static long getCurrentUserId() {
        String userId = RequestContext.get().getUserId();
        if (ExtJarApi.isNumber(userId)) {
            return Long.parseLong(userId);
        }
        return 0L;
    }

    private static boolean isNumber(String userId) {
        if (userId == null) {
            return false;
        }
        for (int i = 0; i < userId.length(); ++i) {
            char c = userId.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static long getCRC(byte[] jar) {
        CRC32 crc = new CRC32();
        crc.update(jar);
        return crc.getValue();
    }

    private static List<Map<String, Object>> toList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        while (rs.next()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(16);
            item.put("id", rs.getObject("fid"));
            item.put("number", rs.getObject("fnumber"));
            item.put("description", rs.getObject("fdescription"));
            item.put("enabled", rs.getObject("fenabled"));
            item.put("hash", rs.getObject("fhash"));
            item.put("last_modified_time", rs.getObject("flast_modified_time"));
            item.put("last_modifier", rs.getObject("flast_modifier"));
            item.put("app", rs.getObject("fapp"));
            item.put("isv", rs.getObject("fisv"));
            list.add(item);
        }
        return list;
    }
}

