/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upgrade.ClassManager;
import kd.bos.upgrade.SingletonContainer;

class ZipFileCache {
    private static final int MAX_IDLE_LIFE = 5000;
    private static final SingletonContainer<File, Item> opened_zip_files = new SingletonContainer<File, Item>(new SingletonContainer.Factory<File, Item>(){

        @Override
        public Item create(File file) {
            return new Item(file);
        }
    });
    private static Log logger = LogFactory.getLog(ZipFileCache.class);

    ZipFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] read(File file, String res) throws IOException {
        Item item = ZipFileCache.getItem(file);
        try {
            byte[] byArray = ZipFileCache.readContent(item.zipFile, res);
            return byArray;
        }
        finally {
            item.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] readContent(ZipFile zip, String res) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Item getItem(File file) {
        Item item;
        while (!(item = ZipFileCache.opened_zip_files.get(file)).tryLock()) {
        }
        return item;
    }

    static void close(File file) throws IOException {
        Item item = opened_zip_files.remove(file);
        if (item != null) {
            item.close();
        }
    }

    private static void closeIdleFiles() {
        try {
            final long deadline = System.currentTimeMillis() - 5000L;
            opened_zip_files.visit(new SingletonContainer.Visitor<File, Item>(){

                @Override
                public SingletonContainer.Action visit(Map.Entry<File, Item> e) throws IOException {
                    Item item = e.getValue();
                    if (item.tryClose(deadline)) {
                        return SingletonContainer.Action.Remove;
                    }
                    return SingletonContainer.Action.NOP;
                }
            });
        }
        catch (Throwable e) {
            logger.warn("\u5173\u95ed\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
    }

    static {
        ClassManager.addJob(new ClassManager.Job(){

            @Override
            public void run() {
                ZipFileCache.closeIdleFiles();
            }
        });
    }

    private static class Item {
        private File file;
        private ZipFile zipFile;
        private long access_time;
        private int count = 0;

        private Item(File file) {
            try {
                this.file = file;
                this.zipFile = new ZipFile(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private synchronized boolean tryLock() {
            if (this.zipFile == null) {
                opened_zip_files.remove(this.file);
                return false;
            }
            this.access_time = System.currentTimeMillis();
            ++this.count;
            return true;
        }

        private synchronized void unlock() {
            this.access_time = System.currentTimeMillis();
            --this.count;
        }

        private synchronized boolean tryClose(long deadline) throws IOException {
            if (this.count > 0 || this.access_time > deadline) {
                return false;
            }
            this.close();
            return true;
        }

        private synchronized void close() throws IOException {
            this.zipFile.close();
            this.zipFile = null;
        }
    }
}

