/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userbehavior.service;

import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.userbehavior.UserBehaviorLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.useragent.util.UserAgentUtils;
import kd.bos.userbehavior.service.ProductInfoReader;
import kd.bos.userbehavior.service.UserBehaviorConfig;
import kd.bos.userbehavior.service.cloudplatform.CPUserBehaviorLogService;

public abstract class UserBehaviorLogService {
    private static ProductInfoReader reader;
    static ThreadPool runtime;
    private LogQueque queque = new LogQueque();
    private static UserBehaviorLogService behaviorLogService;

    public UserBehaviorLogService(ProductInfoReader reader) {
        UserBehaviorLogService.reader = reader;
    }

    protected ProductInfoReader getProductInfoReader() {
        return reader;
    }

    public static synchronized UserBehaviorLogService getDefault(ProductInfoReader reader) {
        if (behaviorLogService == null) {
            behaviorLogService = new CPUserBehaviorLogService(reader);
        }
        return behaviorLogService;
    }

    public void sendUserBehaviorLog(String appId, String formId, String function, long timespan) {
        if (UserBehaviorConfig.getEnabled().booleanValue()) {
            UserBehaviorLog behaviorLog = UserBehaviorLogService.create(appId, formId, function, timespan);
            this.queque.enQueque(behaviorLog);
        }
    }

    protected abstract void sendLog(List<UserBehaviorLog> var1);

    private static UserBehaviorLog create(String appId, String formId, String action, long timespan) {
        RequestContext ctx = RequestContext.get();
        String acctId = ctx.getAccountId();
        String uid = ctx.getUid();
        String sessionId = ctx.getGlobalSessionId();
        long time = System.currentTimeMillis();
        String agent = ctx.getUserAgent();
        UserAgentUtils ua = UserAgentUtils.parseUserAgentString((String)agent);
        String browser = ua.getBrowser().toString();
        String operatingsystem = ua.getOperatingSystem().toString();
        ZoneId defaultZone = ZoneId.systemDefault();
        String ip = ctx.getLoginIP();
        UserBehaviorLog userlog = new UserBehaviorLog();
        userlog.setAccountid(acctId);
        userlog.setUid(uid);
        userlog.setSessionid(sessionId);
        userlog.setAppid(appId);
        userlog.setFormid(formId);
        userlog.setAction(action);
        userlog.setTimezone(defaultZone.toString());
        userlog.setTime(time);
        userlog.setTimespan(timespan);
        userlog.setIp(ip);
        userlog.setBrowser(browser);
        userlog.setOperatingsystem(operatingsystem);
        userlog.setVersion("1.0");
        userlog.setAccountname("");
        userlog.setUsername("");
        userlog.setFunctionname("");
        userlog.setFunctiontype("");
        userlog.setProductname("");
        return userlog;
    }

    static {
        runtime = ThreadPools.newFixedThreadPool((String)"UserBehaviorLogService execute threads", (int)2);
    }

    static class LogQueque
    implements Closeable {
        private int batchSize = 1000;
        private int maxQueueSize = 1500;
        private static Log log = LogFactory.getLog(UserBehaviorLogService.class);
        private BlockingQueue<UserBehaviorLog> logsQueue = new LinkedBlockingQueue<UserBehaviorLog>();
        private Boolean hasLogged = Boolean.FALSE;

        LogQueque() {
        }

        public void enQueque(UserBehaviorLog userlog) {
            if (this.logsQueue.size() >= this.maxQueueSize) {
                if (!this.hasLogged.booleanValue()) {
                    log.info("\u5f53\u524d\u6536\u96c6\u961f\u5217\u5df2\u6ee1\uff0c\u4e0d\u5728\u6536\u96c6\u65e5\u5fd7\u4fe1\u606f");
                    this.hasLogged = Boolean.TRUE;
                }
            } else {
                if (this.hasLogged.booleanValue()) {
                    log.info("\u961f\u5217\u5df2\u6e05\u7a7a\uff0c\u5f00\u59cb\u6536\u96c6\u65e5\u5fd7\u4fe1\u606f");
                    this.hasLogged = Boolean.FALSE;
                }
                this.logsQueue.offer(userlog);
            }
            runtime.executeIncludeRequestContext(new Runnable(){

                @Override
                public void run() {
                    if (logsQueue.size() >= batchSize) {
                        this.flush();
                    }
                }
            });
        }

        private void flush() {
            ArrayList<UserBehaviorLog> list = new ArrayList<UserBehaviorLog>();
            this.logsQueue.drainTo(list);
            UserBehaviorLogService.getDefault(reader).sendLog(list);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

