/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.filter.ArchiveOptions;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IClientViewProxy;

class ArchiveUIProxy {
    private String dbRouteKey;
    private String entityTypeName;
    private FilterContainer filterContainer;

    ArchiveUIProxy(FilterContainer filterContainer, String dbRouteKey, String entityTypeName) {
        this.filterContainer = filterContainer;
        this.dbRouteKey = dbRouteKey;
        this.entityTypeName = entityTypeName;
    }

    void setArchiveInfo() {
        RouteInfo routeInfo = MCArchive.get((String)this.dbRouteKey, (String)this.entityTypeName);
        boolean existedArchiveKey = StringUtils.isNotEmpty((CharSequence)this.filterContainer.getContext().getArchiveKey());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.filterContainer.getView().getService(IClientViewProxy.class);
        if (existedArchiveKey) {
            List archiveInfo = routeInfo.getArchiveInfo();
            for (ArchiveInfo info : archiveInfo) {
                String key = info.getKey();
                if (!this.filterContainer.getContext().getArchiveKey().equals(key)) continue;
                ArrayList<ArchiveInfo> archiveMade = new ArrayList<ArchiveInfo>(1);
                archiveMade.add(info);
                ArchiveOptions archiveOptions = new ArchiveOptions(archiveMade);
                this.filterContainer.getContext().setRouteKey(routeInfo.getRouteKey());
                this.filterContainer.getContext().setArchiveKey(key);
                this.filterContainer.getListCache().putRouteKey(routeInfo.getRouteKey());
                this.filterContainer.getListCache().putArchiveKey(key);
                clientViewProxy.invokeControlMethod(this.filterContainer.getKey(), "setArchiveInfo", new Object[]{archiveOptions});
                break;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)routeInfo.getRouteKey()) && !routeInfo.getArchiveInfo().isEmpty()) {
            List archiveInfo = routeInfo.getArchiveInfo();
            String archiveKey = ((ArchiveInfo)routeInfo.getArchiveInfo().get(0)).getKey();
            ArchiveOptions archiveOptions = new ArchiveOptions(archiveInfo);
            this.filterContainer.getContext().setRouteKey(routeInfo.getRouteKey());
            this.filterContainer.getContext().setArchiveKey(archiveKey);
            this.filterContainer.getListCache().putRouteKey(routeInfo.getRouteKey());
            this.filterContainer.getListCache().putArchiveKey(archiveKey);
            clientViewProxy.invokeControlMethod(this.filterContainer.getKey(), "setArchiveInfo", new Object[]{archiveOptions});
        }
    }
}

