/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CommonDateFilterColumn
extends CommonFilterColumn {
    private String dataConst;
    private String selectDimension;
    private static final String SYSTEMTYPE = "bos-metadata";

    public CommonDateFilterColumn() {
    }

    public CommonDateFilterColumn(String fieldName) {
        super(fieldName);
    }

    @SimplePropertyAttribute
    @SdkInternal
    public String getDataConst() {
        return this.dataConst;
    }

    @SdkInternal
    public void setDataConst(String dataConst) {
        this.dataConst = dataConst;
    }

    @SimplePropertyAttribute
    @SdkInternal
    public String getSelectDimension() {
        return this.selectDimension;
    }

    public void setSelectDimension(String selectDimension) {
        this.selectDimension = selectDimension;
    }

    private List<String> getSelectDimensionList() {
        ArrayList<String> selectDimensionList = new ArrayList<String>(10);
        if (StringUtils.isNotEmpty((CharSequence)this.selectDimension)) {
            List<String> dimensions = Arrays.asList(this.selectDimension.split(","));
            selectDimensionList.addAll(dimensions);
        }
        return selectDimensionList;
    }

    @Override
    protected List<ComboItem> getRunTimeComboItems() {
        return this.getDefaultComboItems();
    }

    @Override
    protected List<Map<String, Object>> getClientItems() {
        ArrayList<Map<String, Object>> clientItems = new ArrayList<Map<String, Object>>(10);
        List<String> selectDimensionList = this.getSelectDimensionList();
        FilterMetadata meta = FilterMetadata.get();
        IDataEntityProperty fieldProp = this.getFilterField().getFieldProp();
        boolean isLongDateToShotDate = false;
        if (fieldProp instanceof DateTimeProp) {
            DateTimeProp prop = (DateTimeProp)fieldProp;
            isLongDateToShotDate = prop.getRegionType() == 1;
        }
        for (ComboItem comboItem : this.comboItems) {
            HashMap<String, Object> clientItem = new HashMap<String, Object>();
            LocaleString caption = comboItem.getCaption();
            CompareType type = meta.getCompareTypeByCompareTypeId(comboItem.getValue());
            if (null != type && null != type.getName()) {
                caption = type.getName();
            }
            if (isLongDateToShotDate && ("1403".equals(comboItem.getValue()) || "1404".equals(comboItem.getValue()))) continue;
            clientItem.put("caption", caption);
            if (selectDimensionList.contains(comboItem.getValue())) {
                clientItem.put("value", "");
            } else {
                clientItem.put("value", comboItem.getValue());
            }
            clientItem.put("compare", comboItem.getValue());
            clientItems.add(clientItem);
        }
        return clientItems;
    }

    @Override
    public Map<String, Object> createColumn() {
        String compareType;
        this.setMulti(false);
        Map<String, Object> column = super.createColumn();
        List defValues = (List)column.get("defaultValues");
        if (defValues.size() == 2) {
            ControlFilter controlFilter;
            compareType = null;
            if (this.context != null && this.context.getControlFiltersMap() != null && this.context.getControlFiltersMap().get(this.getFilterFieldName()) != null && (controlFilter = this.context.getControlFiltersMap().get(this.getFilterFieldName())) != null) {
                compareType = controlFilter.getCompareType();
            }
            List<String> selectDimensionList = this.getSelectDimensionList();
            if (!(StringUtils.isNotBlank(compareType) && CollectionUtils.isNotEmpty(selectDimensionList) && selectDimensionList.contains(compareType))) {
                defValues.replaceAll(ele -> {
                    String datetime = (String)ele;
                    if (StringUtils.isNotBlank((CharSequence)datetime)) {
                        try {
                            IDataEntityProperty fieldProp = this.getFilterField().getFieldProp();
                            if (fieldProp instanceof DateTimeProp) {
                                boolean isLongDateToShotDate;
                                DateTimeProp prop = (DateTimeProp)fieldProp;
                                boolean bl = isLongDateToShotDate = prop.getRegionType() == 1;
                                if (!(prop instanceof DateProp) && !isLongDateToShotDate) {
                                    datetime = KDDateFormatUtils.getDateTimeFormat().format(KDDateUtils.parseDateTime((String)datetime));
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1a%s", (String)"CommonDateFilterColumn_0", (String)"bos-form-core", (Object[])new Object[0]), datetime)), new Object[0]);
                        }
                    }
                    return datetime;
                });
            }
        }
        column.put("defaultValues", defValues);
        if (this.getFieldName() != null && this.context != null && this.context.getControlFiltersMap() != null && this.context.getControlFiltersMap().get(this.getFieldName()) != null && StringUtils.isNotBlank((CharSequence)(compareType = this.context.getControlFiltersMap().get(this.getFieldName()).getCompareType()))) {
            column.put("selectedCompare", compareType);
        }
        return column;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getFieldName() == null) {
            return false;
        }
        if (obj instanceof CommonDateFilterColumn) {
            CommonDateFilterColumn state = (CommonDateFilterColumn)((Object)obj);
            return this.getFieldName().equals(state.getFieldName());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getFieldName().hashCode();
    }

    private List<ComboItem> getDefaultComboItems() {
        List<String> selectDimensionList;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        ArrayList<String> allItemList = new ArrayList<String>(10);
        if (StringUtils.isNotEmpty((CharSequence)this.dataConst)) {
            List<String> dataConsts = Arrays.asList(this.dataConst.split(","));
            allItemList.addAll(dataConsts);
        }
        if (CollectionUtils.isNotEmpty(selectDimensionList = this.getSelectDimensionList())) {
            allItemList.addAll(selectDimensionList);
        }
        for (String item : allItemList) {
            FilterMetadata meta = FilterMetadata.get();
            CompareType type = meta.getCompareTypeByCompareTypeId(item);
            LocaleString caption = null;
            if (null != type) {
                caption = type.getName();
            }
            if (null == caption) {
                caption = new LocaleString(CommonDateFilterColumn.getName(item));
            }
            ComboItem comboItem = new ComboItem(caption, item);
            items.add(comboItem);
        }
        return items;
    }

    private static String getName(String key) {
        switch (key) {
            case "13": {
                return ResManager.loadKDString((String)"\u4eca\u5929", (String)"CommonDateFilterColumnAp_0", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "10": {
                return ResManager.loadKDString((String)"\u672c\u5468", (String)"CommonDateFilterColumnAp_1", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "63": {
                return ResManager.loadKDString((String)"\u672c\u6708", (String)"CommonDateFilterColumnAp_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "24": {
                return ResManager.loadKDString((String)"\u8fc7\u53bb\u4e09\u4e2a\u6708", (String)"CommonDateFilterColumnAp_3", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "11": {
                return ResManager.loadKDString((String)"\u6628\u5929", (String)"CommonDateFilterColumnAp_4", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "25": {
                return ResManager.loadKDString((String)"\u660e\u5929", (String)"CommonDateFilterColumnAp_5", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "61": {
                return ResManager.loadKDString((String)"\u4e0a\u5468", (String)"CommonDateFilterColumnAp_6", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "73": {
                return ResManager.loadKDString((String)"\u4e0b\u5468", (String)"CommonDateFilterColumnAp_7", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "92": {
                return ResManager.loadKDString((String)"\u4e0a\u4e2a\u6708", (String)"CommonDateFilterColumnAp_8", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "8": {
                return ResManager.loadKDString((String)"\u4e0b\u4e2a\u6708", (String)"CommonDateFilterColumnAp_9", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "37": {
                return ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CommonDateFilterColumnAp_10", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "9": {
                return ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"CommonDateFilterColumnAp_11", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u4eca\u5929\u4e4b\u524d\uff08\u5929\uff09", (String)"CommonDateFilterColumnAp_12", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "22": {
                return ResManager.loadKDString((String)"\u4eca\u5929\u4e4b\u540e\uff08\u5929\uff09", (String)"CommonDateFilterColumnAp_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "107": {
                return ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e\u4eca\u5929", (String)"CommonDateFilterColumnAp_14", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "108": {
                return ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e\u4eca\u5929", (String)"CommonDateFilterColumnAp_15", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "77": {
                return ResManager.loadKDString((String)"\u672c\u5b63\u5ea6", (String)"CommonDateFilterColumnAp_16", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "78": {
                return ResManager.loadKDString((String)"\u4e0a\u5b63\u5ea6", (String)"CommonDateFilterColumnAp_17", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "79": {
                return ResManager.loadKDString((String)"\u4e0b\u5b63\u5ea6", (String)"CommonDateFilterColumnAp_18", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "66": {
                return ResManager.loadKDString((String)"\u4eca\u5e74", (String)"CommonDateFilterColumnAp_19", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "68": {
                return ResManager.loadKDString((String)"\u53bb\u5e74", (String)"CommonDateFilterColumnAp_20", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "69": {
                return ResManager.loadKDString((String)"\u660e\u5e74", (String)"CommonDateFilterColumnAp_21", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
            case "26": {
                return ResManager.loadKDString((String)"\u672a\u6765\u4e09\u4e2a\u6708", (String)"CommonDateFilterColumnAp_22", (String)SYSTEMTYPE, (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    protected void addFieldCompareTypes() {
        if (this.getView() instanceof IListView && this.filterField != null && this.filterField.getFieldProp() instanceof DateTimeProp) {
            ArrayList<CompareType> allCompareTypes = new ArrayList<CompareType>(10);
            allCompareTypes.addAll(this.filterField.getCompareTypes());
            List fieldCompareList = FilterMetadata.get().getCompareTypes("14");
            for (CompareType compareType : fieldCompareList) {
                CompareType newCompareType = new CompareType(compareType);
                newCompareType.setFieldCompare(true);
                newCompareType.setVisible(true);
                allCompareTypes.add(newCompareType);
            }
            this.filterField.setCompareTypes(allCompareTypes);
            String oldCompareGroupID = this.filterField.getCompareGroupID();
            StringBuilder newCompareGroupId = new StringBuilder(oldCompareGroupID);
            newCompareGroupId.append(",14");
            this.filterField.setCompareGroupID(newCompareGroupId.toString());
        }
    }
}

