/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.CompareTypeConfig;
import kd.bos.entity.CompareTypeField;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ICompareTypeConfig;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.DependField;
import kd.bos.filter.OrgDependField;
import kd.bos.filter.helper.DataPermFilterHelper;
import kd.bos.filter.helper.QueryBaseDataParameter;
import kd.bos.filter.helper.QueryBaseDataParameterWithDt;
import kd.bos.filter.helper.QueryLookUpdataParameter;
import kd.bos.form.CoreSingleOrgContextHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.ControlContext;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.IReportView;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class FilterColumn
extends Container {
    private String type;
    private LocaleString caption;
    private String fieldName;
    private List<Object> defaultValues = new ArrayList<Object>();
    private String parentViewKey;
    MainEntityType entityType;
    FilterField filterField;
    ControlContext context;
    private String entryEntity;
    private boolean isEntityField = true;
    private static final String USEREGION = "useregion";
    private List<QFilter> dependQFilters = new ArrayList<QFilter>(10);
    private boolean isNewAdded;
    private boolean baseDataControl;
    private String entityId;
    protected MainEntityType bindBaseDataEntityType;
    Map<String, List<String>> orgFieldColumnsMap = new HashMap<String, List<String>>(16);

    boolean isBaseDataControl() {
        return this.baseDataControl;
    }

    void setBaseDataControl(boolean baseDataControl) {
        this.baseDataControl = baseDataControl;
    }

    boolean isNewAdded() {
        return this.isNewAdded;
    }

    void setNewAdded(boolean isNewAdded) {
        this.isNewAdded = isNewAdded;
    }

    QFilter getDependFilter(DependField dependField, FilterField dependFilterField, FilterField joinPropertyFilterField) {
        return null;
    }

    QFilter getDependFilter(DependField dependField) {
        FilterField dependFilterField = FilterField.create((MainEntityType)this.entityType, (String)dependField.getDependFieldName());
        FilterField joinPropertyFilterField = FilterField.create((MainEntityType)this.entityType, (String)dependField.getJoinPropertyName());
        if (dependFilterField != null && dependFilterField.getLatestParent() instanceof IBasedataField && joinPropertyFilterField != null) {
            return this.getDependFilter(dependField, dependFilterField, joinPropertyFilterField);
        }
        return null;
    }

    @SdkInternal
    protected void addDependQFilter(QFilter qFilter) {
        this.dependQFilters.add(qFilter);
    }

    List<QFilter> getDependQFilters() {
        return this.dependQFilters;
    }

    public FilterColumn() {
    }

    public FilterColumn(String fieldName) {
        this.fieldName = fieldName;
    }

    @SimplePropertyAttribute
    public String getEntryEntity() {
        return this.entryEntity;
    }

    public void setEntryEntity(String entryEntity) {
        this.entryEntity = entryEntity;
    }

    public ControlContext getContext() {
        return this.context;
    }

    public void setContext(ControlContext context) {
        this.context = context;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public String getParentViewKey() {
        return this.parentViewKey;
    }

    public void setParentViewKey(String parentViewKey) {
        this.parentViewKey = parentViewKey;
    }

    public List<Object> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(List<Object> defaultValues) {
        ArrayList<Object> tempDefaultValues = new ArrayList<Object>(10);
        if (defaultValues != null) {
            tempDefaultValues.addAll(defaultValues);
        }
        this.defaultValues.clear();
        if (defaultValues == null) {
            return;
        }
        this.defaultValues.addAll(tempDefaultValues);
    }

    public void setDefaultValues(Object ... defaultValues) {
        ArrayList<Object> tempDefaultValues = new ArrayList<Object>(10);
        for (Object defaultValue : defaultValues) {
            if (defaultValue instanceof Collection) {
                tempDefaultValues.addAll((Collection)defaultValue);
                continue;
            }
            tempDefaultValues.add(defaultValue);
        }
        this.setDefaultValues(tempDefaultValues);
    }

    public void setDefaultValue(String value) {
        if (value == null) {
            this.defaultValues.clear();
            return;
        }
        this.setDefaultValues(Collections.singletonList(value));
    }

    @SimplePropertyAttribute
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @SimplePropertyAttribute
    public LocaleString getCaption() {
        return this.caption;
    }

    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @SimplePropertyAttribute
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        if (this.isEntityField() && this.filterField != null) {
            this.filterField = null;
        }
    }

    public boolean isEntityField() {
        return this.isEntityField;
    }

    public void setEntityField(boolean isEntityField) {
        this.isEntityField = isEntityField;
    }

    @SdkInternal
    protected Set<CompareType> getCustomCompareTypes() {
        CompareTypeConfig compareTypeConfig;
        IDataEntityProperty fieldProp;
        LinkedHashSet<CompareType> compareTypes = new LinkedHashSet<CompareType>(16);
        Map<String, List<CompareType>> fieldCompareTypeMap = this.getContext().getFieldCompareTypeMap();
        if (fieldCompareTypeMap.containsKey(this.getFieldName())) {
            List<CompareType> thisCompareTypes = fieldCompareTypeMap.get(this.getFieldName());
            for (CompareType compareType : thisCompareTypes) {
                compareTypes.add(compareType);
            }
        }
        if ((fieldProp = this.getFilterField().getLatestParent()) instanceof ICompareTypeConfig && (compareTypeConfig = ((ICompareTypeConfig)fieldProp).getCompareTypeConfig()) != null) {
            for (CompareTypeField compareTypeField : compareTypeConfig.getCompareTypeFields()) {
                compareTypes.add(compareTypeField.createCompareType());
            }
        }
        return compareTypes;
    }

    @SdkInternal
    public Map<String, Object> createColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryEntity", this.getEntryEntity());
        map.put("type", this.getFilterControlType());
        map.put("fieldCaption", this.getCaption());
        map.put("fieldName", this.getFilterFieldName());
        List<Object> defValues = this.getDefaultValues();
        if (defValues != null && !defValues.isEmpty()) {
            map.put("defaultValues", defValues);
        }
        map.put("entityId", this.getRealEntityId());
        if (this.isEntityField() && this.getFilterField().getFieldProp() instanceof DateTimeProp) {
            map.put("today", KDDateUtils.now());
        }
        if (this.isEntityField() && this.getFilterField() != null) {
            if (this.getFilterField().getFieldProp() instanceof DateTimeProp) {
                map.put(USEREGION, ((DateTimeProp)this.getFilterField().getFieldProp()).isUseRegion());
                if (((DateTimeProp)this.getFilterField().getFieldProp()).getRegionType() == 1) {
                    map.put("type", "date");
                }
            } else if (this.getFilterField().getFieldProp() instanceof DecimalProp) {
                map.put(USEREGION, ((DecimalProp)this.getFilterField().getFieldProp()).isUseRegion());
                if (!this.getFilterField().getFieldProp().getClass().equals(IntegerProp.class) && !this.getFilterField().getFieldProp().getClass().equals(LongProp.class)) {
                    map.put("sc", 10);
                    map.put("sz", true);
                }
            }
        } else {
            map.put(USEREGION, false);
        }
        return map;
    }

    @SdkInternal
    protected List<Object> getCompares() {
        return new ArrayList<Object>();
    }

    @SdkInternal
    public Map<String, List<Object>> getDefaultFilter() {
        HashMap<String, List<Object>> filter = null;
        List<Object> defValues = this.getDefaultValues();
        if (this.isEntityField() && defValues != null && !defValues.isEmpty()) {
            List<Object> compares = this.getCompares();
            filter = new HashMap<String, List<Object>>();
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.getFilterField().getFieldName());
            filter.put("FieldName", values);
            filter.put("Compare", compares);
            filter.put("Value", defValues);
        }
        return filter;
    }

    Map<String, List<Object>> getDefaultFilterWithVirtural() {
        HashMap<String, List<Object>> filter = null;
        List<Object> defValues = this.getDefaultValues();
        if (defValues != null && !defValues.isEmpty()) {
            List<Object> compares = this.getCompares();
            filter = new HashMap<String, List<Object>>();
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.getFilterField().getFieldName());
            filter.put("FieldName", values);
            filter.put("Compare", compares);
            filter.put("Value", defValues);
        }
        return filter;
    }

    @SdkInternal
    public void initProperties() {
        this.setEntryEntity(this.getFilterField().getEntityKey());
        if (this.getCaption() == null) {
            this.setCaption(this.getFilterField().getCaption());
        }
        this.initEntityId();
    }

    void fixContext() {
        if (StringUtils.isBlank((CharSequence)this.getEntryEntity())) {
            if (this.getFilterField() != null) {
                this.setEntryEntity(this.getFilterField().getEntityKey());
            } else {
                this.setEntryEntity(this.getEntityType().getName());
            }
        }
    }

    @SdkInternal
    protected void initDefaultValues() {
    }

    @SdkInternal
    protected MainEntityType getMainEntityType(String baseEntityId) {
        if (this.bindBaseDataEntityType == null) {
            this.bindBaseDataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        }
        return this.bindBaseDataEntityType;
    }

    @SdkInternal
    protected List<QFilter> getBaseDataPropQFilters(IBasedataField basedataProp) {
        QFilter qFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (basedataProp instanceof OrgProp && (qFilter = ((OrgProp)basedataProp).getBizOrgFilter()) != null) {
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    @SdkInternal
    protected BasedataEntityType getBaseDataEntityType(IBasedataField basedataProp) {
        if (basedataProp instanceof MasterBasedataProp) {
            return (BasedataEntityType)((MasterBasedataProp)basedataProp).getParent();
        }
        return (BasedataEntityType)basedataProp.getComplexType();
    }

    @SdkInternal
    public List<QFilter> getFilter(BasedataProp bdProp) {
        return this.getFilter0((IBasedataField)bdProp);
    }

    @SdkInternal
    protected List<QFilter> getFilter0(IBasedataField bdProp) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        BasedataEntityType baseDataEntityType = this.getBaseDataEntityType(bdProp);
        FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta((String)this.getEntityType().getName(), (String)bdProp.getName());
        if (this.getView() instanceof IListView && filterCondition != null && filterCondition.isForList()) {
            FilterBuilder filterBuilder = new FilterBuilder((MainEntityType)baseDataEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter != null) {
                filters.add(filterBuilder.getQFilter());
            }
        }
        filters.addAll(this.getCustomFilter(this.getMainEntityType(baseDataEntityType.getName())));
        filters.addAll(this.getBaseDataPropQFilters(bdProp));
        filters.addAll(this.dependQFilters);
        if (bdProp instanceof AssistantProp) {
            AssistantProp assProp = (AssistantProp)bdProp;
            if (assProp.getGroupQFilter() != null) {
                filters.add(assProp.getGroupQFilter());
            }
        } else if (bdProp instanceof BillTypeProp) {
            MainEntityType et = this.getEntityType();
            String formId = et != null ? et.getName() : this.getContext().getBillFormId();
            filters.add(new QFilter("billformid", "=", (Object)formId));
        }
        return filters;
    }

    List<QFilter> getFilter0(IRefBillField refBillField) {
        String billStatus;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Boolean isShowDisabled = refBillField.isShowOnlyAudited();
        if (isShowDisabled.booleanValue() && StringUtils.isNotEmpty((CharSequence)(billStatus = refBillField.getBillStatus()))) {
            filters.add(new QFilter(billStatus, "=", (Object)"C"));
        }
        MainEntityType baseDataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityType().getName());
        FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta((String)this.getEntityType().getName(), (String)refBillField.getName());
        if (this.getView() instanceof IListView && filterCondition != null && filterCondition.isForList()) {
            FilterBuilder filterBuilder = new FilterBuilder(baseDataEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter != null) {
                filters.add(filterBuilder.getQFilter());
            }
        }
        return filters;
    }

    List<QFilter> getFilterByRefBillField(IRefBillField refBillField) {
        QFilter specialDataPermQFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        QFilter dataRuleQFilter = this.getDataRuleQFilterByRefBillField(refBillField);
        if (dataRuleQFilter != null) {
            filters.add(dataRuleQFilter);
        }
        if ((specialDataPermQFilter = this.getSpecialDataPermQFilterByRefBillField(refBillField)) != null) {
            filters.add(specialDataPermQFilter);
        }
        return filters;
    }

    QFilter getDataRuleQFilterByRefBillField(IRefBillField refBillField) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.getDataPermWithOrg(RequestContext.get().getCurrUserId(), this.getAppId(), refBillField.getBillEntityId(), new HashMap(0));
    }

    QFilter getSpecialDataPermQFilterByRefBillField(IRefBillField refBillField) {
        QFilter specialDataPermQFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)this.getAppId(), (String)refBillField.getBillEntityId(), (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class)));
        return specialDataPermQFilter;
    }

    @SdkInternal
    protected Map<String, List<String>> getOrgFieldColumnsMap() {
        return this.orgFieldColumnsMap;
    }

    @SdkInternal
    protected void setOrgFieldColumnsMap(Map<String, List<String>> orgFieldColumnsMap) {
        this.orgFieldColumnsMap = orgFieldColumnsMap;
    }

    @SdkInternal
    protected boolean isEntityOrgField() {
        String[] split = this.getFieldName().split("\\.");
        return split.length == 2 && this.isBaseDataProp() && this.getFilterField().getSrcFieldProp() instanceof OrgProp;
    }

    @SdkInternal
    FilterField convertDependOrgFilterFieldToId(FilterField dependOrgFilterField) {
        return dependOrgFilterField;
    }

    private String getDependOrgFilterFieldName(String dependOrgFieldName) {
        if (dependOrgFieldName == null) {
            return null;
        }
        FilterField dependOrgFilterField = FilterField.create((MainEntityType)this.getEntityType(), (String)dependOrgFieldName);
        if (dependOrgFilterField != null) {
            return this.convertDependOrgFilterFieldToId(dependOrgFilterField).getFieldName();
        }
        return null;
    }

    List<DependField> getOrgDependField() {
        ArrayList<DependField> dependFields = new ArrayList<DependField>(10);
        String[] split = this.getFieldName().split("\\.");
        if (split.length == 2 && this.isBaseDataProp() && !(this.getLatestParent() instanceof JoinProperty) && !this.isEntityOrgField()) {
            String mainOrg = this.getEntityType().getMainOrg();
            Map<String, List<String>> orgFieldColumnsmMap = this.getOrgFieldColumnsMap();
            IBasedataField latestParent = (IBasedataField)this.getLatestParent();
            BasedataEntityType baseDataEntityType = this.getBaseDataEntityType(latestParent);
            String usedOrg = latestParent.getOrgProp();
            if (StringUtils.isNotBlank((CharSequence)usedOrg) || StringUtils.isNotBlank((CharSequence)mainOrg)) {
                List<Object> dependOrgFieldNames = new ArrayList(10);
                if (StringUtils.isNotBlank((CharSequence)usedOrg)) {
                    dependOrgFieldNames = orgFieldColumnsmMap.get(usedOrg);
                } else if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
                    dependOrgFieldNames = orgFieldColumnsmMap.get(mainOrg);
                }
                if (dependOrgFieldNames != null) {
                    for (String string : dependOrgFieldNames) {
                        dependFields.add(new OrgDependField(this.getFieldName(), string, this.getDependOrgFilterFieldName(string), baseDataEntityType.getName()));
                    }
                }
            }
        }
        return dependFields;
    }

    boolean isBaseDataProp() {
        IDataEntityProperty latestParent = this.getLatestParent();
        return this.isEntityField() && this.getFilterField() != null && latestParent instanceof IBasedataField && !(this.filterField.getFieldProp() instanceof ComboProp) && !(this.filterField.getFieldProp() instanceof BooleanProp) && !(this.filterField.getFieldProp() instanceof DateTimeProp);
    }

    @SdkInternal
    protected List<QFilter> getDefaultDataFilters(MainEntityType mainEntityType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter approvedQFilter = PermissionFilterUtil.getApprovedFilter((EntityType)mainEntityType);
        if (approvedQFilter != null) {
            qFilters.add(approvedQFilter);
        }
        return qFilters;
    }

    protected List<QFilter> getCustomFilter(MainEntityType mainEntityType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.addAll(this.getDefaultDataFilters(mainEntityType));
        return qFilters;
    }

    @SdkInternal
    protected String getAppId() {
        return this.getView().getFormShowParameter().getCheckRightAppId();
    }

    @SdkInternal
    protected boolean isMainOrgProp(IDataEntityProperty basedataProp) {
        return EntityTypeUtil.isMainOrgProp((IDataEntityProperty)basedataProp);
    }

    @SdkInternal
    protected String getEntityId(BasedataProp basedataProp) {
        MainEntityType billEntityType = (MainEntityType)basedataProp.getParent();
        return billEntityType.getName();
    }

    @SdkInternal
    protected IDataEntityProperty getEntityProperty(MainEntityType entityType) {
        return EntityTypeUtil.getDataEntityProperty((String)this.getFieldName(), (EntityType)entityType, (boolean)true);
    }

    @SdkInternal
    String getItemClassTypeEntityId(ItemClassProp itemClassProp) {
        return null;
    }

    @SdkInternal
    public FilterField getFilterField() {
        if (this.filterField == null) {
            this.filterField = FilterField.create((MainEntityType)this.entityType, (String)this.getFieldName());
            if (this.filterField != null) {
                String itemClassTypeEntityId;
                IDataEntityProperty basedataProp = this.filterField.getLatestParent();
                if (basedataProp instanceof ItemClassProp && (itemClassTypeEntityId = this.getItemClassTypeEntityId((ItemClassProp)basedataProp)) != null) {
                    this.filterField = FilterField.createForItemClassProp((MainEntityType)this.entityType, (String)this.fieldName, (String)itemClassTypeEntityId);
                }
                this.addFieldCompareTypes();
            }
        }
        if (!(this.getView() instanceof IReportView) && this.filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getFieldName(), "FIELDNOTEXISTS000005")});
        }
        return this.filterField;
    }

    protected void addFieldCompareTypes() {
    }

    @SdkInternal
    protected String getFilterControlType() {
        if (("text".equals(this.getFilterField().getFilterControlType()) || this.getFilterField().getFieldProp() instanceof PKFieldProp) && StringUtils.isNotBlank((CharSequence)this.getFilterField().getBaseDataFilterControlType())) {
            return this.getFilterField().getBaseDataFilterControlType();
        }
        return this.getFilterField().getFilterControlType();
    }

    public String getFilterFieldName() {
        return this.isEntityField() && this.entityType != null ? this.getFilterField().getFieldName() : this.fieldName;
    }

    @SdkInternal
    protected void createBlankProp() {
        if (this.getFieldName() == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getFieldName(), "FIELDNOTEXISTS000006")});
        }
        for (Consumer<FilterColumn> clickListener : this.context.getFilterColumnInitListeners()) {
            clickListener.accept(this);
        }
    }

    @SdkInternal
    public void addProp() {
        Object p = null;
        p = "date".equals(this.getType()) ? new DateProp() : new TextProp();
        p.setFilterControlType(this.getType());
        p.setName(this.getFieldName());
        p.setDisplayName(this.getCaption());
        p.setDbIgnore(true);
        this.entityType.addProperty((DynamicProperty)p);
    }

    public boolean equals(Object obj) {
        if (this.fieldName == null) {
            return false;
        }
        if (obj instanceof FilterColumn) {
            FilterColumn state = (FilterColumn)((Object)obj);
            return this.fieldName.equals(state.getFieldName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public String toString() {
        return this.fieldName;
    }

    @SdkInternal
    public void addFilterFields(Map<String, FilterField> filterFields) {
        if (this.caption != null) {
            this.getFilterField().setCaption(this.caption);
        }
        filterFields.put(this.getFilterField().getFieldName(), this.getFilterField());
    }

    public List<FilterColumn> getFilterColumns() {
        ArrayList<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
        filterColumns.add(this);
        return filterColumns;
    }

    @SdkInternal
    protected List<Map<String, List<Object>>> getFilterValues(Map<String, List<Object>> value) {
        ArrayList<Map<String, List<Object>>> fillterValues = new ArrayList<Map<String, List<Object>>>();
        fillterValues.add(value);
        return fillterValues;
    }

    @SdkInternal
    protected IDataEntityProperty getLatestParent() {
        return this.getFilterField().getLatestParent();
    }

    @SdkInternal
    protected boolean isNeedHideOrg() {
        if (!this.getContext().isSingleOrgMode() || this.getFilterField() == null) {
            return false;
        }
        return CoreSingleOrgContextHelper.isNeedHideOrg((FilterField)this.getFilterField());
    }

    @SdkInternal
    protected boolean isBlackField() {
        return this.getContext().getBlackFields().contains(this.getFieldName().split("\\.")[0]);
    }

    private void initEntityId() {
        IDataEntityProperty latestParent = this.getLatestParent();
        if (latestParent instanceof IBasedataField) {
            this.entityId = ((IBasedataField)latestParent).getBaseEntityId();
            if (latestParent instanceof MasterBasedataProp) {
                this.entityId = latestParent.getParent().getName();
            }
        } else if (latestParent instanceof IRefBillField) {
            this.entityId = ((IRefBillField)latestParent).getBillEntityId();
        }
        if (this.entityId == null && "text".equals(this.getFilterControlType()) && this.getFilterField().getSrcFieldProp() instanceof FlexProp || this.entityId == null && this.getFilterField().getSrcFieldProp() instanceof TextProp) {
            this.entityId = "bos_multitext";
        }
    }

    private String getRealEntityId() {
        IDataEntityProperty latestParent = this.getLatestParent();
        if (latestParent instanceof ItemClassProp) {
            return this.getItemClassTypeEntityId((ItemClassProp)latestParent);
        }
        return this.entityId;
    }

    boolean isBaseDataField(IDataEntityProperty latestParent) {
        return latestParent instanceof IBasedataField && !(this.filterField.getFieldProp() instanceof ComboProp) && !(this.filterField.getFieldProp() instanceof BooleanProp) && !(this.filterField.getFieldProp() instanceof DateTimeProp);
    }

    FilterField getOrgFieldField() {
        return this.getFilterField();
    }

    String getNameField(IBasedataField basedataProp, BasedataEntityType dt, String pkField) {
        String nameField = this.getOrgFieldField().getFieldProp().getName();
        if ((nameField.equalsIgnoreCase(pkField) || nameField.equalsIgnoreCase(dt.getNumberProperty()) || this.getOrgFieldField().getFieldProp() instanceof IBasedataField) && StringUtils.isNotBlank((CharSequence)basedataProp.getDisplayProp())) {
            if (basedataProp.getDisplayProp().contains("name")) {
                nameField = dt.getNameProperty();
            } else if ("number".equalsIgnoreCase(basedataProp.getDisplayProp())) {
                nameField = dt.getNumberProperty();
            } else {
                nameField = basedataProp.getDisplayProp();
                DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)dt.getName(), new ArrayList<String>(Collections.singleton(nameField)));
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)subDataEntityType), (String)nameField);
                if (filterField != null) {
                    nameField = filterField.getFullFieldName();
                }
            }
        }
        return StringUtils.isNotBlank((CharSequence)nameField) ? nameField : pkField;
    }

    StringBuilder getSelectFields(BasedataEntityType dt, String nameField) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(this.getSelectFieldsWithMaster(dt, nameField));
        if (!"id".equalsIgnoreCase(nameField)) {
            selectFields.append(",");
            selectFields.append(this.getSelectFieldsWithMaster(dt, dt.getPrimaryKey().getName()));
        }
        return selectFields;
    }

    @NotNull
    String getSelectFieldsWithMaster(BasedataEntityType dt, String selectField) {
        if (this.getLatestParent() instanceof MasterBasedataProp && dt.getMasteridType() == 2) {
            return this.getLatestParent().getName() + "." + selectField;
        }
        return selectField;
    }

    protected QueryBaseDataParameter createQueryBaseDataParameter(IBasedataField basedataProp, BasedataEntityType dt, String nameField, String inSelectFields, List<QFilter> inQfilters) {
        List<QFilter> filter0 = this.getFilter0(basedataProp);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(inQfilters.size() + filter0.size());
        qfilters.addAll(inQfilters);
        qfilters.addAll(filter0);
        return new QueryBaseDataParameter(qfilters, null, dt.getName(), StringUtils.isNotBlank((CharSequence)inSelectFields) ? inSelectFields : this.getSelectFields(dt, nameField).toString());
    }

    DynamicObjectCollection queryBaseDataCollections(QueryLookUpdataParameter queryLookUpdataParameter) {
        IDataEntityProperty latestParent = this.getLatestParent();
        if (this.isBaseDataField(latestParent)) {
            IBasedataField basedataProp = (IBasedataField)latestParent;
            BasedataEntityType dt = this.getBaseDataEntityType(basedataProp);
            QueryBaseDataParameter queryBaseDataParameter = this.createQueryBaseDataParameter(basedataProp, dt, this.getNameField(basedataProp, dt, dt.getPrimaryKey().getName()), String.join((CharSequence)",", queryLookUpdataParameter.getShowFields()), queryLookUpdataParameter.getPara().getListFilterParameter().getQFilters());
            return this.queryBaseDataCollections(basedataProp, dt, queryBaseDataParameter, queryLookUpdataParameter.getLimit());
        }
        return null;
    }

    BasedataEntityType getRealBasedataEntityType() {
        IDataEntityProperty latestParent = this.getLatestParent();
        BasedataEntityType basedataEntityType = null;
        if (latestParent instanceof IBasedataField) {
            basedataEntityType = this.getBaseDataEntityType((IBasedataField)latestParent);
        }
        return basedataEntityType;
    }

    Map<String, Object> getShowFormCustomParams() {
        IDataEntityProperty latestParent = this.getLatestParent();
        Map<String, Object> showFormCustomParams = new HashMap<String, Object>(16);
        if (latestParent instanceof OrgProp) {
            showFormCustomParams = ((OrgProp)latestParent).getShowFormCustomParams();
        }
        return showFormCustomParams;
    }

    protected DynamicObjectCollection queryBaseDataCollections(IBasedataField basedataProp, BasedataEntityType dt, QueryBaseDataParameter parameterObject, int topSize) {
        DataPermFilterHelper dataPermFilterHelper = new DataPermFilterHelper(this.getAppId(), this.getFieldName(), this.getEntityType(), topSize, (Control)this);
        return dataPermFilterHelper.queryBaseDataCollections(new QueryBaseDataParameterWithDt(parameterObject, basedataProp, dt, this.getShowFormCustomParams(), this.getRealBasedataEntityType(), this.isMainOrgProp((IDataEntityProperty)basedataProp)));
    }

    Map<String, String> getColumnServiceContext() {
        return null;
    }
}

