/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.OrderByParameter;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.DependField;
import kd.bos.filter.FastSearchGridView;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.filter.FilterGridView;
import kd.bos.filter.IFilterControlCache;
import kd.bos.filter.IFilterGridView;
import kd.bos.filter.OrgDependField;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.filter.mcontrol.MobCommonBaseDataFilterColumn;
import kd.bos.filter.mcontrol.MobCommonDateFilterColumn;
import kd.bos.filter.mcontrol.MobCommonFilterColumn;
import kd.bos.form.FilterF7Helper;
import kd.bos.form.IFormView;
import kd.bos.form.MessageProxy;
import kd.bos.form.SimpleBaseData;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SwitchModeEvent;
import kd.bos.form.control.events.SwitchModeListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ControlContext;
import kd.bos.list.IMobileListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListCache;
import kd.bos.list.ViewCommonUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import org.jetbrains.annotations.NotNull;

public class FilterControlHelper {
    private static final String FAST_FILTER = "fastfilter";
    private static final String CUSTOM_FILTER = "customfilter";
    private Container container;
    private IFilterModel filterModel;
    private MainEntityType mainEntityType;
    private ControlContext context;
    private ListCache listCache = null;
    private String selectedCommomFilterFieldName = "";
    private List<Object> selectedCommomFilterFieldValues = new ArrayList<Object>();
    private List<SearchClickListener> searchClickListeners = new ArrayList<SearchClickListener>();
    private List<AfterSearchClickListener> afterSearchClickListeners = new ArrayList<AfterSearchClickListener>();
    private LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
    private SimpleBaseData simpleBaseData;
    private List<SwitchModeListener> switchModeListeners = new ArrayList<SwitchModeListener>();
    private List<Map<String, List<Object>>> andFilter;
    private List<BeforeFilterF7SelectListener> beforeF7SelectListeners = new ArrayList<BeforeFilterF7SelectListener>();
    private List<String> cannotEmptyNames = new ArrayList<String>(10);

    void setAndFilter(List<Map<String, List<Object>>> andFilter) {
        this.andFilter = andFilter;
    }

    SimpleBaseData getSimpleBaseData() {
        return this.simpleBaseData;
    }

    void setSimpleBaseData(SimpleBaseData simpleBaseData) {
        this.simpleBaseData = simpleBaseData;
    }

    private LinkQueryPkIdCollection getLinkQueryPkIdCollection() {
        return this.linkQueryPkIdCollection;
    }

    void setLinkQueryPkIdCollection(LinkQueryPkIdCollection linkQueryPkIdCollection) {
        this.linkQueryPkIdCollection = linkQueryPkIdCollection;
    }

    public void setSwitchModeListeners(List<SwitchModeListener> switchModeListeners) {
        this.switchModeListeners = switchModeListeners;
    }

    public void setSearchClickListeners(List<SearchClickListener> searchClickListeners) {
        this.searchClickListeners = searchClickListeners;
    }

    public void setAfterSearchClickListeners(List<AfterSearchClickListener> afterSearchClickListeners) {
        this.afterSearchClickListeners = afterSearchClickListeners;
    }

    protected String getSelectedCommomFilterFieldName() {
        return this.selectedCommomFilterFieldName;
    }

    protected List<Object> getSelectedCommomFilterFieldValues() {
        return this.selectedCommomFilterFieldValues;
    }

    public void setBeforeF7SelectListeners(List<BeforeFilterF7SelectListener> beforeF7SelectListeners) {
        this.beforeF7SelectListeners = beforeF7SelectListeners;
    }

    private IFilterModel getFilterModel() {
        return this.filterModel;
    }

    private MainEntityType getEntityType() {
        return this.mainEntityType;
    }

    private ControlContext getContext() {
        return this.context;
    }

    private ListCache getListCache() {
        return this.listCache;
    }

    public FilterControlHelper(Container container, IFilterModel filterModel, MainEntityType mainEntityType, ControlContext context, ListCache listCache) {
        this.container = container;
        this.filterModel = filterModel;
        this.mainEntityType = mainEntityType;
        this.context = context;
        this.listCache = listCache;
    }

    private List<Control> getItems() {
        return this.container.getItems();
    }

    private List<FilterColumn> getCommonFilterColumns() {
        ArrayList<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>();
        for (Control item : this.getItems()) {
            if (item instanceof FilterColumn) {
                FilterColumn filterColumn = (FilterColumn)item;
                if (filterColumn.isBlackField()) continue;
                commonFilterColumns.add(filterColumn);
                continue;
            }
            if (!(item instanceof FilterGridView) && !(item instanceof FastSearchGridView)) continue;
            for (Control control : ((AbstractFilterGridView)item).getFilterColumns()) {
                FilterColumn filterColumn = (FilterColumn)control;
                if (filterColumn.isBlackField()) continue;
                commonFilterColumns.add(filterColumn);
            }
        }
        return commonFilterColumns;
    }

    private void setCommonFilterFields() {
        FilterObject filterObject = this.getFilterModel().getFilterObject();
        List<FilterColumn> allFilterColumns = this.getCommonFilterColumns();
        for (FilterColumn filterColumn : allFilterColumns) {
            filterColumn.addFilterFields(filterObject.getAllFilterFields());
        }
    }

    public FilterColumn getFilterColumn(String fieldName) {
        for (Control item : this.getItems()) {
            FilterColumn filterColumn;
            if (!(item instanceof FilterColumn) || (filterColumn = (FilterColumn)item).isBlackField() || !fieldName.equals(filterColumn.getFilterFieldName())) continue;
            return filterColumn;
        }
        return null;
    }

    FilterColumn getFilterColumn(String fieldName, Class<?> cls) {
        for (Control view : this.getItems()) {
            if (!(view instanceof IFilterGridView) || view.getClass() != cls) continue;
            for (FilterColumn filterColumn : ((IFilterGridView)view).getFilterColumns()) {
                if (filterColumn.isBlackField() || !fieldName.equals(filterColumn.getFilterFieldName())) continue;
                return filterColumn;
            }
        }
        return null;
    }

    void setDependFieldMap(Class<?> cls) {
        for (Control view : this.getItems()) {
            if (!(view instanceof AbstractFilterGridView) || view.getClass() != cls) continue;
            ((AbstractFilterGridView)view).setDependFieldMap();
        }
    }

    private List<Map<String, List<Object>>> splitColumns(List<Map<String, List<Object>>> filterValues) {
        ArrayList<Map<String, List<Object>>> splitFillterValues = new ArrayList<Map<String, List<Object>>>();
        FilterObject filterObject = this.getFilterModel().getFilterObject();
        for (Map<String, List<Object>> value : filterValues) {
            String fieldName = value.get("FieldName").get(0).toString();
            FilterColumn filterColumn = this.getFilterColumn(fieldName);
            if (filterColumn == null) continue;
            filterColumn.setEntityType(this.getEntityType());
            splitFillterValues.addAll(filterColumn.getFilterValues(value));
            filterColumn.addFilterFields(filterObject.getAllFilterFields());
        }
        return splitFillterValues;
    }

    private FilterParameter buildCommonFilter(List<Map<String, List<Object>>> filter) {
        this.setCommonFilterFields();
        FilterParameter commonFilterParameter = this.getFilterModel().getCommonFilterParameter(this.splitColumns(filter));
        this.initContextFilterParameter(new ArrayList<Map<String, List<Object>>>(0), this.getCommonFilterColumns(), commonFilterParameter);
        return commonFilterParameter;
    }

    public void buildContext(Map<String, List<Map<String, List<Object>>>> filterValues) {
        FilterParameter filterParameter = null;
        if (filterValues.containsKey(CUSTOM_FILTER)) {
            filterParameter = this.buildCommonFilter(filterValues.get(CUSTOM_FILTER));
        }
        this.getContext().setClientQueryFilterParameter(filterParameter);
        this.getContext().setContainMainOrg(this.getFilterModel().isContainMainOrg());
        this.getContext().setMainOrgNoLimit(this.getFilterModel().isMainOrgNoLimit());
        this.getContext().setContainBillStatus(this.getFilterModel().isContainBillStatus());
        this.getContext().setContainUsedStatus(this.getFilterModel().isContainUsedStatus());
        this.setSelectedMainOrgIds(Boolean.parseBoolean(System.getProperty("bos.filter.isNeedCheckMainOrgs", "false")));
    }

    public static void createBlankProp(FilterColumn filterColumn) {
        filterColumn.createBlankProp();
    }

    private List<FilterColumn> getSchemeFilterColumns() {
        ArrayList<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>();
        for (Control item : this.getItems()) {
            if (!(item instanceof SchemeFilterView) && !(item instanceof FastSearchGridView)) continue;
            for (Control control : ((AbstractFilterGridView)item).getFilterColumns()) {
                FilterColumn filterColumn = (FilterColumn)control;
                if (filterColumn.isBlackField()) continue;
                schemeFilterColumns.add(filterColumn);
            }
        }
        return schemeFilterColumns;
    }

    private void setSchemeFilterFields() {
        FilterObject filterObject = this.getFilterModel().getFilterObject();
        List<FilterColumn> allFilterColumns = this.getSchemeFilterColumns();
        for (FilterColumn filterColumn : allFilterColumns) {
            filterColumn.addFilterFields(filterObject.getAllFilterFields());
        }
    }

    void buildSchemeFilter(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter) {
        this.setSchemeFilterFields();
        this.initContextFilterParameter(fastFilter, this.getSchemeFilterColumns(), this.filterModel.getSchemeFilterParameter(filter, this.andFilter));
    }

    List<String> getCannotEmptyNames() {
        return this.cannotEmptyNames;
    }

    private void initContextFilterParameter(List<Map<String, List<Object>>> fastFilter, List<FilterColumn> filterColumns, FilterParameter filterParameter) {
        HashMap<String, String> selectFieldsCaptionMap = new HashMap<String, String>(16);
        List<String> filterColumnsMustInputs = FilterControlHelper.initFilterColumnsMustInputs(filterColumns);
        Map<String, String> filterColumnsCaptionMap = FilterControlHelper.initFilterColumnsCaptionMap(filterColumns);
        if (fastFilter != null && !fastFilter.isEmpty()) {
            FilterParameter fastFilterParameter = this.filterModel.getFastFilterParameter(fastFilter);
            FilterControlHelper.initSelectFieldsMap(fastFilterParameter, selectFieldsCaptionMap, filterColumnsCaptionMap);
            this.getContext().setFastQueryFilterParameter(fastFilterParameter);
        }
        FilterControlHelper.initSelectFieldsMap(filterParameter, selectFieldsCaptionMap, filterColumnsCaptionMap);
        List<String> originalSelectFieldList = this.getOriginalSelectFieldList(filterParameter);
        for (String filterColumnsMustInput : filterColumnsMustInputs) {
            if (originalSelectFieldList.contains(filterColumnsMustInput)) continue;
            String name = filterColumnsCaptionMap.get(filterColumnsMustInput);
            if (name != null) {
                this.cannotEmptyNames.add(name);
                continue;
            }
            this.cannotEmptyNames.add(filterColumnsMustInput);
        }
        this.getContext().setClientQueryFilterParameter(filterParameter);
        this.getContext().setSelectFieldsCaptionMap(selectFieldsCaptionMap);
    }

    private static List<String> initFilterColumnsMustInputs(List<FilterColumn> allFilterColumns) {
        ArrayList<String> filterColumnsMustInputs = new ArrayList<String>(10);
        for (FilterColumn filterColumn : allFilterColumns) {
            if (!(filterColumn instanceof SchemeFilterColumn) || !((SchemeFilterColumn)filterColumn).isMustInput()) continue;
            filterColumnsMustInputs.add(filterColumn.getFilterFieldName());
        }
        return filterColumnsMustInputs;
    }

    @NotNull
    private static Map<String, String> initFilterColumnsCaptionMap(List<FilterColumn> allFilterColumns) {
        HashMap<String, String> filterColumnsCaptionMap = new HashMap<String, String>(16);
        for (FilterColumn filterColumn : allFilterColumns) {
            if (filterColumn.getFieldName() == null || filterColumn.getCaption() == null) continue;
            filterColumnsCaptionMap.put(filterColumn.getFilterFieldName(), filterColumn.getCaption().toString());
        }
        return filterColumnsCaptionMap;
    }

    private static void initSelectFieldsMap(FilterParameter filterParameter, Map<String, String> selectFieldsCaptionMap, Map<String, String> filterColumnsCaptionMap) {
        for (String selectField : filterParameter.getSelectFields()) {
            String caption;
            String fConvertField = (String)filterParameter.getConvertFieldsMap().get(selectField);
            if (fConvertField != null) {
                caption = filterColumnsCaptionMap.get(fConvertField);
                if (!StringUtils.isNotBlank((CharSequence)caption)) continue;
                selectFieldsCaptionMap.put(selectField, caption);
                continue;
            }
            caption = filterColumnsCaptionMap.get(selectField);
            if (!StringUtils.isNotBlank((CharSequence)caption)) continue;
            selectFieldsCaptionMap.put(selectField, caption);
        }
    }

    private void setSelectedValues(Map<String, Object> selectedValues) {
        this.getListCache().setSelectedValues(selectedValues);
    }

    private void buildCommonFilter(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter) {
        this.setCommonFilterFields();
        if (ViewCommonUtil.checkCompare(filter)) {
            this.setSchemeFilterFields();
        }
        List<Map<String, List<Object>>> splitFillterValues = this.splitColumnsForFilterGridView(filter);
        this.initContextFilterParameter(fastFilter, this.getCommonFilterColumns(), this.filterModel.getCommonFilterParameter(splitFillterValues));
        this.setSelectedValues(this.filterModel.getSelectedValues());
    }

    protected List<Map<String, List<Object>>> splitColumnsForFilterGridView(List<Map<String, List<Object>>> filterValues) {
        ArrayList<Map<String, List<Object>>> splitFillterValues = new ArrayList<Map<String, List<Object>>>();
        FilterObject filterObject = this.getFilterModel().getFilterObject();
        for (Map<String, List<Object>> value : filterValues) {
            String fieldName = value.get("FieldName").get(0).toString();
            FilterColumn filterColumn = this.getFilterColumn(fieldName, FilterGridView.class);
            if (filterColumn == null) continue;
            filterColumn.setEntityType(this.getEntityType());
            splitFillterValues.addAll(filterColumn.getFilterValues(value));
            filterColumn.addFilterFields(filterObject.getAllFilterFields());
        }
        return splitFillterValues;
    }

    protected void buildContext(Map<String, List<Map<String, List<Object>>>> filterValues, boolean isNeedCheckMainOrgs) {
        if (filterValues.containsKey(CUSTOM_FILTER)) {
            this.buildCommonFilter(filterValues.get(FAST_FILTER), filterValues.get(CUSTOM_FILTER));
        } else if (filterValues.containsKey("schemefilter")) {
            this.buildSchemeFilter(filterValues.get(FAST_FILTER), filterValues.get("schemefilter"));
        }
        this.getContext().setContainMainOrg(this.getFilterModel().isContainMainOrg());
        this.getContext().setMainOrgNoLimit(this.getFilterModel().isMainOrgNoLimit());
        this.getContext().setContainBillStatus(this.getFilterModel().isContainBillStatus());
        this.getContext().setContainUsedStatus(this.getFilterModel().isContainUsedStatus());
        List<Long> hasRightMainOrgIds = this.setSelectedMainOrgIds(isNeedCheckMainOrgs);
        if (this.container instanceof FilterContainer) {
            ((FilterContainer)this.container).setSelectedMainOrgIds(hasRightMainOrgIds);
        }
    }

    private List<Long> setSelectedMainOrgIds(boolean isNeedCheckMainOrgs) {
        List buildAfterMainOrgs = this.getFilterModel().getSelectedMainOrgIds();
        ArrayList<Long> hasRightMainOrgIds = new ArrayList<Long>();
        if (isNeedCheckMainOrgs && !buildAfterMainOrgs.isEmpty()) {
            long userId;
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            HasPermDimObjResult hasPermDimObjResult = permissionService.getHasPermDimObjs(userId = Long.parseLong(RequestContext.get().getUserId()), this.container.getView().getFormShowParameter().getAppId(), this.getEntityType().getName(), "47150e89000000ac");
            if (!hasPermDimObjResult.hasAllDimObjPerm()) {
                List newDim = hasPermDimObjResult.getHasPermDimObjs();
                buildAfterMainOrgs.removeIf(dim -> !newDim.contains(dim));
            }
            hasRightMainOrgIds.addAll(buildAfterMainOrgs);
        } else {
            hasRightMainOrgIds.addAll(buildAfterMainOrgs);
        }
        this.getContext().setSelectedMainOrgIds(hasRightMainOrgIds);
        return hasRightMainOrgIds;
    }

    private MainEntityType getBaseDataMainEntityType(IDataEntityType dataEntityType) {
        if (dataEntityType instanceof MainEntityType) {
            return (MainEntityType)dataEntityType;
        }
        if (dataEntityType != null) {
            return this.getBaseDataMainEntityType(dataEntityType.getParent());
        }
        return null;
    }

    public FilterF7Helper createF7FormShowParameter(String fieldName, String clientMethodName, FilterColumn filterColumn, String entityId) {
        if (filterColumn == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000009")});
        }
        BasedataEntityType basedataEntityType = null;
        ArrayList<QFilter> qfilters = new ArrayList();
        String refPropKey = null;
        String refEntityId = entityId;
        String caption = null;
        boolean isMulti = false;
        filterColumn.setEntityType(this.getEntityType());
        filterColumn.setView(this.container.getView());
        IBasedataField basedataProp = null;
        if (filterColumn.getEntityType() != null) {
            FilterField filterField = filterColumn.getFilterField();
            if (filterField == null) {
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000010")});
            }
            basedataProp = (IBasedataField)filterColumn.getLatestParent();
            basedataEntityType = filterColumn.getBaseDataEntityType(basedataProp);
            refEntityId = basedataEntityType.getName();
            qfilters = filterColumn.getFilter0(basedataProp);
            refPropKey = filterColumn.getFilterField().getRefPropKey();
            if (basedataProp instanceof AssistantProp) {
                AssistantProp assistantProp = (AssistantProp)basedataProp;
                String groupId = assistantProp.getAsstTypeId();
                caption = this.getAssistantDataGroupName(groupId);
            }
        }
        FilterF7Helper filterF7Helper = new FilterF7Helper(refEntityId, fieldName, isMulti, refPropKey, clientMethodName);
        if (basedataProp != null) {
            MainEntityType billEntityType = this.getBaseDataMainEntityType(((IDataEntityProperty)basedataProp).getParent());
            if (billEntityType != null) {
                filterF7Helper.setEntityTypeId(billEntityType.getName());
            }
            filterF7Helper.setMainOrg(filterColumn.isMainOrgProp((IDataEntityProperty)basedataProp));
        }
        filterF7Helper.setCurrentBillEntityTypeId(this.getEntityType().getName());
        filterF7Helper.setOrgFieldName(filterColumn.getFieldName());
        filterF7Helper.setAppId(this.container.getView().getFormShowParameter().getAppId());
        filterF7Helper.setFilterColumn(filterColumn);
        filterF7Helper.setBasedataProp(basedataProp);
        filterF7Helper.setBasedataEntityType(basedataEntityType);
        if (filterColumn instanceof CommonFilterColumn) {
            filterF7Helper.setCommonFilterInitFilters(((CommonFilterColumn)filterColumn).getPluginInitQFilters());
        }
        filterF7Helper.setBeforeF7SelectListeners(this.beforeF7SelectListeners);
        filterF7Helper.setQfilters(qfilters);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            filterF7Helper.setCaption(caption);
        }
        return filterF7Helper;
    }

    private String getAssistantDataGroupName(String grouId) {
        String name = ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u8be6\u60c5", (String)"FilterContainer_3", (String)"bos-form-core", (Object[])new Object[0]);
        if (grouId != null) {
            HashSet<String> selectFields = new HashSet<String>(2);
            selectFields.add("id");
            selectFields.add("name");
            DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"bos_assistantdatagroup", selectFields);
            Map groupObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{Long.parseLong(grouId)}, (DynamicObjectType)dt);
            if (groupObjs != null && !groupObjs.isEmpty()) {
                DynamicObject groupObj = (DynamicObject)groupObjs.entrySet().iterator().next().getValue();
                ILocaleString localeName = groupObj.getLocaleString("name");
                name = localeName != null ? localeName.getLocaleValue() : name;
            }
        }
        return name;
    }

    public static BasedataEntityType getBasedataEntityType(FilterF7Helper filterF7Helper) {
        return filterF7Helper.getFilterColumn().getBaseDataEntityType(filterF7Helper.getBasedataField());
    }

    public void closeCallBackForBaseData(ClosedCallBackEvent e, String[] actionIds) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        int clientType = Integer.parseInt(actionIds[1]);
        int rowIndex = Integer.parseInt(actionIds[2]);
        String fieldKey = actionIds[3];
        String clientMethodName = actionIds[4];
        String fieldName = actionIds[5];
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        if (rows != null) {
            for (ListSelectedRow listSelectedRow : rows) {
                selectedIds.add(listSelectedRow.getPrimaryKeyValue().toString());
            }
        } else {
            return;
        }
        if (rows.isClearFlag()) {
            MessageProxy.sendBaseDataSetValueAction((String)this.container.getKey(), (String)fieldName, (IFormView)this.container.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, new ArrayList(), new ArrayList());
            return;
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)actionIds[0]);
        if ("setCommonF7Value".equals(clientMethodName)) {
            this.selectedCommomFilterFieldName = fieldName;
            this.selectedCommomFilterFieldValues = selectedIds;
            if (e.getView() instanceof IMobileListView) {
                MessageProxy.sendBaseDataSetValueActionForMob((String)this.container.getKey(), (String)fieldKey, (String)fieldName, (BasedataEntityType)basedataEntityType, (ListSelectedRowCollection)rows, (IFormView)this.container.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, (MainEntityType)this.getEntityType());
            } else {
                MessageProxy.sendBaseDataSetValueAction((String)this.container.getKey(), (String)fieldKey, (String)fieldName, (BasedataEntityType)basedataEntityType, (ListSelectedRowCollection)rows, (IFormView)this.container.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, (MainEntityType)this.getEntityType());
            }
        } else {
            SimpleBaseData simpleBaseData = this.simpleBaseData;
            if (simpleBaseData == null) {
                simpleBaseData = SimpleBaseData.loadSimpleBaseDataWithPkToName((BasedataEntityType)basedataEntityType, (ListSelectedRowCollection)rows, (String)fieldKey, (MainEntityType)this.getEntityType(), (String)fieldName);
            }
            MessageProxy.sendBaseDataSetValueAction((String)this.container.getKey(), (String)fieldName, (IFormView)this.container.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, (List)simpleBaseData.getIds(), (List)simpleBaseData.getValues());
        }
    }

    private Map<String, List<Object>> getCurrentCommonFilter(Map<String, List<Map<String, List<Object>>>> filterValues) {
        if (filterValues == null) {
            return null;
        }
        List<Map<String, List<Object>>> filter = filterValues.get(CUSTOM_FILTER);
        Map<String, List<Object>> currentCommonFilter = null;
        if (filter != null && !filter.isEmpty()) {
            currentCommonFilter = filter.get(filter.size() - 1);
        }
        return currentCommonFilter;
    }

    void parseFilterValues(Map<String, List<Map<String, List<Object>>>> filterValues, String entryEntity, Function<List<FilterColumn>, List<FilterColumn>> filterColumnFilterFunction) {
        List<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>();
        for (Control item : this.getItems()) {
            if (!(item instanceof FilterGridView)) continue;
            FilterGridView filterGridView = (FilterGridView)item;
            if (this.container instanceof FilterContainer) {
                ((FilterContainer)this.container).setFilterMode(item);
            }
            commonFilterColumns = filterGridView.getShowFilterColumns(false);
        }
        this.parseFilterValues(filterValues, new ArrayList<Map<String, List<Object>>>(), entryEntity, filterColumnFilterFunction != null ? filterColumnFilterFunction.apply(commonFilterColumns) : commonFilterColumns);
    }

    public void parseFilterValues(Map<String, List<Map<String, List<Object>>>> filterValues, List<Map<String, List<Object>>> sortFilter, String entryEntity) {
        this.parseFilterValues(filterValues, sortFilter, entryEntity, this.getCommonFilterColumns());
    }

    private void parseFilterValues(Map<String, List<Map<String, List<Object>>>> filterValues, List<Map<String, List<Object>>> sortFilter, String entryEntity, List<FilterColumn> commonFilterColumns) {
        OrderByParameter orderByFilterParameter;
        this.doBuildContext(filterValues);
        Map<String, List<Object>> currentCommonFilter = this.getCurrentCommonFilter(filterValues);
        SearchClickEvent evt = new SearchClickEvent((Object)this.container, filterValues, entryEntity, this.getFilterModel(), this.getContext().getClientQueryFilterParameter(), currentCommonFilter, this.getContext().getFastQueryFilterParameter().getQFilters());
        evt.setDefaultCommonFilters(AbstractFilterGridView.getDefaultFilterValuesWithVirtural(commonFilterColumns, this.getEntityType()));
        for (SearchClickListener searchClickListener : this.searchClickListeners) {
            searchClickListener.click(evt);
        }
        this.collectCommonFilterValues(filterValues, commonFilterColumns, currentCommonFilter);
        this.doBuildContext(filterValues);
        if (!this.getLinkQueryPkIdCollection().isEmpty()) {
            this.getContext().getClientQueryFilterParameter().getQFilters().add(this.getLinkQueryPkIdCollection().toQFilter());
        }
        if ((orderByFilterParameter = this.getFilterModel().getOrderByFilterParameter(sortFilter)) != null && StringUtils.isNotBlank((CharSequence)orderByFilterParameter.toString())) {
            this.getContext().getClientQueryFilterParameter().setOrderBy(orderByFilterParameter.toString());
        }
        evt = new SearchClickEvent((Object)this.container, filterValues, entryEntity, this.getFilterModel(), this.getContext().getClientQueryFilterParameter(), currentCommonFilter, this.getContext().getFastQueryFilterParameter().getQFilters());
        for (AfterSearchClickListener afterSearchClickListener : this.afterSearchClickListeners) {
            afterSearchClickListener.click(evt);
        }
        SwitchModeEvent switchModeEvent = new SwitchModeEvent((Object)this.container);
        switchModeEvent.setSearchClickEvent(evt);
        for (SwitchModeListener switchModeListener : this.switchModeListeners) {
            switchModeListener.switchMode(switchModeEvent);
        }
    }

    private void collectCommonFilterValues(Map<String, List<Map<String, List<Object>>>> filterValues, List<FilterColumn> commonFilterColumns, Map<String, List<Object>> currentCommonFilter) {
        if (filterValues != null && filterValues.containsKey(CUSTOM_FILTER)) {
            List<Map<String, List<Object>>> filter = filterValues.get(CUSTOM_FILTER);
            filterValues.put(CUSTOM_FILTER, this.getDefaultFilter(commonFilterColumns, filter, currentCommonFilter));
        }
    }

    public void cacheFilterValues(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity) {
        FilterContainerFilterValues cachedFilterValues = new FilterContainerFilterValues(fastFilter, CUSTOM_FILTER, filter, entryEntity);
        if (this.container instanceof IFilterControlCache) {
            ((IFilterControlCache)this.container).setCachedFilterValues(cachedFilterValues);
        }
        ControlFilters controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues(), cachedFilterValues.getOtherFilterValues());
        this.getContext().setControlFilters(controlFilters);
        this.getContext().setEntryEntity(entryEntity);
    }

    private void doBuildContext(Map<String, List<Map<String, List<Object>>>> filterValues) {
        if (this.container instanceof FilterContainer) {
            this.buildContext(filterValues, Boolean.parseBoolean(System.getProperty("bos.filter.isNeedCheckMainOrgs", "false")));
        } else {
            this.buildContext(filterValues);
        }
    }

    private List<Map<String, List<Object>>> getDefaultFilter(List<FilterColumn> commonFilterColumns, List<Map<String, List<Object>>> filter, Map<String, List<Object>> currentCommonFilter) {
        ArrayList<Map<String, List<Object>>> templateDefaultFilter = new ArrayList<Map<String, List<Object>>>();
        List<Map<String, List<Object>>> defaultFilter = AbstractFilterGridView.getFilterValues(commonFilterColumns, this.getEntityType());
        Map<String, List<DependField>> dependFieldMap = this.getDependFieldMap(FilterGridView.class);
        this.addClientFilters(commonFilterColumns, currentCommonFilter, templateDefaultFilter, filter, dependFieldMap, this.getDependFieldColumn(commonFilterColumns, currentCommonFilter));
        for (Map<String, List<Object>> tempDefaultFilter : defaultFilter) {
            boolean isContain = false;
            for (Map map : templateDefaultFilter) {
                List<Object> defaultFieldNames = tempDefaultFilter.get("FieldName");
                List fieldNames = (List)map.get("FieldName");
                if (!defaultFieldNames.get(0).equals(fieldNames.get(0))) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            templateDefaultFilter.add(tempDefaultFilter);
        }
        return templateDefaultFilter;
    }

    AbstractFilterGridView getAbstractFilterGridView(Class<?> cls) {
        for (Control item : this.getItems()) {
            if (!(item instanceof AbstractFilterGridView) || item.getClass() != cls) continue;
            return (AbstractFilterGridView)item;
        }
        return null;
    }

    Map<String, List<DependField>> getDependFieldMap(Class<?> cls) {
        Map<String, List<DependField>> dependFieldMap = new HashMap<String, List<DependField>>();
        for (Control item : this.getItems()) {
            if (!(item instanceof AbstractFilterGridView) || item.getClass() != cls) continue;
            dependFieldMap = ((AbstractFilterGridView)item).getDependFieldMap();
        }
        return dependFieldMap;
    }

    private void addClientFilters(List<FilterColumn> commonFilterColumns, Map<String, List<Object>> currentCommonFilter, List<Map<String, List<Object>>> templateDefaultFilter, List<Map<String, List<Object>>> filter, Map<String, List<DependField>> dependFieldMap, FilterColumn dependFieldColumn) {
        FilterField currentFilterField = dependFieldColumn != null ? dependFieldColumn.getFilterField() : null;
        block0: for (Map<String, List<Object>> tempFilter : filter) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                filterColumn.setEntityType(this.getEntityType());
                boolean notDependFilterColumn = this.isNotDependFilterColumn(currentCommonFilter, dependFieldMap, dependFieldColumn, filterColumn);
                if (!this.checkNotIsItemClassProp(currentFilterField, filterColumn) || !tempFilter.get("FieldName").get(0).equals(filterColumn.getFilterFieldName()) || !notDependFilterColumn) continue;
                templateDefaultFilter.add(tempFilter);
                if (filterColumn instanceof MobCommonFilterColumn || filterColumn instanceof MobCommonDateFilterColumn || filterColumn instanceof MobCommonBaseDataFilterColumn) continue block0;
                boolean isUserProp = filterColumn.getFilterField() != null && filterColumn.getLatestParent() instanceof UserProp;
                boolean isLoadMissing = true;
                List<Object> defaultValues = tempFilter.get("Value");
                if (filterColumn instanceof CommonFilterColumn) {
                    List<Object> compare = tempFilter.get("Compare");
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    if (compare != null && !compare.isEmpty() && StringUtils.isNotBlank((Object)compare.get(0))) {
                        isLoadMissing = false;
                    }
                    if (isUserProp && !defaultValues.isEmpty()) {
                        commonFilterColumn.getComboItems().clear();
                        commonFilterColumn.clearTopPkList();
                    }
                }
                if (isLoadMissing) {
                    filterColumn.setDefaultValues(defaultValues);
                    continue;
                }
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (isUserProp && !defaultValues.isEmpty()) {
                    commonFilterColumn.getComboItems().removeIf(p -> defaultValues.contains(p.getValue()));
                }
                commonFilterColumn.setConstantDefaultValue(defaultValues);
            }
        }
    }

    private boolean isNotDependFilterColumn(Map<String, List<Object>> currentCommonFilter, Map<String, List<DependField>> dependFieldMap, FilterColumn dependFieldColumn, FilterColumn filterColumn) {
        return !dependFieldMap.containsKey(filterColumn.getFieldName()) || this.isNotDependCurrentFilterColumn(dependFieldMap, currentCommonFilter, dependFieldColumn != null ? dependFieldColumn.getFieldName() : null, filterColumn);
    }

    private boolean checkNotIsItemClassProp(FilterField currentFilterField, FilterColumn filterColumn) {
        return currentFilterField != null && (!(currentFilterField.getLatestParent() instanceof ItemClassTypeProp) || currentFilterField.getLatestParent() instanceof ItemClassTypeProp && (!(filterColumn.getLatestParent() instanceof ItemClassProp) || filterColumn.getLatestParent() instanceof ItemClassProp && !currentFilterField.getFieldName().equals(((ItemClassProp)filterColumn.getLatestParent()).getTypePropName())));
    }

    private boolean isNotDependCurrentFilterColumn(Map<String, List<DependField>> dependFieldMap, Map<String, List<Object>> currentCommonFilter, String dependFieldName, FilterColumn filterColumn) {
        return currentCommonFilter == null || currentCommonFilter.get("FieldName").get(0).equals(filterColumn.getFilterFieldName()) || !this.isDependCurrentCommonFilter(dependFieldMap, filterColumn.getFieldName(), dependFieldName);
    }

    private FilterColumn getDependFieldColumn(List<FilterColumn> commonFilterColumns, Map<String, List<Object>> currentCommonFilter) {
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            if (currentCommonFilter == null || !currentCommonFilter.get("FieldName").get(0).equals(commonFilterColumn.getFilterFieldName())) continue;
            return commonFilterColumn;
        }
        return null;
    }

    private boolean isDependCurrentCommonFilter(Map<String, List<DependField>> dependFieldMap, String currentFieldName, String dependFieldName) {
        List<DependField> dependFields = dependFieldMap.get(currentFieldName);
        if (dependFields == null || dependFields.isEmpty()) {
            return false;
        }
        Iterator<DependField> iterator = dependFields.iterator();
        if (iterator.hasNext()) {
            DependField dependField = iterator.next();
            if (!(dependField instanceof OrgDependField) && dependField.getDependFieldName() != null && dependField.getDependFieldName().equals(dependFieldName)) {
                return true;
            }
            return this.isDependCurrentCommonFilter(dependFieldMap, dependField.getDependFieldName(), dependFieldName);
        }
        return false;
    }

    private List<String> getOriginalSelectFieldList(FilterParameter filterParameter) {
        ArrayList<String> originalSelectFieldList = new ArrayList<String>(filterParameter.getSelectFields().size());
        for (String selectField : filterParameter.getSelectFields()) {
            String fConvertField = (String)filterParameter.getConvertFieldsMap().get(selectField);
            if (fConvertField != null) {
                originalSelectFieldList.add(fConvertField);
                continue;
            }
            originalSelectFieldList.add(selectField);
        }
        return originalSelectFieldList;
    }
}

