/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.filter.DependField;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;

public class OrgDependField
extends DependField {
    private static final String SPAN_TYPE = "OrgDependField";
    private String entityId;

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public OrgDependField() {
    }

    public OrgDependField(String fieldName, String dependFieldName, String joinPropertyName, String entityId) {
        super(fieldName, dependFieldName, joinPropertyName);
        this.entityId = entityId;
    }

    private QFilter getBaseDataFilter(String appId, QFilter orgQFilter) {
        try (EntityTraceSpan span = EntityTracer.create((String)"list", (String)"OrgDependField.getBaseDataFilter");){
            IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
            QFilter baseDataFilter = baseDataService.getBaseDataFilter(Long.valueOf(RequestContext.get().getCurrUserId()), appId, this.getEntityId(), orgQFilter, false);
            if (span.isRealtime()) {
                span.addLocaleTag("fieldName", (Object)this.getFieldName());
                span.addLocaleTag("dependFieldName", (Object)this.getDependFieldName());
                span.addLocaleTag("joinPropertyName", (Object)this.getJoinPropertyName());
                span.addLocaleTag("userId", (Object)RequestContext.get().getCurrUserId());
                span.addLocaleTag("appId", (Object)appId);
                span.addLocaleTag("entityId", (Object)this.getEntityId());
                span.addLocaleTag("dependQFilter", (Object)orgQFilter);
                span.addLocaleTag("baseDataFilter", (Object)baseDataFilter);
            }
            QFilter qFilter = baseDataFilter;
            return qFilter;
        }
    }

    @Override
    QFilter getDependFilter(FilterField dependFilterField, FilterField joinPropertyFilterField, String compare, List<Object> dependValues, BasedataEntityType basedataEntityType, MainEntityType mainEntityType) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"getDependFilter");){
            if (span.isRealtime()) {
                span.addTag("compare", compare);
                span.addLocaleTag("dependValues", dependValues);
                span.addLocaleTag("mainEntityTypeName", (Object)mainEntityType.getName());
                span.addLocaleTag("mainEntityTypeAppId", (Object)mainEntityType.getAppId());
                span.addLocaleTag("basedataEntityTypeAppId", (Object)basedataEntityType.getAppId());
                span.addLocaleTag("currUserId", (Object)RequestContext.get().getCurrUserId());
            }
            if ("37".equals(compare)) {
                QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                return qFilter;
            }
            QFilter orgQFilter = null;
            if (compare == null || dependValues == null) {
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                HasPermOrgResult hasPermOrgResult = permissionService.getAllPermOrgs(RequestContext.get().getCurrUserId(), null, mainEntityType.getName(), "47150e89000000ac");
                if (span.isRealtime()) {
                    span.addLocaleTag("hasPermOrgResult", (Object)SerializationUtils.toJsonString((Object)hasPermOrgResult));
                }
                ArrayList hasPermOrgs = new ArrayList(10);
                if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                    hasPermOrgs.addAll(hasPermOrgResult.getHasPermOrgs());
                }
                if (hasPermOrgs != null && hasPermOrgs.size() > 0) {
                    orgQFilter = new QFilter("id", "in", hasPermOrgs);
                }
            } else {
                orgQFilter = this.getDependFilterFieldFilter(dependFilterField, compare, dependValues, mainEntityType);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("orgQFilter", (Object)orgQFilter);
            }
            QFilter qFilter = this.getBaseDataFilter(basedataEntityType.getAppId(), orgQFilter);
            return qFilter;
        }
    }
}

