/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.form.CoreLicenseServiceFacade;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.license.api.ICoreLicenseService;
import kd.bos.list.ListCardView;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SingleOrgContextHelper {
    private static final String ORG_ENTITY_NUMBER = "bos_org";
    private static final String ITEM = "items";
    private static final String THREAD_CACHE_KEY_IS_SINGLE_ORG_MANAGE_MODE = "bos_license_is_single_org_manage_mode";
    private static final String THREAD_CACHE_KEY_LICENSE_MODE_TYPE = "bos_license_mode_type";
    private static final String ORG_FUNC_ADMIN = "01";

    @Deprecated
    public static void createFormSingleOrgContext(FormShowParameter params, Map<String, Object> config) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateFormSingleOrgContext(params, config);
        }
    }

    private static void doCreateFormSingleOrgContext(FormShowParameter params, Map<String, Object> config) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        ArrayList<Control> lstEntrys = new ArrayList<Control>();
        SingleOrgContextHelper.getSingleOrgFieldControlsFromFormRoot(params, mapFields, lstEntrys);
        ArrayList<Control> lstValidOrgs = new ArrayList<Control>();
        SingleOrgContextHelper.addOrgEditAndBasedataProEditToValidOrgs(mapFields, lstValidOrgs);
        SingleOrgContextHelper.addSochToConfig(config, mapFields, lstEntrys);
        List<Map<String, Object>> configItems = SingleOrgContextHelper.getConfigItemsFromConfig(config);
        SingleOrgContextHelper.setCtrlInvisible(lstValidOrgs, configItems);
    }

    private static void setCtrlInvisible(List<Control> lstValidOrgs, List<Map<String, Object>> configItems) {
        for (Control org : lstValidOrgs) {
            HashMap<String, Object> mapCtrl = new HashMap<String, Object>(16);
            mapCtrl.put("id", org.getKey());
            mapCtrl.put("vi", 0);
            configItems.add(mapCtrl);
        }
    }

    private static void addOrgEditAndBasedataProEditToValidOrgs(Map<String, Control> mapFields, List<Control> lstValidOrgs) {
        for (Map.Entry<String, Control> field : mapFields.entrySet()) {
            Control value = field.getValue();
            if (!SingleOrgContextHelper.isControlField(value, mapFields)) continue;
            lstValidOrgs.add(value);
        }
    }

    private static void addSochToConfig(Map<String, Object> config, Map<String, Control> mapFields, List<Control> lstEntrys) {
        Map<String, List<String>> mapEntry = SingleOrgContextHelper.getValidEntryMap(mapFields, lstEntrys, null);
        if (mapEntry.size() > 0) {
            config.put("soch", mapEntry);
        }
    }

    private static void getSingleOrgFieldControlsFromFormRoot(FormShowParameter params, Map<String, Control> mapFields, List<Control> lstEntrys) {
        FormRoot root = FormMetadataCache.getRootControl((String)params.getFormId());
        List rootItems = root.getItems();
        for (Control item : rootItems) {
            SingleOrgContextHelper.getSingleOrgFieldControls(item, mapFields, lstEntrys);
        }
    }

    private static List<Map<String, Object>> getConfigItemsFromConfig(Map<String, Object> config) {
        ArrayList configItems;
        HashMap metas = (HashMap)config.get("metas");
        if (metas == null) {
            metas = new HashMap(16);
            config.put("metas", metas);
        }
        if ((configItems = (ArrayList)metas.get(ITEM)) == null) {
            configItems = new ArrayList(10);
            metas.put(ITEM, configItems);
        }
        return configItems;
    }

    public static void createReportSingleOrgContext(List<AbstractReportColumn> columns) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateReportSingleOrgContext(columns);
        }
    }

    private static void doCreateReportSingleOrgContext(List<AbstractReportColumn> columns) {
        if (columns == null) {
            return;
        }
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                String xzzn;
                boolean isOrg = ((ReportColumn)column).isRefOrg();
                if (!isOrg || StringUtils.isNotBlank((CharSequence)(xzzn = ((ReportColumn)column).getOrgFuncs())) && xzzn.equals(ORG_FUNC_ADMIN)) continue;
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            List children = ((ReportColumnGroup)column).getChildren();
            SingleOrgContextHelper.doCreateReportSingleOrgContext(children);
        }
    }

    public static void createListSingleOrgContext(Control item, Map<String, Object> column) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateListSingleOrgContext(item, column);
        }
    }

    private static void doCreateListSingleOrgContext(Control item, Map<String, Object> column) {
        IDataEntityProperty srcProp;
        if (column == null) {
            return;
        }
        if (item instanceof ListColumn && SingleOrgContextHelper.isControlField(srcProp = ((ListColumn)item).getSrcFieldProp(), null)) {
            column.put("vi", 0);
        }
    }

    private static boolean isControlField(Object orgOrBase, Map<String, Control> mapFields) {
        boolean ret = false;
        String xzzn = "";
        if (orgOrBase instanceof OrgProp) {
            ret = true;
            xzzn = ((OrgProp)orgOrBase).getOrgFunc();
            if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                ret = false;
            }
        } else if (orgOrBase instanceof BasedataProp && !(orgOrBase instanceof ItemClassProp)) {
            String refEntity = ((BasedataProp)orgOrBase).getBaseEntityId();
            if (ORG_ENTITY_NUMBER.equals(refEntity)) {
                ret = true;
            }
        } else if (orgOrBase instanceof MulBasedataProp) {
            String refEntity = ((MulBasedataProp)orgOrBase).getBaseEntityId();
            if (ORG_ENTITY_NUMBER.equals(refEntity)) {
                ret = true;
                xzzn = ((MulBasedataProp)orgOrBase).getOrgFunc();
                if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                    ret = false;
                }
            }
        } else if (orgOrBase instanceof OrgEdit) {
            ret = true;
            xzzn = ((OrgProp)((OrgEdit)orgOrBase).getProperty()).getOrgFunc();
            if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                ret = false;
            }
        } else if (orgOrBase instanceof BasedataPropEdit) {
            String ref = ((BasedataPropEdit)orgOrBase).getRefBasedataProp();
            if (mapFields != null && StringUtils.isNotBlank((Object)ref)) {
                String refDisplayName;
                Control refCtrl = mapFields.get(ref);
                if (refCtrl instanceof OrgEdit && SingleOrgContextHelper.isControlField(refCtrl, null)) {
                    ret = true;
                } else if (refCtrl instanceof BasedataEdit && StringUtils.isNotBlank((CharSequence)(refDisplayName = ((BasedataPropEdit)orgOrBase).getRefDisplayProp()))) {
                    String[] dps = refDisplayName.split("\\.");
                    String baseEntityNumber = ((BasedataProp)((BasedataEdit)refCtrl).getProperty()).getBaseEntityId();
                    if (StringUtils.isNotBlank((CharSequence)baseEntityNumber)) {
                        MainEntityType tp = EntityMetadataCache.getDataEntityType((String)baseEntityNumber);
                        DynamicProperty prop = tp.getProperty(dps[0]);
                        ret = SingleOrgContextHelper.isControlField(prop, null);
                    }
                }
            }
        } else if (orgOrBase instanceof BasedataEdit && !(orgOrBase instanceof ItemClassEdit)) {
            IDataEntityProperty prop = ((BasedataEdit)orgOrBase).getProperty();
            ret = SingleOrgContextHelper.isControlField(prop, null);
        }
        return ret;
    }

    public static void createReportSearchConditionSingleOrgContext(List<String> fields, IFormView view) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateReportSearchConditionSingleOrgContext(fields, view);
        }
    }

    private static void doCreateReportSearchConditionSingleOrgContext(List<String> fields, IFormView view) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        HashMap<String, List<Control>> mapCardEntryFields = new HashMap<String, List<Control>>();
        HashMap<String, CardEntry> cardEntrys = new HashMap<String, CardEntry>();
        ArrayList<Control> ctls = new ArrayList<Control>();
        FormRoot root = (FormRoot)view.getRootControl();
        List lstItems = root.getItems();
        for (Control item : lstItems) {
            SingleOrgContextHelper.createOrgAndBasedataPropControl(item, ctls, mapFields, cardEntrys, mapCardEntryFields);
        }
        Iterator<String> it = fields.iterator();
        while (it.hasNext()) {
            String key = it.next();
            Control fd = view.getControl(key);
            if (fd == null || !SingleOrgContextHelper.isControlField(fd, mapFields)) continue;
            it.remove();
        }
    }

    public static void createFilterGridSingleOrgContext(Map<String, List<Map<String, Object>>> fieldMap, MainEntityType mainType) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateFilterGridSingleOrgContext(fieldMap, mainType);
        }
    }

    private static void doCreateFilterGridSingleOrgContext(Map<String, List<Map<String, Object>>> fieldMap, MainEntityType mainType) {
        List<Map<String, Object>> lstField = fieldMap.get("filterColumns");
        SingleOrgContextHelper.hideFilterSearchOrgByName(lstField, mainType);
    }

    @Deprecated
    public static void createListFilterSingleOrgContext(Map<String, Object> clientMeta, MainEntityType mainType) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateListFilterSingleOrgContext(clientMeta, mainType);
        }
    }

    private static void doCreateListFilterSingleOrgContext(Map<String, Object> clientMeta, MainEntityType mainType) {
        SingleOrgContextHelper.hideFilterSearchOrgByName(clientMeta, mainType, "fast");
        SingleOrgContextHelper.hideFilterSearchOrgByName(clientMeta, mainType, "common");
        Map mapScheme = (Map)clientMeta.get("scheme");
        SingleOrgContextHelper.hideFilterSearchOrgByName(mapScheme, mainType, "conditions");
    }

    private static void hideFilterSearchOrgByName(Map<String, Object> clientMeta, MainEntityType mainType, String name) {
        Object nameObj = clientMeta.get(name);
        if (mainType == null) {
            return;
        }
        if (!(nameObj instanceof List)) {
            return;
        }
        List lstName = (List)nameObj;
        SingleOrgContextHelper.hideFilterSearchOrgByName(lstName, mainType);
    }

    private static void hideFilterSearchOrgByName(List<Map<String, Object>> lstName, MainEntityType mainType) {
        String ret = lstName.toString();
        Iterator<Map<String, Object>> it = lstName.iterator();
        while (it.hasNext()) {
            Map<String, Object> mapName = it.next();
            String type = (String)mapName.get("type");
            String entryEntity = (String)mapName.get("entryEntity");
            String fieldName = (String)mapName.get("fieldName");
            FilterField filterField = null;
            if (filterField == null) {
                filterField = FilterField.create((MainEntityType)mainType, (String)fieldName);
            }
            if (filterField == null || !SingleOrgContextHelper.isNeedHideOrg(filterField)) continue;
            it.remove();
        }
    }

    public static void createCardSingleOrgContext(ListCardView lstcardview, List<Map<String, Object>> cardviewItems) {
        if (cardviewItems == null) {
            return;
        }
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateCardSingleOrgContext(lstcardview, cardviewItems);
        }
    }

    private static void doCreateCardSingleOrgContext(ListCardView lstcardview, List<Map<String, Object>> cardviewItems) {
        for (Map<String, Object> cardviewItem : cardviewItems) {
            HashMap<String, Map> mapItems = new HashMap<String, Map>();
            List lstHeader = (List)cardviewItem.get(ITEM);
            for (Map mapItem : lstHeader) {
                String type = (String)mapItem.get("type");
                if (type.equals("cardfield")) {
                    mapItems.put((String)mapItem.get("id"), mapItem);
                    continue;
                }
                if (!type.equals("cardflexpanel")) continue;
                List lstItems = (List)mapItem.get(ITEM);
                for (Map item : lstItems) {
                    String itemtype = (String)item.get("type");
                    if (!itemtype.equals("cardfield")) continue;
                    mapItems.put((String)item.get("id"), item);
                }
            }
            ArrayList<Control> lstValidOrgs = new ArrayList<Control>();
            List lstItems = lstcardview.getItems();
            for (Control item : lstItems) {
                SingleOrgContextHelper.getSingleOrgFieldControls(item, lstValidOrgs);
            }
            for (Control ctl : lstValidOrgs) {
                Map item;
                IDataEntityProperty srcProp = ((ListColumn)ctl).getSrcFieldProp();
                if (!SingleOrgContextHelper.isControlField(srcProp, null) || (item = (Map)mapItems.get(((ListColumn)ctl).getKey())) == null) continue;
                item.put("vi", 0);
            }
        }
    }

    public static void createFormSingleOrgContext(IFormView view) {
        int modelType = CoreLicenseServiceFacade.getModelType();
        boolean singleOrgMode = CoreLicenseServiceFacade.isSingleOrgMode();
        Log logger = LogFactory.getLog(SingleOrgContextHelper.class);
        logger.debug("modelType {}, singleOrgMode {}", (Object)modelType, (Object)singleOrgMode);
        if (1 == modelType && singleOrgMode) {
            SingleOrgContextHelper.doCreateFormSingleOrgContext(view, ControlType.Visbile);
        } else if (4 == modelType && singleOrgMode) {
            SingleOrgContextHelper.doCreateFormSingleOrgContext(view, ControlType.Enabled);
        }
    }

    public static boolean isSingleOrgManageMode() {
        return (Boolean)ThreadCache.get((Object)THREAD_CACHE_KEY_IS_SINGLE_ORG_MANAGE_MODE, (CacheLoader)new CacheLoader<Boolean>(){

            public Boolean load() {
                ICoreLicenseService service = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
                return service.isSingleOrgManageMode();
            }
        });
    }

    public static void createSystemParamSingleOrgContext(IFormView view, boolean visible) {
        if (SingleOrgContextHelper.isSingleOrgManageMode()) {
            SingleOrgContextHelper.doCreateSystemParamSingleOrgContext(view, visible);
        }
    }

    private static void doCreateSystemParamSingleOrgContext(IFormView view, boolean visible) {
        view.setVisible(Boolean.valueOf(false), new String[]{"orgfield"});
        view.setVisible(Boolean.valueOf(false), new String[]{"viewtype"});
        view.setVisible(Boolean.valueOf(false), new String[]{"groupcontrol"});
        view.setVisible(Boolean.valueOf(visible), new String[]{"headpanel"});
    }

    private static void doCreateFormSingleOrgContext(IFormView view, ControlType controlType) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        HashMap<String, List<Control>> mapCardEntryFields = new HashMap<String, List<Control>>();
        HashMap<String, CardEntry> cardEntrys = new HashMap<String, CardEntry>();
        ArrayList<Control> ctls = new ArrayList<Control>();
        FormRoot root = (FormRoot)view.getRootControl();
        List lstItems = root.getItems();
        for (Control control : lstItems) {
            SingleOrgContextHelper.createOrgAndBasedataPropControl(control, ctls, mapFields, cardEntrys, mapCardEntryFields);
        }
        for (Control control : ctls) {
            if (!SingleOrgContextHelper.isControlField(control, mapFields)) continue;
            if (controlType == ControlType.Visbile) {
                view.setVisible(Boolean.valueOf(false), new String[]{control.getKey()});
                continue;
            }
            if (!(control instanceof FieldEdit)) continue;
            IDataEntityProperty property = ((FieldEdit)control).getProperty();
            boolean isMustInput = true;
            if (property instanceof FieldProp) {
                isMustInput = ((FieldProp)property).isMustInput();
            } else if (property instanceof BasedataProp) {
                isMustInput = ((BasedataProp)property).isMustInput();
            }
            ((FieldEdit)control).setEnable(control.getKey(), !isMustInput, -1);
        }
        if (mapCardEntryFields.size() > 0) {
            for (Map.Entry entry : mapCardEntryFields.entrySet()) {
                List items = (List)entry.getValue();
                CardEntry cn = (CardEntry)cardEntrys.get(entry.getKey());
                for (Control item : items) {
                    if (!SingleOrgContextHelper.isControlField(item, mapFields)) continue;
                    if (controlType == ControlType.Visbile) {
                        cn.setChildVisible(false, -1, new String[]{item.getKey()});
                        continue;
                    }
                    cn.setChildEnable(false, -1, new String[]{item.getKey()});
                }
            }
        }
    }

    private static void getSingleOrgFieldControls(Control parent, List<Control> lst) {
        if (parent instanceof Container) {
            List lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    SingleOrgContextHelper.getSingleOrgFieldControls(ctl, lst);
                    continue;
                }
                SingleOrgContextHelper.addOrgAndBasedataProp(lst, ctl);
            }
        } else {
            SingleOrgContextHelper.addOrgAndBasedataProp(lst, parent);
        }
    }

    private static void addOrgAndBasedataProp(List<Control> lst, Control ctl) {
        IDataEntityProperty ref;
        if (ctl instanceof ListColumn && (ref = ((ListColumn)ctl).getSrcFieldProp()) instanceof OrgProp) {
            lst.add(ctl);
        }
    }

    private static void getSingleOrgFieldControls(Control parent, Map<String, Control> lstField, List<Control> lstEntry) {
        if (parent instanceof EntryGrid) {
            lstEntry.add(parent);
        }
        if (parent instanceof Container) {
            List lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    SingleOrgContextHelper.getSingleOrgFieldControls(ctl, lstField, lstEntry);
                    continue;
                }
                SingleOrgContextHelper.addOrgAndBasedataProp(lstField, ctl);
            }
        } else {
            SingleOrgContextHelper.addOrgAndBasedataProp(lstField, parent);
        }
    }

    private static boolean isControlType(Control ctl) {
        return ctl instanceof OrgEdit || ctl instanceof BasedataPropEdit || ctl instanceof BasedataEdit && !(ctl instanceof ItemClassEdit);
    }

    private static void addOrgAndBasedataProp(Map<String, Control> lst, Control ctl) {
        if (SingleOrgContextHelper.isControlType(ctl) || ctl instanceof EntryGrid) {
            lst.put(ctl.getKey(), ctl);
        }
    }

    private static Map<String, List<String>> getValidEntryMap(Map<String, Control> mapFields, List<Control> lstEntrys, Map<String, List<String>> mapEntry) {
        if (mapEntry == null) {
            mapEntry = new HashMap<String, List<String>>();
        }
        for (Control entry : lstEntrys) {
            if (!(entry instanceof Container)) continue;
            List lstCtls = ((Container)entry).getItems();
            for (Control ctl : lstCtls) {
                if (SingleOrgContextHelper.isControlField(ctl, mapFields)) {
                    List lstMapCtls = mapEntry.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                    lstMapCtls.add(ctl.getKey());
                    continue;
                }
                if (!(ctl instanceof Container)) continue;
                mapEntry = SingleOrgContextHelper.getValidEntryMap(mapFields, ((Container)ctl).getItems(), mapEntry);
            }
        }
        return mapEntry;
    }

    private static void createOrgAndBasedataPropControl(Control parent, List<Control> ctls, Map<String, Control> mapFields, Map<String, CardEntry> cardEntrys, Map<String, List<Control>> mapCardEntryFields) {
        if (parent instanceof CardEntry) {
            cardEntrys.put(parent.getKey(), (CardEntry)parent);
            List<Control> fields = SingleOrgContextHelper.createCardEntryControl(parent);
            mapCardEntryFields.put(parent.getKey(), fields);
        } else if (parent instanceof Container) {
            List lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    SingleOrgContextHelper.createOrgAndBasedataPropControl(ctl, ctls, mapFields, cardEntrys, mapCardEntryFields);
                    continue;
                }
                if (!SingleOrgContextHelper.isControlType(ctl)) continue;
                ctls.add(ctl);
                mapFields.put(ctl.getKey(), ctl);
            }
        } else if (SingleOrgContextHelper.isControlType(parent)) {
            ctls.add(parent);
            mapFields.put(parent.getKey(), parent);
        }
    }

    private static List<Control> createCardEntryControl(Control cardentry) {
        ArrayList<Control> fields = new ArrayList<Control>();
        SingleOrgContextHelper.recursionGetFields(cardentry, fields);
        return fields;
    }

    private static void recursionGetFields(Control parent, List<Control> ctls) {
        if (parent instanceof Container) {
            List lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    SingleOrgContextHelper.recursionGetFields(ctl, ctls);
                    continue;
                }
                if (!SingleOrgContextHelper.isControlType(ctl)) continue;
                ctls.add(ctl);
            }
        } else if (SingleOrgContextHelper.isControlType(parent)) {
            ctls.add(parent);
        }
    }

    public static int getOrgmanageMode() {
        Map paramMap = ParameterReader.loadPublicParameterFromCache();
        if (paramMap == null) {
            return 2;
        }
        Object mode = paramMap.get("orgmanagemode");
        return StringUtils.isBlank(mode) ? 2 : Integer.parseInt(mode.toString());
    }

    public static boolean isNeedHideOrg(FilterField filterField) {
        if (!SingleOrgContextHelper.isSingleOrgManageMode()) {
            return false;
        }
        boolean ret = false;
        if (SingleOrgContextHelper.isStandardVersionMode()) {
            IDataEntityProperty ref0 = filterField.getSrcFieldProp();
            IDataEntityProperty ref1 = filterField.getRefProp1();
            IDataEntityProperty ref2 = filterField.getRefProp2();
            if (ref0 != null && SingleOrgContextHelper.isFieldNeedHide(ref0) || ref1 != null && SingleOrgContextHelper.isFieldNeedHide(ref1) || ref2 != null && SingleOrgContextHelper.isFieldNeedHide(ref2)) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isStandardVersionMode() {
        Integer license_modeType = (Integer)ThreadCache.get((Object)THREAD_CACHE_KEY_LICENSE_MODE_TYPE, (CacheLoader)new CacheLoader<Integer>(){

            public Integer load() {
                ICoreLicenseService service = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
                return service.getModeType();
            }
        });
        return license_modeType != null && 1 == license_modeType;
    }

    public static boolean isFieldNeedHide(IDataEntityProperty prop) {
        if (!SingleOrgContextHelper.isSingleOrgManageMode()) {
            return false;
        }
        boolean ret = false;
        if (SingleOrgContextHelper.isStandardVersionMode()) {
            if (prop instanceof OrgProp && !ORG_FUNC_ADMIN.equals(((OrgProp)prop).getOrgFunc())) {
                ret = true;
            }
            if (!(prop instanceof OrgProp) && prop instanceof BasedataProp && !(prop instanceof ItemClassProp) && ORG_ENTITY_NUMBER.equals(((BasedataProp)prop).getBaseEntityId())) {
                ret = true;
            }
            if (prop instanceof MulBasedataProp && ORG_ENTITY_NUMBER.equals(((MulBasedataProp)prop).getBaseEntityId()) && !ORG_FUNC_ADMIN.equals(((MulBasedataProp)prop).getOrgFunc())) {
                ret = true;
            }
        }
        return ret;
    }

    static enum ControlType {
        Visbile,
        Enabled;

    }
}

