/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.IBasedataField;
import kd.bos.filter.FieldPluginQFilterMapCache;
import kd.bos.filter.helper.BaseDataSearchHelper;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.list.events.ListColumnSetFilterEvent;
import kd.bos.list.events.ListColumnSetListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

class BasedataSearchParser {
    private IBasedataField basedataProp;
    private BillList billList;
    private List<ListColumnSetListener> listColumnSetFilterListeners = new ArrayList<ListColumnSetListener>(10);
    private FieldPluginQFilterMapCache fieldPluginQFilterMapCache;

    BasedataSearchParser(IBasedataField basedataProp, IPageCache pageCache, BillList billList, List<ListColumnSetListener> listColumnSetFilterListeners) {
        this.basedataProp = basedataProp;
        this.billList = billList;
        this.listColumnSetFilterListeners.addAll(listColumnSetFilterListeners);
        this.fieldPluginQFilterMapCache = new FieldPluginQFilterMapCache(pageCache);
    }

    Map<String, Object> parse(String fieldName, String showfield, String searchKey, int start, int limit, QFilter qFilter) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        BasedataEntityType dt = (BasedataEntityType)this.basedataProp.getComplexType();
        ArrayList<String> showFields = new ArrayList<String>(2);
        showFields.add("id");
        showFields.add(showfield);
        ArrayList<String> seachFields = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)dt.getNumberProperty())) {
            seachFields.add(dt.getNumberProperty());
        }
        if (StringUtils.isNotBlank((CharSequence)dt.getNameProperty())) {
            seachFields.add(dt.getNameProperty());
        }
        seachFields.add(showfield);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter searchFilter = BaseDataSearchHelper.getSearchFilter((String)searchKey, seachFields, (String)dt.getName());
        if (searchFilter != null) {
            qFilters.add(searchFilter);
        }
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
        qFilters.add(new QFilter(showfield, "!=", (Object)" "));
        HashMap<String, Integer> fieldsIndexMap = new HashMap<String, Integer>(3);
        fieldsIndexMap.put("id", 0);
        fieldsIndexMap.put(showfield, 2);
        DynamicObjectCollection queryCollection = this.queryBaseDataCollections(dt.getName(), qFilters, String.join((CharSequence)",", showFields), showfield, start, limit);
        if (queryCollection != null) {
            HashSet<String> keySet = new HashSet<String>(1);
            keySet.add(showfield);
            List queryLookUpdata = BaseDataSearchHelper.assembleDataDistinct(showFields, (int)0, (int)limit, (DynamicObjectCollection)queryCollection, fieldsIndexMap, keySet);
            data.put("data", queryLookUpdata);
            data.put("next", !queryLookUpdata.isEmpty() && queryLookUpdata.size() >= limit);
            data.put("k", fieldName);
            data.put("size", limit);
            data.put("start", start);
        }
        return data;
    }

    private void addPluginFilters(List<QFilter> qFilters, String fieldName) {
        ListColumnSetFilterEvent listColumnSetFilterEvent = new ListColumnSetFilterEvent((Object)this.billList, fieldName);
        for (ListColumnSetListener listColumnSetFilterListener : this.listColumnSetFilterListeners) {
            listColumnSetFilterListener.setFilter(listColumnSetFilterEvent);
            if (listColumnSetFilterEvent.getQFilter() == null) continue;
            qFilters.add(listColumnSetFilterEvent.getQFilter());
        }
        Map<String, List<QFilter>> fieldPluginQFilterMap = this.fieldPluginQFilterMapCache.get();
        List<QFilter> commonFilterColumnPluginQFilters = fieldPluginQFilterMap.get(fieldName);
        if (commonFilterColumnPluginQFilters != null) {
            qFilters.addAll(commonFilterColumnPluginQFilters);
        }
    }

    private DynamicObjectCollection queryBaseDataCollections(String entityId, List<QFilter> qFilters, String selectFields, String orderBy, int start, int topSize) {
        DynamicObjectCollection dynamicObjectCollection;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.bos.list.BasedataSearchParser.queryBaseDataCollections." + entityId, entityId, selectFields, qFilters.toArray(new QFilter[0]), orderBy, start, topSize, (Distinctable)WithEntityEntryDistinctable.get());){
            dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
        }
        return dynamicObjectCollection;
    }
}

