/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.LongProp;
import kd.bos.form.control.AbstractGrid;
import kd.bos.list.BillList;

public class BillListSelection {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String MAIN_ORG_ID = "mainOrgId";
    private static final String PRIMARY_KEY_VALUE = "primaryKeyValue";
    private static final String BILL_NO = "billNo";
    private static final String SUB_ENTRY_PRIMARY_KEY_VALUE = "subEntryPrimaryKeyValue";
    private static final String ENTRY_PRIMARY_KEY_VALUE = "entryPrimaryKeyValue";
    private static final String BILL_STATUS = "billStatus";
    BillList billList;
    List<String> cachedListFields;
    Map<String, String> cachedKeyFieldsMap;
    ListSelectedRowCollection currentPageSelectedRows;

    public BillList getBillList() {
        return this.billList;
    }

    public void setBillList(BillList billList) {
        this.billList = billList;
    }

    public BillListSelection(BillList billList) {
        this.billList = billList;
    }

    private IDataModel getModel() {
        return this.billList.getModel();
    }

    private EntityType getEntityType() {
        return this.billList.getEntityType();
    }

    private AbstractGrid.GridState getEntryState() {
        return this.billList.getEntryState();
    }

    void setCachedListFields(List<String> cachedListFields) {
        this.cachedListFields = cachedListFields;
    }

    void setCachedListKeyFields(Map<String, String> cachedKeyFieldsMap) {
        this.cachedKeyFieldsMap = cachedKeyFieldsMap;
    }

    private Map<String, Integer> lookupClientReturnCols(MainEntityType entityType, List<ListField> pkFields) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int size = pkFields.size();
        if (entityType instanceof QueryEntityType) {
            int i = 0;
            for (ListField pkField : pkFields) {
                map.put(pkField.getKey(), i++);
            }
        } else {
            if (size > 0) {
                map.put(PRIMARY_KEY_VALUE, 0);
            }
            if (size > 1) {
                map.put(ENTRY_PRIMARY_KEY_VALUE, 1);
            }
            if (size > 2) {
                map.put(SUB_ENTRY_PRIMARY_KEY_VALUE, 2);
            }
            int i = size;
            for (String key : this.cachedKeyFieldsMap.keySet()) {
                map.put(key, i);
                ++i;
            }
        }
        return map;
    }

    Object convertPkValue(ListField pkField, Object value) {
        if (pkField.getSrcFieldProp() instanceof LongProp) {
            if (value instanceof Long) {
                return value;
            }
            if (StringUtils.isNotBlank((Object)value)) {
                if (StringUtils.equals((CharSequence)"null", (CharSequence)value.toString())) {
                    return 0L;
                }
                return Long.parseLong(value.toString());
            }
            return 0L;
        }
        return value;
    }

    private ListSelectedRow getSelectedRow(List<Object> list, AbstractGrid.GridState state, int rowKey, List<ListField> pkFields, Map<String, Integer> keyFields) {
        Integer mainOrgIndex;
        Integer billStatusIndex;
        Integer billNoIndex;
        Integer nameIndex;
        Integer numberIndex;
        Integer subEntryPk;
        Integer entryPkIndex;
        Object pkValue = null;
        ListField pkField = null;
        Object queryEntityPrimayKeyValue = null;
        if (this.getEntityType() instanceof QueryEntityType) {
            pkField = this.getPkField(pkFields);
            Object value = list.get(keyFields.get(pkField.getKey()));
            pkValue = this.convertPkValue(pkField, value);
            Object mainEntitykeyValue = list.get(keyFields.get(pkFields.get(0).getKey()));
            queryEntityPrimayKeyValue = this.convertPkValue(pkFields.get(0), mainEntitykeyValue);
        } else {
            pkField = pkFields.get(0);
            Integer pkIndex = keyFields.get(PRIMARY_KEY_VALUE);
            if (pkIndex != null) {
                Object value = list.get(pkIndex);
                pkValue = this.convertPkValue(pkField, value);
            }
        }
        ListSelectedRow row = new ListSelectedRow(pkValue, Boolean.valueOf(pkField.getSrcFieldProp() instanceof LongProp));
        if (this.getEntityType() instanceof QueryEntityType) {
            row.setQueryEntityPrimayKeyValue(queryEntityPrimayKeyValue);
        }
        if ((entryPkIndex = keyFields.get(ENTRY_PRIMARY_KEY_VALUE)) != null) {
            pkField = pkFields.get(1);
            Object value = list.get(entryPkIndex);
            Object newValue = this.convertPkValue(pkField, value);
            row.setEntryPrimaryKeyValue(newValue);
            row.setEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
        }
        if ((subEntryPk = keyFields.get(SUB_ENTRY_PRIMARY_KEY_VALUE)) != null) {
            pkField = pkFields.get(2);
            Object value = list.get(subEntryPk);
            Object newValue = this.convertPkValue(pkField, value);
            row.setSubEntryPrimaryKeyValue(newValue);
            row.setSubEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
        }
        if ((numberIndex = keyFields.get(NUMBER)) != null && list.get(numberIndex) != null) {
            row.setNumber(list.get(numberIndex).toString());
        }
        if ((nameIndex = keyFields.get(NAME)) != null && list.get(nameIndex) != null) {
            row.setName(list.get(nameIndex).toString());
        }
        if ((billNoIndex = keyFields.get(BILL_NO)) != null && list.get(billNoIndex) != null) {
            row.setBillNo(list.get(billNoIndex).toString());
        }
        if ((billStatusIndex = keyFields.get(BILL_STATUS)) != null && list.get(billStatusIndex) != null) {
            row.setBillStatus(list.get(billStatusIndex).toString());
        }
        if ((mainOrgIndex = keyFields.get(MAIN_ORG_ID)) != null && list.get(mainOrgIndex) != null && this.checkIsNumric(list.get(mainOrgIndex).toString())) {
            row.setMainOrgId(Long.parseLong(list.get(mainOrgIndex).toString()));
        }
        if (this.getEntityType() instanceof BillEntityType) {
            Object value;
            BillEntityType billDt = (BillEntityType)this.getEntityType();
            String billTypeKey = billDt.getBillType();
            Integer billTypeIdx = keyFields.get(billTypeKey + "_id");
            if (StringUtils.isNotBlank((CharSequence)billDt.getBillType()) && billTypeIdx != null && (value = list.get(billTypeIdx)) != null) {
                row.setBillTypeID(Long.valueOf(Long.parseLong(value.toString())));
            }
        }
        row.setRowKey(rowKey);
        row.setPageIndex(state.getCurrentPageIndex().intValue());
        return row;
    }

    private ListField getPkField(List<ListField> pkFields) {
        ListField pkField = null;
        QueryEntityType qet = (QueryEntityType)this.getEntityType();
        String editEntityName = qet.getEditEntityAliasName();
        for (ListField lf : pkFields) {
            if (!editEntityName.equals(lf.getEntityName())) continue;
            pkField = lf;
            break;
        }
        if (pkField == null) {
            pkField = pkFields.get(0);
        }
        return pkField;
    }

    private boolean checkIsNumric(String str) {
        return str.matches("-?[0-9]+.?[0-9]*");
    }

    private List<ListField> getPkFields() {
        MainEntityType entityType = (MainEntityType)this.getEntityType();
        ArrayList<ListField> listFields = new ArrayList<ListField>(10);
        for (String cachedListField : this.cachedListFields) {
            if (StringUtils.isBlank((CharSequence)cachedListField)) continue;
            ListField listField = new ListField(cachedListField);
            listField.setFieldName(cachedListField);
            listFields.add(listField);
        }
        return EntityTypeUtil.getValidPkFields((EntityType)entityType, listFields);
    }

    ListSelectedRowCollection getCurrentPageSelectedRows() {
        this.currentPageSelectedRows = new ListSelectedRowCollection();
        AbstractGrid.GridState state = this.getEntryState();
        List<ListField> pkFields = this.getPkFields();
        Map<String, Integer> keyFields = this.lookupClientReturnCols((MainEntityType)this.getEntityType(), pkFields);
        if (state.get("selDatas") != null) {
            List listRows = (List)state.get("selDatas");
            int[] selectdRows = state.getSelectedRows();
            int i = 0;
            for (Object listRow : listRows) {
                if (i >= selectdRows.length) break;
                this.currentPageSelectedRows.add((Object)this.getSelectedRow((List)listRow, state, selectdRows[i++], pkFields, keyFields));
            }
        }
        return this.currentPageSelectedRows;
    }

    ListSelectedRow getFocusRow() {
        AbstractGrid.GridState state = this.getEntryState();
        List<ListField> pkFields = this.getPkFields();
        Map<String, Integer> keyFields = this.lookupClientReturnCols((MainEntityType)this.getEntityType(), pkFields);
        if (state.get("rowData") != null) {
            List rowadata = (List)state.get("rowData");
            return this.getSelectedRow(rowadata, state, state.getFocusRow(), pkFields, keyFields);
        }
        return null;
    }

    ListSelectedRowCollection getRowSelection(List<Integer> rowKeys, List<List<Object>> rowDatas) {
        AbstractGrid.GridState state = this.getEntryState();
        List<ListField> pkFields = this.getPkFields();
        Map<String, Integer> keyFields = this.lookupClientReturnCols((MainEntityType)this.getEntityType(), pkFields);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        int i = 0;
        for (List<Object> rowData : rowDatas) {
            listSelectedRowCollection.add((Object)this.getSelectedRow(rowData, state, rowKeys.get(i++), pkFields, keyFields));
        }
        return listSelectedRowCollection;
    }
}

