/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.CitySortUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class CityListUtil {
    private static final Log logger = LogFactory.getLog(CityListUtil.class);
    private static final String YES = "1";
    private static final String ENTITY_BD_ADMINDIVISION = "bd_admindivision";
    private static final Long CHINA_COUNTRY_ID = 1000001L;
    private static final String HAS_MORE = "hasMore";
    private static final String CLG = "clg";
    private static final String COUNTRY = "country";
    private static final String NUMBER = "number";
    private static final String LONGNUMBER = "longnumber";
    private static final HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
    private static final String IS_CITY = "iscity";
    private static final String ENABLE = "enable";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String GR = "gr";
    private static final String LIKE_SIGN = "%";
    private static final String FULLSPELL = "fullspell";
    private static final String PROVINCE = "province";
    private static final String ILID = "ilid";
    private static final String COUNTRY_NAME = "countryName";
    private static final String LAST_DIVISION = "lastDivision";
    private static final String PARENT = "parent";
    private static final String SIMPLESPELL = "simplespell";
    private static final int CITY_DEFAULT_NUM = 10000;

    public static List<Map<String, Object>> getCityData(boolean isDomestic, boolean isFirst, int dataPerPage, String gr, String lastCityId) {
        long start = System.currentTimeMillis();
        ArrayList<Map<String, Object>> cityGroups = new ArrayList<Map<String, Object>>(10);
        List<Long> noProvinceCityIds = Arrays.asList(123L, 2675L, 141L, 3134L);
        Map<Object, DynamicObject> dynamicObjectMap = CityListUtil.getCityDynamicObject(isDomestic);
        if (CollectionUtils.isEmpty(dynamicObjectMap)) {
            return cityGroups;
        }
        Map<String, List<Map<String, Object>>> groupMap = CityListUtil.getGroupCity(noProvinceCityIds, dynamicObjectMap);
        Lang lang = RequestContext.get().getLang();
        if (!(isFirst || StringUtils.isEmpty((CharSequence)gr) || StringUtils.isEmpty((CharSequence)lastCityId))) {
            HashMap<String, Object> resMap = CityListUtil.reducePageCity(dataPerPage, gr, lastCityId, groupMap, lang);
            cityGroups.add(resMap);
            return cityGroups;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : groupMap.entrySet()) {
            HashMap<String, Object> groupResMap = new HashMap<String, Object>(16);
            String group = entry.getKey();
            List<Map<String, Object>> cityList = entry.getValue();
            CityListUtil.sortCityList(lang, cityList);
            groupResMap.put(GR, group);
            if (dataPerPage > 0 && cityList.size() > dataPerPage) {
                groupResMap.put(HAS_MORE, true);
                groupResMap.put(CLG, cityList.subList(0, dataPerPage));
            } else {
                groupResMap.put(HAS_MORE, false);
                groupResMap.put(CLG, cityList);
            }
            cityGroups.add(groupResMap);
        }
        logger.info(String.format("CityListUtil getCityData method query time is %sms", System.currentTimeMillis() - start));
        return cityGroups;
    }

    private static Map<Object, DynamicObject> getCityDynamicObjectById(boolean isDomestic, List<Long> hotCityIds) {
        QFilter filter = new QFilter(IS_CITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        QFilter idFilter = new QFilter(ID, "in", hotCityIds);
        QFilter domesticFilter = isDomestic ? new QFilter(COUNTRY, "=", (Object)CityListUtil.getDefaultCountryId()) : new QFilter(COUNTRY, "<>", (Object)CityListUtil.getDefaultCountryId());
        return BusinessDataReader.loadFromCache((String)ENTITY_BD_ADMINDIVISION, (String)"name,number,country,simplespell,parent", (QFilter[])new QFilter[]{idFilter, filter, enableFilter, domesticFilter});
    }

    private static Map<Object, DynamicObject> getCityDynamicObject(boolean isDomestic) {
        QFilter filter = new QFilter(IS_CITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        QFilter domesticFilter = isDomestic ? new QFilter(COUNTRY, "=", (Object)CityListUtil.getDefaultCountryId()) : new QFilter(COUNTRY, "<>", (Object)CityListUtil.getDefaultCountryId());
        List prop = Stream.of(NAME, NUMBER, COUNTRY, SIMPLESPELL, PARENT).collect(Collectors.toList());
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)ENTITY_BD_ADMINDIVISION, prop);
        ArrayList listIds = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("CityListUtil.getCityDynamicObject", ENTITY_BD_ADMINDIVISION, ID, new QFilter[]{filter, enableFilter, domesticFilter}, "id asc", 10000);){
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        return BusinessDataReader.loadFromCache((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
    }

    private static String getLike() {
        String cp = "like";
        String tenantId = RequestContext.get().getTenantId();
        if (DB.getDBType((DBRoute)DBRoute.meta) == DBType.PostgreSQL && "TRUE".equalsIgnoreCase(SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)tenantId))) {
            cp = "ilike";
        }
        return cp;
    }

    public static List<Map<String, Object>> getSearchData(String keyword) {
        long start = System.currentTimeMillis();
        List<Map<String, Object>> searchCityList = new ArrayList(10);
        QFilter filter = new QFilter(IS_CITY, "=", (Object)YES);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)YES);
        QFilter simpleSpellLikeFilter = new QFilter(SIMPLESPELL, CityListUtil.getLike(), (Object)(LIKE_SIGN + keyword + LIKE_SIGN));
        QFilter fullSpellLikeFilter = new QFilter(FULLSPELL, CityListUtil.getLike(), (Object)(LIKE_SIGN + keyword + LIKE_SIGN));
        QFilter nameLikeFilter = new QFilter(NAME, CityListUtil.getLike(), (Object)(LIKE_SIGN + keyword + LIKE_SIGN));
        QFilter propLikeFilter = simpleSpellLikeFilter.or(fullSpellLikeFilter).or(nameLikeFilter);
        DynamicObject[] dynamicObjects = BusinessDataReader.loadFromCache((String)ENTITY_BD_ADMINDIVISION, (QFilter[])new QFilter[]{filter, enableFilter, propLikeFilter}).values().toArray(new DynamicObject[0]);
        Map<Object, Object> chinaProvinceCityMap = new HashMap(16);
        if (dynamicObjects.length != 0) {
            chinaProvinceCityMap = CityListUtil.getChinaProvinceAndCity(Arrays.stream(dynamicObjects).map(x -> x.getLong(ID)).collect(Collectors.toList()));
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject countryDy = (DynamicObject)dynamicObject.get(COUNTRY);
            if (countryDy == null) continue;
            Long countryId = (Long)countryDy.getPkValue();
            HashMap<String, String> cityMap = new HashMap<String, String>(16);
            cityMap.put(ID, dynamicObject.getString(ID));
            cityMap.put(NAME, dynamicObject.getString(NAME));
            String province = (String)chinaProvinceCityMap.get(dynamicObject.getString(NUMBER));
            cityMap.put(PROVINCE, province != null ? province : "");
            cityMap.put(ILID, countryId.toString());
            cityMap.put(COUNTRY_NAME, countryDy.getString(NAME));
            String parentName = dynamicObject.getDynamicObject(PARENT) == null ? "" : dynamicObject.getDynamicObject(PARENT).getString(NAME);
            cityMap.put(LAST_DIVISION, parentName);
            cityMap.put("jp", dynamicObject.getString(SIMPLESPELL));
            cityMap.put("qp", dynamicObject.getString(FULLSPELL));
            searchCityList.add(cityMap);
        }
        if ((searchCityList = CitySortUtil.sortCityList(searchCityList, (String)keyword)).size() > 500) {
            logger.info(String.format("CityListUtil getSearchData method query time is %sms", System.currentTimeMillis() - start));
            return searchCityList.subList(0, 500);
        }
        logger.info(String.format("CityListUtil getSearchData method query time is %sms", System.currentTimeMillis() - start));
        return searchCityList;
    }

    public static List<Map<String, Object>> getHotCityData(boolean isDomestic, boolean isCommon, List<Long> freqCitiesList) {
        Map<Object, DynamicObject> cityDynamicObject;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        List<Long> hotCityIds = freqCitiesList;
        if (!isCommon) {
            hotCityIds.addAll(Arrays.asList(123L, 2675L, 383L, 407L, 2818L, 2216L, 2933L, 3534L));
        }
        if (CollectionUtils.isEmpty(cityDynamicObject = CityListUtil.getCityDynamicObjectById(isDomestic, hotCityIds))) {
            return result;
        }
        List<Long> ids = cityDynamicObject.values().stream().map(x -> x.getLong(ID)).collect(Collectors.toList());
        Map<String, String> chinaProvinceCityMap = CityListUtil.getChinaProvinceAndCity(ids);
        List<Long> noProvinceCityIds = Arrays.asList(123L, 2675L, 141L, 3134L);
        Long defaultCountryId = CityListUtil.getDefaultCountryId();
        for (DynamicObject dynamicObject : cityDynamicObject.values()) {
            DynamicObject countryDy = (DynamicObject)dynamicObject.get(COUNTRY);
            if (countryDy == null) continue;
            Long countryId = (Long)countryDy.getPkValue();
            Long cityId = dynamicObject.getLong(ID);
            if (countryId == null || !(isDomestic ? countryId.equals(defaultCountryId) : !countryId.equals(defaultCountryId)) || !hotCityIds.contains(cityId)) continue;
            HashMap<String, String> cityDetail = new HashMap<String, String>();
            cityDetail.put(ID, cityId.toString());
            cityDetail.put(NAME, dynamicObject.getString(NAME));
            String province = chinaProvinceCityMap.get(dynamicObject.getString(NUMBER));
            if (noProvinceCityIds.contains(cityId)) {
                province = "";
            }
            cityDetail.put(COUNTRY_NAME, countryDy.getString(NAME));
            cityDetail.put(PROVINCE, province != null ? province : "");
            cityDetail.put(ILID, countryId.toString());
            String parentName = dynamicObject.getDynamicObject(PARENT) == null ? "" : dynamicObject.getDynamicObject(PARENT).getString(NAME);
            cityDetail.put(LAST_DIVISION, parentName);
            result.add(cityDetail);
        }
        return result;
    }

    private static HashMap<String, Object> reducePageCity(int dataPerPage, String gr, String lastCityId, Map<String, List<Map<String, Object>>> groupMap, Lang lang) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        List<Map<String, Object>> cityList = groupMap.get(gr);
        resMap.put(GR, gr);
        if (CollectionUtils.isEmpty(cityList)) {
            resMap.put(HAS_MORE, false);
            resMap.put(CLG, Collections.EMPTY_LIST);
            return resMap;
        }
        CityListUtil.sortCityList(lang, cityList);
        List cityIds = cityList.stream().map(map -> map.get(ID).toString()).collect(Collectors.toList());
        int lastIndex = cityIds.indexOf(lastCityId);
        int listEndIndex = cityList.size() - 1;
        if (lastIndex == listEndIndex) {
            resMap.put(HAS_MORE, false);
            resMap.put(CLG, Collections.EMPTY_LIST);
            return resMap;
        }
        int endIndex = lastIndex + 1 + dataPerPage;
        if (endIndex < cityList.size()) {
            resMap.put(HAS_MORE, true);
            resMap.put(CLG, cityList.subList(lastIndex + 1, endIndex));
        } else {
            resMap.put(HAS_MORE, false);
            resMap.put(CLG, cityList.subList(lastIndex + 1, cityList.size()));
        }
        return resMap;
    }

    private static Map<String, List<Map<String, Object>>> getGroupCity(List<Long> noProvinceCityIds, Map<Object, DynamicObject> dynamicObjectMap) {
        HashMap<String, List<Map<String, Object>>> groupMap = new HashMap<String, List<Map<String, Object>>>(16);
        List<Long> ids = dynamicObjectMap.values().stream().map(x -> x.getLong(ID)).collect(Collectors.toList());
        Map<String, String> chinaProvinceCityMap = CityListUtil.getChinaProvinceAndCity(ids);
        String defaultCountryId = CityListUtil.getDefaultCountryId().toString();
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            String province;
            DynamicObject countryDy;
            String group;
            String simpleSpell = StringUtils.deleteWhitespace((String)dynamicObject.getString(SIMPLESPELL));
            if (StringUtils.isBlank((CharSequence)simpleSpell) || (group = CityListUtil.getGroupStr(simpleSpell, dynamicObject.getString(NAME))) == null || (countryDy = (DynamicObject)dynamicObject.get(COUNTRY)) == null) continue;
            ArrayList cities = (ArrayList)groupMap.get(group);
            if (CollectionUtils.isEmpty((Collection)cities)) {
                cities = new ArrayList(16);
                groupMap.put(group, cities);
            }
            HashMap<String, String> cityDetail = new HashMap<String, String>(16);
            String cityId = dynamicObject.getString(ID);
            cityDetail.put(ID, cityId);
            cityDetail.put(NAME, dynamicObject.getString(NAME));
            String number = dynamicObject.getString(NUMBER);
            String string = province = chinaProvinceCityMap.get(number) == null ? "" : chinaProvinceCityMap.get(number);
            if (noProvinceCityIds.contains(Long.valueOf(cityId))) {
                province = "";
            }
            cityDetail.put(PROVINCE, province);
            String countryId = countryDy.getPkValue().toString();
            cityDetail.put(ILID, countryId);
            if (defaultCountryId.equals(countryId)) {
                cityDetail.put(COUNTRY_NAME, "");
            } else {
                cityDetail.put(COUNTRY_NAME, countryDy.getString(NAME));
            }
            String parentName = dynamicObject.getDynamicObject(PARENT) == null ? "" : dynamicObject.getDynamicObject(PARENT).getString(NAME);
            cityDetail.put(LAST_DIVISION, parentName);
            cities.add(cityDetail);
        }
        return groupMap;
    }

    private static void sortCityList(Lang lang, List<Map<String, Object>> cityList) {
        if (CollectionUtils.isEmpty(cityList)) {
            return;
        }
        if (lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
            cityList.sort((o1, o2) -> {
                String name1 = CityListUtil.getPinYinStr((String)o1.get(NAME));
                String name2 = CityListUtil.getPinYinStr((String)o2.get(NAME));
                return name1.compareTo(name2);
            });
        } else {
            cityList.sort((o1, o2) -> {
                String name1 = (String)o1.get(NAME);
                String name2 = (String)o2.get(NAME);
                return name1.compareTo(name2);
            });
        }
    }

    private static Map<String, String> getChinaProvinceAndCity(List<Long> ids) {
        QFilter filter = new QFilter(IS_CITY, "=", (Object)YES);
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)CityListUtil.getDefaultCountryId());
        QFilter idsFilter = new QFilter(ID, "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataReader.loadFromCache((String)ENTITY_BD_ADMINDIVISION, (String)"number,longnumber", (QFilter[])new QFilter[]{idsFilter, filter, countryFilter}).values().toArray(new DynamicObject[0]);
        HashMap<String, String> provinceCityMap = new HashMap<String, String>(16);
        for (DynamicObject object : dynamicObjects) {
            String string = object.getString(NUMBER);
            String longNumber = object.getString(LONGNUMBER);
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            String provinceNumber = "";
            if (longNumber.contains("!")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)"!");
            } else if (longNumber.contains(".")) {
                provinceNumber = StringUtils.substringBefore((String)longNumber, (String)".");
            }
            if (!StringUtils.isNotEmpty((CharSequence)provinceNumber) || string.equals(provinceNumber)) continue;
            provinceCityMap.put(string, provinceNumber);
        }
        QFilter provincesFilter = new QFilter(NUMBER, "in", provinceCityMap.values());
        DynamicObject[] provinces = BusinessDataReader.loadFromCache((String)ENTITY_BD_ADMINDIVISION, (String)"name,number", (QFilter[])provincesFilter.toArray()).values().toArray(new DynamicObject[0]);
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (DynamicObject province : provinces) {
            String number = province.getString(NUMBER);
            String name = province.getString(NAME);
            map.put(number, name);
        }
        for (Map.Entry entry : provinceCityMap.entrySet()) {
            String provinceNumber = (String)entry.getValue();
            entry.setValue(map.get(provinceNumber));
        }
        return provinceCityMap;
    }

    private static String getGroupStr(String simpleSpell, String name) {
        Lang lang = RequestContext.get().getLang();
        if (lang.equals((Object)Lang.en_US) || lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW)) {
            return CityListUtil.getFirstAlphaFormStr(name, simpleSpell);
        }
        return Character.toString(simpleSpell.charAt(0)).toUpperCase();
    }

    private static String getPinYinStr(String input) {
        char[] arr;
        if (input == null || "".equals(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : arr = input.toCharArray()) {
            try {
                String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                if (temp.length > 0) {
                    sb.append(temp[0]);
                    continue;
                }
                sb.append(c);
            }
            catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static String getFirstAlphaFormStr(String input, String simpleSpell) {
        if (input != null && input.toCharArray().length > 0) {
            char firstChar = input.charAt(0);
            if (CityListUtil.isAlpha(firstChar)) {
                return Character.toString(firstChar).toUpperCase();
            }
            if (CityListUtil.isHan(firstChar)) {
                HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
                defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
                defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)firstChar, (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp.length > 1) {
                        return Character.toString(simpleSpell.charAt(0)).toUpperCase();
                    }
                    return temp[0].toUpperCase().substring(0, 1);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return String.valueOf(firstChar);
        }
        return null;
    }

    private static boolean isHan(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static Long getDefaultCountryId() {
        Object defaultcountry = CityListUtil.callStaticMethod("kd.bos.servicehelper.parameter.SystemParamServiceHelper", "loadPublicParameterFromCache", new Object[]{"defaultcountry"}, String.class);
        if (defaultcountry != null) {
            Map defaultCountryMap = (Map)defaultcountry;
            return Long.valueOf(defaultCountryMap.get(ID).toString());
        }
        return CHINA_COUNTRY_ID;
    }

    public static Object callStaticMethod(String className, String methodName, Object[] param, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            return method.invoke(null, param);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9ed8\u8ba4\u56fd\u5bb6\u6216\u5730\u533a\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    static {
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

