/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFieldMeta;
import kd.bos.permission.api.FieldControlRule;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DynamicTextListColumn
extends AbstractListColumn {
    List<ListFieldMeta> listFieldMetas = new ArrayList<ListFieldMeta>();
    String formatExpression;

    @CollectionPropertyAttribute(collectionItemPropertyType=ListFieldMeta.class)
    public List<ListFieldMeta> getListFieldMetas() {
        return this.listFieldMetas;
    }

    public void setListFieldMetas(List<ListFieldMeta> listFieldMetas) {
        this.listFieldMetas = listFieldMetas;
    }

    @SimplePropertyAttribute
    public String getFormatExpression() {
        return this.formatExpression;
    }

    public void setFormatExpression(String formatExpression) {
        this.formatExpression = formatExpression;
    }

    public DynamicTextListColumn() {
    }

    public DynamicTextListColumn(String key, LocaleString caption, List<ListFieldMeta> listFieldMetas, String formatExpression) {
        this.key = key;
        this.setCaption(caption);
        this.listFieldMetas = listFieldMetas;
        this.formatExpression = formatExpression;
    }

    protected String getBizType() {
        return "largeText";
    }

    private IListColumn getListColumn(String key) {
        for (Control item : this.getParent().getItems()) {
            if (!(item instanceof IListColumn) || ((IListColumn)item).getListFieldKey() == null || !((IListColumn)item).getListFieldKey().equals(key)) continue;
            return (IListColumn)item;
        }
        return null;
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        ArrayList<ListField> listFields = new ArrayList<ListField>(10);
        for (ListFieldMeta listFieldMeta : this.getListFieldMetas()) {
            String key = listFieldMeta.getKey();
            if (!fieldSet.containsKey(listFieldMeta.getKey())) {
                Object listColumn = this.getListColumn(listFieldMeta.getKey());
                if (listColumn != null) {
                    listColumn.addFieldSet(fieldSet, entityType, withoutDetailEntry, isListShowParameter, isLookUp);
                    if (listColumn instanceof AbstractListColumn) {
                        key = ((AbstractListColumn)listColumn).getFieldKey();
                    }
                } else {
                    FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)listFieldMeta.getKey());
                    if (filterField == null) {
                        throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getListFieldKey(), "FIELDNOTEXISTS000017")});
                    }
                    listColumn = filterField.getFieldProp() instanceof AmountProp || filterField.getFieldProp() instanceof QtyProp ? new DecimalListColumn() : new ListColumn();
                    listColumn.setListFieldKey(listFieldMeta.getKey());
                    listColumn.setContext(this.getContext());
                    listColumn.addFieldSet(fieldSet, entityType, withoutDetailEntry, isListShowParameter, isLookUp);
                }
            }
            ListField listField = fieldSet.get(key);
            if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
                this.setHeaderField(!(listField.getSrcFieldProp().getParent() instanceof EntryType));
                this.setEntityName(listField.getSrcFieldProp().getParent().getName());
            }
            listFields.add(listField);
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.setHeaderField(true);
            this.setEntityName(entityType.getName());
        }
        DynamicTextListField dynamicTextListField = new DynamicTextListField(this.getKey(), listFields, this.formatExpression);
        dynamicTextListField.setEntityName(this.getEntityName());
        fieldSet.put(this.getKey(), (ListField)dynamicTextListField);
    }

    protected String getFieldKey() {
        return this.key;
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        for (ListFieldMeta listFieldMeta : this.getListFieldMetas()) {
            if (!fieldControlRule.getCanNotReadFields().contains(listFieldMeta.getKey().split("\\.")[0])) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map ctl = super.createColumn(entityType);
        ctl.put("sort", false);
        ctl.put("filter", false);
        return ctl;
    }

    public Map<String, Object> getListColumnConfigMap(MainEntityType entityType) {
        Map listColumnConfigMap = super.getListColumnConfigMap(entityType);
        listColumnConfigMap.put("listFieldKey", this.getKey());
        return listColumnConfigMap;
    }

    public Map<String, Object> getFactoryConfigColumnSetting() {
        Map factoryConfigColumnSetting = super.getFactoryConfigColumnSetting();
        factoryConfigColumnSetting.put("listFieldKey", this.getKey());
        return factoryConfigColumnSetting;
    }

    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        return new ArrayList<Map<String, Object>>(0);
    }
}

