/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.container.Container;
import kd.bos.list.BillList;
import kd.bos.list.ExtendedFlexDimensions;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.IListColumnGroupConfig;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListColumnGroupConfigUtil;
import kd.bos.list.ListFlexDimension;
import kd.bos.list.ListGridView;
import kd.bos.utils.SortUtil;

public class FlexListColumn
extends ListColumn
implements IListColumnGroupConfig {
    private MainEntityType dataEntityType;
    private boolean expand;
    private boolean defaultSplit;
    private int flexMaxShow = 20;
    private List<String> showDimissions = new ArrayList<String>(10);
    private ExtendedFlexDimensions extendedFlexDimensions;

    public void addShowDimission(String showDimission) {
        if (StringUtils.isNotBlank((CharSequence)showDimission)) {
            this.showDimissions.add(showDimission);
        }
    }

    public void setShowDimissions(List<String> showDimissions) {
        this.showDimissions = showDimissions;
    }

    @SimplePropertyAttribute(name="Expand")
    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    @SimplePropertyAttribute(name="DefaultSplit")
    public boolean isDefaultSplit() {
        return this.defaultSplit;
    }

    public void setDefaultSplit(boolean defaultSplit) {
        this.defaultSplit = defaultSplit;
    }

    @SimplePropertyAttribute(name="FlexMaxShow")
    public int getFlexMaxShow() {
        return this.flexMaxShow;
    }

    public void setFlexMaxShow(int flexMaxShow) {
        this.flexMaxShow = flexMaxShow;
    }

    private void createEntityType() {
        this.dataEntityType = new MainEntityType();
        this.dataEntityType.setName("FlexListColumn_" + this.getKey());
    }

    private MainEntityType getEntityType() {
        if (this.dataEntityType == null) {
            this.createEntityType();
        }
        return this.dataEntityType;
    }

    void setExtendedFlexDimensions(ExtendedFlexDimensions extendedFlexDimensions) {
        this.extendedFlexDimensions = extendedFlexDimensions;
        for (IListColumnConfig listColumnConfig : extendedFlexDimensions.getFlexPropList()) {
            listColumnConfig.setUserConfigColumnSettings(this.getUserConfigColumnSettings());
        }
    }

    ExtendedFlexDimensions getExtendedFlexDimensions() {
        return this.extendedFlexDimensions;
    }

    boolean isSplit() {
        Object flexset = this.getUserConfigColumnSettings() != null ? this.getUserConfigColumnSettings().get("flexset") : null;
        return this.isExpand() && (flexset == null && this.isDefaultSplit() || "1".equals(flexset));
    }

    void extendFlexFields(EntityType entityType) {
        if (!this.isSplit()) {
            return;
        }
        this.extendFlexFieldsWithoutOption(entityType);
    }

    void extendFlexFieldsWithoutOption(EntityType entityType) {
        FlexProp flexProp = null;
        FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)this.getListFieldKey());
        if (filterField != null && filterField.getSrcFieldProp() instanceof FlexProp) {
            flexProp = (FlexProp)filterField.getSrcFieldProp();
        }
        if (flexProp == null || StringUtils.isBlank((CharSequence)flexProp.getBasePropertyKey())) {
            return;
        }
        this.extendedFlexDimensions = new ExtendedFlexDimensions(this.getListFieldKey());
        this.extendedFlexDimensions.setRegisterPropertyListeners(flexProp.extendFlexProperties(entityType.getName() + "_" + this.getKey(), registerFlexPropertyArgs -> {
            this.dataEntityType = registerFlexPropertyArgs.getEntityType();
            if (registerFlexPropertyArgs.getBaseProp() != null) {
                BasedataEntityType type = (BasedataEntityType)registerFlexPropertyArgs.getBaseProp().getComplexType();
                String displayProp = ((BasedataProp)registerFlexPropertyArgs.getDataEntityProperty()).getDisplayProp();
                String[] displayPropNames = displayProp.split(",");
                ArrayList<String> localNameList = new ArrayList<String>(displayPropNames.length);
                for (String displayPropName : displayPropNames) {
                    DynamicProperty property;
                    if ("name".equalsIgnoreCase(displayPropName)) {
                        String realNameProp = type.getNameProperty();
                        property = type.getProperty(realNameProp);
                    } else if ("number".equalsIgnoreCase(displayPropName)) {
                        String realNumberProp = type.getNumberProperty();
                        property = type.getProperty(realNumberProp);
                    } else {
                        property = (IDataEntityProperty)type.getProperties().get((Object)displayPropName);
                    }
                    if (property == null) continue;
                    localNameList.add(property.getDisplayName().getLocaleValue());
                }
                String localNames = String.join((CharSequence)",", localNameList);
                String name = String.format("%s.%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), registerFlexPropertyArgs.getBaseProp(), type.getNameProperty());
                LocaleString displayName = new LocaleString(String.format("%s.%s", registerFlexPropertyArgs.getBaseProp().getDisplayName(), localNames));
                this.createListFlexDimension(this.getEntityName(), registerFlexPropertyArgs.getDataEntityProperty(), name, displayName, "basedata");
            } else {
                String name = String.format("%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), "value");
                LocaleString displayName = registerFlexPropertyArgs.getDimensionProp().getDisplayName();
                this.createListFlexDimension(this.getEntityName(), registerFlexPropertyArgs.getDataEntityProperty(), name, displayName, "text");
            }
        }));
    }

    private void createListFlexDimension(String entryEntity, IDataEntityProperty dataEntityProperty, String name, LocaleString displayName, String type) {
        ListFlexDimension listFlexDimension = new ListFlexDimension(dataEntityProperty, name, entryEntity, displayName, type);
        this.extendedFlexDimensions.getFlexPropList().add(listFlexDimension);
        FilterField filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)name);
        this.extendedFlexDimensions.getFilterFields().put(filterField.getFieldName(), filterField);
    }

    @Override
    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        super.addFieldSet(fieldSet, entityType, withoutDetailEntry, isListShowParameter, isLookUp);
        FlexProp flexProp = (FlexProp)this.srcFieldProp;
        if (withoutDetailEntry && this.srcFieldProp != null && this.srcFieldProp.getParent() instanceof EntryType) {
            return;
        }
        if (flexProp != null && StringUtils.isNotBlank((CharSequence)flexProp.getBasePropertyKey())) {
            BasedataProp basedataProp = (BasedataProp)entityType.findProperty(flexProp.getBasePropertyKey());
            String baseDataFieldId = String.format("%s.%s", flexProp.getBasePropertyKey(), basedataProp.getComplexType().getPrimaryKey().getName());
            FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)flexProp.getBasePropertyKey());
            if (filterField != null) {
                ListField baseDataListField = fieldSet.get(baseDataFieldId);
                ListField controlListField = new ListField(baseDataFieldId);
                controlListField.setFieldName(filterField.getFullFieldName());
                controlListField.setEntityName(filterField.getEntityKey());
                controlListField.setSrcFieldProp(filterField.getSrcFieldProp());
                if (baseDataListField == null) {
                    fieldSet.put(baseDataFieldId, controlListField);
                }
                ListField listField = fieldSet.get(this.getFieldKey());
                listField.setControlField(controlListField);
            }
        }
    }

    private List<Object> createColumns(MainEntityType entityType, Map<String, FilterField> filterFields) {
        ArrayList<Object> cols = new ArrayList<Object>(10);
        HashMap<String, List<CompareType>> fieldCompareTypeMap = new HashMap(16);
        Container container = this.getParent();
        if (container instanceof ListGridView) {
            BillList billList = ((ListGridView)container).getParent();
            fieldCompareTypeMap = billList.getContext().getFieldCompareTypeMap();
        } else if (container instanceof ListColumnGroup) {
            fieldCompareTypeMap = ((ListColumnGroup)container).getFieldCompareTypeMap();
        }
        Map childItemSetting = ListColumnGroupConfigUtil.getChildItemSetting(new ArrayList(10), (Map)this.getUserConfigColumnSettings());
        ArrayList<String> designListColumnKeys = new ArrayList<String>(10);
        ArrayList<String> userListColumnKeys = new ArrayList<String>(10);
        List items = null;
        if (this.getUserConfigColumnSettings() != null) {
            items = (List)this.getUserConfigColumnSettings().get("items");
        }
        if (items != null) {
            for (Map item : items) {
                userListColumnKeys.add(item.get("listFieldKey").toString());
            }
        }
        ArrayList<ListFlexDimension> listFlexDimensions = new ArrayList<ListFlexDimension>(this.getFlexMaxShow());
        int i = 0;
        for (IListColumnConfig listFlexDimension : this.extendedFlexDimensions.getFlexPropList()) {
            if (i < this.getFlexMaxShow()) {
                designListColumnKeys.add(listFlexDimension.getListFieldKey());
            }
            ++i;
        }
        List sortListColumnKeys = SortUtil.sortListByKeys(userListColumnKeys, userListColumnKeys.isEmpty() ? designListColumnKeys : userListColumnKeys);
        for (IListColumnConfig iListColumnConfig : this.extendedFlexDimensions.getFlexPropList()) {
            if (!(iListColumnConfig instanceof ListFlexDimension)) continue;
            ListFlexDimension listFlexDimension = (ListFlexDimension)iListColumnConfig;
            if (sortListColumnKeys.contains(iListColumnConfig.getListFieldKey())) {
                listFlexDimensions.add(listFlexDimension);
                listFlexDimension.setSeq(sortListColumnKeys.indexOf(listFlexDimension.getListFieldKey()));
                continue;
            }
            listFlexDimension.setSeq(-1);
        }
        Collections.sort(listFlexDimensions, (o1, o2) -> Integer.compare(o1.getSeq(), o2.getSeq()));
        for (IListColumnConfig iListColumnConfig : listFlexDimensions) {
            if (!this.showDimissions.isEmpty() && (this.showDimissions.isEmpty() || !this.showDimissions.contains(iListColumnConfig.getListFieldKey()))) continue;
            ListColumnGroupConfigUtil.setListColumnGroupSetting((Map)childItemSetting, (IListColumnConfig)iListColumnConfig);
            cols.add(((ListFlexDimension)iListColumnConfig).createColumn(entityType, filterFields, this.isColumnFilter(), fieldCompareTypeMap));
        }
        return cols;
    }

    @Override
    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map<String, Object> ctl = super.createColumn(entityType);
        ctl.put("sort", false);
        ctl.put("filter", false);
        if (this.isSplit()) {
            ctl.put("children", this.createColumns(entityType, this.extendedFlexDimensions.getFilterFields()));
        }
        return ctl;
    }

    public List<IListColumnConfig> getListColumnConfigList() {
        List<IListColumnConfig> flexPropList = this.extendedFlexDimensions.getFlexPropList();
        for (int i = 0; i < flexPropList.size(); ++i) {
            if (i < this.getFlexMaxShow()) continue;
            flexPropList.get(i).setVisible(0);
        }
        return flexPropList;
    }

    public Map<String, Object> getListColumnConfigMap(MainEntityType entityType) {
        Map listColumnConfigMap;
        if (this.isSplit()) {
            listColumnConfigMap = super.getListColumnConfigMap(entityType);
            listColumnConfigMap.put("flexset", "1");
        } else {
            listColumnConfigMap = super.getListColumnConfigMap(entityType);
            if (this.isExpand()) {
                listColumnConfigMap.put("flexset", "0");
                if (this.getUserConfigColumnSettings() != null) {
                    Map baseListColumnConfigMap = super.getListColumnConfigMap(entityType);
                    listColumnConfigMap.put("items", baseListColumnConfigMap.get("items"));
                }
            }
        }
        listColumnConfigMap.put("isDefaultSplit", this.isDefaultSplit());
        this.hideBackFields(entityType, listColumnConfigMap);
        return listColumnConfigMap;
    }

    public Map<String, Object> getFactoryConfigColumnSetting() {
        if (this.isExpand()) {
            Map factoryConfigColumnSetting = super.getFactoryConfigColumnSetting();
            factoryConfigColumnSetting.put("isDefaultSplit", this.isDefaultSplit());
            factoryConfigColumnSetting.put("flexMaxShow", String.valueOf(this.getFlexMaxShow()));
            factoryConfigColumnSetting.put("showDimissions", this.showDimissions);
            return factoryConfigColumnSetting;
        }
        return super.getFactoryConfigColumnSetting();
    }

    @Override
    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        return new ArrayList<Map<String, Object>>(0);
    }
}

