/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.TimeoutSummaryResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.ControlTypes;
import kd.bos.form.IPageCache;
import kd.bos.list.FieldSort;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.events.ListColumnFilterCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.sdk.annotation.SdkInternal;
import org.jetbrains.annotations.NotNull;

@SdkInternal
public class ListCache {
    private static final int REDISBATCHSIZE = 1000;
    private static final String LISTCACHE_HFF = "listcache_hff";
    private static final String TWO_PLACEHOLDER = "%s_%s";
    private static final String APPENDING_LIST_COLUMN_FILTERS = "appendingListColumnFilters";
    private static final String CARD_SELECT_STATUS = "cardSelectStatus";
    private Map<String, String> cacheMap = null;
    private IPageCache pageCache;
    private String preKey;
    private static final String LISTVIEWFILTERCACHEKEY = "lvf";
    private FilterParameter listViewFilterParameter = null;
    private static final String MOBILESEARCHFILTERCACHEKEY = "ms";
    private FilterParameter mobileSearchFilterParameter = null;
    private static final String MOBFILTERSORTFILTERCACHEKEY = "mfs";
    private FilterParameter mobFilterSortFilterParameter = null;
    private static final String MOB_SCHEME_QUERY_FILTER_CACHE_KEY = "msqf";
    private FilterParameter mobSchemeQueryFilterParameter = null;
    private static final String TREELISTFILTERCACHEKEY = "tlf";
    private static final String TREEROOTLISTFILTERCACHEKEY = "trlf";
    private FilterParameter treeListFilterParameter = null;
    private FilterParameter treeRootListFilterParameter = null;
    private LocaleString filterContainerTitle;
    private FilterContainerFilterValues cachedFilterValues;
    Map<String, Object> selectedValues = new HashMap<String, Object>();
    private String isMultiString = null;
    private String isDefaultOrderString = null;
    private Set<String> headerSelectFields = null;
    private Set<String> headerSelectFieldsWithNotCompare = null;
    private ListSelectedRowCollection noHeaderFilterListAllSelectedRows;
    ListSelectedRowCollection currentListAllSelectedRows;
    ListSelectedRowCollection cachedSelectedRows;
    ListSelectedRowCollection cachedNotSelectedRows;
    private ListSelectedRowCollection currentCachedSelectedRows;
    ListSelectedRowCollection appendCachedSelectedRows;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        private static final long serialVersionUID = 1L;
        private SimpleDateFormat shortSDF;
        {
            this.shortSDF = new SimpleDateFormat("yyyy-MM-dd");
        }

        @Override
        public Date parse(String source) throws ParseException {
            if (source == null) {
                return null;
            }
            if (source.length() <= 10) {
                return this.shortSDF.parse(source);
            }
            return super.parse(source);
        }
    };
    private Boolean isDesignNewFitler;
    private Optional<Boolean> isNewFitler = Optional.empty();
    private Optional<Integer> filterMode = Optional.empty();
    private boolean cardSelectStatus;

    public ListCache(IPageCache pageCache) {
        this(pageCache, "");
    }

    public ListCache(IPageCache pageCache, String preKey) {
        this.pageCache = pageCache;
        this.cacheMap = pageCache.getAll();
        this.preKey = preKey;
    }

    private Map<String, String> getCacheMap() {
        if (this.cacheMap == null) {
            this.cacheMap = this.pageCache.getAll();
        }
        return this.cacheMap;
    }

    public void savePageCache() {
        if (this.cacheMap != null && !this.cacheMap.isEmpty()) {
            this.pageCache.put(this.cacheMap);
            this.cacheMap = null;
        }
    }

    void savePageCacheImmediately() {
        if (this.cacheMap != null && !this.cacheMap.isEmpty()) {
            this.pageCache.put(this.cacheMap);
            this.pageCache.saveChanges();
            this.cacheMap = null;
        }
    }

    @NotNull
    private String getListViewFilterParameterKey() {
        return this.preKey + LISTVIEWFILTERCACHEKEY;
    }

    public FilterParameter getListViewFilterParameter() {
        if (this.listViewFilterParameter == null && this.getCacheMap().get(this.getListViewFilterParameterKey()) != null) {
            this.listViewFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(this.getListViewFilterParameterKey()));
        }
        if (this.listViewFilterParameter == null) {
            this.listViewFilterParameter = new FilterParameter();
        }
        return this.listViewFilterParameter;
    }

    public void setListViewFilterParameter(FilterParameter listViewFilterParameter) {
        this.listViewFilterParameter = listViewFilterParameter;
        String listViewFilterParameterKey = this.getListViewFilterParameterKey();
        String s1 = this.getCacheMap().get(listViewFilterParameterKey);
        String s = ControlTypes.toJsonString((Object)listViewFilterParameter);
        this.setListViewFilterParameterChanged(!s.equals(s1));
        this.getCacheMap().put(listViewFilterParameterKey, ControlTypes.toJsonString((Object)listViewFilterParameter));
    }

    private String getListViewFilterParameterChangedKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "lvfp_c");
    }

    boolean isListViewFilterParameterChanged() {
        String s = this.getCacheMap().get(this.getIsClientQueryFilterParameterChangedKey());
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    void setListViewFilterParameterChanged(boolean isChanged) {
        this.getCacheMap().put(this.getIsClientQueryFilterParameterChangedKey(), Boolean.toString(isChanged));
    }

    public FilterParameter getMobileSearchFilterParameter() {
        if (this.mobileSearchFilterParameter == null && this.getCacheMap().get(MOBILESEARCHFILTERCACHEKEY) != null) {
            this.mobileSearchFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(MOBILESEARCHFILTERCACHEKEY));
        }
        if (this.mobileSearchFilterParameter == null) {
            this.mobileSearchFilterParameter = new FilterParameter();
        }
        return this.mobileSearchFilterParameter;
    }

    public void setMobileSearchFilterParameter(FilterParameter mobileSearchFilterParameter) {
        this.mobileSearchFilterParameter = mobileSearchFilterParameter;
        this.getCacheMap().put(MOBILESEARCHFILTERCACHEKEY, ControlTypes.toJsonString((Object)mobileSearchFilterParameter));
    }

    public FilterParameter getMobFilterSortFilterParameter() {
        if (this.mobFilterSortFilterParameter == null && this.getCacheMap().get(MOBFILTERSORTFILTERCACHEKEY) != null) {
            this.mobFilterSortFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(MOBFILTERSORTFILTERCACHEKEY));
        }
        if (this.mobFilterSortFilterParameter == null) {
            this.mobFilterSortFilterParameter = new FilterParameter();
        }
        return this.mobFilterSortFilterParameter;
    }

    public void setMobFilterSortFilterParameter(FilterParameter mobFilterSortFilterParameter) {
        this.mobFilterSortFilterParameter = mobFilterSortFilterParameter;
        if (mobFilterSortFilterParameter != null) {
            this.getCacheMap().put(MOBFILTERSORTFILTERCACHEKEY, ControlTypes.toJsonString((Object)mobFilterSortFilterParameter));
        }
    }

    public FilterParameter getMobSchemeQueryFilterParameter() {
        if (this.mobSchemeQueryFilterParameter == null && this.getCacheMap().get(MOB_SCHEME_QUERY_FILTER_CACHE_KEY) != null) {
            this.mobSchemeQueryFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(MOB_SCHEME_QUERY_FILTER_CACHE_KEY));
        }
        if (this.mobSchemeQueryFilterParameter == null) {
            this.mobSchemeQueryFilterParameter = new FilterParameter();
        }
        return this.mobSchemeQueryFilterParameter;
    }

    public void setMobSchemeQueryFilterParameter(FilterParameter mobSchemeQueryFilterParameter) {
        this.mobSchemeQueryFilterParameter = mobSchemeQueryFilterParameter;
        if (mobSchemeQueryFilterParameter != null) {
            this.getCacheMap().put(MOB_SCHEME_QUERY_FILTER_CACHE_KEY, ControlTypes.toJsonString((Object)mobSchemeQueryFilterParameter));
        }
    }

    public FilterParameter getTreeListFilterParameter() {
        if (this.treeListFilterParameter == null && this.getCacheMap().get(TREELISTFILTERCACHEKEY) != null) {
            this.treeListFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(TREELISTFILTERCACHEKEY));
        }
        if (this.treeListFilterParameter == null) {
            this.treeListFilterParameter = new FilterParameter();
        }
        return this.treeListFilterParameter;
    }

    public void setTreeListFilterParameter(FilterParameter treeListFilterParameter) {
        this.treeListFilterParameter = treeListFilterParameter;
        this.getCacheMap().put(TREELISTFILTERCACHEKEY, ControlTypes.toJsonString((Object)treeListFilterParameter));
    }

    public FilterParameter getTreeRootListFilterParameter() {
        if (this.treeRootListFilterParameter == null && this.getCacheMap().get(TREEROOTLISTFILTERCACHEKEY) != null) {
            this.treeRootListFilterParameter = (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(TREEROOTLISTFILTERCACHEKEY));
        }
        if (this.treeRootListFilterParameter == null) {
            this.treeRootListFilterParameter = new FilterParameter();
        }
        return this.treeRootListFilterParameter;
    }

    public void setTreeRootListFilterParameter(FilterParameter treeRootListFilterParameter) {
        this.treeRootListFilterParameter = treeRootListFilterParameter;
        this.getCacheMap().put(TREEROOTLISTFILTERCACHEKEY, ControlTypes.toJsonString((Object)treeRootListFilterParameter));
    }

    public LocaleString getFilterContainerTitle() {
        if (this.filterContainerTitle != null) {
            return this.filterContainerTitle;
        }
        String cacheKey = this.preKey + "_fcTitle";
        if (this.getCacheMap().get(cacheKey) != null) {
            this.filterContainerTitle = (LocaleString)SerializationUtils.fromJsonString((String)this.getCacheMap().get(cacheKey), LocaleString.class);
        }
        return this.filterContainerTitle;
    }

    public void setFilterContainerTitle(LocaleString filterContainerTitle) {
        this.filterContainerTitle = filterContainerTitle;
        this.getCacheMap().put(this.preKey + "_fcTitle", SerializationUtils.toJsonString((Object)filterContainerTitle));
    }

    public FilterContainerFilterValues getCachedFilterValues() {
        if (this.cachedFilterValues != null) {
            return this.cachedFilterValues;
        }
        String cacheKey = this.preKey + "_cachedFilterValues";
        if (this.getCacheMap().get(cacheKey) != null) {
            this.cachedFilterValues = FilterContainerFilterValues.deSerialize((String)this.getCacheMap().get(cacheKey));
        }
        if (this.cachedFilterValues == null) {
            this.cachedFilterValues = new FilterContainerFilterValues();
        }
        return this.cachedFilterValues;
    }

    public void setCachedFilterValues(FilterContainerFilterValues cachedFilterValues) {
        this.cachedFilterValues = cachedFilterValues;
        this.getCacheMap().put(this.preKey + "_cachedFilterValues", cachedFilterValues.serialize());
    }

    public Map<String, Object> getSelectedValues() {
        String cacheKey = this.preKey + "_sv";
        if (this.selectedValues.isEmpty() && this.getCacheMap().get(cacheKey) != null) {
            this.selectedValues = (Map)SerializationUtils.deSerializeFromBase64((String)this.getCacheMap().get(cacheKey));
        }
        return this.selectedValues;
    }

    public void setSelectedValues(Map<String, Object> selectedValues) {
        this.selectedValues = selectedValues;
        this.getCacheMap().put(this.preKey + "_sv", SerializationUtils.serializeToBase64(selectedValues));
    }

    private String getFieldMapKey() {
        return this.preKey + "_fk";
    }

    Map<String, String> getFieldKeyMap() {
        return this.getCacheMap().get(this.getFieldMapKey()) == null ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)this.getCacheMap().get(this.getFieldMapKey()), Map.class);
    }

    void putFieldKeyMap(Map<String, String> fieldKeyMap) {
        this.getCacheMap().put(this.getFieldMapKey(), SerializationUtils.toJsonString(fieldKeyMap));
    }

    private String getSelectedMainOrgIdsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "soids");
    }

    public List<Long> getSelectedMainOrgIds() {
        String selectedMainOrgIds = this.getSelectedMainOrgIdsKey();
        if (this.getCacheMap().get(selectedMainOrgIds) != null) {
            return (List)SerializationUtils.deSerializeFromBase64((String)this.getCacheMap().get(selectedMainOrgIds));
        }
        return new ArrayList<Long>(0);
    }

    public void setSelectedMainOrgIds(List<Long> selectedMainOrgIds) {
        this.getCacheMap().put(this.getSelectedMainOrgIdsKey(), SerializationUtils.serializeToBase64(selectedMainOrgIds));
    }

    private String getQueryTypeKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "qt");
    }

    String getQueryType() {
        String queryTypeKey = this.getQueryTypeKey();
        if (this.getCacheMap().get(queryTypeKey) != null) {
            return this.getCacheMap().get(queryTypeKey);
        }
        return "";
    }

    void setQueryType(String queryType) {
        this.getCacheMap().put(this.getQueryTypeKey(), queryType);
    }

    private String getIsMultiKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "im");
    }

    boolean isMulti(boolean isMulti) {
        String isMultiKey = this.getIsMultiKey();
        if (null == this.isMultiString && this.getCacheMap().get(isMultiKey) == null) {
            this.isMultiString = Boolean.toString(isMulti);
            this.pageCache.put(this.getIsMultiKey(), this.isMultiString);
            return isMulti;
        }
        if (null != this.isMultiString) {
            return Boolean.parseBoolean(this.isMultiString);
        }
        return Boolean.parseBoolean(this.getCacheMap().get(isMultiKey));
    }

    private String getIsDefaultOrderKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "do");
    }

    boolean isDefaultOrder(boolean isDefaultOrder) {
        String isDefaultOrderKey = this.getIsDefaultOrderKey();
        if (null == this.isDefaultOrderString && this.getCacheMap().get(isDefaultOrderKey) == null) {
            this.isDefaultOrderString = Boolean.toString(isDefaultOrder);
            this.getCacheMap().put(this.getIsDefaultOrderKey(), this.isDefaultOrderString);
            return isDefaultOrder;
        }
        if (null != this.isDefaultOrderString) {
            return Boolean.parseBoolean(this.isDefaultOrderString);
        }
        return Boolean.parseBoolean(this.getCacheMap().get(isDefaultOrderKey));
    }

    private String getHasFlexFilterKey() {
        return LISTCACHE_HFF;
    }

    public void setHasFlexFilter(boolean hasFlexFilter) {
        this.getCacheMap().put(this.getHasFlexFilterKey(), Boolean.toString(hasFlexFilter));
    }

    public boolean hasFlexFiler() {
        String hasFlexFilterKey = this.getHasFlexFilterKey();
        if (this.getCacheMap().get(hasFlexFilterKey) == null) {
            return false;
        }
        return Boolean.parseBoolean(this.getCacheMap().get(hasFlexFilterKey));
    }

    private String getFieldControlRulesKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "fcr");
    }

    FieldControlRules getFieldControlRules() {
        String fieldControlRulesKey = this.getFieldControlRulesKey();
        if (this.getCacheMap().get(fieldControlRulesKey) != null) {
            return (FieldControlRules)SerializationUtils.fromJsonString((String)this.getCacheMap().get(fieldControlRulesKey), FieldControlRules.class);
        }
        return new FieldControlRules();
    }

    void setFieldControlRules(FieldControlRules fieldControlRules) {
        if (fieldControlRules != null) {
            this.getCacheMap().put(this.getFieldControlRulesKey(), SerializationUtils.toJsonString((Object)fieldControlRules));
        } else {
            this.getCacheMap().put(this.getFieldControlRulesKey(), SerializationUtils.toJsonString((Object)new FieldControlRules()));
        }
    }

    private String getMainOrgQFilterKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "mo");
    }

    QFilter getMainOrgQFilter() {
        String s;
        String mainOrgQFilterKey = this.getMainOrgQFilterKey();
        if (this.getCacheMap().get(mainOrgQFilterKey) != null && !"1".equals(s = this.getCacheMap().get(mainOrgQFilterKey))) {
            return QFilter.fromSerializedString((String)s);
        }
        return null;
    }

    void setMainOrgQFilter(QFilter mainOrgQFilter) {
        if (mainOrgQFilter != null) {
            this.getCacheMap().put(this.getMainOrgQFilterKey(), mainOrgQFilter.toSerializedString());
        } else {
            this.getCacheMap().put(this.getMainOrgQFilterKey(), "1");
        }
    }

    private String getSpecialDataPermQFilterKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "sdpq");
    }

    QFilter getSpecialDataPermQFilter() {
        String s;
        String specialDataPermQFilterKey = this.getSpecialDataPermQFilterKey();
        if (this.getCacheMap().get(specialDataPermQFilterKey) != null && !"1".equals(s = this.getCacheMap().get(specialDataPermQFilterKey))) {
            return QFilter.fromSerializedString((String)s);
        }
        return null;
    }

    void setSpecialDataPermQFilter(QFilter specialDataPermQFilter) {
        if (specialDataPermQFilter != null) {
            this.getCacheMap().put(this.getSpecialDataPermQFilterKey(), specialDataPermQFilter.toSerializedString());
        } else {
            this.getCacheMap().put(this.getSpecialDataPermQFilterKey(), "1");
        }
    }

    private String getDataPermQFiltersKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "dpq");
    }

    List<QFilter> getDataPermQFilters() {
        ArrayList<QFilter> dataPermQFilters = new ArrayList<QFilter>();
        String dataPermQFiltersKey = this.getDataPermQFiltersKey();
        if (this.getCacheMap().get(dataPermQFiltersKey) != null) {
            List qFilterSerialList = SerializationUtils.fromJsonStringToList((String)this.getCacheMap().get(dataPermQFiltersKey), String.class);
            for (String qFilterSerial : qFilterSerialList) {
                dataPermQFilters.add(QFilter.fromSerializedString((String)qFilterSerial));
            }
        }
        return dataPermQFilters;
    }

    void setDataPermQFilters(List<QFilter> dataPermQFilters) {
        ArrayList<String> qFilterSerialList = new ArrayList<String>();
        for (QFilter dataPermQFilter : dataPermQFilters) {
            if (dataPermQFilter == null) continue;
            qFilterSerialList.add(dataPermQFilter.toSerializedString());
        }
        this.getCacheMap().put(this.getDataPermQFiltersKey(), SerializationUtils.toJsonString(qFilterSerialList));
    }

    private String getBillEntityIdKey() {
        return StringUtils.isNotBlank((CharSequence)this.preKey) ? String.format(TWO_PLACEHOLDER, this.preKey, "be") : "be";
    }

    public String getBillEntityId() {
        String billEntityIdKey = this.getBillEntityIdKey();
        if (this.getCacheMap().get(billEntityIdKey) != null) {
            return this.getCacheMap().get(billEntityIdKey);
        }
        return null;
    }

    public void setBillEntityId(String billFormId) {
        this.getCacheMap().put(this.getBillEntityIdKey(), billFormId);
    }

    private String getBillFormIdKey() {
        return StringUtils.isNotBlank((CharSequence)this.preKey) ? String.format(TWO_PLACEHOLDER, this.preKey, "bf") : "bf";
    }

    public String getBillFormId() {
        String billFormIdKey = this.getBillFormIdKey();
        if (this.getCacheMap().get(billFormIdKey) != null) {
            return this.getCacheMap().get(billFormIdKey);
        }
        return null;
    }

    public void setBillFormId(String billFormId) {
        this.getCacheMap().put(this.getBillFormIdKey(), billFormId);
    }

    private String getIsQingViewAddedKey() {
        return StringUtils.isNotBlank((CharSequence)this.preKey) ? String.format(TWO_PLACEHOLDER, this.preKey, "isqa") : "isqa";
    }

    public boolean getIsQingViewAdded() {
        String isQingViewAddedKey = this.getIsQingViewAddedKey();
        if (this.getCacheMap().get(isQingViewAddedKey) != null) {
            return Boolean.parseBoolean(this.getCacheMap().get(isQingViewAddedKey));
        }
        return false;
    }

    public void setIsQingViewAdded(boolean isQingViewAdded) {
        this.getCacheMap().put(this.getIsQingViewAddedKey(), Boolean.toString(isQingViewAdded));
    }

    private String getEntryEntityKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "ee");
    }

    private String getBillEntryEntityKey() {
        return "blee";
    }

    public String getEntryEntity() {
        String entryEntityKey = this.getEntryEntityKey();
        if (this.getCacheMap().get(entryEntityKey) != null) {
            return this.getCacheMap().get(entryEntityKey);
        }
        return null;
    }

    public String getBillEntryEntity() {
        String entryEntityKey = this.getBillEntryEntityKey();
        if (this.getCacheMap().get(entryEntityKey) != null) {
            return this.getCacheMap().get(entryEntityKey);
        }
        return null;
    }

    void setEntryEntity(String entryEntity) {
        this.getCacheMap().put(this.getEntryEntityKey(), entryEntity);
        this.getCacheMap().put(this.getBillEntryEntityKey(), entryEntity);
    }

    private String getFilterParameterKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "fp");
    }

    FilterParameter getFilterParameter() {
        String filterParameterKey = this.getFilterParameterKey();
        if (this.getCacheMap().get(filterParameterKey) != null) {
            return (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(filterParameterKey));
        }
        return new FilterParameter();
    }

    void setFilterParameter(FilterParameter filterParameter) {
        this.getCacheMap().put(this.getFilterParameterKey(), ControlTypes.toJsonString((Object)filterParameter));
    }

    private String getClientQueryFilterParameterKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "cqfp");
    }

    FilterParameter getClientQueryFilterParameter() {
        String filterParameterKey = this.getClientQueryFilterParameterKey();
        if (this.getCacheMap().get(filterParameterKey) != null) {
            return (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(filterParameterKey));
        }
        return new FilterParameter();
    }

    void setClientQueryFilterParameter(FilterParameter queryFilterParameter) {
        String filterParameterKey = this.getClientQueryFilterParameterKey();
        String s1 = this.getCacheMap().get(filterParameterKey);
        String s = ControlTypes.toJsonString((Object)queryFilterParameter);
        this.setClientQueryFilterParameterChanged(!s.equals(s1));
        this.getCacheMap().put(this.getClientQueryFilterParameterKey(), s);
    }

    private String getIsClientQueryFilterParameterChangedKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "cqfp_c");
    }

    boolean isClientQueryFilterParameterChanged() {
        String s = this.getCacheMap().get(this.getIsClientQueryFilterParameterChangedKey());
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    void setClientQueryFilterParameterChanged(boolean isChanged) {
        this.getCacheMap().put(this.getIsClientQueryFilterParameterChangedKey(), Boolean.toString(isChanged));
    }

    private String getCannotHeaderReadSelectFieldsKey() {
        return "crhsf_h";
    }

    public Set<String> getHeaderCannotReadSelectFields() {
        String cannotReadSelectFields = this.getCacheMap().get(this.getCannotHeaderReadSelectFieldsKey());
        if (StringUtils.isNotBlank((CharSequence)cannotReadSelectFields)) {
            return new HashSet<String>(Arrays.asList(cannotReadSelectFields.split(",")));
        }
        return new HashSet<String>(0);
    }

    public void setHeaderCannotReadSelectFields(Set<String> cannotReadHeaderSelectFields) {
        this.getCacheMap().put(this.getCannotHeaderReadSelectFieldsKey(), String.join((CharSequence)",", cannotReadHeaderSelectFields));
    }

    private String getHeaderCannotReadSelectFieldsKey() {
        return "crhsf_f";
    }

    public Set<String> getFilterControlCannotReadSelectFields() {
        String cannotReadSelectFields = this.getCacheMap().get(this.getHeaderCannotReadSelectFieldsKey());
        if (StringUtils.isNotBlank((CharSequence)cannotReadSelectFields)) {
            return new HashSet<String>(Arrays.asList(cannotReadSelectFields.split(",")));
        }
        return new HashSet<String>(0);
    }

    public void setFilterControlCannotReadSelectFields(Set<String> cannotReadHeaderSelectFields) {
        this.getCacheMap().put(this.getHeaderCannotReadSelectFieldsKey(), String.join((CharSequence)",", cannotReadHeaderSelectFields));
    }

    private String getHeaderSelectFieldsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "hsf");
    }

    Set<String> getHeaderSelectFields() {
        if (this.headerSelectFields != null) {
            return this.headerSelectFields;
        }
        String headerSelectFieldsKey = this.getHeaderSelectFieldsKey();
        this.headerSelectFields = this.getCacheMap().get(headerSelectFieldsKey) != null ? new HashSet<String>(Arrays.asList(this.getCacheMap().get(headerSelectFieldsKey).split(","))) : new HashSet<String>(0);
        return this.headerSelectFields;
    }

    void setHeaderSelectFields(Set<String> headerSelectFields) {
        this.headerSelectFields = headerSelectFields;
        this.getCacheMap().put(this.getHeaderSelectFieldsKey(), String.join((CharSequence)",", headerSelectFields));
    }

    private String getHeaderSelectFieldsWithNotCompareKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "hsfwnc");
    }

    Set<String> getHeaderSelectFieldsWithNotCompare() {
        if (this.headerSelectFieldsWithNotCompare != null) {
            return this.headerSelectFieldsWithNotCompare;
        }
        String headerSelectFieldsWithNotCompareKey = this.getHeaderSelectFieldsWithNotCompareKey();
        this.headerSelectFieldsWithNotCompare = this.getCacheMap().get(headerSelectFieldsWithNotCompareKey) != null ? new HashSet<String>(Arrays.asList(this.getCacheMap().get(headerSelectFieldsWithNotCompareKey).split(","))) : new HashSet<String>(0);
        return this.headerSelectFieldsWithNotCompare;
    }

    void setHeaderSelectFieldsWithNotCompare(Set<String> headerSelectFieldsWithNotCompare) {
        this.getCacheMap().put(this.getHeaderSelectFieldsWithNotCompareKey(), String.join((CharSequence)",", headerSelectFieldsWithNotCompare));
    }

    private String getQueryFilterParameterKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "qfp");
    }

    FilterParameter getQueryFilterParameter() {
        String filterParameterKey = this.getQueryFilterParameterKey();
        if (this.getCacheMap().get(filterParameterKey) != null) {
            return (FilterParameter)ControlTypes.fromJsonStringToObj((String)this.getCacheMap().get(filterParameterKey));
        }
        return new FilterParameter();
    }

    void setQueryFilterParameter(FilterParameter queryFilterParameter) {
        String queryFilterParameterKey = this.getQueryFilterParameterKey();
        String s1 = this.getCacheMap().get(queryFilterParameterKey);
        String s = ControlTypes.toJsonString((Object)queryFilterParameter);
        this.setQueryFilterParameterChanged(!s.equals(s1));
        this.getCacheMap().put(queryFilterParameterKey, ControlTypes.toJsonString((Object)queryFilterParameter));
    }

    private String getIsQueryFilterParameterChangedKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "qfp_c");
    }

    boolean isQueryFilterParameterChanged() {
        String s = this.getCacheMap().get(this.getIsQueryFilterParameterChangedKey());
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    void setQueryFilterParameterChanged(boolean isChanged) {
        this.getCacheMap().put(this.getIsQueryFilterParameterChangedKey(), Boolean.toString(isChanged));
    }

    private String getListFieldsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "lf");
    }

    List<String> getCachedListFields() {
        List<String> listFields = new ArrayList<String>();
        String cacheKey = this.getListFieldsKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            listFields = SerializationUtils.fromJsonStringToList((String)this.getCacheMap().get(cacheKey), String.class);
        }
        return listFields;
    }

    void putCachedListFields(List<String> listFields) {
        String cacheKey = this.getListFieldsKey();
        this.getCacheMap().put(cacheKey, SerializationUtils.toJsonString(listFields));
    }

    private String getListKeyFieldsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "lkf");
    }

    Map<String, String> getCachedListKeyFields() {
        Map<String, String> listFields = new HashMap<String, String>();
        String cacheKey = this.getListKeyFieldsKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            listFields = (Map)SerializationUtils.fromJsonString((String)this.getCacheMap().get(cacheKey), Map.class);
        }
        return listFields;
    }

    void putCachedListKeyFields(Map<String, String> keyFieldsMap) {
        String cacheKey = this.getListKeyFieldsKey();
        this.getCacheMap().put(cacheKey, SerializationUtils.toJsonString(keyFieldsMap));
    }

    private String getMultiSortFieldsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "msf");
    }

    public Collection<String> getMultiSortFields() {
        List<String> listFields = new ArrayList<String>();
        String cacheKey = this.getMultiSortFieldsKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            listFields = SerializationUtils.fromJsonStringToList((String)this.getCacheMap().get(cacheKey), String.class);
        }
        return listFields;
    }

    public void putMultiSortFields(Collection<String> multiSortFields) {
        String cacheKey = this.getMultiSortFieldsKey();
        this.getCacheMap().put(cacheKey, SerializationUtils.toJsonString(multiSortFields));
    }

    private String getFieldSortConfigKey() {
        return "fsc";
    }

    public List<FieldSort> getFieldSortConfig() {
        List<FieldSort> fieldSorts = new ArrayList<FieldSort>();
        String cacheKey = this.getFieldSortConfigKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            fieldSorts = SerializationUtils.fromJsonStringToList((String)this.getCacheMap().get(cacheKey), FieldSort.class);
        }
        return fieldSorts;
    }

    public void putFieldSortConfig(List<FieldSort> fieldSorts) {
        String cacheKey = this.getFieldSortConfigKey();
        this.getCacheMap().put(cacheKey, SerializationUtils.toJsonString(fieldSorts));
    }

    private String getNoHeaderFilterListAllRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "clarc_f");
    }

    ListSelectedRowCollection getNoHeaderFilterListAllRowCollection() {
        if (this.noHeaderFilterListAllSelectedRows != null) {
            return this.noHeaderFilterListAllSelectedRows;
        }
        this.noHeaderFilterListAllSelectedRows = this.getListSelectedRowCollectionByPart(this.getNoHeaderFilterListAllRowCollectionKey());
        String batchstr = this.getCacheMap().get(this.getNoHeaderFilterListAllRowCollectionKey());
        if (StringUtils.isBlank((CharSequence)batchstr)) {
            this.noHeaderFilterListAllSelectedRows = this.getCurrentListAllRowCollection();
        }
        return this.noHeaderFilterListAllSelectedRows;
    }

    void putNoHeaderFilterListAllRowCollection(ListSelectedRowCollection listSelectedRowCollection) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getNoHeaderFilterListAllRowCollectionKey());
        }
        this.noHeaderFilterListAllSelectedRows = listSelectedRowCollection;
    }

    private String getCurrentListAllRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "clarc");
    }

    ListSelectedRowCollection getCurrentListAllRowCollection() {
        if (this.currentListAllSelectedRows != null) {
            return this.currentListAllSelectedRows;
        }
        this.currentListAllSelectedRows = this.getListSelectedRowCollectionByPart(this.getCurrentListAllRowCollectionKey());
        return this.currentListAllSelectedRows;
    }

    private ListSelectedRowCollection getListSelectedRowCollectionByPart(String cacheKey) {
        String[] batchArray;
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        String batchstr = this.getCacheMap().get(cacheKey);
        if (batchstr == null) {
            return listSelectedRowCollection;
        }
        for (String batchKey : batchArray = batchstr.split("\\,")) {
            String collectionString = this.getCacheMap().get(cacheKey + "_" + batchKey);
            if (collectionString == null) continue;
            listSelectedRowCollection.addAll((Collection)ListSelectedRowCollection.deSerialize((String)collectionString));
        }
        return listSelectedRowCollection;
    }

    void putCurrentListAllRowCollection(ListSelectedRowCollection listSelectedRowCollection) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getCurrentListAllRowCollectionKey());
        }
        this.currentListAllSelectedRows = listSelectedRowCollection;
    }

    private void putListSelectedRowCollectionByPart(ListSelectedRowCollection listSelectedRowCollection, String cacheKey) {
        this.putListSelectedRowCollectionByPart(listSelectedRowCollection, cacheKey, ModifyType.ALL);
    }

    private void putListSelectedRowCollectionByPart(ListSelectedRowCollection listSelectedRowCollection, String cacheKey, ModifyType modifyType) {
        LinkedHashMap<String, ListSelectedRowCollection> batchMap = new LinkedHashMap<String, ListSelectedRowCollection>(16);
        ArrayList<String> batchList = new ArrayList<String>(10);
        String batchStr = this.getCacheMap().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)batchStr) && modifyType != ModifyType.ALL) {
            batchList.addAll(Arrays.asList(batchStr.split("\\,")));
        }
        if (StringUtils.isNotBlank((CharSequence)batchStr) && modifyType == ModifyType.ALL) {
            for (String batchKey : batchStr.split("\\,")) {
                this.getCacheMap().put(cacheKey + "_" + (String)batchKey, "[]");
            }
        }
        this.collectBatchData(listSelectedRowCollection, cacheKey, modifyType, batchMap);
        for (Map.Entry entry : batchMap.entrySet()) {
            this.getCacheMap().put(cacheKey + "_" + (String)entry.getKey(), ((ListSelectedRowCollection)entry.getValue()).serialize());
            if (batchList.contains(entry.getKey())) continue;
            batchList.add((String)entry.getKey());
        }
        if (!batchList.isEmpty()) {
            Collections.sort(batchList, (o1, o2) -> Integer.compare(Integer.parseInt(o1), Integer.parseInt(o2)));
            this.getCacheMap().put(cacheKey, String.join((CharSequence)",", batchList));
        } else {
            this.getCacheMap().put(cacheKey, "");
        }
    }

    private Set<ListSelectedRow> getListSelectedRowSet(ListSelectedRowCollection currentListSelectedRowCollection) {
        HashSet<ListSelectedRow> currentPkSet = new HashSet<ListSelectedRow>(16);
        for (ListSelectedRow listSelectedRow : currentListSelectedRowCollection) {
            currentPkSet.add(listSelectedRow);
        }
        return currentPkSet;
    }

    private void collectBatchData(ListSelectedRowCollection listSelectedRowCollection, String cacheKey, ModifyType modifyType, Map<String, ListSelectedRowCollection> batchMap) {
        Set<Object> listSelectedRowSet = new HashSet(16);
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            Integer indexKey = listSelectedRow.getRowKey() / 1000;
            ListSelectedRowCollection listSelectedRowCollection2 = batchMap.get(indexKey.toString());
            if (listSelectedRowCollection2 == null) {
                String collectionString = this.getCacheMap().get(cacheKey + "_" + indexKey);
                listSelectedRowCollection2 = new ListSelectedRowCollection();
                if (collectionString != null && modifyType == ModifyType.ADD) {
                    listSelectedRowCollection2.addAll((Collection)ListSelectedRowCollection.deSerialize((String)collectionString));
                }
                listSelectedRowSet = this.getListSelectedRowSet(listSelectedRowCollection2);
                batchMap.put(indexKey.toString(), listSelectedRowCollection2);
            }
            if (listSelectedRowSet.contains(listSelectedRow)) continue;
            listSelectedRowCollection2.add((Object)listSelectedRow);
        }
    }

    private String getListSeletedRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "lsrc");
    }

    ListSelectedRowCollection getCachedSelectedRowsByPart(Integer ... rowKeys) {
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        int i = 0;
        int size = rowKeys.length;
        do {
            String collectionString;
            if ((collectionString = this.getCacheMap().get(this.getListSeletedRowCollectionKey() + "_" + rowKeys[i] / 1000)) == null) continue;
            listSelectedRowCollection.addAll((Collection)ListSelectedRowCollection.deSerialize((String)collectionString));
        } while ((i += 1000) < size);
        return listSelectedRowCollection;
    }

    void removeCachedSelectedRowsByPart(Integer ... rowKeys) {
        this.removeSelectRowsByPart(this.getListSeletedRowCollectionKey(), rowKeys);
        this.cachedSelectedRows = null;
    }

    void removeCurrentCachedSelectedRowsByPart(Integer ... rowKeys) {
        this.removeSelectRowsByPart(this.getCurrentListSeletedRowCollectionKey(), rowKeys);
        this.currentCachedSelectedRows = null;
    }

    void removeSelectRowsByPart(String cacheKey, Integer ... rowKeys) {
        ArrayList<String> batchList = new ArrayList<String>(10);
        String batchStr = this.getCacheMap().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)batchStr)) {
            batchList.addAll(Arrays.asList(batchStr.split("\\,")));
        }
        int i = 0;
        int size = rowKeys.length;
        do {
            Integer indexKey = rowKeys[i] / 1000;
            String indexKeyStr = indexKey.toString();
            batchList.removeIf(t -> t.equals(indexKeyStr));
            this.getCacheMap().put(cacheKey + "_" + indexKey, "[]");
        } while ((i += 1000) < size);
        this.getCacheMap().put(cacheKey, String.join((CharSequence)",", batchList));
    }

    void putCachedSelectedRowsByPart(ListSelectedRowCollection listSelectedRowCollection, ModifyType modifyType) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getListSeletedRowCollectionKey(), modifyType);
        }
        this.cachedSelectedRows = null;
    }

    ListSelectedRowCollection getCachedSelectedRows() {
        if (this.cachedSelectedRows != null) {
            return this.cachedSelectedRows;
        }
        this.cachedSelectedRows = this.getListSelectedRowCollectionByPart(this.getListSeletedRowCollectionKey());
        return this.cachedSelectedRows;
    }

    void putCachedSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getListSeletedRowCollectionKey());
        }
        this.cachedSelectedRows = listSelectedRowCollection;
    }

    private String getListNotSeletedRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "lnsrc");
    }

    ListSelectedRowCollection getCachedNotSelectedRows() {
        if (this.cachedNotSelectedRows != null) {
            return this.cachedNotSelectedRows;
        }
        this.cachedNotSelectedRows = new ListSelectedRowCollection();
        String cacheKey = this.getListNotSeletedRowCollectionKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            this.cachedNotSelectedRows = ListSelectedRowCollection.deSerialize((String)this.getCacheMap().get(cacheKey));
        }
        return this.cachedNotSelectedRows;
    }

    void putCachedNotSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        String cacheKey = this.getListNotSeletedRowCollectionKey();
        if (listSelectedRowCollection != null) {
            this.getCacheMap().put(cacheKey, listSelectedRowCollection.serialize());
        }
        this.cachedNotSelectedRows = listSelectedRowCollection;
    }

    private String getLinkQueryPkIdCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "linkQueryPkIdCollection");
    }

    public LinkQueryPkIdCollection getLinkQueryPkIdCollection() {
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        String cacheKey = this.getLinkQueryPkIdCollectionKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            linkQueryPkIdCollection = LinkQueryPkIdCollection.deSerialize((String)this.getCacheMap().get(cacheKey));
        }
        return linkQueryPkIdCollection;
    }

    public void putLinkQueryPkIdCollection(LinkQueryPkIdCollection linkQueryPkIdCollection) {
        String cacheKey = this.getLinkQueryPkIdCollectionKey();
        if (linkQueryPkIdCollection != null) {
            this.getCacheMap().put(cacheKey, linkQueryPkIdCollection.serialize());
        }
    }

    private String getRouteInfoKey() {
        return "rk";
    }

    public String getRouteKey() {
        String cacheKey = this.getRouteInfoKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            return this.getCacheMap().get(cacheKey);
        }
        return "";
    }

    public void putRouteKey(String routeKey) {
        if (routeKey != null) {
            this.getCacheMap().put(this.getRouteInfoKey(), routeKey);
        }
    }

    private String getArchiveInfoKey() {
        return "ak";
    }

    public String getArchiveKey() {
        String cacheKey = this.getArchiveInfoKey();
        if (this.getCacheMap().get(cacheKey) != null) {
            return this.getCacheMap().get(cacheKey);
        }
        return "";
    }

    public void putArchiveKey(String archiveKey) {
        if (archiveKey != null) {
            this.getCacheMap().put(this.getArchiveInfoKey(), archiveKey);
        }
    }

    private String getDataCountKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "dc");
    }

    int getDataCount() {
        String value_i = this.getCacheMap().get(this.getDataCountImdediatelyKey());
        if (value_i == null) {
            String value = this.getCacheMap().get(this.getDataCountKey());
            if (value == null) {
                return 0;
            }
            return Integer.parseInt(value);
        }
        return Integer.parseInt(value_i);
    }

    void putDataCount(int dataCount) {
        String cacheKey = this.getDataCountKey();
        this.getCacheMap().put(cacheKey, String.valueOf(dataCount));
    }

    private String getDataCountImdediatelyKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "dc_i");
    }

    void putDataCountImdediately(int dataCount) {
        String cacheKey = this.getDataCountImdediatelyKey();
        this.pageCache.put(cacheKey, String.valueOf(dataCount));
    }

    private String getBillDataCountKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "bdc");
    }

    int getBillDataCount() {
        String cacheKey = this.getBillDataCountKey();
        String value = this.getCacheMap().get(cacheKey);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    void putBillDataCount(int billDataCount) {
        String cacheKey = this.getBillDataCountKey();
        this.getCacheMap().put(cacheKey, String.valueOf(billDataCount));
    }

    void putBillDataCountImdediately(int billDataCount) {
        String cacheKey = this.getBillDataCountKey();
        this.pageCache.put(cacheKey, String.valueOf(billDataCount));
    }

    String getFloatBottomDataKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "fbd");
    }

    List<SummaryResult> getFloatBottomData() {
        String floatBottomDataStr = this.pageCache.get(this.getFloatBottomDataKey());
        if (floatBottomDataStr == null) {
            return new ArrayList<SummaryResult>(0);
        }
        List results = SerializationUtils.fromJsonStringToList((String)floatBottomDataStr, SummaryResult.class);
        if (results != null) {
            FormatObject formatObject = FormatFactory.getFormat((Long)RequestContext.get().getCurrUserId());
            for (SummaryResult summaryResult : results) {
                summaryResult.getNumberPrecision().setFormatObject(formatObject);
            }
        }
        return results;
    }

    void putFloatBottomData(List<SummaryResult> floatBottomData) {
        String cacheKey = this.getFloatBottomDataKey();
        if (floatBottomData != null) {
            this.pageCache.put(cacheKey, floatBottomData.isEmpty() ? "[]" : SerializationUtils.toJsonString(floatBottomData));
        }
    }

    String getTotalFloatBottomDataKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "tfbd");
    }

    List<SummaryResult> getTimeOutTotalFloatBottomData() {
        String totalFloatBottomDataStr = this.pageCache.get(this.getTotalFloatBottomDataKey());
        if (totalFloatBottomDataStr == null) {
            return new ArrayList<SummaryResult>(0);
        }
        List results = SerializationUtils.fromJsonStringToList((String)totalFloatBottomDataStr, TimeoutSummaryResult.class);
        if (results != null) {
            FormatObject formatObject = FormatFactory.getFormat((Long)RequestContext.get().getCurrUserId());
            for (SummaryResult summaryResult : results) {
                summaryResult.getNumberPrecision().setFormatObject(formatObject);
            }
        }
        return results;
    }

    void putTotalFloatBottomData(List<SummaryResult> floatBottomData) {
        String cacheKey = this.getTotalFloatBottomDataKey();
        if (floatBottomData != null) {
            this.pageCache.put(cacheKey, floatBottomData.isEmpty() ? "[]" : SerializationUtils.toJsonString(floatBottomData));
        }
    }

    private String getFieldSumDataKey() {
        return this.preKey + "_FieldSumData_";
    }

    void clearCachedSumData(List<String> groupBySumFields) {
        this.putTotalFloatBottomData(new ArrayList<SummaryResult>());
        this.putFloatBottomData(new ArrayList<SummaryResult>());
        for (String groupBySumField : groupBySumFields) {
            this.pageCache.put(this.getFieldSumDataKey() + groupBySumField, "");
        }
    }

    private String getShowTipsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "stk");
    }

    Map<String, Object> getCachedShowTips() {
        String tips = this.getCacheMap().get(this.getShowTipsKey());
        if (tips == null || "".equals(tips)) {
            return null;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)tips);
    }

    void putCachedShowTips(Map<String, Object> tipsInfo) {
        String cacheKey = this.getShowTipsKey();
        if (tipsInfo != null) {
            this.getCacheMap().put(cacheKey, SerializationUtils.serializeToBase64(tipsInfo));
        }
    }

    private String getCurrentListSeletedRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "clsrc");
    }

    ListSelectedRowCollection getCurrentCachedSelectedRowsByPart(Integer ... rowKeys) {
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        int i = 0;
        int size = rowKeys.length;
        do {
            String collectionString;
            if ((collectionString = this.getCacheMap().get(this.getCurrentListSeletedRowCollectionKey() + "_" + rowKeys[i] / 1000)) == null) continue;
            listSelectedRowCollection.addAll((Collection)ListSelectedRowCollection.deSerialize((String)collectionString));
        } while ((i += 1000) < size);
        return listSelectedRowCollection;
    }

    void putCurrentCachedSelectedRowsByPart(ListSelectedRowCollection listSelectedRowCollection, ModifyType modifyType) {
        this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getCurrentListSeletedRowCollectionKey(), modifyType);
        this.currentCachedSelectedRows = null;
    }

    ListSelectedRowCollection getCurrentCachedSelectedRows() {
        if (this.currentCachedSelectedRows != null) {
            return this.currentCachedSelectedRows;
        }
        this.currentCachedSelectedRows = this.getListSelectedRowCollectionByPart(this.getCurrentListSeletedRowCollectionKey());
        return this.currentCachedSelectedRows;
    }

    void putCurrentCachedSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getCurrentListSeletedRowCollectionKey());
        }
        this.currentCachedSelectedRows = listSelectedRowCollection;
    }

    private String getAppendListSeletedRowCollectionKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "alsrc");
    }

    ListSelectedRowCollection getAppendCachedSelectedRows() {
        if (this.appendCachedSelectedRows != null) {
            return this.appendCachedSelectedRows;
        }
        this.appendCachedSelectedRows = this.getListSelectedRowCollectionByPart(this.getAppendListSeletedRowCollectionKey());
        return this.appendCachedSelectedRows;
    }

    void putAppendCachedSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        if (listSelectedRowCollection != null) {
            this.putListSelectedRowCollectionByPart(listSelectedRowCollection, this.getAppendListSeletedRowCollectionKey());
        }
        this.appendCachedSelectedRows = listSelectedRowCollection;
    }

    public final void setAppendingListColumnFilters(Map<String, ListColumnFilterCollection> listColumnFilterMap) {
        if (listColumnFilterMap != null && !listColumnFilterMap.isEmpty()) {
            this.getCacheMap().put(APPENDING_LIST_COLUMN_FILTERS, SerializationUtils.toJsonString(listColumnFilterMap));
        }
    }

    public final Map<String, ListColumnFilterCollection> getAppendingListColumnFilters() {
        String object = this.getCacheMap().get(APPENDING_LIST_COLUMN_FILTERS);
        Map<String, ListColumnFilterCollection> listColumnFilterMap = new HashMap<String, ListColumnFilterCollection>();
        ObjectMapper lomap = new ObjectMapper();
        lomap.setDateFormat((DateFormat)this.sdf);
        lomap.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        lomap.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        if (object != null) {
            try {
                listColumnFilterMap = (Map)lomap.readValue(object.toString(), (TypeReference)new TypeReference<Map<String, ListColumnFilterCollection>>(){});
            }
            catch (JsonProcessingException e) {
                throw new KDException((Throwable)e, new ErrorCode("DESERIALIZEERROR", "Deserialize error for getAppendingListColumnFilters"), new Object[0]);
            }
        }
        return listColumnFilterMap;
    }

    void clearSelectedRows() {
        this.putCachedSelectedRows(new ListSelectedRowCollection());
        this.putCurrentCachedSelectedRows(new ListSelectedRowCollection());
        this.putCachedNotSelectedRows(new ListSelectedRowCollection());
        this.savePageCache();
    }

    private String getIsDesignNewFilterKey() {
        return "idnf";
    }

    public void setDesignNewFilter(Boolean isDesignNewFitler) {
        this.isDesignNewFitler = isDesignNewFitler;
        this.getCacheMap().put(this.getIsDesignNewFilterKey(), Boolean.toString(isDesignNewFitler));
    }

    public Boolean isDesignerNewFilter() {
        if (this.isDesignNewFitler != null) {
            return this.isDesignNewFitler;
        }
        String isNewFilterString = this.getCacheMap().get(this.getIsDesignNewFilterKey());
        if (isNewFilterString == null) {
            return null;
        }
        this.isDesignNewFitler = Boolean.parseBoolean(isNewFilterString);
        return this.isDesignNewFitler;
    }

    private String getIsNewFilterKey() {
        return "inf";
    }

    public void setNewFilter(boolean isNewFilter) {
        this.isNewFitler = Optional.of(isNewFilter);
        this.getCacheMap().put(this.getIsNewFilterKey(), Boolean.toString(isNewFilter));
    }

    public Optional<Boolean> isNewFilter() {
        if (this.isNewFitler.isPresent()) {
            return this.isNewFitler;
        }
        String isNewFilterKey = this.getIsNewFilterKey();
        String isNewFilterString = this.getCacheMap().get(isNewFilterKey);
        if (isNewFilterString == null) {
            return Optional.empty();
        }
        this.isNewFitler = Optional.of(Boolean.parseBoolean(isNewFilterString));
        return this.isNewFitler;
    }

    private String getFilterModeKey() {
        return "fm";
    }

    public void setFilterMode(int filterMode) {
        this.filterMode = Optional.of(filterMode);
        this.getCacheMap().put(this.getFilterModeKey(), String.valueOf(filterMode));
    }

    public Optional<Integer> getFilterMode() {
        if (this.filterMode.isPresent()) {
            return this.filterMode;
        }
        String filterModeKey = this.getFilterModeKey();
        String filterModeString = this.getCacheMap().get(filterModeKey);
        if (filterModeString == null) {
            return Optional.empty();
        }
        this.filterMode = Optional.of(Integer.valueOf(filterModeString));
        return this.filterMode;
    }

    public boolean getCardSelectStatus() {
        String cardSelectStatus = this.getCacheMap().get(CARD_SELECT_STATUS);
        if (StringUtils.isNotBlank((CharSequence)cardSelectStatus)) {
            return Boolean.parseBoolean(cardSelectStatus);
        }
        return false;
    }

    public void putCardSelectStatus(Boolean cardSelectStatus) {
        if (cardSelectStatus != null) {
            this.cardSelectStatus = cardSelectStatus;
        }
        this.getCacheMap().put(CARD_SELECT_STATUS, Boolean.toString(this.cardSelectStatus));
    }

    private String getIsEnableCustomSumKey() {
        return "iecs";
    }

    void setEnableCustomSum(boolean enableCustomSum) {
        this.getCacheMap().put(this.getIsEnableCustomSumKey(), Boolean.toString(enableCustomSum));
    }

    boolean isEnableCustomSum() {
        String isEnableCustomSumKey = this.getIsEnableCustomSumKey();
        if (this.getCacheMap().get(isEnableCustomSumKey) == null) {
            return true;
        }
        return Boolean.parseBoolean(this.getCacheMap().get(isEnableCustomSumKey));
    }

    public void setDeleteConfirmMsg(String confirmMsg) {
        this.getCacheMap().put("bos_custom_deleteConfirm_msg", confirmMsg);
    }

    public String getDeleteConfirmMsg() {
        return this.getCacheMap().get("bos_custom_deleteConfirm_msg");
    }

    private String getSchemeIdKey() {
        return "si";
    }

    public void setSchemeId(String schemeId) {
        Optional<Integer> filterMode = this.getFilterMode();
        Optional<Boolean> newFilter = this.isNewFilter();
        if (filterMode.isPresent() && filterMode.get() == 1 || (!newFilter.isPresent() || newFilter.get().booleanValue()) && this.isDesignerNewFilter() != null && this.isDesignerNewFilter().booleanValue()) {
            this.getCacheMap().put(this.getSchemeIdKey(), schemeId);
        }
    }

    public String getSchemeId() {
        return this.getCacheMap().get(this.getSchemeIdKey());
    }

    private String getListColumnSettingPageIdKey() {
        return "lcspi";
    }

    public void setListColumnSettingPageId(String pageId) {
        this.pageCache.put(this.getListColumnSettingPageIdKey(), pageId);
    }

    public String getListColumnSettingPageId() {
        return this.pageCache.get(this.getListColumnSettingPageIdKey());
    }

    private String getListSortSettingPageIdKey() {
        return "lsspi";
    }

    public void setListSortSettingPageId(String pageId) {
        this.pageCache.put(this.getListSortSettingPageIdKey(), pageId);
    }

    public String getListSortSettingPageId() {
        return this.pageCache.get(this.getListSortSettingPageIdKey());
    }

    public boolean isExsitMainOrgQFilter() {
        String mainOrgQFilter = this.getCacheMap().get(this.getMainOrgQFilterKey());
        return mainOrgQFilter != null;
    }

    public boolean isExsitFieldControlRules() {
        String fieldControlRules = this.getCacheMap().get(this.getFieldControlRulesKey());
        return fieldControlRules != null;
    }

    public boolean isExsitSpecialDataPermQFilter() {
        String specialDataPermQFilter = this.getCacheMap().get(this.getSpecialDataPermQFilterKey());
        return specialDataPermQFilter != null;
    }

    public boolean isExsitDataPermQFilters() {
        String dataPermQFilters = this.getCacheMap().get(this.getDataPermQFiltersKey());
        return dataPermQFilters != null;
    }

    private String getIsSumOpenKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "iso");
    }

    void setSumOpen(Boolean isOpen) {
        this.pageCache.put(this.getIsSumOpenKey(), isOpen.toString());
    }

    Boolean isSumOpen() {
        String isSumOpen = this.pageCache.get(this.getIsSumOpenKey());
        if (StringUtils.isBlank((CharSequence)isSumOpen)) {
            return false;
        }
        return Boolean.parseBoolean(isSumOpen);
    }

    static enum ModifyType {
        ALL,
        ADD,
        UPDATE;

    }
}

