/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.list.CheckFilterPermissionResult;
import kd.bos.list.QFilterPropertyNameConverter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.perm.req.field.GetFieldControlRulesReq;
import kd.bos.service.ServiceFactory;

public final class ListPermissionService {
    private ListPermissionService() {
    }

    public static Set<String> getCanNotReadFields(String appId, String entityId) {
        return ListPermissionService.getCanNotReadFields(appId, entityId, null);
    }

    public static Set<String> getCanNotReadFields(String appId, String entityId, Long orgId) {
        Set<String> lstCanNotReadFields = new HashSet<String>(16);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRule frule = null;
        if (orgId == null) {
            FieldControlRules fieldControlRules = permissionService.getFieldControlRules(RequestContext.get().getCurrUserId(), appId, entityId);
            if (fieldControlRules != null) {
                frule = ListPermissionService.getFieldControlRule(fieldControlRules);
            }
        } else {
            frule = permissionService.getFieldControlRule(new GetFieldControlRulesReq(Long.valueOf(RequestContext.get().getCurrUserId()), appId, entityId, orgId));
        }
        if (frule != null) {
            lstCanNotReadFields = frule.getCanNotReadFields();
        }
        return lstCanNotReadFields;
    }

    static FieldControlRule getFieldControlRule(FieldControlRules fieldControlRules) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
            FieldControlRule temp = listField.getFieldControlRule();
            if (temp == null) continue;
            fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
            fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
            fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
            fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
        }
        return fieldControlRule;
    }

    public static CheckFilterPermissionResult checkFilterPermission(List<String> filterNames, String bizAppId, EntityType entityType, Long orgId) {
        Set<String> cannotReadFields = ListPermissionService.getCanNotReadFields(bizAppId, entityType.getName(), orgId);
        if (filterNames.isEmpty() || cannotReadFields.isEmpty()) {
            return new CheckFilterPermissionResult();
        }
        HashSet<String> hasNotFieldPermissionFields = new HashSet<String>(16);
        for (String filterName : filterNames) {
            QFilterPropertyNameConverter qFilterPropertyNameConverter;
            String fieldKey;
            if (!StringUtils.isNotBlank((CharSequence)filterName) || !cannotReadFields.contains(fieldKey = (qFilterPropertyNameConverter = new QFilterPropertyNameConverter(entityType)).getRealFieldKey(filterName))) continue;
            hasNotFieldPermissionFields.add(filterName);
        }
        return new CheckFilterPermissionResult(hasNotFieldPermissionFields);
    }
}

