/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.ListPermissionService;
import kd.bos.list.events.SetCellsDataEvent;
import kd.bos.list.events.SetCellsDataListener;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.OperationService;
import kd.sdk.annotation.SdkInternal;

class ListRowEditor {
    static final String NO_FIELD_RULE = "noFieldRule";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private BillList billList;

    ListRowEditor(BillList billList) {
        this.billList = billList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SdkInternal
    void updateValue(Map<String, List<Object>> map) {
        block24: {
            block25: {
                block22: {
                    block23: {
                        cellsData = map.get("cellsData");
                        valueMap = new HashMap<K, V>();
                        if (cellsData != null && !cellsData.isEmpty() && cellsData.get(0) instanceof Map) {
                            valueMap = (Map)cellsData.get(0);
                        }
                        fieldKey = (String)valueMap.get("k");
                        v = valueMap.get("v");
                        row = (Integer)valueMap.get("r");
                        pks = valueMap.get("pks") instanceof List != false ? (List)valueMap.get("pks") : new ArrayList<E>();
                        range = valueMap.get("range") instanceof List != false ? (List)valueMap.get("range") : new ArrayList<E>();
                        setCellsDataEvent = new SetCellsDataEvent(fieldKey, v, row, pks);
                        for (SetCellsDataListener setCellsDataListener : this.billList.setCellsDataListeners) {
                            setCellsDataListener.setCellsData(setCellsDataEvent);
                        }
                        if (setCellsDataEvent.isCancel()) {
                            return;
                        }
                        this.billList.rearrangeAndExetendFlex();
                        listFields = this.billList.getListFields();
                        pkFields = EntityTypeUtil.getValidPkFields((EntityType)this.billList.getEntityType(), listFields);
                        if (StringUtils.isEmpty((CharSequence)fieldKey)) {
                            return;
                        }
                        listField = null;
                        for (ListField field : listFields) {
                            if (field.getKey() == null || !fieldKey.equals(field.getKey().replace(".", "_"))) continue;
                            listField = field;
                            break;
                        }
                        if (listField == null) {
                            BillList.logger.error("fieldKey not found" + fieldKey);
                            return;
                        }
                        if (pks.isEmpty() || pkFields.size() != pks.size()) {
                            BillList.logger.error("pks " + pks + " pkFields " + pkFields);
                            return;
                        }
                        entityId = this.billList.getEntityId();
                        operations = EntityMetadataCache.getDataEntityOperations((String)entityId);
                        if (operations == null || StringUtils.isBlank((CharSequence)operations.getSave())) {
                            return;
                        }
                        pkVal = this.billList.billListSelection.convertPkValue((ListField)pkFields.get(0), pks.get(0));
                        dataEntity = BusinessDataReader.loadSingle((Object)pkVal, (DynamicObjectType)this.billList.getEntityType());
                        dynamicObject = this.getTargetObj(listField, dataEntity, pks);
                        if (dynamicObject == null) {
                            return;
                        }
                        dynamicObject.set(fieldKey, v);
                        opKey = null;
                        isMutexLocked = false;
                        try {
                            userId = Long.parseLong(RequestContext.get().getUserId());
                            entityNumber = this.billList.getListModel().getDataEntityType().getName();
                            bizAppId = ShowFormHelper.getBizAppId(this.billList.getView().getFormShowParameter());
                            permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                            fieldControlRules = permissionService.getFieldControlRules(userId, bizAppId, entityNumber);
                            if (fieldControlRules == null || !(frule = ListPermissionService.getFieldControlRule(fieldControlRules)).getCanNotReadFields().contains(fieldKey) && !frule.getCanNotWriteFields().contains(fieldKey)) break block22;
                            confirmCallBacks = new ConfirmCallBackListener("noFieldRule", (Control)this.billList);
                            btnNameMaps = new HashMap<Integer, String>();
                            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"BillList_11", (String)"bos-form-core", (Object[])new Object[0]));
                            options = MessageBoxOptions.OK;
                            msg = ResManager.loadKDString((String)"\u60a8\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u5c06\u4e3a\u60a8\u5237\u65b0\u9875\u9762\u3002", (String)"BillList_12", (String)"bos-form-core", (Object[])new Object[0]);
                            this.billList.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                            if (!isMutexLocked) break block23;
                        }
                        catch (Throwable var32_34) {
                            if (isMutexLocked) {
                                MutexHelper.release(entityId, opKey, String.valueOf(pkVal));
                            }
                            throw var32_34;
                        }
                        MutexHelper.release(entityId, opKey, String.valueOf(pkVal));
                    }
                    return;
                }
                formOperate = (FormOperate)FormMetadataCache.getFormOperation((String)entityId, (String)"modify");
                if (formOperate == null) break block24;
                failInfo = new StringBuilder();
                opKey = formOperate.getOperateKey();
                lockInfo = new MutexLockInfo(String.valueOf(pkVal), null, null, this.billList.getEntityId(), opKey, true, "default");
                isMutexLocked = MutexHelper.require(this.billList.getView(), lockInfo, failInfo);
                if (isMutexLocked) break block24;
                this.billList.getView().showErrorNotification(failInfo.toString());
                if (!isMutexLocked) break block25;
                MutexHelper.release(entityId, opKey, String.valueOf(pkVal));
            }
            return;
        }
        operationService = (OperationService)ServiceFactory.getService((String)"OperationService");
        str = operationService.invokeOperation(operations.getSave(), new DynamicObject[]{dataEntity}, OperateOption.create());
        operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        ** if (!isMutexLocked) goto lbl93
lbl-1000:
        // 1 sources

        {
            MutexHelper.release(entityId, opKey, String.valueOf(pkVal));
        }
        {
        }
lbl93:
        // 2 sources

        if (operationResult != null) {
            if (operationResult.isSuccess()) {
                this.billList.clearCachedSumData(this.billList.getShowGroupSumFields(listFields));
                this.billList.getSumData();
                this.billList.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BillList_10", (String)"bos-form-core", (Object[])new Object[0]));
            } else {
                this.billList.getView().showOperationResult(operationResult);
            }
        }
        if (operationResult != null && !operationResult.getSuccessPkIds().isEmpty()) {
            listRowColl = new ListSelectedRowCollection();
            listRow = new ListSelectedRow(pkVal, Boolean.valueOf(((ListField)pkFields.get(0)).getSrcFieldProp() instanceof LongProp));
            if (pkFields.size() > 1) {
                pkField = (ListField)pkFields.get(1);
                newValue = this.billList.billListSelection.convertPkValue(pkField, pks.get(1));
                listRow.setEntryPrimaryKeyValue(newValue);
                listRow.setEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
            if (pkFields.size() > 2) {
                pkField = (ListField)pkFields.get(2);
                newValue = this.billList.billListSelection.convertPkValue(pkField, pks.get(2));
                listRow.setSubEntryPrimaryKeyValue(newValue);
                listRow.setSubEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
            listRowColl.add((Object)listRow);
            queryObj4Format = this.queryObj4Format(listField, pkFields, listRowColl);
            formatValue = queryObj4Format != null ? this.getFormatValue(listField, queryObj4Format) : null;
            value = listField.getFieldProp().getValueFast((Object)queryObj4Format);
            data = new HashMap<String, ArrayList<E>>(6);
            cells = new ArrayList<HashMap<K, V>>(3);
            tmp = new HashMap<String, Object>(6);
            tmp.put("v", formatValue != null ? formatValue : value);
            tmp.put("k", fieldKey);
            tmp.put("r", row);
            if (range.size() > 0) {
                tmp.put("range", range);
            }
            cells.add(tmp);
            data.put("cells", cells);
            clientViewProxy = (IClientViewProxy)this.billList.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.billList.getKey(), "setCellsData", new Object[]{data});
        }
    }

    private DynamicObject getTargetObj(ListField listField, DynamicObject dataEntity, List<Object> pks) {
        IDataEntityProperty srcFieldProp = listField.getSrcFieldProp();
        if (srcFieldProp != null && srcFieldProp.getParent() instanceof EntryType) {
            boolean isSubEntry = srcFieldProp.getParent() instanceof SubEntryType;
            DynamicObject entryObj = null;
            String entryKey = isSubEntry ? srcFieldProp.getParent().getParent().getName() : srcFieldProp.getParent().getName();
            for (DynamicObject rowObj : dataEntity.getDynamicObjectCollection(entryKey)) {
                if (pks.size() <= 1 || !pks.get(1).equals(String.valueOf(rowObj.getPkValue()))) continue;
                entryObj = rowObj;
            }
            if (isSubEntry && entryObj != null) {
                for (DynamicObject subRowObj : entryObj.getDynamicObjectCollection(srcFieldProp.getParent().getName())) {
                    if (pks.size() <= 2 || !pks.get(2).equals(String.valueOf(subRowObj.getPkValue()))) continue;
                    return subRowObj;
                }
            } else {
                return entryObj;
            }
        }
        return dataEntity;
    }

    private DynamicObject queryObj4Format(ListField listField, List<ListField> pkFields, ListSelectedRowCollection listRowColl) {
        ArrayList<ListField> listFields = new ArrayList<ListField>(4);
        listFields.add(listField);
        if (listField.getSrcFieldProp() instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)listField.getSrcFieldProp();
            String controlPropName = amountProp.getControlPropName();
            for (ListField field : this.billList.getListFields()) {
                if (field == null || !StringUtils.equals((CharSequence)controlPropName, (CharSequence)field.getKey())) continue;
                listFields.add(field);
                break;
            }
        }
        ArrayList<ListField> listFieldList = new ArrayList<ListField>();
        listFieldList.addAll(pkFields);
        listFieldList.addAll(listFields);
        QueryResult queryResult = this.billList.getQueryResult(listFieldList, listRowColl, false, this.billList.generalFilterParameter(), true, false);
        DynamicObjectCollection coll = queryResult.getCollection();
        if (coll != null && coll.size() > 0) {
            return (DynamicObject)coll.get(0);
        }
        return null;
    }

    private Object getFormatValue(ListField listField, DynamicObject item) {
        String mainOrg = ((MainEntityType)this.billList.getEntityType()).getMainOrg();
        try {
            if (this.billList.getListModel().getProvider() != null && this.billList.getListModel().getProvider().getQueryBuilder() != null) {
                AbstractColumnDesc desc = listField.getColumnDesc(this.billList.getListModel().getProvider().getQueryBuilder().getReturnEntityType(), mainOrg, false);
                desc.setListUserOption(this.billList.listUserOption);
                HashMap<String, Boolean> sysParams = new HashMap<String, Boolean>();
                sysParams.put("ismaterialprecisionenable", FmtInfoUtils.applyMaterialPrecision());
                FormatObject format = null;
                if (BillList.InteServiceHelper_getUserFormat != null) {
                    format = (FormatObject)BillList.InteServiceHelper_getUserFormat.invoke(null, RequestContext.get().getCurrUserId());
                }
                desc.setUserFormat(format);
                desc.setFormatParams(sysParams);
                return desc.getValue(item);
            }
        }
        catch (Exception e) {
            BillList.logger.error("getUserFormat error", (Throwable)e);
        }
        return null;
    }
}

