/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.service.ServiceFactory;

public class MulBdPermUtil {
    public static void setAuthorizedData(IFormView formView, String controlKey, List<Object> pks) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        String parentFormId = (String)showParameter.getCustomParam("originFormId");
        String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)(parentFormId = FormMetadataCache.getFormConfig((String)parentFormId).getEntityTypeId()));
        IDataEntityProperty mulBaseDataProp = dataEntityType.findProperty(originFieldKey);
        if (mulBaseDataProp == null || !(mulBaseDataProp instanceof MulBasedataProp)) {
            return;
        }
        Map<String, Object> result = MulBdPermUtil.getAblePkIdsForMulBdProp(formView, pks);
        MulBdPermUtil.cacheDisabledData(formView, result, pks);
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(controlKey, "setAuthorizedData", new Object[]{result});
    }

    public static Map<String, Object> getAblePkIdsForMulBdProp(IFormView formView, List<Object> pks) {
        try (EntityTraceSpan span = EntityTracer.create((String)"MulBdPermUtil", (String)"setAuthorizedData");){
            FormShowParameter showParameter = formView.getFormShowParameter();
            String parentFormId = (String)showParameter.getCustomParam("originFormId");
            ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
            String appId = showParameter.getAppId();
            Long userId = RequestContext.get().getCurrUserId();
            String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
            HashMap customParams = new HashMap();
            customParams.putAll(showParameter.getCustomParams());
            ArrayList<Object> useOrgs = new ArrayList<Object>();
            useOrgs.add(showParameter.getCustomParam("originUseOrg"));
            span.addTag("userId", String.valueOf(userId));
            span.addTag("appId", appId);
            span.addTag("formId", parentFormId);
            span.addTag("baseKey", originFieldKey);
            span.addLocaleTag("pks", pks);
            span.addLocaleTag("useorg", useOrgs);
            parentFormId = FormMetadataCache.getFormConfig((String)parentFormId).getEntityTypeId();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)parentFormId);
            IDataEntityProperty mulBaseDataProp = dataEntityType.findProperty(originFieldKey);
            if (mulBaseDataProp == null || !(mulBaseDataProp instanceof MulBasedataProp)) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map result = permissionService.getAblePkIdsForMulBdProp(userId.longValue(), appId, parentFormId, originFieldKey, pks, useOrgs, customParams);
            span.addLocaleTag("result", (Object)result);
            if (result != null && result.get("items") != null) {
                List list = (List)result.get("items");
                ArrayList<String> newList = new ArrayList<String>(list.size());
                for (Object obj : list) {
                    if (obj == null) continue;
                    newList.add(obj.toString());
                }
                result.put("items", newList);
            }
            Map map = result;
            return map;
        }
    }

    private static void cacheDisabledData(IFormView formView, Map<String, Object> result, List<Object> pks) {
        String key;
        List<Object> disableds = new ArrayList();
        if (result != null && result.get("items") == null) {
            key = (String)result.get("key");
            if ("enabled".equals(key)) {
                disableds = pks.stream().map(Object::toString).collect(Collectors.toList());
            }
        } else if (result != null && result.get("items") != null) {
            key = (String)result.get("key");
            List list = (List)result.get("items");
            if ("enabled".equals(key)) {
                disableds = pks.stream().map(Object::toString).collect(Collectors.toList());
                disableds.removeAll(list.stream().map(Object::toString).collect(Collectors.toList()));
            } else {
                disableds = list.stream().map(Object::toString).collect(Collectors.toList());
            }
        }
        FormShowParameter showParameter = formView.getFormShowParameter();
        String parentFormId = (String)showParameter.getCustomParam("originFormId");
        String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
        formView.getPageCache().put(parentFormId + "__" + originFieldKey, SerializationUtils.toJsonString(disableds));
    }
}

