/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.list.AbstractList;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.events.QueryListEvent;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class UserList
extends AbstractList {
    private List<ListSelectedListener> listeners = new ArrayList<ListSelectedListener>();

    @Override
    public void addListSelectedListener(ListSelectedListener listener) {
        this.listeners.add(listener);
    }

    public void itemSelect(Object params) {
        ItemSelectEvent evt = new ItemSelectEvent((Object)this);
        evt.setData(params);
        for (ListSelectedListener l : this.listeners) {
            l.itemSelect(evt);
        }
    }

    public void backPressed(Object params) {
        BackPressedEvent evt = new BackPressedEvent((Object)this);
        evt.setData(params);
        for (ListSelectedListener l : this.listeners) {
            l.backPressed(evt);
        }
    }

    @Override
    public void endSelect(List<Object> params) {
        EndSelectEvent evt = new EndSelectEvent((Object)this);
        if (!params.isEmpty()) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows(params);
            evt.setData((Object)listSelectedRows);
        }
        for (ListSelectedListener l : this.listeners) {
            l.endSelect(evt);
        }
    }

    public void getLookUpList(String queryKey) {
        QueryListEvent evt = new QueryListEvent((Object)this);
        evt.setData(queryKey);
        for (ListSelectedListener l : this.listeners) {
            l.query(evt);
        }
    }
}

