/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.VoucherNoListField;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.ListColumnCompareServiceHelper;
import kd.bos.list.column.ListColumnCompares;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.permission.api.FieldControlRule;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class VoucherNoListColumn
extends AbstractListColumn {
    private String operationKey;
    private String voucherFieldId;
    private boolean columnFilter = false;

    @SimplePropertyAttribute
    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    @SimplePropertyAttribute
    public String getVoucherFieldId() {
        return this.voucherFieldId;
    }

    public void setVoucherFieldId(String voucherFieldId) {
        this.voucherFieldId = voucherFieldId;
    }

    @SimplePropertyAttribute(name="ColumnFilter")
    @DefaultValueAttribute(value="false")
    public boolean isColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(boolean columnFilter) {
        this.columnFilter = columnFilter;
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        VoucherNoListField voucherNoListField = new VoucherNoListField(this.getFieldKey());
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.setHeaderField(true);
            this.setEntityName(entityType.getName());
        }
        voucherNoListField.setEntityName(this.getEntityName());
        voucherNoListField.setOperationKey(this.getOperationKey());
        voucherNoListField.setVoucherFieldId(this.getVoucherFieldId());
        fieldSet.put(this.getKey(), (ListField)voucherNoListField);
    }

    public Map<String, Object> getListColumnConfigMap(MainEntityType entityType) {
        Map listColumnConfigMap = super.getListColumnConfigMap(entityType);
        listColumnConfigMap.put("listFieldKey", this.getKey());
        return listColumnConfigMap;
    }

    private void setColumnCompareOperators(Map<String, Object> column) {
        ListColumnCompares listColumnCompares = ListColumnCompareServiceHelper.getListColumnCompares(ListColumnMeta.VoucherNoListColumn);
        if (listColumnCompares != null) {
            column.put("filterItems", listColumnCompares.getColumnComboItems());
        }
    }

    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map column = super.createColumn(entityType);
        column.put("ln", true);
        column.put("sort", false);
        column.put("filter", this.isColumnFilter());
        if (this.isColumnFilter()) {
            this.setColumnCompareOperators(column);
        }
        return column;
    }

    protected String getFieldKey() {
        return this.key;
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        return false;
    }

    public Map<String, Object> getFactoryConfigColumnSetting() {
        HashMap<String, Object> listColumnMap = new HashMap<String, Object>();
        listColumnMap.put("listFieldKey", this.getKey());
        listColumnMap.put("caption", this.getCaption().toString());
        listColumnMap.put("textAlign", this.getTextAlign());
        listColumnMap.put("visible", this.getVisible());
        listColumnMap.put("fixed", this.isFixed());
        listColumnMap.put("class", ((Object)((Object)this)).getClass());
        listColumnMap.put("isHeaderField", this.isHeaderField());
        listColumnMap.put("entityCaption", this.getEntityCaption() != null ? this.getEntityCaption().getLocaleValue() : "");
        return listColumnMap;
    }

    public Map<String, String> getColumnServiceContext() {
        HashMap<String, String> formShowParameterIn = new HashMap<String, String>(2);
        formShowParameterIn.put("operationKey", this.operationKey);
        formShowParameterIn.put("voucherFieldId", this.voucherFieldId);
        return formShowParameterIn;
    }

    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        return new ArrayList<Map<String, Object>>(0);
    }
}

