/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.form.events.BeforeTreeNodeClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.ITreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AbstractTreeListPlugin
extends AbstractListPlugin
implements ITreeListPlugin,
SearchEnterListener {
    protected ITreeListView treeListView;
    private ITreeModel treeModel;

    public ITreeListView getTreeListView() {
        if (this.treeListView == null && this.getView() instanceof IListView) {
            this.treeListView = ((IListView)this.getView()).getTreeListView();
        }
        return this.treeListView;
    }

    public void initialize() {
        super.initialize();
        this.getTreeListView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    @Override
    public void setTreeListView(ITreeListView treeListView) {
        this.treeListView = treeListView;
    }

    protected ITreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = this.getTreeListView().getTreeModel();
        }
        return this.treeModel;
    }

    @Override
    public void initializeTree(EventObject e) {
        TreeNode root = this.getTreeModel().createRootNode();
        this.treeModel.setRoot(root);
        this.treeModel.setCurrentNodeId((Object)root.getId());
    }

    @Override
    public void initTreeToolbar(EventObject e) {
        this.treeModel = this.getTreeListView().getTreeModel();
        GroupProp prop = this.treeModel.getGroupProp();
        if (!(prop instanceof ParentBasedataProp)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        }
    }

    @Override
    public void treeToolbarClick(EventObject e) {
    }

    public void setCustomerParam() {
    }

    @Override
    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
    }

    @Override
    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 20);
        e.setExpandedNode(node);
    }

    @Override
    public void refreshNode(RefreshNodeEvent e) {
    }

    @Override
    public void beforeTreeNodeClick(BeforeTreeNodeClickEvent e) {
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
    }

    @Override
    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter filter = this.nodeClickFilter();
        if (filter != null) {
            e.addQFilter(filter);
            e.setCancel(true);
        }
    }

    protected QFilter nodeClickFilter() {
        return null;
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.treeModel != null && this.treeModel.getGroupProp() != null) {
            if (e.getParameter().getStatus() == OperationStatus.ADDNEW) {
                Object currNodeId = this.treeModel.getCurrentNodeId();
                if (currNodeId != null && currNodeId.toString().compareTo(this.treeModel.getRoot().getId()) != 0) {
                    HashMap<String, Object> parentInfo = new HashMap<String, Object>();
                    parentInfo.put("key", this.treeModel.getGroupProp().getName());
                    parentInfo.put("value", this.treeModel.getCurrentNodeId());
                    e.getParameter().setCustomParam("tree_parent_id", parentInfo);
                }
            } else if (e.getParameter().getStatus() == OperationStatus.EDIT) {
                TreeNode node = this.treeModel.getRoot().getTreeNode(e.getParameter().getPkId().toString());
                if (node == null) {
                    return;
                }
                String currNodeId = node.getId();
                if (currNodeId != null && currNodeId.toString().compareTo(this.treeModel.getRoot().getId()) != 0) {
                    HashMap<String, String> parentInfo = new HashMap<String, String>();
                    parentInfo.put("key", this.treeModel.getGroupProp().getName());
                    parentInfo.put("value", currNodeId);
                    e.getParameter().setCustomParam("tree_curr_id", parentInfo);
                }
            }
        }
    }

    public void search(SearchEnterEvent evt) {
    }
}

