/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.plugin;

import java.util.EventObject;
import java.util.function.Consumer;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.control.events.MobileSearchInitEvent;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.events.AfterMobileListPushDownRefreshEvent;
import kd.bos.form.events.AfterMobileListPushDownRefreshListener;
import kd.bos.form.events.MobFilterSortInitArgs;
import kd.bos.form.events.MobFilterSortSearchClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.IMobFormPlugin;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.plugin.IMobListPlugin;

public class MobListViewPluginProxy
extends AbstractListViewPluginProxy {
    private static final String SPAN_TYPE_PLUGIN = "plugin";

    private void invokeMobListMethod(Consumer<IFormPlugin> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IFormPlugin pl : this.plugIns) {
            if (!this.isNotOverride(pl.getClass(), methodName, parameterTypes) || !(pl instanceof IMobListPlugin)) continue;
            consumer.accept(pl);
        }
    }

    public void fireMobileSearchInit(MobileSearchInitEvent args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobileSearchInit"));){
                ((IMobListPlugin)plugin).mobileSearchInit(args);
            }
        }, "mobileSearchInit", MobileSearchInitEvent.class);
    }

    public void fireMobileSearchFocus() {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobileSearchFocus"));){
                ((IMobListPlugin)plugin).mobileSearchFocus();
            }
        }, "mobileSearchFocus", new Class[0]);
    }

    public void fireMobileSearchTextChange(MobileSearchTextChangeEvent args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobileSearchTextChange"));){
                ((IMobListPlugin)plugin).mobileSearchTextChange(args);
            }
        }, "mobileSearchTextChange", MobileSearchTextChangeEvent.class);
    }

    public void fireLocate(LocateEvent e) {
        this.invokeMethod(plugin -> {
            if (plugin instanceof IMobFormPlugin) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".locate"));){
                    ((IMobFormPlugin)plugin).locate(e);
                }
            }
        }, "locate", new Class[0]);
    }

    public void afterPushDownRefresh(AfterMobileListPushDownRefreshEvent evt) {
        this.invokeMobListMethod(plugin -> {
            if (plugin instanceof AfterMobileListPushDownRefreshListener) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterPushDownRefresh"));){
                    ((AfterMobileListPushDownRefreshListener)plugin).afterPushDownRefresh(evt);
                }
            }
        }, "afterPushDownRefresh", AfterMobileListPushDownRefreshEvent.class);
    }

    public void fireMobFilterSortInit(MobFilterSortInitArgs args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobFilterSortInit"));){
                ((IMobListPlugin)plugin).mobFilterSortInit(args);
            }
        }, "mobFilterSortInit", MobFilterSortInitArgs.class);
    }

    public void fireMobFilterSortSearchClick(MobFilterSortSearchClickArgs args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobFilterSortSearchClick"));){
                ((IMobListPlugin)plugin).mobFilterSortSearchClick(args);
            }
        }, "mobFilterSortSearchClick", MobFilterSortSearchClickArgs.class);
    }

    public void fireMobFilterSortAfterSearchClick(MobFilterSortSearchClickArgs args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobFilterSortAfterSearchClick"));){
                ((IMobListPlugin)plugin).mobFilterSortAfterSearchClick(args);
            }
        }, "mobFilterSortAfterSearchClick", MobFilterSortSearchClickArgs.class);
    }

    public void fireMobFilterSortBeforeF7Select(BeforeFilterF7SelectEvent args) {
        this.invokeMobListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".mobFilterSortBeforeF7Select"));){
                ((IMobListPlugin)plugin).mobFilterSortBeforeF7Select(args);
            }
        }, "mobFilterSortBeforeF7Select", BeforeFilterF7SelectEvent.class);
    }

    public void fireAfterMobilePageClose(EventObject e) {
        this.invokeMethod(plugin -> {
            if (plugin instanceof IMobFormPlugin) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterMobilePageClose"));){
                    ((IMobFormPlugin)plugin).afterMobilePageClose(e);
                }
            }
        }, "afterMobilePageClose", new Class[]{EventObject.class});
    }
}

