/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ActiveViewEvent;
import kd.bos.form.control.events.ActiveViewListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class StandardTreeListPlugin
extends AbstractTreeListPlugin
implements ActiveViewListener {
    protected static final String BillList_Key = "billlistap";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected static final String SplitContainer_Key = "splitcontainerap";
    private static final String TBLDISABLE = "tbldisable";
    private static final String LONGNUMBER = "longnumber";
    private static final String BOS_FORM_CORE = "bos-form-core";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BillList_Key);
        if (billList != null) {
            billList.addActiveViewListener(this);
        }
    }

    @Override
    public void treeToolbarClick(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        Control ctl = (Control)e.getSource();
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = prop.getBaseEntityId();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (ctl.getKey().equals("btnnew")) {
            this.addGroupNode(entityId, currentNodeId);
        } else if (ctl.getKey().equals("btnedit")) {
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_0", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            if (!prop.isNeedRefreshTree()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u4fee\u6539\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_2", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            this.editGroupNode(entityId, currentNodeId);
        } else if (ctl.getKey().equals("btndel")) {
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_3", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            if (!prop.isNeedRefreshTree()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u5220\u9664\u8282\u70b9\u3002", (String)"StandardTreeListPlugin_4", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
            String text = currentNode.getText();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u5206\u7ec4\"%s\"\uff1f", (String)"StandardTreeListPlugin_5", (String)BOS_FORM_CORE, (Object[])new Object[0]), text);
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        }
    }

    protected void loadChildNodes(TreeNode node) {
    }

    @Override
    public void search(SearchEnterEvent evt) {
        List treeNodes;
        super.search(evt);
        String searchText = evt.getText();
        TreeNode rootNode = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(this.getClass().getName() + "loadChildNodes"));){
                    this.loadChildNodes((TreeNode)node);
                }
            }, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(this.getClass().getName() + "loadChildNodes"));){
                    this.loadChildNodes((TreeNode)node);
                }
            }, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"StandardTreeListPlugin_6", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = rootNode.getTreeNode(parentid);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentid);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection listSelectedRowCollection;
        GroupProp prop = this.getTreeModel().getGroupProp();
        if (!(prop instanceof ParentBasedataProp)) {
            return;
        }
        String entityName = prop.getEntityType().getName();
        String listCaption = this.getView().getFormShowParameter().getCaption();
        if ((evt.getItemKey().equals(TBLDISABLE) || evt.getItemKey().equals("tbldel")) && (listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows()) != null && !listSelectedRowCollection.isEmpty()) {
            QFilter[] filters;
            ORM orm = ORM.create();
            Object[] ids = new Object[listSelectedRowCollection.size()];
            Object[] numbers = new Object[listSelectedRowCollection.size()];
            for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
                numbers[i] = listSelectedRowCollection.get(i).getNumber();
            }
            QFilter filter = new QFilter("parent", "in", (Object)ids);
            if (evt.getItemKey().equals(TBLDISABLE)) {
                filter.and(new QFilter("enable", "!=", (Object)"0"));
            }
            if (orm.exists(entityName, filters = new QFilter[]{filter})) {
                evt.setCancel(true);
                if (evt.getItemKey().equals(TBLDISABLE)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"StandardTreeListPlugin_8", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s%2$s\u6709\u4e0b\u7ea7%3$s\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u57fa\u7840\u8d44\u6599\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardTreeListPlugin_9", (String)BOS_FORM_CORE, (Object[])new Object[0]), listCaption, Arrays.toString(numbers), listCaption), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("disablebyall", (IFormPlugin)this));
                } else if (evt.getItemKey().equals("tbldel")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"StandardTreeListPlugin_10", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s\uff1a\u5c06\u5220\u9664\u672c\u6761\u6570\u636e\u53ca\u5176\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardTreeListPlugin_11", (String)BOS_FORM_CORE, (Object[])new Object[0]), Arrays.toString(numbers)), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("delbyall", (IFormPlugin)this));
                }
            }
        }
    }

    private void addGroupNode(String entityId, String currentNodeId) {
        BasedataEntityType basedataEntityType;
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_add");
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        if (!currentNodeId.equals(this.getTreeModel().getRoot().getId()) && (basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId)) != null) {
            HashMap<String, String> parentInfo = new HashMap<String, String>();
            for (IDataEntityProperty pro : basedataEntityType.getProperties()) {
                if (!(pro instanceof ParentBasedataProp)) continue;
                parentInfo.put("key", pro.getName());
                parentInfo.put("value", currentNodeId);
                formShowParameter.setCustomParam("tree_parent_id", parentInfo);
                break;
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void editGroupNode(String entityId, String currentNodeId) {
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_edit");
        formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("operate", (Object)"edit");
        HashMap<String, String> parentInfo = new HashMap<String, String>();
        parentInfo.put("value", currentNodeId);
        formShowParameter.setCustomParam("tree_curr_id", parentInfo);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @SdkInternal
    protected BillShowParameter createFormShowParameter(String entityId, String currentNodeId, String actionId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(entityId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("table", (Object)this.getTreeModel().getGroupProp().getGroupTableName());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, actionId);
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setCustomParam("id", (Object)currentNodeId);
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("group_bar_add".equals(closedCallBackEvent.getActionId()) || "group_bar_edit".equals(closedCallBackEvent.getActionId()) || "newcallback".equals(closedCallBackEvent.getActionId())) {
            String key = this.getTreeModel().getGroupProp().getName();
            Object value = closedCallBackEvent.getReturnData();
            boolean needRefresh = this.getTreeModel().getGroupProp().isNeedRefreshTree();
            if (needRefresh) {
                this.updatePageCache(null);
                if (this.treeListView.getTreeModel().getRoot() == null) {
                    this.treeListView.refresh();
                } else if (value != null) {
                    if (!(value instanceof Map)) {
                        String currenNodeId = value.toString();
                        TreeNode currenNode = this.treeListView.getTreeModel().getRoot().getTreeNode(currenNodeId);
                        if (StringUtils.isBlank((CharSequence)currenNode.getLongNumber())) {
                            String rootId = this.treeListView.getTreeModel().getRoot().getId();
                            this.treeListView.getTreeModel().refreshNode((Object)rootId);
                            this.treeListView.refreshTreeNode(rootId);
                        } else {
                            this.treeListView.getTreeModel().refreshNode((Object)currenNodeId);
                            this.treeListView.refreshTreeNode(currenNodeId);
                        }
                        BillList billList = (BillList)this.getView().getControl(BillList_Key);
                        billList.refresh();
                        return;
                    }
                    String currenNodeId = (String)((Map)value).get("currentNode");
                    String parentId = (String)((Map)value).get("parentId");
                    String rootId = this.treeListView.getTreeModel().getRoot().getId();
                    TreeNode currenNode = this.treeListView.getTreeModel().getRoot().getTreeNode(currenNodeId);
                    String oldParent = currenNode.getParentid();
                    if (StringUtils.isBlank((CharSequence)parentId) || !oldParent.equals(parentId) || StringUtils.isBlank((CharSequence)currenNode.getLongNumber())) {
                        this.treeListView.getTreeModel().refreshNode((Object)rootId);
                        this.treeListView.refreshTreeNode(rootId);
                    } else {
                        this.treeListView.getTreeModel().refreshNode((Object)parentId);
                        currenNode = this.treeListView.getTreeModel().getRoot().getTreeNode(currenNodeId);
                        if (currenNode == null) {
                            this.treeListView.refreshTreeNode(parentId);
                        } else {
                            this.treeListView.refreshTreeNode(currenNodeId);
                        }
                    }
                    BillList billList = (BillList)this.getView().getControl(BillList_Key);
                    billList.refresh();
                } else {
                    String rootId = this.treeListView.getTreeModel().getRoot().getId();
                    this.treeListView.getTreeModel().refreshNode((Object)rootId);
                    this.treeListView.refreshTreeNode(rootId);
                    BillList billList = (BillList)this.getView().getControl(BillList_Key);
                    billList.refresh();
                }
            } else {
                BillList billList = (BillList)this.getView().getControl(BillList_Key);
                billList.refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes && "group_bar_del".equals(event.getCallBackId())) {
            BasedataEntityType entityType;
            DynamicObjectCollection collection;
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
            ArrayList list = new ArrayList();
            if (props != null && (collection = this.getChildrenDynamicObject(new Object[]{nodeId}, entityType = props.getEntityType())) != null && !collection.isEmpty()) {
                collection.forEach(c -> list.add(c.getPkValue()));
            }
            if (list.size() > 1) {
                TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
                String text = currentNode.getText();
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"StandardTreeListPlugin_10", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u5b58\u5728\u4e0b\u7ea7\u5206\u7ec4\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u5206\u7ec4\u53ca\u6240\u6709\u4e0b\u7ea7\u5206\u7ec4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardTreeListPlugin_13", (String)BOS_FORM_CORE, (Object[])new Object[0]), text), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("delbygroup", (IFormPlugin)this));
            } else {
                IOperationResult result = this.getTreeModel().deleteGroup(new Object[]{nodeId});
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"StandardTreeListPlugin_14", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"StandardTreeListPlugin_15", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
                if (!result.getSuccessPkIds().isEmpty()) {
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId);
                    this.getTreeModel().deleteNode(node, false);
                    TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid());
                    if (parentNode != null) {
                        this.updatePageCache(null);
                        this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                        this.treeListView.refreshTreeNode(parentNode.getId());
                        this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                    }
                }
            }
        } else if ("delbyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(this.getClass().getName() + "delete"));){
                this.delete(event);
            }
        } else if ("disablebyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(this.getClass().getName() + "disable"));){
                this.disable(event);
            }
        } else if ("enablebyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(this.getClass().getName() + "enable"));){
                this.enable(event);
            }
        } else if (event.getResult() == MessageBoxResult.Yes && "delbygroup".equals(event.getCallBackId())) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
            ArrayList list = new ArrayList();
            if (props != null) {
                BasedataEntityType entityType = props.getEntityType();
                DynamicObjectCollection collection = this.getChildrenDynamicObject(new Object[]{nodeId}, entityType);
                collection.forEach(c -> list.add(c.getPkValue()));
            }
            if (list.size() > 0) {
                IOperationResult result = this.getTreeModel().deleteGroup(list.toArray());
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"StandardTreeListPlugin_14", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"StandardTreeListPlugin_15", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
                if (!result.getSuccessPkIds().isEmpty()) {
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId);
                    this.getTreeModel().deleteNode(node, false);
                    TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid());
                    if (parentNode != null) {
                        this.updatePageCache(null);
                        this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                        this.treeListView.refreshTreeNode(parentNode.getId());
                        this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                    }
                }
            }
        }
    }

    public void delete(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
        }
    }

    public void disable(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("disable");
        }
    }

    public void enable(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("enable");
        }
    }

    public void activeView(ActiveViewEvent evt) {
        SplitContainer splitContainer = (SplitContainer)this.getView().getControl(SplitContainer_Key);
        if (splitContainer == null) {
            return;
        }
        switch (evt.getView()) {
            case "qingview": {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
                break;
            }
            default: {
                splitContainer.changeFlexStatus(SplitDirection.right, false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String type;
        super.beforeDoOperation(args);
        if ("kd.bos.entity.operate.Delete".equals(args.getSource().getClass().getName())) {
            args.setListSelectedData(this.deleteOperation(args));
        } else if ("kd.bos.entity.operate.StatusConvert".equals(args.getSource().getClass().getName()) && "disable".equals(type = ((AbstractOperate)args.getSource()).getType())) {
            args.setListSelectedData(this.disableOperation(args));
        }
    }

    public DynamicObjectCollection getChildrenDynamicObject(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Object[] ids = new Object[listSelectedRowCollection.size()];
        for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
            ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
        }
        return this.getChildrenDynamicObject(ids, entityType);
    }

    private DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty(LONGNUMBER) != null) {
            String entityName = entityType.getName();
            String selectFields = StringUtils.equals((CharSequence)number, (CharSequence)LONGNUMBER) ? "id,longnumber,parent.longnumber,enable" : "id,longnumber,parent.longnumber," + number + ",enable";
            String orderBy = "longnumber desc";
            int dbType = entityType.getPrimaryKey().getDbType();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = DbTypeConverter.safeConvert((int)dbType, (Object)ids[i]);
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                if (dynamicObject.getString(LONGNUMBER) == null || "".equals(dynamicObject.getString(LONGNUMBER).trim())) continue;
                list.add(dynamicObject.getString(LONGNUMBER));
            }
            ParentBasedataProp parentProp = null;
            DataEntityPropertyCollection props = entityType.getProperties();
            for (IDataEntityProperty prop : props) {
                if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
                parentProp = (ParentBasedataProp)prop;
                break;
            }
            String longNumberDLM = ".";
            if (parentProp != null) {
                longNumberDLM = parentProp.getLongNumberDLM();
            }
            QFilter baseQfilter = new QFilter("id", "in", (Object)ids);
            if (ids.length > 1000) {
                return collection;
            }
            for (int i = 0; i < list.size(); ++i) {
                baseQfilter.or(new QFilter(LONGNUMBER, "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
            }
            if (list.isEmpty()) {
                return collection;
            }
            return orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
        }
        return null;
    }

    public ListSelectedRowCollection deleteOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection sortListSelectedRowCollection = args.getListSelectedData();
        GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
        if (props instanceof ParentBasedataProp) {
            BasedataEntityType entityType = props.getEntityType();
            String primaryKey = entityType.getPrimaryKey().getName();
            DynamicObjectCollection deleteCol = this.getChildrenDynamicObject(args, entityType);
            if (deleteCol != null) {
                sortListSelectedRowCollection = new ListSelectedRowCollection();
                for (DynamicObject dynamicObject : deleteCol) {
                    ListSelectedRow rows = new ListSelectedRow(dynamicObject.get(primaryKey));
                    if (sortListSelectedRowCollection.contains((Object)rows)) continue;
                    sortListSelectedRowCollection.add((Object)rows);
                }
            }
        }
        return sortListSelectedRowCollection;
    }

    public ListSelectedRowCollection disableOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection sortListSelectedRowCollection = args.getListSelectedData();
        GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
        if (props instanceof ParentBasedataProp) {
            BasedataEntityType entityType = props.getEntityType();
            String primaryKey = entityType.getPrimaryKey().getName();
            DynamicObjectCollection disableCol = this.getChildrenDynamicObject(args, entityType);
            if (disableCol != null) {
                sortListSelectedRowCollection = new ListSelectedRowCollection();
                for (DynamicObject dynamicObject : disableCol) {
                    ListSelectedRow rows = new ListSelectedRow(dynamicObject.get(primaryKey));
                    sortListSelectedRowCollection.add((Object)rows);
                }
            }
        }
        return sortListSelectedRowCollection;
    }

    public ListSelectedRowCollection enableOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection sortListSelectedRowCollection = args.getListSelectedData();
        GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
        if (props instanceof ParentBasedataProp) {
            BasedataEntityType entityType = props.getEntityType();
            return this.getOperationData(args, entityType);
        }
        return sortListSelectedRowCollection;
    }

    public ListSelectedRowCollection getOperationData(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        return null;
    }

    private void updatePageCache(List<TreeNode> treeNodes) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String treeNodesString = null;
        if (treeNodes != null) {
            treeNodesString = SerializationUtils.toJsonString(treeNodes);
        }
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        pageCache.put(matchNodesCacheKey, treeNodesString);
        pageCache.put(searchNodesCacheKey, treeNodesString);
        pageCache.put(searchIndexCacheKey, String.valueOf(0));
    }
}

