/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.notification;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.notification.INotificationClick;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.events.ButtonClickEventArgs;

public class NotificationClickProxy {
    private IFormView formView;
    private String notificationId;
    private NotificationFormInfo notificationFormInfo;

    public NotificationClickProxy(IFormView formView, String notificationId) {
        this.formView = formView;
        this.notificationId = notificationId;
        this.notificationFormInfo = NotificationClientCache.getNotificationFormInfo((String)notificationId);
    }

    public void click(String buttonKey) {
        INotificationClick notificationClick = this.createPlugin();
        if (notificationClick == null) {
            return;
        }
        ButtonClickEventArgs args = new ButtonClickEventArgs(buttonKey);
        notificationClick.buttonClick(args);
        this.release();
    }

    public void close() {
        INotificationClick notificationClick = this.createPlugin();
        if (notificationClick == null) {
            return;
        }
        notificationClick.closeCallBack();
        this.release();
    }

    public void release() {
        NotificationClientCache.removeNotification((String)RequestContext.get().getUserId(), (String)this.notificationId);
    }

    private INotificationClick createPlugin() {
        Class<?> notificationClickClass;
        if (this.notificationFormInfo == null || this.notificationFormInfo.getNotification() == null) {
            return null;
        }
        String clickClassName = this.notificationFormInfo.getNotification().getClickClassName();
        if (StringUtils.isBlank((CharSequence)clickClassName)) {
            ErrorCode ec = new ErrorCode("NOTIFICATION_CLASS_NAME_EMPTY", clickClassName);
            throw new KDException(ec, new Object[0]);
        }
        try {
            notificationClickClass = TypesContainer.getOrRegister((String)clickClassName);
        }
        catch (Exception ex) {
            try {
                notificationClickClass = Class.forName(clickClassName);
            }
            catch (ClassNotFoundException e) {
                ErrorCode ec = new ErrorCode("NOTIFICATION_CLASS_NOT_FOUND", clickClassName);
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        INotificationClick notificationClick = null;
        try {
            notificationClick = (INotificationClick)notificationClickClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ErrorCode ec = new ErrorCode("NOTIFICATION_CLASS_INIT_FAILED", clickClassName);
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        notificationClick.setContext(this.formView, this.notificationFormInfo, this.notificationId);
        return notificationClick;
    }
}

