/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.CollectionUtils;

@SdkPublic
public abstract class AbstractReportListModel
extends AbstractReportModel
implements IReportListModel {
    private static final Log log = LogFactory.getLog(AbstractReportListModel.class);
    private Map<Integer, DynamicObject> rowDataList = new HashMap<Integer, DynamicObject>();
    private List<AbstractReportColumn> columns;
    private ReportTaskResult taskResult;
    private Map<String, Object> summaryValueMap;
    private int rowCount = -1;

    public Object getValue(int rowIndex, String columnKey) {
        DynamicObject rowData = this.rowDataList.get(rowIndex);
        if (rowData == null) {
            rowData = this.getRowData(rowIndex);
            this.rowDataList.put(rowIndex, rowData);
        }
        if (rowData != null) {
            return rowData.get(columnKey);
        }
        return null;
    }

    public DynamicObject getRowData(int rowIndex) {
        DynamicObjectCollection rowSet = this.getRowData(rowIndex - 1, 1);
        DynamicObject rowData = null;
        if (rowSet != null && !rowSet.isEmpty()) {
            rowData = (DynamicObject)rowSet.get(0);
        }
        return rowData;
    }

    @SdkInternal
    public abstract DynamicObjectCollection getRowData(int var1, int var2);

    @SdkInternal
    protected abstract DynamicObjectCollection getRowData(int var1, int var2, String var3);

    @SdkInternal
    protected abstract DynamicObjectCollection getRowData(int var1, int var2, String var3, Integer var4);

    @SdkInternal
    public abstract DynamicObjectCollection getRowData(int var1, int var2, boolean var3);

    @SdkInternal
    protected void setColumns(List<AbstractReportColumn> columns) {
        this.columns = columns;
    }

    public List<AbstractReportColumn> getColumns() {
        ReportTaskResult result = this.getReportTaskResult();
        if (result != null) {
            List orgColumns = result.getReportColumns();
            ArrayList<AbstractReportColumn> reportColumns = new ArrayList<AbstractReportColumn>(orgColumns.size());
            CollectionUtils.addAll(reportColumns, (Object[])new Object[orgColumns.size()]);
            Collections.copy(reportColumns, orgColumns);
            return reportColumns;
        }
        return this.columns;
    }

    @Override
    @SdkInternal
    protected ReportTaskParam getTaskParam(Object otherParam) {
        ReportTaskParam param = super.getTaskParam(otherParam);
        param.setReportTree(false);
        param.setColumns(this.columns);
        return param;
    }

    public List<String> getSummaryTitleFields() {
        return this.getReportTaskResult().getSummaryTitleFields();
    }

    public int getRowCount() {
        ReportTaskResult result = this.getReportTaskResult();
        if (result != null) {
            ReportResultLimit limit = this.getReportCache().getReportResultLimit(this.getPageId(), this.getCtrlId());
            this.rowCount = result.getRowCount();
            if (limit != null && this.rowCount > limit.getLimitCount()) {
                log.info("\u83b7\u53d6\u6570\u636e\u8d85\u8fc7\u9650\u5236\u884c\u6570\uff0climitCount={}, rowCount={}", (Object)limit.getLimitCount(), (Object)this.rowCount);
                this.rowCount = limit.getLimitCount();
            }
        } else {
            this.rowCount = 0;
        }
        return this.rowCount;
    }

    @SdkInternal
    protected String getResultId() {
        ReportTaskResult result = this.getReportTaskResult();
        if (result != null) {
            return result.getResultId();
        }
        return null;
    }

    public ReportTaskResult getReportTaskResult() {
        if (this.taskResult == null) {
            this.taskResult = this.getReportCache().getReportTaskResult(this.getPageId(), this.getCtrlId());
        }
        return this.taskResult;
    }

    public void setReportTaskResult(ReportTaskResult result) {
        this.taskResult = result;
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).firePreProcessExportData(exportColumns, data, numberFormatProvider);
        }
    }

    public Map<String, Object> getSummaryValueMap() {
        ReportTaskResult result;
        if (this.summaryValueMap == null && (result = this.getReportTaskResult()) != null) {
            this.summaryValueMap = result.getSummaryValueMap();
        }
        return this.summaryValueMap;
    }

    @SdkInternal
    protected abstract Map<String, Object> formatSummaryValue();
}

