/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.operate.FlexGridConfigRow;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.IReportListDataPlugin;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportResultReadOption;
import kd.bos.entity.report.ReportServiceProxyPlugin;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.ClientBR;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.TotalType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.format.FieldFormatContext;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.rule.ReportClientRuleExecuteContext;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.constant.UserParaType;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.RptFieldControl;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.events.FlexEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.events.SummaryEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.export.ExportManager;
import kd.bos.report.filter.TableHeadFilter;
import kd.bos.report.flex.FlexColumnSplitService;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.report.processor.IReportColumnProcessor;
import kd.bos.report.processor.ReportColumnProcessorFactory;
import kd.bos.report.proxy.ReportListProxy;
import kd.bos.report.selection.ReportRowSelectWrapper;
import kd.bos.report.summate.ReportCalculateTotal;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.tips.IHotTipsService;
import kd.bos.userconfig.GridConfigDAO;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.SerializationUtils;

@KSObject
@SdkPublic
public class ReportList
extends AbstractGrid
implements ICloseCallBack {
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String DATA_INDEX = "dataIndex";
    private static final String IS_FIXED = "isFixed";
    private static final String TEXT_ALIGN = "text-align";
    private static final String HEADER = "header";
    private static final String CELL_STYLE_RULES = "cellStyleRules";
    private static final String ROW_STYLE_RULES = "rowStyleRules";
    private static final String FILTER = "filter";
    private static final String VALUE = "Value";
    private static final String VISIBLE = "visible";
    private static final String SORT = "sort";
    private static final String CHILDREN = "children";
    private static final String SELECT_ROWS = "selRows";
    private static final String NOT_SELECT_ROWS = "notSelRows";
    private static final String FLEXORGIDFIELD = "flexorgidfield";
    private static final int MAX_PAGE_ROWS = 5000;
    private String reportPluginClassName;
    private List<Plugin> reportExtPlugins;
    private List<AbstractReportColumn> columns = new ArrayList<AbstractReportColumn>();
    private AbstractReportListModel reportModel;
    private RptFieldControl rptFldCtrl = null;
    private String DataSource;
    private boolean colFilter = false;
    private boolean colSort = false;
    private boolean is_AsynQuery = false;
    private boolean defaultSelectRow = false;
    private String totalType;
    private boolean is_ShowSeq = true;
    private int pageRows = 200;
    private String dataSourceId;
    private boolean selectedAll = false;
    private boolean asyncTotal = false;
    private boolean isShowCount = true;
    private static final Log log = LogFactory.getLog(ReportList.class);
    private static final String ISTREEREPORTLIST = "isTreeReportList";
    private static final String TREEEXPANDCOLID = "treeExpandColId";
    private static final String FLEX_PARAM = "flexParam";
    private static final String CONTROL_STATES = "controlstates";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private int order2ndMaxRowCount = 0;
    private int filter2ndMaxRowCount = 0;
    public static Method reportPropUtil_createReportType;
    private List<Map<String, String>> initField;
    private List<Consumer<PackageDataEvent>> packageDataListeners = new ArrayList<Consumer<PackageDataEvent>>();
    List<ClientBR> clientRules = new ArrayList<ClientBR>();
    private IReportCache reportCache;
    private boolean hasSettingRow = true;
    private Map<String, String> mergeMap = new HashMap<String, String>();
    private ReportListProxy reportListProxy;
    private FlexColumnSplitService flexColumnSplitService;
    Map<String, FlexValueFormatter> flexFormaterMap = new HashMap<String, FlexValueFormatter>();
    private ReportRowSelectWrapper rowSelectWrapper;
    private List<Plugin> reportQueryPlugins;

    public int getOrder2ndMaxRowCount() {
        return this.order2ndMaxRowCount;
    }

    public int getFilter2ndMaxRowCount() {
        return this.filter2ndMaxRowCount;
    }

    public void setOrder2ndMaxRowCount(int order2ndMaxRowCount) {
        if (order2ndMaxRowCount > 100000) {
            order2ndMaxRowCount = 100000;
        }
        this.order2ndMaxRowCount = order2ndMaxRowCount;
    }

    public void setFilter2ndMaxRowCount(int filter2ndMaxRowCount) {
        this.filter2ndMaxRowCount = filter2ndMaxRowCount;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getInitField() {
        return this.initField;
    }

    public void setInitField(List<Map<String, String>> initField) {
        this.initField = initField;
    }

    @SimplePropertyAttribute
    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public boolean isAsyncTotal() {
        return this.asyncTotal;
    }

    public void setAsyncTotal(boolean asyncTotal) {
        this.asyncTotal = asyncTotal;
    }

    public void addPackageDataListener(Consumer<PackageDataEvent> packageDataListener) {
        this.packageDataListeners.add(packageDataListener);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ClientBR.class)
    public List<ClientBR> getClientRules() {
        return this.clientRules;
    }

    public void setClientRules(List<ClientBR> clientRules) {
        this.clientRules = clientRules;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=AbstractReportColumn.class)
    public List<AbstractReportColumn> getColumns() {
        return this.columns;
    }

    @SimplePropertyAttribute
    public String getReportPluginClassName() {
        return this.reportPluginClassName;
    }

    public void setReportPluginClassName(String reportPluginClassName) {
        this.reportPluginClassName = reportPluginClassName;
    }

    @SimplePropertyAttribute
    public List<Plugin> getReportExtPlugins() {
        return this.reportExtPlugins;
    }

    public void setReportExtPlugins(List<Plugin> reportExtPlugins) {
        this.reportExtPlugins = reportExtPlugins;
    }

    @SimplePropertyAttribute
    public String getDataSource() {
        return this.DataSource;
    }

    public void setDataSource(String dataSource) {
        this.DataSource = dataSource;
    }

    @SimplePropertyAttribute(name="ShowSeq")
    @DefaultValueAttribute(value="true")
    public boolean isShowSeq() {
        return this.is_ShowSeq;
    }

    public void setPageRows(int pageRows) {
        if (pageRows > 0) {
            this.pageRows = pageRows;
        }
    }

    public void setShowSeq(boolean isShowSeq) {
        this.is_ShowSeq = isShowSeq;
    }

    public boolean isAsynQuery() {
        return this.is_AsynQuery;
    }

    public void setAsynQuery(boolean isAsynQuery) {
        this.is_AsynQuery = isAsynQuery;
    }

    public String getTotalType() {
        return this.totalType;
    }

    public void setTotalType(String totalType) {
        TotalType totalTypeEnum = TotalType.createTotalType((String)totalType);
        if (totalTypeEnum != null) {
            this.totalType = totalTypeEnum.getValue();
        }
    }

    public boolean isDefaultSelectRow() {
        return this.defaultSelectRow;
    }

    public void setDefaultSelectRow(boolean defaultSelectRow) {
        this.defaultSelectRow = defaultSelectRow;
    }

    @SimplePropertyAttribute(name="SelectedAll")
    @DefaultValueAttribute(value="false")
    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    @SimplePropertyAttribute(name="ColFilter", displayName="supports column header filtering")
    public boolean isColFilter() {
        return this.colFilter;
    }

    public void setColFilter(boolean colFilter) {
        this.colFilter = colFilter;
    }

    @SimplePropertyAttribute(name="ColSort", displayName="supports column header sorting")
    public boolean isColSort() {
        return this.colSort;
    }

    public void setColSort(boolean colSort) {
        this.colSort = colSort;
    }

    public void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    public IReportCache getReportCache() {
        if (this.reportCache == null) {
            this.reportCache = ReportCacheManager.getInstance().getCache();
        }
        return this.reportCache;
    }

    public boolean isShowCount() {
        return this.isShowCount;
    }

    public void setShowCount(boolean showCount) {
        this.isShowCount = showCount;
    }

    public void submitTask(ReportQueryParam repotParam, Object selectedObj) {
        this.setTreeReportList();
        this.setFlexParamMap();
        repotParam.setTreeReportList(Boolean.parseBoolean(this.getView().getPageCache().get(ISTREEREPORTLIST)));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && formShowParameter.getCustomParam("bos_reportConcurrencyQueryLimit") != null && StringUtils.equals((CharSequence)((CharSequence)formShowParameter.getCustomParam("bos_reportConcurrencyQueryLimit")), (CharSequence)"false")) {
            repotParam.getCustomParam().put("bos_reportConcurrencyQueryLimit", "false");
        }
        this.getReportCache().setReportQueryParam(this.getView().getPageId(), repotParam);
        this.getView().getPageCache().put("isAsyncTotal", String.valueOf(this.isAsyncTotal()));
        String flag = this.getView().getPageCache().get("DirectExportExcel");
        this.getAbstractReportModel().submitTask(repotParam, selectedObj);
        if (!this.is_AsynQuery && !StringUtils.equals((CharSequence)flag, (CharSequence)"exportExcelNoQuery")) {
            this.initGrid();
        }
    }

    public String exportExcel() {
        return new ExportManager(this).exportExcel();
    }

    public String exportPdf(PaperSetting info, Map<String, Object> columnSetting) {
        return new ExportManager(this).exportPdf(info, columnSetting);
    }

    public String getExcelExporter() {
        return "kd.bos.mvc.export.GridExcelExporter";
    }

    public String getPdfExporter() {
        return "kd.bos.mvc.export.GridPdfExporter";
    }

    @KSMethod
    public void refresh() {
        this.clearEntryState();
        this.getView().getPageCache().remove(this.getBottomDataKey());
        this.getAbstractReportModel().refresh();
        Map<String, Object> data = null;
        ReportResultReadOption.setRead2ndFilterData((boolean)true);
        data = this.isSupportSplitPage() ? this.getData(0, this.getPageRows()) : this.getData(0, 0);
        if (this.isDefaultSelectRow()) {
            data.put("selectRows", new int[]{0});
        }
        this.clientViewProxy.setEntryProperty(this.getKey(), "data", data);
    }

    private void setTreeReportList() {
        TreeReportListEvent event = new TreeReportListEvent();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setTreeReportList(event);
        }
        this.getView().getPageCache().put(ISTREEREPORTLIST, String.valueOf(event.isTreeReportList()));
        this.getView().getPageCache().put(TREEEXPANDCOLID, event.getTreeExpandColId());
    }

    private void setFlexParamMap() {
        FlexEvent event = new FlexEvent();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setFlexProperty(event);
        }
        if (!CollectionUtils.isEmpty(event.getFlexProperty())) {
            this.getView().getPageCache().put(FLEX_PARAM, kd.bos.dataentity.serialization.SerializationUtils.toJsonString(event.getFlexProperty()));
        }
    }

    @KSMethod
    public void initGrid() {
        Map<String, Object> data;
        this.getView().getPageCache().remove(this.getBottomDataKey());
        IReportListModel reportModel = this.getReportModel();
        List<AbstractReportColumn> columns = this.getReportListProxy().getColumnList(reportModel);
        if (CollectionUtils.isEmpty(columns)) {
            log.info("\u672a\u83b7\u53d6\u5230\u62a5\u8868\u5217\u4fe1\u606f");
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        List<GridConfigurationRow> gridConfigRows = this.getReportListProxy().getUserGridConfigRows();
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>();
        columns.forEach(col -> newColumns.add((AbstractReportColumn)SerializationUtils.clone((Serializable)col)));
        this.createGrid(clientViewProxy, newColumns, gridConfigRows, this.getUserOption());
        ReportResultReadOption.setRead2ndFilterData((boolean)true);
        if (this.isSupportSplitPage()) {
            int pageRows = this.getPageRows();
            data = this.getData(0, pageRows);
            this.getView().getPageCache().put("lastGetVirtualDataStartIndex", String.valueOf(0));
            this.getView().getPageCache().put("lastGetVirtualDataLength", String.valueOf(pageRows));
            this.setHottips();
        } else {
            data = this.getData(0, 0);
        }
        if (this.isDefaultSelectRow()) {
            data.put("selectRows", new int[]{0});
        }
        clientViewProxy.setEntryProperty(this.getKey(), "data", data);
    }

    @KSMethod
    public void initEmptyGrid() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(10);
        data.put("datacount", Integer.valueOf(0));
        data.put(DATA_INDEX, new HashMap(0));
        data.put("pagerows", Integer.valueOf(this.getPageRows()));
        data.put("pid", null);
        data.put("queryId", null);
        data.put("rows", new ArrayList(0));
        data.put("startIndex", Integer.valueOf(0));
        clientViewProxy.setEntryProperty(this.getKey(), "data", data);
    }

    public void loadAllData() {
        IReportListModel model = this.getReportModel();
        Map<String, Object> data = this.getData(0, model.getRowCount());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(this.getKey(), "data", data);
    }

    @KSMethod
    public void getVirtualData(int startIndex, int length) {
        String[] split;
        ReportResultReadOption.setRead2ndFilterData((boolean)true);
        if (this.isTreeReport()) {
            this.getVirtualData(startIndex, length, "0");
        } else {
            this.getVirtualData(startIndex, length, null);
        }
        String startIndexStr = this.getView().getPageCache().get("lastGetVirtualDataStartIndex");
        startIndexStr = StringUtils.isNotBlank((CharSequence)startIndexStr) ? ((split = startIndexStr.split(",")).length > 1 ? String.format("%1$s,%2$s", split[1], startIndex) : String.format("%1$s,%2$s", split[0], startIndex)) : String.valueOf(startIndex);
        this.getView().getPageCache().put("lastGetVirtualDataStartIndex", startIndexStr);
        this.getView().getPageCache().put("lastGetVirtualDataLength", String.valueOf(length));
        this.setHottips();
    }

    @KSMethod
    public void getVirtualData(int startIndex, int length, String parentId) {
        this.getVirtualData(startIndex, length, parentId, null);
    }

    @KSMethod
    public void getVirtualData(int startIndex, int length, String parentId, Integer currentSeq) {
        Map<String, Object> data = this.getData(startIndex, length, parentId, currentSeq);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(this.getKey(), "setVirtualData", new Object[]{data});
    }

    @KSMethod
    public void close() {
        this.getAbstractReportModel().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("reportFieldControl".equals(actionId)) {
            Map result = (Map)e.getReturnData();
            if (result != null) {
                String action = (String)result.get("action");
                GridConfigDAO gridConfigDAO = new GridConfigDAO();
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                Map option = (Map)result.get("option");
                String gridConfigStr = (String)result.get("gridConfig");
                List configRows = kd.bos.dataentity.serialization.SerializationUtils.fromJsonStringToList((String)gridConfigStr, GridConfigurationRow.class);
                String flexMaxSizeShowMapStr = this.getView().getPageCache().get("flexMaxSizeShowMap");
                Map flexMaxSizeShowMap = new HashMap();
                if (StringUtils.isNotEmpty((CharSequence)flexMaxSizeShowMapStr)) {
                    flexMaxSizeShowMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexMaxSizeShowMapStr, Map.class);
                    for (GridConfigurationRow row : configRows) {
                        if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)flexMaxSizeShowMap.get(row.getFieldKey())))) continue;
                        row.setLastFlexMaxSize(Integer.parseInt((String)flexMaxSizeShowMap.get(row.getFieldKey())));
                        row.setFlexMaxSize(Integer.parseInt((String)flexMaxSizeShowMap.get(row.getFieldKey())));
                    }
                }
                if ("setConfig".equals(action)) {
                    boolean isShowZero;
                    String childrenListStr = (String)result.get("rep_flex_children_list");
                    if (!StringUtils.isEmpty((CharSequence)childrenListStr)) {
                        List list = kd.bos.dataentity.serialization.SerializationUtils.fromJsonStringToList((String)childrenListStr, Map.class);
                        Map<String, List<GridConfigurationRow>> map = this.listToMap(list);
                        for (GridConfigurationRow row : configRows) {
                            if (CollectionUtils.isEmpty(map) || !map.containsKey(row.getFieldKey()) || CollectionUtils.isEmpty((Collection)map.get(row.getFieldKey())) || row.getChildren().size() != 0) continue;
                            row.setChildren(map.get(row.getFieldKey()));
                        }
                    }
                    gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), this.getEntryKey(), configRows);
                    this.getFlexColumnSplitService().clearFlexProperties();
                    ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>();
                    this.getReportListProxy().getColumnList(this.getReportModel()).forEach(col -> newColumns.add((AbstractReportColumn)SerializationUtils.clone((Serializable)col)));
                    boolean flag = false;
                    String gridConfigOld = (String)result.get("gridConfigOld");
                    if (StringUtils.isEmpty((CharSequence)gridConfigOld)) {
                        flag = true;
                    } else {
                        List gridConfigOldList = kd.bos.dataentity.serialization.SerializationUtils.fromJsonStringToList((String)gridConfigOld, GridConfigurationRow.class);
                        Map<String, Integer> flexSplitOldMap = gridConfigOldList.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
                        Map<String, Integer> flexSplitMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
                        for (Map.Entry<String, Integer> entry : flexSplitMap.entrySet()) {
                            if (entry.getValue() == null || entry.getValue().equals(flexSplitOldMap.get(entry.getKey()))) continue;
                            flag = true;
                            break;
                        }
                    }
                    String formId = this.getView().getFormShowParameter().getFormId();
                    DynamicObject dynamicObject = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)formId, (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.getKey());
                    boolean isshowzero = true;
                    if (dynamicObject != null && dynamicObject.containsProperty("isshowzero")) {
                        isshowzero = dynamicObject.getBoolean("isshowzero");
                    }
                    if ((isShowZero = Boolean.parseBoolean((String)result.get("isShowZero"))) != isshowzero) {
                        flag = true;
                    }
                    this.createGrid(clientViewProxy, newColumns, configRows, option);
                    if (flag) {
                        this.refresh();
                    }
                } else if ("reset".equals(action)) {
                    gridConfigDAO.deleteGridConfig(this.getView().getFormShowParameter().getFormId(), this.getEntryKey());
                    this.getFlexColumnSplitService().clearFlexProperties();
                    ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>();
                    this.columns.forEach(col -> newColumns.add((AbstractReportColumn)SerializationUtils.clone((Serializable)col)));
                    this.createGrid(clientViewProxy, newColumns, null, option);
                }
            }
        } else {
            this.getAbstractReportModel().close();
        }
    }

    private Map<String, List<GridConfigurationRow>> listToMap(List<Map<String, List<GridConfigurationRow>>> lsit) {
        HashMap<String, List<GridConfigurationRow>> map = new HashMap<String, List<GridConfigurationRow>>();
        for (Map<String, List<GridConfigurationRow>> listMap : lsit) {
            map.putAll(listMap);
        }
        return map;
    }

    public void listFieldsControl(List<Map<String, Object>> columnsWidthInFrontEnd) {
        if (this.isHasSettingRow()) {
            HashMap<String, Integer> column2Width = new HashMap<String, Integer>(16);
            for (Map<String, Object> reportColumn : columnsWidthInFrontEnd) {
                String key = (String)reportColumn.get("k");
                String colWidth = reportColumn.get("w").toString();
                try {
                    Integer width = Double.valueOf(colWidth).intValue();
                    column2Width.put(key, width);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification((String)key + "is a invalid number");
                }
            }
            ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
            List<AbstractReportColumn> columns = this.getReportListProxy().getColumnList(this.getReportModel());
            this.getFlexColumnSplitService().setCallParam("listFieldsControl");
            this.getFlexColumnSplitService().splitFlextColumn(columns);
            for (AbstractReportColumn item : columns) {
                Map col = item.createColumn();
                cols.add(col);
            }
            GridConfigRenderUtils.setListColumnFixed(cols, (List)this.getFreezeList());
            CloseCallBack closeCallBack = new CloseCallBack();
            FormShowParameter parameter = new FormShowParameter();
            List<GridConfigurationRow> resetGridConfig = this.buildGridConfigRowsWidth(cols, column2Width);
            parameter.setCustomParam("resetGridConfig", (Object)kd.bos.dataentity.serialization.SerializationUtils.toJsonString(resetGridConfig));
            parameter.setCustomParam("formId", (Object)this.getView().getFormShowParameter().getFormId());
            parameter.setCustomParam("entityNum", (Object)this.getView().getFormShowParameter().getFormId());
            ArrayList<FlexGridConfigRow> flexGridConfig = new ArrayList<FlexGridConfigRow>();
            List<GridConfigurationRow> gridConfig = this.buildGridConfigRows(cols, column2Width, this.getReportListProxy().getUserGridConfigRows(), flexGridConfig);
            if (CollectionUtils.isEmpty(this.reportListProxy.getUserGridConfigRows())) {
                GridConfigRenderUtils.setInitField(gridConfig, this.getInitField());
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            DynamicObject dynamicObject = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)formId, (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.getKey());
            boolean isshowzero = true;
            if (dynamicObject != null && dynamicObject.containsProperty("isshowzero")) {
                isshowzero = dynamicObject.getBoolean("isshowzero");
            }
            closeCallBack.setControlKey(this.getKey());
            closeCallBack.setActionId("reportFieldControl");
            parameter.setFormId("ide_gridconfig");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(closeCallBack);
            parameter.setCustomParam("gridConfig", (Object)kd.bos.dataentity.serialization.SerializationUtils.toJsonString(gridConfig));
            parameter.setCustomParam("sourceType", (Object)"report");
            parameter.setCustomParam("gridConfigKey", (Object)this.getKey());
            parameter.setCustomParam("flexGridConfig", (Object)kd.bos.dataentity.serialization.SerializationUtils.toJsonString(flexGridConfig));
            parameter.setCustomParam("initField", (Object)kd.bos.dataentity.serialization.SerializationUtils.toJsonString(this.getInitField()));
            parameter.setCustomParam("isshowzero", (Object)kd.bos.dataentity.serialization.SerializationUtils.toJsonString((Object)isshowzero));
            this.getView().showForm(parameter);
        }
    }

    public void postColWidth(String columnKey, String width) {
        List<GridConfigurationRow> userConfig = this.getReportListProxy().getUserGridConfigRows();
        Optional<GridConfigurationRow> gridConfigRow = userConfig.stream().filter(gridConfig -> gridConfig.getFieldKey().equals(columnKey)).findFirst();
        if (gridConfigRow.isPresent()) {
            GridConfigurationRow gridConfigurationRow = gridConfigRow.get();
            gridConfigurationRow.setColWidth(Integer.parseInt(width));
            GridConfigDAO gridConfigDAO = new GridConfigDAO();
            gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), this.getEntryKey(), userConfig);
        }
    }

    public boolean isHasSettingRow() {
        return this.hasSettingRow;
    }

    public void setHasSettingRow(boolean hasSettingRow) {
        this.hasSettingRow = hasSettingRow;
    }

    private List<GridConfigurationRow> buildGridConfigRowsWidth(Collection<Map<String, Object>> colsRunTimeMeta, Map<String, Integer> column2Width) {
        ArrayList<GridConfigurationRow> configRows = new ArrayList<GridConfigurationRow>(colsRunTimeMeta.size());
        for (Map<String, Object> reportColumnMeta : colsRunTimeMeta) {
            LocaleString header;
            boolean visible;
            String key = (String)reportColumnMeta.get(DATA_INDEX);
            boolean bl = visible = reportColumnMeta.get(VISIBLE) != null ? (Boolean)reportColumnMeta.get(VISIBLE) : true;
            if (!visible && !key.contains("___") || "fseq".equals(reportColumnMeta.get(DATA_INDEX)) || StringUtils.isBlank((CharSequence)(header = (LocaleString)reportColumnMeta.get(HEADER)).getLocaleValue())) continue;
            String fieldKey = this.mergeMap.get(key) == null ? key : this.mergeMap.get(key);
            Integer colWidth = column2Width.get(key) != null ? column2Width.get(key) : Integer.valueOf(0);
            boolean isFreeze = reportColumnMeta.get(IS_FIXED) != null ? (Boolean)reportColumnMeta.get(IS_FIXED) : false;
            GridConfigurationRow gridConfigurationRow = new GridConfigurationRow(header, colWidth.intValue(), (String)reportColumnMeta.get(TEXT_ALIGN), fieldKey, !visible, isFreeze);
            Object children = reportColumnMeta.get(CHILDREN);
            String flexMaxSizeShowMapStr = this.getView().getPageCache().get("flexMaxSizeShowMap");
            Map flexMaxSizeShowMap = new HashMap();
            if (StringUtils.isNotEmpty((CharSequence)flexMaxSizeShowMapStr) && (flexMaxSizeShowMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexMaxSizeShowMapStr, Map.class)).containsKey(key)) {
                children = null;
            }
            if (children != null) {
                gridConfigurationRow.setChildren(this.buildGridConfigRowsWidth((List)children, column2Width));
            } else {
                Map flexFieldCanSplitMap;
                String isDefaultSplitMapStr = this.getView().getPageCache().get("isDefaultSplitMap");
                String flexFieldCanSplitMapStr = this.getView().getPageCache().get("flexFieldCanSplitMap");
                if (StringUtils.isNotEmpty((CharSequence)isDefaultSplitMapStr) && StringUtils.isNotEmpty((CharSequence)flexMaxSizeShowMapStr) && StringUtils.isNotEmpty((CharSequence)flexFieldCanSplitMapStr) && (flexFieldCanSplitMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexFieldCanSplitMapStr, Map.class)).containsKey(fieldKey) && ((Boolean)flexFieldCanSplitMap.get(fieldKey)).booleanValue()) {
                    int maxSize = 40;
                    String size = (String)flexMaxSizeShowMap.get(fieldKey);
                    maxSize = size != null ? Integer.parseInt(size) : maxSize;
                    List<FlexProperty> flexPropertyList = this.getAllFlexProperties(fieldKey);
                    List<GridConfigurationRow> childrenList = this.getChildrenList(flexPropertyList, maxSize, fieldKey);
                    gridConfigurationRow.setChildren(childrenList);
                }
            }
            configRows.add(gridConfigurationRow);
        }
        return configRows;
    }

    private List<GridConfigurationRow> buildGridConfigRows(List<Map<String, Object>> colsRunTimeMeta, Map<String, Integer> column2Width, List<GridConfigurationRow> userGridConfigRows, List<FlexGridConfigRow> flexGridConfig) {
        ArrayList<GridConfigurationRow> configRows = new ArrayList<GridConfigurationRow>(colsRunTimeMeta.size());
        Map<String, Map<String, Object>> colsRunTimeMetaMap = this.getColsRunTimeMeta(colsRunTimeMeta);
        for (GridConfigurationRow row : userGridConfigRows) {
            boolean visible;
            String fieldKey;
            Map<String, Object> reportColumnMeta;
            if (this.getFlexColumnSplitService().getFlexFieldList().contains(row.getFieldKey()) && !this.getFlexColumnSplitService().isNeedSplit(row.getFieldKey()) && !CollectionUtils.isEmpty((Collection)row.getChildren()) && !this.getFlexColumnSplitService().isFlexType(row.getFieldKey()) || CollectionUtils.isEmpty(reportColumnMeta = colsRunTimeMetaMap.get(fieldKey = row.getFieldKey()))) continue;
            boolean bl = visible = reportColumnMeta.get(VISIBLE) != null ? (Boolean)reportColumnMeta.get(VISIBLE) : true;
            if (!visible && !fieldKey.contains("___")) continue;
            LocaleString header = (LocaleString)reportColumnMeta.get(HEADER);
            if (StringUtils.isBlank((CharSequence)header.getLocaleValue())) break;
            row.setFieldName(header);
            if (StringUtils.isEmpty((CharSequence)row.getTextAlign())) {
                row.setTextAlign("default");
            }
            configRows.add(row);
            Object children = reportColumnMeta.get(CHILDREN);
            if (children != null) {
                row.setChildren(this.buildGridConfigRows((List)children, column2Width, row.getChildren(), flexGridConfig));
            }
            colsRunTimeMeta.remove(reportColumnMeta);
        }
        String isDefaultSplitMapStr = this.getView().getPageCache().get("isDefaultSplitMap");
        String flexMaxSizeShowMapStr = this.getView().getPageCache().get("flexMaxSizeShowMap");
        String flexFieldCanSplitMapStr = this.getView().getPageCache().get("flexFieldCanSplitMap");
        if (StringUtils.isNotEmpty((CharSequence)isDefaultSplitMapStr)) {
            Map isDefaultSplitMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)isDefaultSplitMapStr, Map.class);
            Map flexMaxSizeShowMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexMaxSizeShowMapStr, Map.class);
            Map flexFieldCanSplitMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexFieldCanSplitMapStr, Map.class);
            for (Map.Entry entry : isDefaultSplitMap.entrySet()) {
                if (!flexFieldCanSplitMap.containsKey(entry.getKey()) || !((Boolean)flexFieldCanSplitMap.get(entry.getKey())).booleanValue()) continue;
                FlexGridConfigRow flexGridConfigRow = new FlexGridConfigRow();
                String key = (String)entry.getKey();
                flexGridConfigRow.setFlexMaxSize(Integer.parseInt((String)flexMaxSizeShowMap.get(key)));
                flexGridConfigRow.setDefaultSplit(((Boolean)entry.getValue()).booleanValue());
                flexGridConfigRow.setFieldKey(key);
                if (!CollectionUtils.isEmpty(userGridConfigRows)) {
                    for (GridConfigurationRow row : userGridConfigRows) {
                        if (!StringUtils.equals((CharSequence)row.getFieldKey(), (CharSequence)key)) continue;
                        flexGridConfigRow.setFlexSplit(row.getFlexSplit());
                        if (row.getChildren().size() == 0) {
                            int maxSize = 40;
                            String size = (String)flexMaxSizeShowMap.get(row.getFieldKey());
                            maxSize = size != null ? Integer.parseInt(size) : maxSize;
                            List<FlexProperty> flexPropertyList = this.getAllFlexProperties(row.getFieldKey());
                            List<GridConfigurationRow> childrenList = this.getChildrenList(flexPropertyList, maxSize, row.getFieldKey());
                            row.setChildren(childrenList);
                        }
                        flexGridConfigRow.setChildren(row.getChildren());
                    }
                } else if (flexFieldCanSplitMap.containsKey(flexGridConfigRow.getFieldKey())) {
                    List<FlexProperty> flexPropertyList = this.getAllFlexProperties(flexGridConfigRow.getFieldKey());
                    List<GridConfigurationRow> childrenList = this.getChildrenList(flexPropertyList, 40, flexGridConfigRow.getFieldKey());
                    flexGridConfigRow.setChildren(childrenList);
                }
                this.addFlexGridConfig(flexGridConfig, flexGridConfigRow, flexFieldCanSplitMap);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)flexFieldCanSplitMapStr)) {
            Map flexFieldCanSplitMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)flexFieldCanSplitMapStr, Map.class);
            for (GridConfigurationRow row : userGridConfigRows) {
                if (!flexFieldCanSplitMap.containsKey(row.getFieldKey()) || ((Boolean)flexFieldCanSplitMap.get(row.getFieldKey())).booleanValue() || row.getChildren().size() == 0) continue;
                row.setChildren(null);
            }
        }
        configRows.addAll(this.buildGridConfigRowsWidth(colsRunTimeMeta, column2Width));
        return configRows;
    }

    private List<FlexProperty> getAllFlexProperties(String fieldKey) {
        return this.flexColumnSplitService.getAllFlexProperties(fieldKey);
    }

    private List<GridConfigurationRow> getChildrenList(List<FlexProperty> flexPropertyList, int maxSize, String fieldKey) {
        ArrayList<GridConfigurationRow> list = new ArrayList<GridConfigurationRow>(flexPropertyList.size());
        int i = 0;
        for (FlexProperty flexProperty : flexPropertyList) {
            GridConfigurationRow row = new GridConfigurationRow();
            row.setFieldKey(fieldKey + "___" + flexProperty.getNumber());
            row.setFieldName(flexProperty.getName());
            row.setTextAlign("default");
            if (i < maxSize) {
                row.setHide(false);
            } else {
                row.setHide(true);
            }
            list.add(row);
            ++i;
        }
        return list;
    }

    private void addFlexGridConfig(List<FlexGridConfigRow> flexGridConfig, FlexGridConfigRow flexGridConfigRow, Map<String, Boolean> flexFieldCanSplitMap) {
        Iterator<FlexGridConfigRow> iterator = flexGridConfig.iterator();
        while (iterator.hasNext()) {
            FlexGridConfigRow row = iterator.next();
            if (!row.getFieldKey().equals(flexGridConfigRow.getFieldKey())) continue;
            iterator.remove();
        }
        if (flexFieldCanSplitMap.containsKey(flexGridConfigRow.getFieldKey()) && flexFieldCanSplitMap.get(flexGridConfigRow.getFieldKey()).booleanValue()) {
            flexGridConfig.add(flexGridConfigRow);
        }
    }

    public IReportListModel getReportModel() {
        if (this.reportModel == null) {
            this.reportModel = (AbstractReportListModel)TypesContainer.createInstance((String)"kd.bos.mvc.report.ReportListModel");
            this.reportModel.setView(this.getView());
            this.reportModel.setPageId(this.getView().getPageId());
            this.reportModel.setCtrlId(this.getKey());
            this.reportModel.setColumns(this.getColumns());
            IDataModel model = this.getView().getModel();
            if (model != null) {
                MainEntityType itemType = model.getDataEntityType();
                this.reportModel.setEntityType(itemType);
            }
            this.reportModel.setAsynQuery(this.isAsynQuery());
            this.reportModel.setPluginClassName(this.getReportPluginClassName());
            this.reportModel.setReportQueryPlugins(this.getReportQueryPlugins());
            this.reportModel.setPluginExtPlugins(this.getReportExtPlugins());
            this.reportModel.setInitField(this.getInitField());
            this.reportModel.setDataSource(this.getDataSource());
            this.reportModel.setDataSourceId(this.getDataSourceId());
        }
        return this.reportModel;
    }

    public Map<String, String> getMergeMap() {
        return this.mergeMap;
    }

    public void setMergeMap(Map<String, String> mergeMap) {
        this.mergeMap = mergeMap;
    }

    public Map<String, String> getMergeMapFromCache() {
        String mergeMapStr = this.getView().getPageCache().get("report_mergemap");
        if (StringUtils.isNotEmpty((CharSequence)mergeMapStr)) {
            this.mergeMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)mergeMapStr, Map.class);
        }
        return this.mergeMap;
    }

    public ReportListProxy getReportListProxy() {
        if (this.reportListProxy == null) {
            this.reportListProxy = new ReportListProxy(this);
        }
        return this.reportListProxy;
    }

    public FlexColumnSplitService getFlexColumnSplitService() {
        if (this.flexColumnSplitService == null) {
            this.flexColumnSplitService = (FlexColumnSplitService)this.getView().getService(FlexColumnSplitService.class);
            this.flexColumnSplitService.setEntityType(EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()));
            this.flexColumnSplitService.setReportList(this);
            this.flexColumnSplitService.init();
        }
        return this.flexColumnSplitService;
    }

    private boolean isSupportFilter() {
        try (EntityTraceSpan span = EntityTracer.create((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"isSupportFilter", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            String isTreeReportList = this.getView().getPageCache().get(ISTREEREPORTLIST);
            boolean supportFilter = !Boolean.parseBoolean(isTreeReportList);
            span.addLocaleTag(ISTREEREPORTLIST, (Object)isTreeReportList);
            span.addLocaleTag("supportFilter", (Object)supportFilter);
            boolean bl = supportFilter;
            return bl;
        }
    }

    private void sortAndFilter(List<ReportColumn> columns, List<SortAndFilterEvent> allColumns) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setSortAndFilter(allColumns);
        }
        TableHeadFilter tableHeadFilter = new TableHeadFilter(this);
        tableHeadFilter.afterSortAndFilterEvent(columns, allColumns);
    }

    private List<Map<String, Object>> getCellStyleRules() {
        ArrayList<CellStyleRule> cellStyleRules = new ArrayList<CellStyleRule>(16);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setCellStyleRules(cellStyleRules);
        }
        ArrayList<Map<String, Object>> rules = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(cellStyleRules)) {
            for (CellStyleRule cellStyleRule : cellStyleRules) {
                HashMap<String, Object> styleRule = new HashMap<String, Object>();
                HashMap<String, Object> cellStyleContent = new HashMap<String, Object>();
                styleRule.put("fieldKey", cellStyleRule.getFieldKey());
                cellStyleContent.put("fc", cellStyleRule.getForeColor());
                cellStyleContent.put("bc", cellStyleRule.getBackgroundColor());
                cellStyleContent.put("dg", cellStyleRule.getDegree());
                styleRule.put("style", cellStyleContent);
                styleRule.put("cond", cellStyleRule.getCondition());
                rules.add(styleRule);
            }
        }
        return rules;
    }

    private void addReportColumn(List<AbstractReportColumn> columns, List<SortAndFilterEvent> cols, Map<String, SortAndFilterEvent> map) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportColumn;
            if (col instanceof ReportColumnGroup) {
                List children = ((ReportColumnGroup)col).getChildren();
                this.addReportColumn(children, cols, map);
                continue;
            }
            if (!(col instanceof ReportColumn) || (reportColumn = (ReportColumn)col).isHide() || reportColumn.isPicture() || "fseq".equals(reportColumn.getFieldKey())) continue;
            SortAndFilterEvent event = new SortAndFilterEvent();
            event.setColumnName(reportColumn.getFieldKey());
            event.setDisplayName(reportColumn.getCaption());
            map.put(reportColumn.getFieldKey(), event);
            cols.add(event);
        }
    }

    private Map<String, Object> createColumn(ReportColumnGroup group) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HEADER, group.getCaption());
        if (group.getCtlTips() != null) {
            map.put("tips", group.getCtlTips());
        }
        if (!"default".equals(group.getTextAlign())) {
            map.put(TEXT_ALIGN, group.getTextAlign());
        }
        if (group.getFieldKey() != null) {
            map.put(DATA_INDEX, group.getFieldKey().replace(".", "_"));
        }
        if (StringUtils.isNotBlank((CharSequence)group.getTableHeaderCellBackColor())) {
            map.put("thcb", group.getTableHeaderCellBackColor());
        }
        return map;
    }

    private Map<String, Object> createColumn(AbstractReportColumn item, Map<String, SortAndFilterEvent> map) {
        Map<Object, Object> col = new HashMap();
        if (item instanceof ReportColumn) {
            col = item.createColumn();
            ReportColumn column = (ReportColumn)item;
            if ("fseq".equals(column.getFieldKey()) || column.isHide() || column.isPicture()) {
                col.put(SORT, false);
                col.put(FILTER, false);
            } else {
                col.put(SORT, map.get(column.getFieldKey()).isSort());
                col.put(FILTER, map.get(column.getFieldKey()).isFilter());
                if (map.get(column.getFieldKey()).isFilter()) {
                    IReportColumnProcessor processor = ReportColumnProcessorFactory.createReportColumnProcessor(column);
                    processor.setView(this.getView());
                    processor.setFieldKey(column.getFieldKey());
                    processor.setFieldType(column.getFieldType());
                    Map<String, Object> filterInfo = processor.createFilterInfo();
                    if (!filterInfo.isEmpty()) {
                        col.putAll(filterInfo);
                    }
                }
            }
        } else if (item instanceof ReportColumnGroup) {
            ReportColumnGroup group = (ReportColumnGroup)item;
            col = this.createColumn(group);
            ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>(10);
            for (AbstractReportColumn child : group.getChildren()) {
                children.add(this.createColumn(child, map));
            }
            if (group.isMerge()) {
                col.put("items", children);
                col.put(SORT, false);
                col.put(FILTER, false);
            } else {
                col.put(CHILDREN, children);
            }
        } else {
            col = item.createColumn();
            col.put(SORT, false);
            col.put(FILTER, false);
        }
        return col;
    }

    private void removeByInitField(String key, Map<String, String> initFieldMap, Iterator<Map<String, Object>> combineRuntimeMetaIt, Map<String, Object> next) {
        String fieldKey = next.get(DATA_INDEX).toString().split("\\.")[0];
        if (StringUtils.equals((CharSequence)key, (CharSequence)fieldKey) && next.get(CHILDREN) != null) {
            if (initFieldMap.containsKey(fieldKey) && !Boolean.parseBoolean(initFieldMap.get(fieldKey))) {
                combineRuntimeMetaIt.remove();
            } else {
                List list = (List)next.get(CHILDREN);
                Iterator<Map<String, Object>> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map sonNext = (Map)iterator.next();
                    String sonKey = sonNext.get(DATA_INDEX).toString().split("\\.")[0];
                    this.removeByInitField(sonKey, initFieldMap, iterator, sonNext);
                }
                if (list.size() == 0) {
                    combineRuntimeMetaIt.remove();
                }
            }
        } else if (initFieldMap.containsKey(fieldKey) && !Boolean.parseBoolean(initFieldMap.get(fieldKey))) {
            combineRuntimeMetaIt.remove();
        }
    }

    private boolean removeByFieldRight(List<Map<String, Object>> cols, int loopCount) {
        if (loopCount > 5) {
            return false;
        }
        int removeCount = 0;
        for (int i = cols.size() - 1; i >= 0; --i) {
            Map<String, Object> col = cols.get(i);
            Object children = col.get(CHILDREN);
            if (children instanceof List) {
                List items = (List)children;
                boolean removeChild = this.removeByFieldRight(items, loopCount + 1);
                if (!removeChild || !items.isEmpty()) continue;
                cols.remove(i);
                ++removeCount;
                continue;
            }
            if (this.hasReadFieldRight((String)col.get(DATA_INDEX))) continue;
            cols.remove(i);
            ++removeCount;
        }
        return removeCount > 0;
    }

    private void createGrid(IClientViewProxy clientViewProxy, List<AbstractReportColumn> columns, List<GridConfigurationRow> configRows, Map<String, Object> option) {
        Object suppresscopy;
        List<Map<String, String>> initFieldList;
        if (!this.isShowSeq()) {
            ((ReportColumn)columns.get(0)).setHide(true);
        }
        try {
            this.getReportListProxy().getReportPropUtil_createReportType().invoke(null, this.getModel().getDataEntityType(), this.getReportColumnList(columns));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
        this.getFlexColumnSplitService().setCallParam("createGrid");
        this.getFlexColumnSplitService().splitFlextColumn(columns);
        HashMap<String, Object> args = new HashMap<String, Object>();
        Map<String, Object> ruleActions = this.buildClientRules();
        ArrayList<Map<String, Object>> columnsRuntimeMeta = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> combineRuntimeMeta = new ArrayList<Map<String, Object>>(columns.size());
        boolean isSupportFilter = this.isSupportFilter();
        ArrayList<SortAndFilterEvent> allColumns = new ArrayList<SortAndFilterEvent>(10);
        HashMap<String, SortAndFilterEvent> map = new HashMap<String, SortAndFilterEvent>(16);
        this.addReportColumn(columns, allColumns, map);
        this.sortAndFilter(this.getReportColumnList(columns), allColumns);
        List<Map<String, Object>> cellStyleRules = this.getCellStyleRules();
        if (ruleActions.get(CELL_STYLE_RULES) != null) {
            cellStyleRules.addAll((List)ruleActions.get(CELL_STYLE_RULES));
        }
        Map<String, List<Map<String, Object>>> cellStyleRulesMap = cellStyleRules.stream().collect(Collectors.groupingBy(m -> String.valueOf(m.get("fieldKey"))));
        for (AbstractReportColumn item : columns) {
            Map<String, Object> col = null;
            col = isSupportFilter ? this.createColumn(item, map) : item.createColumn();
            List<Object> colCellStyleRules = new ArrayList();
            if (item instanceof ReportColumn) {
                if (cellStyleRulesMap.containsKey(((ReportColumn)item).getFieldKey())) {
                    colCellStyleRules = cellStyleRulesMap.get(((ReportColumn)item).getFieldKey());
                }
            } else if (item instanceof ReportColumnGroup) {
                List children = (List)col.get(CHILDREN);
                this.recursiveChildren(cellStyleRulesMap, children);
            }
            this.doDesensitize(col, item);
            if (!colCellStyleRules.isEmpty()) {
                col.put(CELL_STYLE_RULES, colCellStyleRules);
            }
            if ("fseq".equals(col.get(DATA_INDEX))) {
                combineRuntimeMeta.add(col);
                continue;
            }
            columnsRuntimeMeta.add(col);
        }
        GridConfigRenderUtils.setListColumnFixed(columnsRuntimeMeta, (List)this.getFreezeList());
        combineRuntimeMeta.addAll(this.combineRuntimeMeta(columnsRuntimeMeta, configRows));
        this.removeByFieldRight(combineRuntimeMeta, 1);
        Iterator<Map<String, Object>> combineRuntimeMetaIt = combineRuntimeMeta.iterator();
        List<GridConfigurationRow> gridConfigurationRowList = this.getReportListProxy().getUserGridConfigRows();
        HashMap<String, String> initFieldMap = new HashMap();
        if (CollectionUtils.isEmpty(gridConfigurationRowList) && !CollectionUtils.isEmpty(initFieldList = this.getInitField())) {
            initFieldMap = this.initFieldListToMap(initFieldList);
        }
        while (combineRuntimeMetaIt.hasNext()) {
            Map next = (Map)combineRuntimeMetaIt.next();
            if (CollectionUtils.isEmpty(initFieldMap)) continue;
            this.removeByInitField(next.get(DATA_INDEX).toString().split("\\.")[0], initFieldMap, combineRuntimeMetaIt, next);
        }
        ArrayList<String> fieldKeys = new ArrayList<String>();
        this.setMergeColums(fieldKeys);
        if (!fieldKeys.isEmpty()) {
            args.put("mergeColumns", fieldKeys);
        }
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("key", this.getKey());
        meta.put("methodname", "createGridColumns");
        args.put("rk", "rk");
        args.put("seq", "fseq");
        args.put("gridtype", "VIRTUALVIEWGRID");
        args.put("columns", combineRuntimeMeta);
        args.put(ROW_STYLE_RULES, ruleActions.get(ROW_STYLE_RULES));
        args.put("showGridConfig", this.isHasSettingRow());
        args.put("istreevirtualviewgrid", Boolean.parseBoolean(this.getView().getPageCache().get(ISTREEREPORTLIST)));
        if (this.isSelectedAll()) {
            args.put("selallrow", this.isSelectedAll());
        }
        if (!this.isShowCount()) {
            args.put("showRowCount", this.isShowCount());
        }
        if (this.isAsyncTotal()) {
            args.put("asyncTotal", this.isAsyncTotal());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTotalType())) {
            args.put("totalType", this.getTotalType());
        }
        boolean isCellSum = true;
        if (!CollectionUtils.isEmpty(option)) {
            isCellSum = Boolean.parseBoolean(String.valueOf(option.getOrDefault("iscellsum", "true")));
        } else {
            String formId = this.getView().getFormShowParameter().getFormId();
            DynamicObject dynamicObject = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)formId, (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.getKey());
            if (dynamicObject != null && dynamicObject.containsProperty("iscellsum")) {
                isCellSum = dynamicObject.getBoolean("iscellsum");
            }
        }
        args.put("isCellSum", isCellSum);
        if (this.getView().getPageCache().get(TREEEXPANDCOLID) != null && !StringUtils.isBlank((CharSequence)this.getView().getPageCache().get(TREEEXPANDCOLID))) {
            args.put("teci", this.getView().getPageCache().get(TREEEXPANDCOLID));
        }
        if ((suppresscopy = ListSysPublicParameter.option("suppresscopy")) != null && Boolean.parseBoolean(suppresscopy.toString())) {
            args.put("scp", true);
        }
        meta.put("args", new Map[]{args});
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    @SdkInternal
    public void postColsInfo(List<Map<String, Object>> listColumns) {
        ArrayList<String> colsOrderList = new ArrayList<String>(listColumns.size());
        for (Map<String, Object> map : listColumns) {
            colsOrderList.add((String)map.get("k"));
        }
        List<GridConfigurationRow> configurationRowList = this.getReportListProxy().getUserGridConfigRows();
        if (CollectionUtils.isEmpty(configurationRowList)) {
            configurationRowList = this.getOrinigGridConfig(listColumns);
        }
        ArrayList<GridConfigurationRow> newConfigurationRowList = new ArrayList<GridConfigurationRow>(configurationRowList.size());
        List gridFieldKeyList = configurationRowList.stream().map(GridConfigurationRow::getFieldKey).collect(Collectors.toList());
        for (GridConfigurationRow gridConfigurationRow : configurationRowList) {
            if (!gridConfigurationRow.isHide()) break;
            newConfigurationRowList.add(gridConfigurationRow);
        }
        this.mergeMap = this.getMergeMapFromCache();
        for (String s : colsOrderList) {
            if (gridFieldKeyList.contains(s)) {
                for (int i = 0; i < configurationRowList.size(); ++i) {
                    if (!StringUtils.equals((CharSequence)configurationRowList.get(i).getFieldKey(), (CharSequence)s)) continue;
                    newConfigurationRowList.add(configurationRowList.get(i));
                    this.addHideColumn(configurationRowList, newConfigurationRowList, i);
                }
                continue;
            }
            if (StringUtils.equals((CharSequence)"fseq", (CharSequence)s)) continue;
            GridConfigurationRow configurationRow = new GridConfigurationRow();
            if (this.mergeMap.get(s) != null) {
                configurationRow.setFieldKey(this.mergeMap.get(s));
            } else {
                configurationRow.setFieldKey(s);
            }
            configurationRow.setTextAlign("default");
            newConfigurationRowList.add(configurationRow);
        }
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(newConfigurationRowList)) {
            this.getReportListProxy().saveGridConfig(newConfigurationRowList);
        }
    }

    private void addHideColumn(List<GridConfigurationRow> configurationRowList, List<GridConfigurationRow> newConfigurationRowList, int i) {
        while (i + 1 < configurationRowList.size() && configurationRowList.get(i + 1).isHide()) {
            newConfigurationRowList.add(configurationRowList.get(i + 1));
            ++i;
        }
    }

    private List<GridConfigurationRow> getOrinigGridConfig(List<Map<String, Object>> listColumns) {
        HashMap<String, Integer> column2Width = new HashMap<String, Integer>(16);
        for (Map<String, Object> reportColumn : listColumns) {
            String key = (String)reportColumn.get("k");
            String colWidth = reportColumn.get("w").toString();
            try {
                Integer width = Double.valueOf(colWidth).intValue();
                column2Width.put(key, width);
            }
            catch (Exception e) {
                this.getView().showErrorNotification((String)key + "is a invalid number");
            }
        }
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        List<AbstractReportColumn> columns = this.getReportListProxy().getColumnList(this.getReportModel());
        this.getFlexColumnSplitService().setCallParam("listFieldsControl");
        this.getFlexColumnSplitService().splitFlextColumn(columns);
        for (AbstractReportColumn item : columns) {
            Map col = item.createColumn();
            cols.add(col);
        }
        GridConfigRenderUtils.setListColumnFixed(cols, (List)this.getFreezeList());
        List<GridConfigurationRow> resetGridConfig = this.buildGridConfigRowsWidth(cols, column2Width);
        return resetGridConfig;
    }

    private void recursiveChildren(Map<String, List<Map<String, Object>>> cellStyleRulesMap, List<Map<String, Object>> children) {
        if (children != null) {
            for (Map<String, Object> child : children) {
                List<Map<String, Object>> dataIndex = cellStyleRulesMap.get(child.get(DATA_INDEX));
                if (dataIndex != null) {
                    child.put(CELL_STYLE_RULES, dataIndex);
                }
                this.recursiveChildren(cellStyleRulesMap, (List)child.get(CHILDREN));
            }
        }
    }

    private Map<String, Map<String, Object>> getColsRunTimeMeta(List<Map<String, Object>> colsRunTimeMeta) {
        if (CollectionUtils.isEmpty(colsRunTimeMeta)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        return colsRunTimeMeta.stream().filter(item -> item.get(DATA_INDEX) != null).collect(Collectors.toMap(item -> {
            String key = item.get(DATA_INDEX).toString();
            return this.mergeMap.get(key) == null ? key : this.mergeMap.get(key);
        }, Function.identity(), (o, o2) -> o, LinkedHashMap::new));
    }

    private List<Map<String, Object>> combineRuntimeMeta(List<Map<String, Object>> columnsRuntimeMeta, List<GridConfigurationRow> userConfig) {
        if (CollectionUtils.isEmpty(userConfig) || CollectionUtils.isEmpty(columnsRuntimeMeta)) {
            return columnsRuntimeMeta;
        }
        Map<String, Map<String, Object>> colsRunTimeMetaMap = this.getColsRunTimeMeta(columnsRuntimeMeta);
        ArrayList<Map<String, Object>> combineRuntimeMeta = new ArrayList<Map<String, Object>>(columnsRuntimeMeta.size());
        for (GridConfigurationRow row : userConfig) {
            Map<String, Object> columnMeta = null;
            Map<String, Object> realCol = colsRunTimeMetaMap.get(row.getFieldKey());
            if (realCol != null) {
                columnMeta = realCol;
            }
            if (columnMeta == null) continue;
            boolean visible = columnMeta.get(VISIBLE) != null ? (Boolean)columnMeta.get(VISIBLE) : true;
            columnsRuntimeMeta.remove(columnMeta);
            columnMeta.put(IS_FIXED, row.isFreeze());
            columnMeta.put(VISIBLE, !row.isHide() && visible);
            columnMeta.put(TEXT_ALIGN, row.getTextAlign());
            List<Map<String, Object>> children = this.combineRuntimeMeta((List)columnMeta.get(CHILDREN), row.getChildren());
            if (!CollectionUtils.isEmpty(children)) {
                columnMeta.put(CHILDREN, children);
            }
            combineRuntimeMeta.add(columnMeta);
        }
        combineRuntimeMeta.addAll(columnsRuntimeMeta);
        return combineRuntimeMeta;
    }

    private Map<String, Object> buildClientRules() {
        HashMap<String, Object> ruleActions = new HashMap<String, Object>(10);
        HashMap groupClientRules = new HashMap();
        for (ClientBR clientBR : this.clientRules) {
            List<ClientBR> groupRulesList;
            if (StringUtils.isBlank((CharSequence)clientBR.getGroupName())) continue;
            if (groupClientRules.containsKey(clientBR.getGroupName())) {
                groupRulesList = (List)groupClientRules.get(clientBR.getGroupName());
                groupRulesList.add(clientBR);
                continue;
            }
            groupRulesList = new ArrayList<ClientBR>();
            groupRulesList.add(clientBR);
            groupClientRules.put(clientBR.getGroupName(), groupRulesList);
        }
        for (Map.Entry entry : groupClientRules.entrySet()) {
            ArrayList myClientRules = new ArrayList();
            for (BR br : (List)entry.getValue()) {
                ReportClientRuleExecuteContext clientRuleExecuteContext = new ReportClientRuleExecuteContext(this.getReportModel(), this.getModel(), br.getPreCondition(), myClientRules);
                br.execute((RuleExecuteContext)clientRuleExecuteContext);
            }
            ruleActions.put((String)entry.getKey(), myClientRules);
        }
        return ruleActions;
    }

    private Map<String, Object> getData(int startIndex, int length) {
        if (this.isTreeReport()) {
            return this.getData(startIndex, length, "0", null);
        }
        return this.getData(startIndex, length, null, null);
    }

    private Map<String, Integer> getGridConfigRowMap() {
        List<GridConfigurationRow> gridConfigRows = this.getReportListProxy().getUserGridConfigRows();
        Map<String, Integer> map = new HashMap<String, Integer>();
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(gridConfigRows)) {
            map = gridConfigRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
        }
        return map;
    }

    private Map<String, Object> getData(int startIndex, int length, String parentId, Integer currentSeq) {
        Integer realDataCount;
        AbstractReportListModel model = this.getAbstractReportModel();
        DynamicObjectCollection rowData = model.getRowData(startIndex, length, parentId, currentSeq);
        List<ReportColumn> cols = this.getReportListProxy().getReportColumnList(model.getColumns(), false);
        Map<String, Integer> gridConfigRowsMap = this.getGridConfigRowMap();
        Map<String, Object> data = this.packageData(rowData, cols, gridConfigRowsMap);
        data.put("startIndex", startIndex);
        data.put("pid", parentId);
        data.put("length", length);
        int rowCount = model.getRowCount();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy && (realDataCount = ((ReportViewPluginProxy)pluginProxy).resetDataCount()) != null) {
            rowCount = realDataCount;
            data.put("resetDataCount", true);
        }
        data.put("datacount", rowCount);
        data.put("pagerows", this.getPageRows());
        if (this.isSupportSplitPage()) {
            data.put("isSplitPage", true);
        }
        data.put("queryId", model.getResultId());
        ReportBatchQueryInfo byBatchInfo = this.getReportListProxy().getByBatchInfo();
        if (byBatchInfo.isLargeData()) {
            data.put("isLargeData", true);
            ReportByBatchTaskResult reportTaskResult = (ReportByBatchTaskResult)model.getReportTaskResult();
            String limitMessage = this.appendLimitMessage(model, startIndex + length);
            if (StringUtils.isNotBlank((CharSequence)limitMessage)) {
                this.getView().showMessage(limitMessage);
                data.put("isLast", true);
            } else if (reportTaskResult.getBatchLoadInfo().isAllBatchLoaded() && startIndex + rowData.size() >= reportTaskResult.getRowCount()) {
                data.put("isLast", true);
            } else if (rowCount == 0 && startIndex == 0) {
                data.put("datacount", 1);
                data.put("length", 1);
            }
        }
        Map<String, Object> formatSummaryValueMap = model.formatSummaryValue();
        Boolean isAsyncTotal = Boolean.parseBoolean(this.getView().getPageCache().get("isAsyncTotal"));
        if (!isAsyncTotal.booleanValue()) {
            ArrayList<SummaryEvent> summaryEvents = new ArrayList<SummaryEvent>(16);
            this.setFloatButtomData(summaryEvents, cols, formatSummaryValueMap, model.getSummaryValueMap());
            for (SummaryEvent summaryEvent : summaryEvents) {
                formatSummaryValueMap.put(summaryEvent.getColumnName(), summaryEvent.getFormatSummaryValue());
            }
        }
        if (!CollectionUtils.isEmpty(formatSummaryValueMap)) {
            ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
            if (isAsyncTotal.booleanValue()) {
                HashMap<String, String> seq = new HashMap<String, String>(1);
                seq.put("fseq", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ReportList_9", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                list.add(seq);
            } else {
                formatSummaryValueMap.put("fseq", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ReportList_9", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                list.add(formatSummaryValueMap);
            }
            data.put("floatBottomData", list);
        }
        this.selectRows(rowData, startIndex);
        return data;
    }

    protected int getSelectedRowsCount(int selectedRowsCount) {
        if (this.getEntryState().isSelectAllRows()) {
            int rowCount = this.getReportModel().getRowCount();
            int[] notSelectedRows = this.getNotSelectedRows();
            return rowCount - notSelectedRows.length;
        }
        return selectedRowsCount;
    }

    public int[] getNotSelectedRows() {
        List notSelectRows;
        AbstractGrid.GridState entryState = this.getEntryState();
        try {
            notSelectRows = (List)entryState.get(NOT_SELECT_ROWS);
        }
        catch (Exception e) {
            return new int[0];
        }
        if (notSelectRows == null) {
            return new int[0];
        }
        int[] data = new int[notSelectRows.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Integer)notSelectRows.get(i);
        }
        return data;
    }

    private void selectRows(DynamicObjectCollection data, int seq) {
        boolean hasAllRows = this.getEntryState().isSelectAllRows();
        if (hasAllRows) {
            int size = data.size();
            int[] selectedRowKeys = new int[size];
            List noSelectRows = (List)this.getEntryState().get(NOT_SELECT_ROWS);
            ++seq;
            for (int i = 0; i < size; ++i) {
                if (!noSelectRows.contains(seq)) {
                    selectedRowKeys[i] = seq;
                }
                ++seq;
            }
            if (this.isSupportSplitPage()) {
                this.clientViewProxy.invokeControlMethod(this.getKey(), "selectRows", new Object[]{selectedRowKeys});
            } else {
                this.clientViewProxy.invokeControlMethod(this.getKey(), "updateSelectRows", new Object[]{selectedRowKeys});
            }
            HashMap<String, Integer> selectedDataInfo = new HashMap<String, Integer>(1);
            selectedDataInfo.put("selectedRowsCount", this.getSelectedRowsCount(selectedRowKeys.length));
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setSelectedDataInfo", new Object[]{selectedDataInfo});
        }
    }

    private void setFloatButtomData(List<SummaryEvent> summaryEvents, List<ReportColumn> cols, Map<String, Object> formatSummaryValueMap, Map<String, Object> srcSummaryValueMap) {
        for (ReportColumn col : cols) {
            if (!(col instanceof DecimalReportColumn) || ((DecimalReportColumn)col).getSummary() != 1 || !formatSummaryValueMap.containsKey(col.getFieldKey())) continue;
            SummaryEvent summaryEvent = new SummaryEvent();
            summaryEvent.setColumnName(col.getFieldKey());
            summaryEvent.setSrcSummaryValue(srcSummaryValueMap.get(col.getFieldKey()));
            summaryEvent.setFormatSummaryValue(formatSummaryValueMap.get(col.getFieldKey()));
            summaryEvents.add(summaryEvent);
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setFloatButtomData(summaryEvents);
        }
    }

    public boolean hasReadFieldRight(String colKey) {
        if (this.rptFldCtrl == null) {
            this.rptFldCtrl = new RptFieldControl(this);
        }
        return this.rptFldCtrl.hasReadFieldRight(colKey);
    }

    private Map<String, String> initFieldListToMap(List<Map<String, String>> initFieldList) {
        HashMap<String, String> resMap = new HashMap<String, String>(initFieldList.size());
        for (Map<String, String> map : initFieldList) {
            resMap.put(map.get("fieldkey"), map.get("isvisible"));
        }
        return resMap;
    }

    private Map<String, Object> packageData(DynamicObjectCollection pageData, List<ReportColumn> cols, Map<String, Integer> gridConfigRowsMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList rows = new ArrayList(pageData.size());
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        int colIndex = 1;
        List<ReportColumn> dataIndexColumns = this.getFlexColumnSplitService().flatFlextColumn(cols);
        String formId = this.view.getFormShowParameter().getFormId();
        DynamicObject parameter = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)formId, (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.getKey());
        boolean isshowzero = true;
        if (parameter != null && parameter.containsProperty("isshowzero")) {
            isshowzero = parameter.getBoolean("isshowzero");
        }
        this.getView().getPageCache().put("isshowzero_weiling", String.valueOf(isshowzero));
        FormatObject format = this.getReportListProxy().getFormat();
        for (ReportColumn col : dataIndexColumns) {
            format.getNumberFormat().setShowZero(isshowzero);
            col.setUserFormat(format);
            if (!this.hasReadFieldRight(col.getFieldKey())) continue;
            dataIndex.put(col.getFieldKey().replace(".", "_"), colIndex++);
        }
        for (ReportColumn reportColumn : cols) {
            reportColumn.setDesensitized(PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)reportColumn.getFieldProperty(), (String)Lang.get().toString(), (String)"LIST"));
        }
        dataIndex.put("cprop", colIndex++);
        data.put("dataindex", dataIndex);
        NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)pageData, cols);
        FieldFormatContext formatContext = new FieldFormatContext((MainEntityType)null, this.getColumnDesc(cols), pageData);
        formatContext.setForExport(true);
        formatContext.setPerPageSize(pageData.size());
        for (DynamicObject dr : pageData) {
            HashMap cprop = new HashMap();
            ArrayList noLinkKey = new ArrayList();
            ArrayList noMergeKey = new ArrayList();
            ArrayList<Object> row = new ArrayList<Object>(10);
            row.add(dr.get("fseq"));
            for (ReportColumn col : cols) {
                if (!this.hasReadFieldRight(col.getFieldKey())) continue;
                Object object = col.getValue(dr, numberFormatProvider);
                if (col.getFieldProperty() instanceof FlexProp) {
                    FlexValueFormatter flexFormatter = this.flexFormaterMap.get(col.getFieldKey());
                    if (flexFormatter == null) {
                        flexFormatter = new FlexValueFormatter(formatContext, col.getFieldKey());
                        String defaultOrgField = this.getDefaultOrgField(cols);
                        if (StringUtils.isNotBlank((CharSequence)defaultOrgField)) {
                            flexFormatter.setReportOrgIdField(defaultOrgField);
                        }
                        this.flexFormaterMap.put(col.getFieldKey(), flexFormatter);
                    }
                    if (!col.isHide()) {
                        List<Object> flexValue = this.getFlexColumnSplitService().getFlexValue(col, flexFormatter, dr, gridConfigRowsMap);
                        if (flexValue.size() > 1) {
                            row.addAll(flexValue);
                            continue;
                        }
                        if (flexValue.isEmpty()) continue;
                        object = flexValue.get(0);
                    }
                }
                PackageDataEvent packageDataEvent = new PackageDataEvent((Object)col, dr, object);
                for (Consumer<PackageDataEvent> consumer : this.packageDataListeners) {
                    consumer.accept(packageDataEvent);
                }
                Object val = packageDataEvent.getFormatValue();
                val = this.getDesensitizeValue(col, dr, val);
                noLinkKey.addAll(packageDataEvent.getNoLinkKey());
                noMergeKey.addAll(packageDataEvent.getNoMergeKey());
                row.add(val);
            }
            if (!noLinkKey.isEmpty()) {
                cprop.put("nolink", noLinkKey);
            }
            if (!noMergeKey.isEmpty()) {
                cprop.put("nomerge", noMergeKey);
            }
            row.add(cprop);
            rows.add(row);
        }
        data.put("rows", rows);
        return data;
    }

    private Object getDesensitizeValue(ReportColumn col, DynamicObject dr, Object value) {
        if (col == null || !col.isDesensitized()) {
            return value;
        }
        String operateType = "LIST";
        boolean isDesensitizeField = false;
        DynamicProperty thisFieldProp = col.getFieldProperty();
        if (thisFieldProp != null) {
            isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr);
        }
        if (isDesensitizeField) {
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                for (int i = 0; i < val.length; ++i) {
                    val[i] = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr, (Object)val[i]);
                }
            } else {
                if (thisFieldProp instanceof ComboProp && value != null) {
                    value = ((ComboProp)thisFieldProp).getItemByName(value.toString());
                }
                value = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr, (Object)value);
            }
        }
        return value;
    }

    private String getDefaultOrgField(List<ReportColumn> cols) {
        Map customParam = this.getReportCache().getReportQueryParam(this.getView().getPageId()).getCustomParam();
        String[] orgField = null != customParam && customParam.containsKey(FLEXORGIDFIELD) ? new String[]{(String)customParam.get(FLEXORGIDFIELD)} : new String[]{ISVService.getISVInfo().getId() + "_orgid", "orgid"};
        for (String s : orgField) {
            for (ReportColumn col : cols) {
                if (!s.equals(col.getFieldKey())) continue;
                return s;
            }
        }
        return "";
    }

    public AbstractReportListModel getAbstractReportModel() {
        return (AbstractReportListModel)this.getReportModel();
    }

    @SdkInternal
    protected HyperLinkClickEvent createHyperLinkClickEvent(String fieldName, int rowIndex) {
        DynamicObject rowData = this.getReportModel().getRowData(rowIndex);
        return new HyperLinkClickEvent((Object)this, fieldName, rowIndex, rowData);
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="200")
    public int getPageRows() {
        if (this.view != null && this.isSupportSplitPage()) {
            AbstractGrid.GridState entryState = this.getEntryState();
            entryState.setMaxPageSize(Integer.valueOf(5000));
            int statePageRows = entryState.getPageRows();
            return statePageRows != 0 ? statePageRows : this.pageRows;
        }
        if (this.pageRows > 5000) {
            this.pageRows = 5000;
        }
        return this.pageRows;
    }

    public int getPageRow() {
        if (this.pageRows > 5000) {
            this.pageRows = 5000;
        }
        this.pageRow = this.pageRows;
        return this.pageRow;
    }

    @KSMethod
    public void clearEntryState() {
        AbstractGrid.GridState gridState = this.getEntryState();
        gridState.setSelectAllRows(false);
        this.selectRows(new int[0], -1);
        gridState.put("selDatas", null);
        gridState.put(NOT_SELECT_ROWS, new ArrayList(0));
    }

    public void setRowSort(String columnName, int sortStyle) {
        new TableHeadFilter(this).sort(columnName, sortStyle);
    }

    public void getGridDataByFilter(List<Map<String, List<Object>>> filter) {
        new TableHeadFilter(this).filter(filter);
    }

    public List<SortAndFilterEvent> getAllColumns() {
        boolean isSupportFilter = this.isSupportFilter();
        if (!isSupportFilter) {
            return Collections.emptyList();
        }
        ArrayList<SortAndFilterEvent> allColumns = new ArrayList<SortAndFilterEvent>(10);
        HashMap<String, SortAndFilterEvent> map = new HashMap<String, SortAndFilterEvent>(16);
        this.addReportColumn(this.getColumns(), allColumns, map);
        this.sortAndFilter(this.getReportColumnList(this.getColumns()), allColumns);
        if (allColumns.isEmpty()) {
            return Collections.emptyList();
        }
        return allColumns.stream().filter(c -> c.isSort()).collect(Collectors.toList());
    }

    public int getTotalRecords() {
        AbstractReportListModel listModel = this.getAbstractReportModel();
        return listModel.getRowCount();
    }

    private void setMergeColums(List<String> columns) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setMergeColums(columns);
        }
    }

    @SdkInternal
    public ReportQueryParam getQueryParam(String pageId, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        ReportQueryParam queryParam = this.getReportCache().getReportQueryParam(pageId);
        Field queryParamField = AbstractReportListDataPlugin.class.getDeclaredField("queryParam");
        queryParamField.setAccessible(true);
        queryParamField.set(reportPlugin, queryParam);
        return queryParam;
    }

    public void saveGridViewWidth(Map<String, Object> setting) {
        HashMap<String, Object> settingMap;
        String settingKey = this.getView().getFormShowParameter().getSettingKey();
        String settingStr = this.getModel().getCurrUserSetting(settingKey);
        if (StringUtils.isNotBlank((CharSequence)settingStr)) {
            settingMap = (HashMap<String, Object>)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)settingStr, Map.class);
            settingMap.putAll(setting);
        } else {
            settingMap = new HashMap<String, Object>(setting);
        }
        this.getModel().setCurrUserSetting(RequestContext.get().getCurrUserId(), settingKey, kd.bos.dataentity.serialization.SerializationUtils.toJsonString(settingMap));
    }

    @SdkInternal
    public void getPlainText(Integer row, String fieldKey, List<Object> pks) {
        if (StringUtils.isEmpty((CharSequence)fieldKey)) {
            log.info("fieldKey is null, row:{}, fieldKey:{}, pks:{}", new Object[]{row, fieldKey, pks});
            return;
        }
        List<ReportColumn> cols = this.getReportListProxy().getReportColumnList(this.getAbstractReportModel().getColumns(), false);
        DynamicObjectCollection coll = this.getAbstractReportModel().getRowData(row - 1, 1);
        if (coll.isEmpty()) {
            log.info("dynamicObject is null, row:{}, fieldKey:{}, pks:{}", new Object[]{row, fieldKey, pks});
            return;
        }
        boolean isshowzero = true;
        String isshowzero_weiling = this.getView().getPageCache().get("isshowzero_weiling");
        if (StringUtils.isNotEmpty((CharSequence)isshowzero_weiling)) {
            isshowzero = Boolean.parseBoolean(isshowzero_weiling);
        }
        FormatObject format = this.getReportListProxy().getFormat();
        ReportColumn reportColumn = null;
        for (ReportColumn col : cols) {
            if (!fieldKey.equalsIgnoreCase(col.getFieldKey())) continue;
            reportColumn = col;
            format.getNumberFormat().setShowZero(isshowzero);
            col.setUserFormat(format);
            break;
        }
        if (reportColumn == null) {
            log.info("reportColumn is null, row:{}, fieldKey:{}, pks:{}", new Object[]{row, fieldKey, pks});
            return;
        }
        DynamicObject dr = (DynamicObject)coll.get(0);
        try {
            String operateType = "LIST";
            DynamicProperty thisFieldProp = reportColumn.getFieldProperty();
            boolean isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr);
            if (isDesensitizeField) {
                PrivacyCenterUtils.checkDecryptPermission((IDataEntityProperty)reportColumn.getFieldProperty(), (String)operateType, (String)"PC", (DynamicObject)dr);
            }
        }
        catch (KDException e) {
            if (PrivacyDataConstant.ERRORCODE.equals((Object)e.getErrorCode())) {
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            throw e;
        }
        NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)coll, cols);
        Object value = reportColumn.getValue(dr, numberFormatProvider);
        PackageDataEvent packageDataEvent = new PackageDataEvent((Object)reportColumn, dr, value);
        for (Consumer<PackageDataEvent> consumer : this.packageDataListeners) {
            consumer.accept(packageDataEvent);
        }
        Object val = packageDataEvent.getFormatValue();
        HashMap data = new HashMap(6);
        ArrayList fieldstates = new ArrayList(3);
        HashMap<String, Object> tmp = new HashMap<String, Object>(6);
        tmp.put("v", val);
        tmp.put("r", row);
        tmp.put("k", fieldKey);
        fieldstates.add(tmp);
        data.put("fieldstates", fieldstates);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.key, "setPlainText", new Object[]{data});
    }

    public List<ReportColumn> getReportColumnList(List<AbstractReportColumn> reportColumns) {
        ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
        this.setReportColumns(reportColumns, cols);
        return cols;
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols) {
        for (AbstractReportColumn acol : acols) {
            if (acol instanceof ReportColumn) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols);
        }
    }

    private void doDesensitize(Map<String, Object> col, AbstractReportColumn reportColumn) {
        if (reportColumn instanceof ReportColumn) {
            this.doDesensitize(col, (ReportColumn)reportColumn);
        } else if (reportColumn instanceof ReportColumnGroup) {
            List childrens = ((ReportColumnGroup)reportColumn).getChildren();
            ArrayList childrenMaps = (ArrayList)col.get(CHILDREN);
            if (childrens != null && childrenMaps != null) {
                for (int i = 0; i < childrens.size(); ++i) {
                    AbstractReportColumn children = (AbstractReportColumn)childrens.get(i);
                    if (children == null) continue;
                    this.doDesensitize((Map<String, Object>)((Map)childrenMaps.get(i)), children);
                }
            }
        }
    }

    private void doDesensitize(Map<String, Object> col, ReportColumn reportColumn) {
        HashMap editor = null;
        if (col.get("editor") instanceof Map) {
            editor = (HashMap)col.get("editor");
        }
        if (editor == null) {
            editor = new HashMap(8);
            col.put("editor", editor);
        }
        String operateType = "LIST";
        boolean isDesensitizeField = false;
        DynamicProperty thisFieldProp = reportColumn.getFieldProperty();
        if (thisFieldProp != null) {
            isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, null);
        }
        if (isDesensitizeField) {
            String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)thisFieldProp, (String)operateType, null);
            boolean canShowDetail = false;
            if ("CLICKVIEW".equals(strategy)) {
                canShowDetail = true;
            }
            HashMap<String, Boolean> pmap = new HashMap<String, Boolean>(3);
            pmap.put("isprivacy", true);
            pmap.put("canshowdetail", canShowDetail);
            editor.put("privacy", pmap);
            boolean isSupportSearch = PrivacyDataCenterManager.getPermissionService().isSupportSearch();
            if (isSupportSearch) {
                boolean isDesensitizeStrategy = "DESENSITIZE".equals(strategy);
                if (isDesensitizeStrategy) {
                    col.put(SORT, false);
                    col.put(FILTER, false);
                    log.info("\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u6b64\u8131\u654f\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f\u8fc7\u6ee4, prop is {}", (Object)thisFieldProp.getName());
                }
            } else {
                col.put(SORT, false);
                col.put(FILTER, false);
                log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\uff0c\u56e0\u6b64\u8131\u654f\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f\u8fc7\u6ee4, prop is {}", (Object)thisFieldProp.getName());
            }
        }
        if (PrivacyCenterUtils.isEncryptField((IDataEntityProperty)thisFieldProp)) {
            String fieldName = thisFieldProp == null ? "" : thisFieldProp.getName();
            log.info("\u52a0\u5bc6\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f, prop is {}", (Object)fieldName);
            col.put(SORT, false);
            if (thisFieldProp instanceof DateTimeProp) {
                col.put(FILTER, false);
            }
        }
    }

    @SdkInternal
    public void selectAllRows() {
        ReportResultReadOption.setRead2ndFilterData((boolean)true);
        this.getRowSelectWrapper().selectAllRows();
    }

    @SdkInternal
    public void clearSelection() {
        this.getRowSelectWrapper().clearSelection();
    }

    @SdkInternal
    public void addRowSelection(List<Integer> rowKeys, List<List<Object>> rowData) {
        this.getRowSelectWrapper().addRowSelection(rowKeys, rowData);
    }

    @SdkInternal
    public void clearRowSelection(List<Integer> rowKeys, List<List<Object>> rowData) {
        this.getRowSelectWrapper().clearRowSelection(rowKeys, rowData);
    }

    @SdkInternal
    public void doubleClickRow(List<Integer> rowKeys, List<List<Object>> rowData) {
        this.getRowSelectWrapper().doubleClickRow(rowKeys, rowData);
    }

    @SdkInternal
    public List<RowClickEventListener> getRowClickListeners() {
        return this.rowClickEventListeners;
    }

    private ReportRowSelectWrapper getRowSelectWrapper() {
        if (this.rowSelectWrapper == null) {
            this.rowSelectWrapper = new ReportRowSelectWrapper(this, this.clientViewProxy);
        }
        return this.rowSelectWrapper;
    }

    private List<AbstractColumnDesc> getColumnDesc(List<ReportColumn> cols) {
        ArrayList<AbstractColumnDesc> columns = new ArrayList<AbstractColumnDesc>(cols.size());
        for (ReportColumn reportColumn : cols) {
            DynamicProperty fieldProperty = reportColumn.getFieldProperty();
            if (!(fieldProperty instanceof FlexProp)) continue;
            columns.add((AbstractColumnDesc)new FlexColumnDesc(reportColumn.getFieldKey(), (IDataEntityProperty)fieldProperty, (IDataEntityProperty)fieldProperty, ((FlexProp)fieldProperty).getBasePropertyKey()));
        }
        return columns;
    }

    @SdkInternal
    public void getSumData() {
        ReportCalculateTotal reportCalculateTotal = new ReportCalculateTotal(this, this.clientViewProxy);
        reportCalculateTotal.getSumData();
    }

    @SdkInternal
    public void setPageIndex(int pageIndex) {
        if (pageIndex < 1) {
            return;
        }
        int pageRows = this.getPageRows();
        this.bindData((pageIndex - 1) * pageRows, pageRows);
    }

    @SdkInternal
    public void setPageSize(int pageRows) {
        if (pageRows > 5000) {
            return;
        }
        this.pageRows = pageRows;
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setMaxPageSize(Integer.valueOf(5000));
        entryState.setPageRows(pageRows);
        HashMap<String, Integer> userConfig = new HashMap<String, Integer>(2);
        userConfig.put("pageRows", pageRows);
        String key = String.format("%s_%s_%s", this.getView().getEntityId(), this.getKey(), "_report_userconfig");
        this.getModel().setCurrUserSetting(RequestContext.get().getCurrUserId(), key, kd.bos.dataentity.serialization.SerializationUtils.toJsonString(userConfig));
        this.bindData(0, pageRows);
    }

    private void bindData(int startIndex, int length) {
        String sumdata;
        ReportResultReadOption.setRead2ndFilterData((boolean)true);
        Map<String, Object> data = this.getData(startIndex, length, null, null);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(this.getKey(), "data", data);
        if (this.isSupportSplitPage() && StringUtils.isNotBlank((CharSequence)(sumdata = this.getView().getPageCache().get(this.getBottomDataKey())))) {
            Map formatSummaryValueMap = (Map)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)sumdata, Map.class);
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setFloatButtomData", new Object[]{formatSummaryValueMap});
        }
        this.getView().getPageCache().put("lastGetVirtualDataStartIndex", String.valueOf(startIndex));
        this.getView().getPageCache().put("lastGetVirtualDataLength", String.valueOf(length));
        this.setHottips();
    }

    private Map<String, Object> getUserOption() {
        DynamicObject parameter = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getEntityId(), (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.getKey());
        if (parameter == null) {
            return null;
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(parameter.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        return jser.serializeToMap((Object)parameter, null);
    }

    private String getBottomDataKey() {
        return String.format("%s:%s", "bottomData", this.getKey());
    }

    private void setHottips() {
        List tipsList;
        IHotTipsService hotTipsService = (IHotTipsService)ServiceFactory.getService(IHotTipsService.class);
        if (hotTipsService.enableHotTips() && (tipsList = hotTipsService.getHotTips(this.getView().getPageId())) != null && !tipsList.isEmpty()) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setTips", (Object)tipsList);
        }
    }

    private boolean isSupportSplitPage() {
        return !Boolean.parseBoolean(this.getView().getPageCache().get(ISTREEREPORTLIST)) && this.isSplitPage();
    }

    private String appendLimitMessage(AbstractReportListModel model, int count) {
        String message = null;
        ReportResultLimit limit = model.getReportCache().getReportResultLimit(model.getPageId(), model.getCtrlId());
        if (limit != null && limit.isExceedLimitCount(count)) {
            int maxQueryLimit = limit.getLimitCount() / 10000;
            message = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8d85\u884c\u6570\u4e0a\u9650\uff08%1$s\u4e07\u884c\uff09\uff0c%2$s\u4e07\u884c\u5185\u6570\u636e\u67e5\u8be2\u6210\u529f\uff0c\u8d85\u51fa\u90e8\u5206\u672a\u67e5\u8be2\u3002", (String)"ReportList_10", (String)BOS_FORM_CORE, (Object[])new Object[0]), maxQueryLimit, "\r\n" + maxQueryLimit);
        }
        return message;
    }

    public void expandAllNode() {
        this.refresh();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("reportlistap", "expandAllNode", new Object[]{true});
        this.getView().getPageCache().put(String.format("%s_expandAllNode", this.getKey()), "true");
    }

    public void collapseAllNode() {
        this.refresh();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("reportlistap", "collapseAllNode", new Object[]{true});
        this.getView().getPageCache().remove(String.format("%s_expandAllNode", this.getKey()));
    }

    public String getLimitSceneCode(LimitType type, String entityId) {
        try {
            Map data = BusinessDataReader.loadFromCache((String)"bos_report_limit_config", (String)type.getCode(), (QFilter[])new QFilter[]{new QFilter("entitynumber.number", "=", (Object)entityId)});
            String sceneCode = null;
            if (data != null && data.size() > 0) {
                for (DynamicObject value : data.values()) {
                    sceneCode = value.getString(type.getCode());
                }
            }
            if (StringUtils.isBlank(sceneCode)) {
                if (LimitType.QUERY_LIMIT == type) {
                    sceneCode = "REPORT_QUERY_LIMIT";
                } else if (LimitType.EXPORT_LIMIT == type) {
                    sceneCode = "REPORT_EXPORT_LIMIT";
                }
            }
            return sceneCode;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u62a5\u8868\u9650\u6d41\u914d\u7f6e\u62a5\u9519", (Throwable)e);
            if (LimitType.QUERY_LIMIT == type) {
                return "REPORT_QUERY_LIMIT";
            }
            if (LimitType.EXPORT_LIMIT == type) {
                return "REPORT_EXPORT_LIMIT";
            }
            return null;
        }
    }

    private boolean isTreeReport() {
        return Boolean.parseBoolean(this.getView().getPageCache().get(ISTREEREPORTLIST)) && !Boolean.parseBoolean(this.getView().getPageCache().get(String.format("%s_expandAllNode", this.getKey())));
    }

    @SimplePropertyAttribute
    public List<Plugin> getReportQueryPlugins() {
        return this.reportQueryPlugins;
    }

    public void setReportQueryPlugins(List<Plugin> reportQueryPlugins) {
        this.reportQueryPlugins = reportQueryPlugins;
    }

    public boolean existQueryPlugin() {
        return StringUtils.isNotEmpty((CharSequence)this.getReportPluginClassName()) || !CollectionUtils.isEmpty(this.getReportQueryPlugins());
    }

    public IReportListDataPlugin initQueryPlugin() {
        String pluginClassName = this.getReportPluginClassName();
        if (StringUtils.isEmpty((CharSequence)pluginClassName) && CollectionUtils.isEmpty(this.getReportQueryPlugins())) {
            return null;
        }
        boolean useOldPlugin = false;
        if (CollectionUtils.isEmpty(this.getReportQueryPlugins())) {
            useOldPlugin = true;
        }
        if (!useOldPlugin) {
            String pluginStr = kd.bos.dataentity.serialization.SerializationUtils.toJsonString((Object)this.getReportQueryPlugins().get(0));
            Plugin plugin = (Plugin)kd.bos.dataentity.serialization.SerializationUtils.fromJsonString((String)pluginStr, Plugin.class);
            if (!StringUtils.isEmpty((CharSequence)pluginClassName) && !pluginClassName.equals(plugin.getClassName())) {
                useOldPlugin = true;
            }
        }
        if (!useOldPlugin) {
            ReportServiceProxyPlugin reportQueryProxy = new ReportServiceProxyPlugin(this.getReportQueryPlugins(), 0);
            return (IReportListDataPlugin)reportQueryProxy.getQueryPlugIns().get(0);
        }
        Class reportPluginClass = TypesContainer.getOrRegister((String)pluginClassName);
        try {
            return (IReportListDataPlugin)reportPluginClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDException((Throwable)e, BosErrorCode.reportPluginInitError, new Object[]{"initial class AbstractReportListDataPlugin failure"});
        }
    }

    public static enum LimitType {
        QUERY_LIMIT("querylimit"),
        EXPORT_LIMIT("exportlimit");

        private String code;

        private LimitType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

