/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.form.operatecol.OperationColItem;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportOperationColumn
extends AbstractReportColumn {
    private int operationColumnShowStyle;
    private String fieldKey;
    private LocaleString width;
    private boolean is_Hide;
    private static final long serialVersionUID = -5601775324613238421L;
    private List<OperationColItem> operationColItems = new ArrayList<OperationColItem>();

    @SimplePropertyAttribute
    public int getOperationColumnShowStyle() {
        return this.operationColumnShowStyle;
    }

    public void setOperationColumnShowStyle(int showStyle) {
        this.operationColumnShowStyle = showStyle;
    }

    @SimplePropertyAttribute
    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute
    public boolean isHide() {
        return this.is_Hide;
    }

    public void setHide(boolean isHide) {
        this.is_Hide = isHide;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OperationColItem.class)
    public List<OperationColItem> getOperationColItems() {
        return this.operationColItems;
    }

    public void setOperationColItems(List<OperationColItem> operationColItems) {
        this.operationColItems = operationColItems;
    }

    private Map<String, Object> createEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "operate");
        ArrayList<Map> items = new ArrayList<Map>(10);
        for (OperationColItem item : this.operationColItems) {
            items.add(item.createControl());
        }
        editor.put("opr", items);
        editor.put("showType", this.getOperationColumnShowStyle());
        return editor;
    }

    public Map<String, Object> createColumn() {
        Map map = super.createColumn();
        map.put("editor", this.createEditor());
        map.put("sort", false);
        map.put("filter", false);
        map.put("dataIndex", this.fieldKey.replace(".", "_"));
        map.put("visible", !this.isHide());
        if (StringUtils.isNotBlank((Object)this.getWidth())) {
            map.put("w", this.getWidth());
        }
        return map;
    }
}

