/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.demo;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class DemoReport
extends AbstractReportFormPlugin {
    private static final String BARCHARTAP = "barchartap";
    private static final String POINTLINECHARTAP = "pointlinechartap";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final String PIECHARTAP = "piechartap";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String DEMO_REPORT_2 = "DemoReport_2";
    private static final String DEMO_REPORT_3 = "DemoReport_3";
    private static final String DEMO_REPORT_4 = "DemoReport_4";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BARCHARTAP, HISTOGRAMCHARTAP, POINTLINECHARTAP, PIECHARTAP});
        this.addGridClickListners();
    }

    private void addGridClickListners() {
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                DemoReport.this.reportRowClick(evt);
            }

            public void entryRowDoubleClick(RowClickEvent evt) {
            }
        });
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                DemoReport.this.hyperLinkAccountClick(evt);
            }
        });
    }

    private void reportRowClick(RowClickEvent evt) {
        ReportList report = (ReportList)this.getControl("reportlistap");
        DynamicObject rowData = report.getReportModel().getRowData(evt.getRow());
        String message = String.format(ResManager.loadKDString((String)"\u70b9\u51fb\u7b2c%1$s\u884c\uff1a %2$s", (String)"DemoReport_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), evt.getRow(), rowData);
        this.getView().showMessage(message);
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("book", (Object)1);
        queryParam.setFilter(filter);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        return true;
    }

    @Override
    public void afterQuery(ReportQueryParam queryParam) {
        Control pieChart;
        PieSeries series;
        Control pointlineChart;
        Control histogramChart;
        Control barChart = this.getControl(BARCHARTAP);
        if (barChart instanceof BarChart) {
            BarChart chart = (BarChart)barChart;
            chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)DEMO_REPORT_2, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            chart.createYAxis(ResManager.loadKDString((String)"y\u8f74", (String)DEMO_REPORT_3, (String)BOS_FORM_CORE, (Object[])new Object[0]), new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"});
            BarSeries series2 = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)DEMO_REPORT_4, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            series2.setData((Number[])new Integer[]{10, 52, 200, 334, 390, 330, 220});
            chart.bindData(null);
        }
        if ((histogramChart = this.getControl(HISTOGRAMCHARTAP)) instanceof HistogramChart) {
            HistogramChart chart = (HistogramChart)histogramChart;
            chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)DEMO_REPORT_2, (String)BOS_FORM_CORE, (Object[])new Object[0]), new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"});
            chart.createYAxis(ResManager.loadKDString((String)"y\u8f74", (String)DEMO_REPORT_3, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            BarSeries series3 = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)DEMO_REPORT_4, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            series3.setData((Number[])new Integer[]{10, 52, 200, 334, 390, 330, 220});
            chart.bindData(null);
        }
        if ((pointlineChart = this.getControl(POINTLINECHARTAP)) instanceof PointLineChart) {
            PointLineChart chart = (PointLineChart)pointlineChart;
            Axis xAxis = chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)DEMO_REPORT_2, (String)BOS_FORM_CORE, (Object[])new Object[0]), AxisType.category);
            xAxis.setCategorys(new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"});
            chart.createYAxis(ResManager.loadKDString((String)"y\u8f74", (String)DEMO_REPORT_3, (String)BOS_FORM_CORE, (Object[])new Object[0]), AxisType.value);
            series = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)DEMO_REPORT_4, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            series.setData(new Number[]{10, 52, 200, 334, 390, 330, 220});
            chart.bindData(null);
        }
        if ((pieChart = this.getControl(PIECHARTAP)) instanceof PieChart) {
            PieChart chart = (PieChart)pieChart;
            series = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e", (String)DEMO_REPORT_4, (String)BOS_FORM_CORE, (Object[])new Object[0]));
            series.addData(new ItemValue("Mon", (Number)10));
            series.addData(new ItemValue("Tue", (Number)52));
            series.addData(new ItemValue("Wed", (Number)200));
            series.addData(new ItemValue("Thu", (Number)334));
            series.addData(new ItemValue("Fri", (Number)390));
            series.addData(new ItemValue("Sat", (Number)330));
            series.addData(new ItemValue("Sun", (Number)220));
            chart.bindData(null);
        }
    }

    public void hyperLinkAccountClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if ("account".equals(key)) {
            Object value = evt.getRowData().get(key);
            String data = null;
            data = value instanceof DynamicObject ? DataEntitySerializer.serializerToString((Object)value) : value.toString();
            this.getView().showMessage(data);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BARCHARTAP) || key.equals(HISTOGRAMCHARTAP) || key.equals(POINTLINECHARTAP) || key.equals(PIECHARTAP)) {
            ChartClickEvent e = (ChartClickEvent)evt;
            this.getView().showMessage("SeriesName:" + e.getSeriesName() + "; Name:" + e.getName() + "; Value:" + e.getValue());
        }
    }
}

